/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.ice4j.stunclient;

import gg.essential.lib.ice4j.StunException;
import gg.essential.lib.ice4j.StunMessageEvent;
import gg.essential.lib.ice4j.TransportAddress;
import gg.essential.lib.ice4j.attribute.AttributeFactory;
import gg.essential.lib.ice4j.attribute.ChangeRequestAttribute;
import gg.essential.lib.ice4j.attribute.ChangedAddressAttribute;
import gg.essential.lib.ice4j.attribute.MappedAddressAttribute;
import gg.essential.lib.ice4j.message.MessageFactory;
import gg.essential.lib.ice4j.message.Request;
import gg.essential.lib.ice4j.socket.IceSocketWrapper;
import gg.essential.lib.ice4j.socket.IceUdpSocketWrapper;
import gg.essential.lib.ice4j.socket.SafeCloseDatagramSocket;
import gg.essential.lib.ice4j.stack.StunStack;
import gg.essential.lib.ice4j.stunclient.BlockingRequestSender;
import gg.essential.lib.ice4j.stunclient.StunDiscoveryReport;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NetworkConfigurationDiscoveryProcess {
    private static final Logger logger = Logger.getLogger(NetworkConfigurationDiscoveryProcess.class.getName());
    private boolean started = false;
    private TransportAddress localAddress = null;
    private TransportAddress serverAddress = null;
    private BlockingRequestSender requestSender = null;
    private IceSocketWrapper sock = null;
    private final StunStack stunStack;

    public NetworkConfigurationDiscoveryProcess(StunStack stunStack, TransportAddress localAddress, TransportAddress serverAddress) {
        if (stunStack == null) {
            throw new NullPointerException("stunStack");
        }
        this.stunStack = stunStack;
        this.localAddress = localAddress;
        this.serverAddress = serverAddress;
    }

    public void shutDown() {
        this.stunStack.removeSocket(this.localAddress);
        this.sock.close();
        this.sock = null;
        this.localAddress = null;
        this.requestSender = null;
        this.started = false;
    }

    public void start() throws IOException, StunException {
        this.sock = new IceUdpSocketWrapper(new SafeCloseDatagramSocket(this.localAddress));
        this.stunStack.addSocket(this.sock);
        this.requestSender = new BlockingRequestSender(this.stunStack, this.localAddress);
        this.started = true;
    }

    public StunDiscoveryReport determineAddress() throws StunException, IOException {
        this.checkStarted();
        StunDiscoveryReport report = new StunDiscoveryReport();
        StunMessageEvent evt = this.doTestI(this.serverAddress);
        if (evt == null) {
            report.setNatType("UDP Blocking Firewall");
            return report;
        }
        TransportAddress mappedAddress = ((MappedAddressAttribute)evt.getMessage().getAttribute('\u0001')).getAddress();
        if (mappedAddress == null) {
            logger.info("Failed to do the network discovery");
            return null;
        }
        logger.fine("mapped address is=" + mappedAddress + ", name=" + mappedAddress.getHostAddress());
        TransportAddress backupServerAddress = ((ChangedAddressAttribute)evt.getMessage().getAttribute('\u0005')).getAddress();
        logger.fine("backup server address is=" + backupServerAddress + ", name=" + backupServerAddress.getHostAddress());
        report.setPublicAddress(mappedAddress);
        if (mappedAddress.equals(this.localAddress)) {
            evt = this.doTestII(this.serverAddress);
            if (evt == null) {
                report.setNatType("Symmetric UDP Firewall");
                return report;
            }
            report.setNatType("Open Internet Configuration");
            return report;
        }
        evt = this.doTestII(this.serverAddress);
        if (evt == null) {
            evt = this.doTestI(backupServerAddress);
            if (evt == null) {
                logger.info("Failed to receive a response from backup stun server!");
                return report;
            }
            TransportAddress mappedAddress2 = ((MappedAddressAttribute)evt.getMessage().getAttribute('\u0001')).getAddress();
            if (mappedAddress.equals(mappedAddress2)) {
                evt = this.doTestIII(this.serverAddress);
                if (evt == null) {
                    report.setNatType("Port Restricted Cone NAT");
                    return report;
                }
                report.setNatType("Restricted Cone NAT");
                return report;
            }
            report.setNatType("Symmetric NAT");
            return report;
        }
        report.setNatType("Full Cone NAT");
        return report;
    }

    private StunMessageEvent doTestI(TransportAddress serverAddress) throws IOException, StunException {
        Request request = MessageFactory.createBindingRequest();
        ChangeRequestAttribute changeRequest = AttributeFactory.createChangeRequestAttribute();
        changeRequest.setChangeIpFlag(false);
        changeRequest.setChangePortFlag(false);
        request.putAttribute(changeRequest);
        StunMessageEvent evt = null;
        try {
            evt = this.requestSender.sendRequestAndWaitForResponse(request, serverAddress);
        }
        catch (StunException ex) {
            logger.log(Level.SEVERE, "Internal Error. Failed to encode a message", ex);
            return null;
        }
        if (evt != null) {
            logger.fine("TEST I res=" + evt.getRemoteAddress().toString() + " - " + evt.getRemoteAddress().getHostAddress());
        } else {
            logger.fine("NO RESPONSE received to TEST I.");
        }
        return evt;
    }

    private StunMessageEvent doTestII(TransportAddress serverAddress) throws StunException, IOException {
        Request request = MessageFactory.createBindingRequest();
        ChangeRequestAttribute changeRequest = AttributeFactory.createChangeRequestAttribute();
        changeRequest.setChangeIpFlag(true);
        changeRequest.setChangePortFlag(true);
        request.putAttribute(changeRequest);
        StunMessageEvent evt = this.requestSender.sendRequestAndWaitForResponse(request, serverAddress);
        if (evt != null) {
            logger.fine("Test II res=" + evt.getRemoteAddress().toString() + " - " + evt.getRemoteAddress().getHostAddress());
        } else {
            logger.fine("NO RESPONSE received to Test II.");
        }
        return evt;
    }

    private StunMessageEvent doTestIII(TransportAddress serverAddress) throws StunException, IOException {
        Request request = MessageFactory.createBindingRequest();
        ChangeRequestAttribute changeRequest = AttributeFactory.createChangeRequestAttribute();
        changeRequest.setChangeIpFlag(false);
        changeRequest.setChangePortFlag(true);
        request.putAttribute(changeRequest);
        StunMessageEvent evt = this.requestSender.sendRequestAndWaitForResponse(request, serverAddress);
        if (evt != null) {
            logger.fine("Test III res=" + evt.getRemoteAddress().toString() + " - " + evt.getRemoteAddress().getHostAddress());
        } else {
            logger.fine("NO RESPONSE received to Test III.");
        }
        return evt;
    }

    private void checkStarted() throws StunException {
        if (!this.started) {
            throw new StunException(1, "The Discoverer must be started before launching the discovery process!");
        }
    }
}

