/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.ice4j.stunclient;

import gg.essential.lib.ice4j.AbstractResponseCollector;
import gg.essential.lib.ice4j.BaseStunMessageEvent;
import gg.essential.lib.ice4j.ResponseCollector;
import gg.essential.lib.ice4j.StunException;
import gg.essential.lib.ice4j.StunMessageEvent;
import gg.essential.lib.ice4j.StunResponseEvent;
import gg.essential.lib.ice4j.TransportAddress;
import gg.essential.lib.ice4j.message.Request;
import gg.essential.lib.ice4j.stack.StunStack;
import gg.essential.lib.ice4j.stack.TransactionID;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BlockingRequestSender
extends AbstractResponseCollector {
    private static final Logger logger = Logger.getLogger(BlockingRequestSender.class.getName());
    private final StunStack stunStack;
    private final TransportAddress localAddress;
    private StunMessageEvent responseEvent = null;
    private boolean ended = false;
    private final Object sendLock = new Object();

    public BlockingRequestSender(StunStack stunStack, TransportAddress localAddress) {
        this.stunStack = stunStack;
        this.localAddress = localAddress;
    }

    public TransportAddress getLocalAddress() {
        return this.localAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void processFailure(BaseStunMessageEvent event) {
        Object object = this.sendLock;
        synchronized (object) {
            this.ended = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void processResponse(StunResponseEvent evt) {
        Object object = this.sendLock;
        synchronized (object) {
            this.responseEvent = evt;
            this.ended = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StunMessageEvent sendRequestAndWaitForResponse(Request request, TransportAddress serverAddress) throws StunException, IOException {
        Object object = this.sendLock;
        synchronized (object) {
            this.stunStack.sendRequest(request, serverAddress, this.localAddress, (ResponseCollector)this);
        }
        this.ended = false;
        while (!this.ended) {
            try {
                this.wait();
            }
            catch (InterruptedException ex) {
                logger.log(Level.WARNING, "Interrupted", ex);
            }
        }
        StunMessageEvent res = this.responseEvent;
        this.responseEvent = null;
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StunMessageEvent sendRequestAndWaitForResponse(Request request, TransportAddress serverAddress, TransactionID tranID) throws StunException, IOException {
        Object object = this.sendLock;
        synchronized (object) {
            this.stunStack.sendRequest(request, serverAddress, this.localAddress, this, tranID);
        }
        this.ended = false;
        while (!this.ended) {
            try {
                this.wait();
            }
            catch (InterruptedException ex) {
                logger.log(Level.WARNING, "Interrupted", ex);
            }
        }
        StunMessageEvent res = this.responseEvent;
        this.responseEvent = null;
        return res;
    }
}

