/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.ice4j.stack;

import gg.essential.lib.ice4j.StunException;
import gg.essential.lib.ice4j.Transport;
import gg.essential.lib.ice4j.TransportAddress;
import gg.essential.lib.ice4j.message.ChannelData;
import gg.essential.lib.ice4j.message.Message;
import gg.essential.lib.ice4j.socket.IceSocketWrapper;
import gg.essential.lib.ice4j.stack.ChannelDataEventHandler;
import gg.essential.lib.ice4j.stack.Connector;
import gg.essential.lib.ice4j.stack.ErrorHandler;
import gg.essential.lib.ice4j.stack.MessageEventHandler;
import gg.essential.lib.ice4j.stack.MessageProcessingTask;
import gg.essential.lib.ice4j.stack.PeerUdpMessageEventHandler;
import gg.essential.lib.ice4j.stack.RawMessage;
import gg.essential.lib.ice4j.stack.StunStack;
import gg.essential.lib.jitsi.utils.concurrent.ExecutorFactory;
import java.io.IOException;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;

class NetAccessManager
implements ErrorHandler {
    private static final Logger logger = Logger.getLogger(NetAccessManager.class.getName());
    private static ExecutorService messageProcessingExecutor = ExecutorFactory.createCachedThreadPool("ice4j.NetAccessManager-");
    private static final int TASK_POOL_SIZE = 8;
    private final ArrayBlockingQueue<MessageProcessingTask> taskPool = new ArrayBlockingQueue(8);
    private final ConcurrentHashMap.KeySetView<MessageProcessingTask, Boolean> activeTasks = ConcurrentHashMap.newKeySet();
    private final Map<TransportAddress, Map<TransportAddress, Connector>> udpConnectors = new HashMap<TransportAddress, Map<TransportAddress, Connector>>();
    private final Map<TransportAddress, Map<TransportAddress, Connector>> tcpConnectors = new HashMap<TransportAddress, Map<TransportAddress, Connector>>();
    private final MessageEventHandler messageEventHandler;
    private final PeerUdpMessageEventHandler peerUdpMessageEventHandler;
    private final ChannelDataEventHandler channelDataEventHandler;
    private final StunStack stunStack;
    private final AtomicBoolean isStopped = new AtomicBoolean(false);
    private final Consumer<MessageProcessingTask> onRawMessageProcessed = messageProcessingTask -> {
        this.activeTasks.remove(messageProcessingTask);
        boolean isAdded = this.taskPool.offer((MessageProcessingTask)messageProcessingTask);
        if (!isAdded && logger.isLoggable(Level.FINEST)) {
            logger.finest("Dropping MessageProcessingTask for " + this + " because pool is full, max pool size is " + 8);
        }
    };

    NetAccessManager(StunStack stunStack) {
        this(stunStack, null, null);
    }

    NetAccessManager(StunStack stunStack, PeerUdpMessageEventHandler peerUdpMessageEventHandler, ChannelDataEventHandler channelDataEventHandler) {
        this.stunStack = stunStack;
        this.messageEventHandler = stunStack;
        this.peerUdpMessageEventHandler = peerUdpMessageEventHandler;
        this.channelDataEventHandler = channelDataEventHandler;
    }

    MessageEventHandler getMessageEventHandler() {
        return this.messageEventHandler;
    }

    public PeerUdpMessageEventHandler getUdpMessageEventHandler() {
        return this.peerUdpMessageEventHandler;
    }

    public ChannelDataEventHandler getChannelDataMessageEventHandler() {
        return this.channelDataEventHandler;
    }

    StunStack getStunStack() {
        return this.stunStack;
    }

    @Override
    public void handleError(String message, Throwable error) {
        if (this.isStopped.get()) {
            logger.log(Level.WARNING, "Got error when stopped, ignoring: " + message, error);
            return;
        }
        logger.log(Level.FINE, "The following error occurred with an incoming message:", error);
    }

    @Override
    public void handleFatalError(Runnable callingThread, String message, Throwable error) {
        if (this.isStopped.get()) {
            logger.log(Level.WARNING, "Got fatal error when stopped, ignoring: " + message, error);
            return;
        }
        if (callingThread instanceof Connector) {
            Connector connector = (Connector)callingThread;
            this.removeSocket(connector.getListenAddress(), connector.getRemoteAddress());
            if (error != null) {
                logger.log(Level.WARNING, "Removing connector:" + connector, error);
            } else if (logger.isLoggable(Level.FINE)) {
                logger.fine("Removing connector " + connector);
            }
        } else {
            logger.log(Level.SEVERE, message, error);
        }
    }

    protected void addSocket(IceSocketWrapper socket) {
        Socket tcpSocket = socket.getTCPSocket();
        TransportAddress remoteAddress = null;
        if (tcpSocket != null) {
            remoteAddress = new TransportAddress(tcpSocket.getInetAddress(), tcpSocket.getPort(), Transport.TCP);
        }
        this.addSocket(socket, remoteAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSocket(IceSocketWrapper socket, TransportAddress remoteAddress) {
        Map<TransportAddress, Map<TransportAddress, Connector>> connectorsMap;
        Transport transport = socket.getUDPSocket() != null ? Transport.UDP : Transport.TCP;
        TransportAddress localAddress = new TransportAddress(socket.getLocalAddress(), socket.getLocalPort(), transport);
        Map<TransportAddress, Map<TransportAddress, Connector>> map2 = connectorsMap = transport == Transport.UDP ? this.udpConnectors : this.tcpConnectors;
        synchronized (map2) {
            Map<TransportAddress, Connector> connectorsForLocalAddress = connectorsMap.get(localAddress);
            if (connectorsForLocalAddress == null) {
                connectorsForLocalAddress = new HashMap<TransportAddress, Connector>();
                connectorsMap.put(localAddress, connectorsForLocalAddress);
            }
            if (!connectorsForLocalAddress.containsKey(remoteAddress)) {
                Connector connector = new Connector(socket, remoteAddress, this::onIncomingRawMessage, this);
                connectorsForLocalAddress.put(remoteAddress, connector);
                connector.start();
            } else {
                logger.info("Not creating a new Connector, because we already have one for the given address pair: " + localAddress + " -> " + remoteAddress);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSocket(TransportAddress localAddress, TransportAddress remoteAddress) {
        Map<TransportAddress, Map<TransportAddress, Connector>> connectorsMap;
        Connector connector = null;
        Map<TransportAddress, Map<TransportAddress, Connector>> map2 = connectorsMap = localAddress.getTransport() == Transport.UDP ? this.udpConnectors : this.tcpConnectors;
        synchronized (map2) {
            Map<TransportAddress, Connector> connectorsForLocalAddress = connectorsMap.get(localAddress);
            if (connectorsForLocalAddress != null && (connector = connectorsForLocalAddress.get(remoteAddress)) != null) {
                connectorsForLocalAddress.remove(remoteAddress);
                if (connectorsForLocalAddress.isEmpty()) {
                    connectorsMap.remove(localAddress);
                }
            }
        }
        if (connector != null) {
            connector.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.isStopped.set(true);
        for (MessageProcessingTask messageProcessingTask : this.activeTasks) {
            messageProcessingTask.cancel();
        }
        this.activeTasks.clear();
        for (Object o : new Object[]{this.udpConnectors, this.tcpConnectors}) {
            Map connectorsMap;
            Map map2 = connectorsMap = (Map)o;
            synchronized (map2) {
                for (Map connectorsForLocalAddress : connectorsMap.values()) {
                    for (Connector connector : connectorsForLocalAddress.values()) {
                        connector.stop();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connector getConnector(TransportAddress localAddress, TransportAddress remoteAddress) {
        boolean udp = localAddress.getTransport() == Transport.UDP;
        Map<TransportAddress, Map<TransportAddress, Connector>> connectorsMap = udp ? this.udpConnectors : this.tcpConnectors;
        Connector connector = null;
        Map<TransportAddress, Map<TransportAddress, Connector>> map2 = connectorsMap;
        synchronized (map2) {
            Map<TransportAddress, Connector> connectorsForLocalAddress = connectorsMap.get(localAddress);
            if (connectorsForLocalAddress != null) {
                connector = connectorsForLocalAddress.get(remoteAddress);
                if (udp && connector == null) {
                    connector = connectorsForLocalAddress.get(null);
                }
            }
        }
        return connector;
    }

    private void onIncomingRawMessage(RawMessage message) {
        if (this.isStopped.get()) {
            logger.fine("Got RawMessage when stopped, ignore it.");
            return;
        }
        MessageProcessingTask messageProcessingTask = this.taskPool.poll();
        if (messageProcessingTask == null) {
            messageProcessingTask = new MessageProcessingTask(this);
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Allocated new MessageProcessingTask for " + this + " due to absence of available pooled instances");
            }
        } else {
            messageProcessingTask.resetState();
        }
        messageProcessingTask.setMessage(message, this.onRawMessageProcessed);
        this.activeTasks.add(messageProcessingTask);
        messageProcessingExecutor.execute(messageProcessingTask);
    }

    void sendMessage(Message stunMessage, TransportAddress srcAddr, TransportAddress remoteAddr) throws IllegalArgumentException, IOException {
        this.sendMessage(stunMessage.encode(this.stunStack), srcAddr, remoteAddr);
    }

    void sendMessage(ChannelData channelData, TransportAddress srcAddr, TransportAddress remoteAddr) throws IllegalArgumentException, IOException, StunException {
        boolean pad = srcAddr.getTransport() == Transport.TCP || srcAddr.getTransport() == Transport.TLS;
        this.sendMessage(channelData.encode(pad), srcAddr, remoteAddr);
    }

    void sendMessage(byte[] bytes, TransportAddress srcAddr, TransportAddress remoteAddr) throws IllegalArgumentException, IOException {
        Connector ap = this.getConnector(srcAddr, remoteAddr);
        if (ap == null) {
            throw new IllegalArgumentException("No socket found for " + srcAddr + "->" + remoteAddr);
        }
        ap.sendMessage(bytes, remoteAddr);
    }
}

