/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.ice4j.stack;

import gg.essential.lib.ice4j.StunMessageEvent;
import gg.essential.lib.ice4j.TransportAddress;
import gg.essential.lib.ice4j.stack.MessageEventHandler;
import gg.essential.lib.ice4j.stack.RequestListener;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class EventDispatcher {
    private final List<MessageTypeEventHandler<?>> messageListeners = new Vector();
    private final Map<TransportAddress, EventDispatcher> children = new Hashtable<TransportAddress, EventDispatcher>();

    public void addIndicationListener(TransportAddress localAddr, MessageEventHandler indicationListener) {
        this.addMessageListener(localAddr, new IndicationEventHandler(indicationListener));
    }

    public void addOldIndicationListener(TransportAddress localAddr, MessageEventHandler indicationListener) {
        this.addMessageListener(localAddr, new OldIndicationEventHandler(indicationListener));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void addMessageListener(MessageTypeEventHandler<?> messageListener) {
        List<MessageTypeEventHandler<?>> list = this.messageListeners;
        synchronized (list) {
            if (!this.messageListeners.contains(messageListener)) {
                this.messageListeners.add(messageListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void addMessageListener(TransportAddress localAddr, MessageTypeEventHandler<?> messageListener) {
        Map<TransportAddress, EventDispatcher> map2 = this.children;
        synchronized (map2) {
            EventDispatcher child = this.children.get(localAddr);
            if (child == null) {
                child = new EventDispatcher();
                this.children.put(localAddr, child);
            }
            child.addMessageListener(messageListener);
        }
    }

    public void addRequestListener(RequestListener listener2) {
        this.addMessageListener(new RequestListenerMessageEventHandler(listener2));
    }

    public void addRequestListener(TransportAddress localAddr, RequestListener listener2) {
        this.addMessageListener(localAddr, new RequestListenerMessageEventHandler(listener2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void removeMessageListener(MessageTypeEventHandler<?> messageListener) {
        List<MessageTypeEventHandler<?>> list = this.messageListeners;
        synchronized (list) {
            this.messageListeners.remove(messageListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void removeMessageListener(TransportAddress localAddr, MessageTypeEventHandler<?> messageListener) {
        Map<TransportAddress, EventDispatcher> map2 = this.children;
        synchronized (map2) {
            EventDispatcher child = this.children.get(localAddr);
            if (child == null) {
                return;
            }
            child.removeMessageListener(messageListener);
        }
    }

    public void removeRequestListener(RequestListener listener2) {
        this.removeMessageListener(new RequestListenerMessageEventHandler(listener2));
    }

    public void removeRequestListener(TransportAddress localAddr, RequestListener listener2) {
        this.removeMessageListener(localAddr, new RequestListenerMessageEventHandler(listener2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireMessageEvent(StunMessageEvent evt) {
        MessageTypeEventHandler[] messageListenersCopy;
        TransportAddress localAddr = evt.getLocalAddress();
        List<MessageTypeEventHandler<?>> list = this.messageListeners;
        synchronized (list) {
            messageListenersCopy = this.messageListeners.toArray(new MessageTypeEventHandler[this.messageListeners.size()]);
        }
        char messageType = (char)(evt.getMessage().getMessageType() & 0x110);
        for (MessageTypeEventHandler messageListener : messageListenersCopy) {
            if (messageType != messageListener.messageType) continue;
            messageListener.handleMessageEvent(evt);
        }
        Map<TransportAddress, EventDispatcher> map2 = this.children;
        synchronized (map2) {
            EventDispatcher child = this.children.get(localAddr);
            if (child != null) {
                child.fireMessageEvent(evt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasRequestListeners(TransportAddress localAddr) {
        Object object = this.messageListeners;
        synchronized (object) {
            if (!this.messageListeners.isEmpty()) {
                return true;
            }
        }
        object = this.children;
        synchronized (object) {
            EventDispatcher child;
            if (!this.children.isEmpty() && (child = this.children.get(localAddr)) != null) {
                return !child.messageListeners.isEmpty();
            }
        }
        return false;
    }

    public void removeAllListeners() {
        this.messageListeners.clear();
        this.children.clear();
    }

    private static class RequestListenerMessageEventHandler
    extends MessageTypeEventHandler<RequestListener> {
        public RequestListenerMessageEventHandler(RequestListener requestListener) {
            super('\u0000', requestListener);
        }

        @Override
        public void handleMessageEvent(StunMessageEvent e) {
            ((RequestListener)this.delegate).processRequest(e);
        }
    }

    private static abstract class MessageTypeEventHandler<T>
    implements MessageEventHandler {
        public final T delegate;
        public final char messageType;

        public MessageTypeEventHandler(char messageType, T delegate) {
            if (delegate == null) {
                throw new NullPointerException("delegate");
            }
            this.messageType = messageType;
            this.delegate = delegate;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!this.getClass().isInstance(obj)) {
                return false;
            }
            MessageTypeEventHandler mteh = (MessageTypeEventHandler)obj;
            return this.messageType == mteh.messageType && this.delegate.equals(mteh.delegate);
        }

        public int hashCode() {
            return this.messageType | this.delegate.hashCode();
        }
    }

    private static class OldIndicationEventHandler
    extends MessageTypeEventHandler<MessageEventHandler> {
        public OldIndicationEventHandler(MessageEventHandler indicationListener) {
            super('\u0110', indicationListener);
        }

        @Override
        public void handleMessageEvent(StunMessageEvent e) {
            ((MessageEventHandler)this.delegate).handleMessageEvent(e);
        }
    }

    private static class IndicationEventHandler
    extends MessageTypeEventHandler<MessageEventHandler> {
        public IndicationEventHandler(MessageEventHandler indicationListener) {
            super('\u0010', indicationListener);
        }

        @Override
        public void handleMessageEvent(StunMessageEvent e) {
            ((MessageEventHandler)this.delegate).handleMessageEvent(e);
        }
    }
}

