/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.ice4j.socket;

import gg.essential.lib.ice4j.socket.DelegatingDatagramSocket;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class SafeCloseDatagramSocket
extends DelegatingDatagramSocket {
    private final ReadWriteLock receiveCloseLock = new ReentrantReadWriteLock();

    public SafeCloseDatagramSocket() throws SocketException {
    }

    public SafeCloseDatagramSocket(DatagramSocket delegate) throws SocketException {
        super(delegate);
    }

    public SafeCloseDatagramSocket(int port) throws SocketException {
        super(port);
    }

    public SafeCloseDatagramSocket(int port, InetAddress laddr) throws SocketException {
        super(port, laddr);
    }

    public SafeCloseDatagramSocket(SocketAddress bindaddr) throws SocketException {
        super(bindaddr);
    }

    @Override
    public void close() {
        super.close();
        Lock closeLock = this.receiveCloseLock.writeLock();
        closeLock.lock();
        closeLock.unlock();
    }

    @Override
    public void receive(DatagramPacket p) throws IOException {
        Lock receiveLock = this.receiveCloseLock.readLock();
        receiveLock.lock();
        try {
            super.receive(p);
        }
        finally {
            receiveLock.unlock();
        }
    }
}

