/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.ice4j.socket;

import gg.essential.lib.ice4j.StunException;
import gg.essential.lib.ice4j.StunMessageEvent;
import gg.essential.lib.ice4j.Transport;
import gg.essential.lib.ice4j.TransportAddress;
import gg.essential.lib.ice4j.attribute.DataAttribute;
import gg.essential.lib.ice4j.attribute.XorPeerAddressAttribute;
import gg.essential.lib.ice4j.ice.RelayedCandidate;
import gg.essential.lib.ice4j.ice.harvest.TurnCandidateHarvest;
import gg.essential.lib.ice4j.message.Indication;
import gg.essential.lib.ice4j.message.Message;
import gg.essential.lib.ice4j.message.MessageFactory;
import gg.essential.lib.ice4j.message.Request;
import gg.essential.lib.ice4j.message.Response;
import gg.essential.lib.ice4j.socket.DatagramPacketFilter;
import gg.essential.lib.ice4j.socket.MultiplexingDatagramSocket;
import gg.essential.lib.ice4j.socket.MultiplexingXXXSocketSupport;
import gg.essential.lib.ice4j.socket.StunDatagramPacketFilter;
import gg.essential.lib.ice4j.socket.TurnDatagramPacketFilter;
import gg.essential.lib.ice4j.stack.MessageEventHandler;
import gg.essential.lib.ice4j.stack.TransactionID;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RelayedCandidateDatagramSocket
extends DatagramSocket
implements MessageEventHandler {
    private static final Logger logger = Logger.getLogger(RelayedCandidateDatagramSocket.class.getName());
    private static final char CHANNEL_NUMBER_NOT_SPECIFIED = '\u0000';
    private static final int CHANNELDATA_CHANNELNUMBER_LENGTH = 2;
    private static final int CHANNELDATA_LENGTH_LENGTH = 2;
    private static final char MAX_CHANNEL_NUMBER = Short.MAX_VALUE;
    private static final char MIN_CHANNEL_NUMBER = '\u4000';
    private static final long PERMISSION_LIFETIME = 300000L;
    private static final long PERMISSION_LIFETIME_LEEWAY = 60000L;
    private final DatagramSocket channelDataSocket;
    private final List<Channel> channels = new LinkedList<Channel>();
    private boolean closed = false;
    private static final DatagramPacketFilter connectivityCheckRecognizer = new StunDatagramPacketFilter();
    private char nextChannelNumber = (char)16384;
    private final List<DatagramPacket> packetsToReceive = new LinkedList<DatagramPacket>();
    private final List<DatagramPacket> packetsToSend = new LinkedList<DatagramPacket>();
    private Thread receiveChannelDataThread;
    private final RelayedCandidate relayedCandidate;
    private Thread sendThread;
    private final TurnCandidateHarvest turnCandidateHarvest;

    public RelayedCandidateDatagramSocket(RelayedCandidate relayedCandidate, TurnCandidateHarvest turnCandidateHarvest) throws SocketException {
        super((SocketAddress)null);
        this.relayedCandidate = relayedCandidate;
        this.turnCandidateHarvest = turnCandidateHarvest;
        this.turnCandidateHarvest.harvester.getStunStack().addIndicationListener(this.turnCandidateHarvest.hostCandidate.getTransportAddress(), this);
        DatagramSocket hostSocket = this.turnCandidateHarvest.hostCandidate.getCandidateIceSocketWrapper().getUDPSocket();
        this.channelDataSocket = hostSocket instanceof MultiplexingDatagramSocket ? ((MultiplexingDatagramSocket)hostSocket).getSocket(new TurnDatagramPacketFilter(this.turnCandidateHarvest.harvester.stunServer){

            @Override
            public boolean accept(DatagramPacket p) {
                return RelayedCandidateDatagramSocket.this.channelDataSocketAccept(p);
            }

            @Override
            protected boolean acceptMethod(char method) {
                return RelayedCandidateDatagramSocket.this.channelDataSocketAcceptMethod(method);
            }
        }) : null;
    }

    private boolean channelDataSocketAccept(DatagramPacket p) {
        int pOffset;
        byte[] pData;
        int pLength;
        if (this.turnCandidateHarvest.harvester.stunServer.equals(p.getSocketAddress()) && (pLength = p.getLength()) >= 4 && ((pData = p.getData())[pOffset = p.getOffset()] & 0xC0) != 0) {
            int length;
            pOffset += 2;
            int padding = (length = pData[pOffset++] << 8 | pData[pOffset++] & 0xFF) % 4 > 0 ? 4 - length % 4 : 0;
            return length == (pLength -= 2) - padding - 2 || length == pLength - 2;
        }
        return false;
    }

    private boolean channelDataSocketAcceptMethod(char method) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        List<DatagramPacket> list = this;
        synchronized (list) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        list = this.packetsToReceive;
        synchronized (list) {
            this.packetsToReceive.notifyAll();
        }
        list = this.packetsToSend;
        synchronized (list) {
            this.packetsToSend.notifyAll();
        }
        this.turnCandidateHarvest.harvester.getStunStack().removeIndicationListener(this.turnCandidateHarvest.hostCandidate.getTransportAddress(), this);
        this.turnCandidateHarvest.close(this);
        super.close();
    }

    private void createReceiveChannelDataThread() {
        this.receiveChannelDataThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean done = false;
                try {
                    RelayedCandidateDatagramSocket.this.runInReceiveChannelDataThread();
                    done = true;
                }
                catch (SocketException sex) {
                    done = true;
                }
                finally {
                    List list = RelayedCandidateDatagramSocket.this.packetsToReceive;
                    synchronized (list) {
                        if (RelayedCandidateDatagramSocket.this.receiveChannelDataThread == Thread.currentThread()) {
                            RelayedCandidateDatagramSocket.this.receiveChannelDataThread = null;
                        }
                        if (RelayedCandidateDatagramSocket.this.receiveChannelDataThread == null && !RelayedCandidateDatagramSocket.this.closed && !done) {
                            RelayedCandidateDatagramSocket.this.createReceiveChannelDataThread();
                        }
                    }
                }
            }
        };
        this.receiveChannelDataThread.start();
    }

    private void createSendThread() {
        this.sendThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    RelayedCandidateDatagramSocket.this.runInSendThread();
                }
                finally {
                    List list = RelayedCandidateDatagramSocket.this.packetsToSend;
                    synchronized (list) {
                        if (RelayedCandidateDatagramSocket.this.sendThread == Thread.currentThread()) {
                            RelayedCandidateDatagramSocket.this.sendThread = null;
                        }
                        if (RelayedCandidateDatagramSocket.this.sendThread == null && !RelayedCandidateDatagramSocket.this.closed && !RelayedCandidateDatagramSocket.this.packetsToSend.isEmpty()) {
                            RelayedCandidateDatagramSocket.this.createSendThread();
                        }
                    }
                }
            }
        };
        this.sendThread.start();
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.getLocalSocketAddress().getAddress();
    }

    @Override
    public int getLocalPort() {
        return this.getLocalSocketAddress().getPort();
    }

    @Override
    public InetSocketAddress getLocalSocketAddress() {
        return this.getRelayedCandidate().getTransportAddress();
    }

    private char getNextChannelNumber() {
        char nextChannelNumber;
        if (this.nextChannelNumber > Short.MAX_VALUE) {
            nextChannelNumber = '\u0000';
        } else {
            nextChannelNumber = this.nextChannelNumber;
            this.nextChannelNumber = (char)(this.nextChannelNumber + '\u0001');
        }
        return nextChannelNumber;
    }

    public final RelayedCandidate getRelayedCandidate() {
        return this.relayedCandidate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMessageEvent(StunMessageEvent e) {
        DatagramPacket packetToReceive;
        if (!this.turnCandidateHarvest.hostCandidate.getTransportAddress().equals(e.getLocalAddress())) {
            return;
        }
        if (!this.turnCandidateHarvest.harvester.stunServer.equals(e.getRemoteAddress())) {
            return;
        }
        Message message = e.getMessage();
        char messageType = message.getMessageType();
        if (messageType != '\u0017') {
            return;
        }
        XorPeerAddressAttribute peerAddressAttribute = (XorPeerAddressAttribute)message.getAttribute('\u0012');
        if (peerAddressAttribute == null) {
            return;
        }
        DataAttribute dataAttribute = (DataAttribute)message.getAttribute('\u0013');
        if (dataAttribute == null) {
            return;
        }
        TransportAddress peerAddress = peerAddressAttribute.getAddress(message.getTransactionID());
        if (peerAddress == null) {
            return;
        }
        byte[] data2 = dataAttribute.getData();
        if (data2 == null) {
            return;
        }
        try {
            packetToReceive = new DatagramPacket(data2, 0, data2.length, peerAddress);
        }
        catch (Throwable t) {
            if (t instanceof SocketException) {
                packetToReceive = null;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            packetToReceive = null;
        }
        if (packetToReceive != null) {
            List<DatagramPacket> list = this.packetsToReceive;
            synchronized (list) {
                this.packetsToReceive.add(packetToReceive);
                this.packetsToReceive.notifyAll();
            }
        }
    }

    public boolean processErrorOrFailure(Response response2, Request request) {
        switch (request.getMessageType()) {
            case '\t': {
                this.setChannelNumberIsConfirmed(request, false);
                break;
            }
            case '\b': {
                this.setChannelBound(request, false);
                break;
            }
        }
        return false;
    }

    public void processSuccess(Response response2, Request request) {
        switch (request.getMessageType()) {
            case '\t': {
                this.setChannelNumberIsConfirmed(request, true);
                break;
            }
            case '\b': {
                this.setChannelBound(request, true);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receive(DatagramPacket p) throws IOException {
        List<DatagramPacket> list = this.packetsToReceive;
        synchronized (list) {
            while (true) {
                if (this.closed) {
                    throw new SocketException(RelayedCandidateDatagramSocket.class.getSimpleName() + " has been closed.");
                }
                if (!this.packetsToReceive.isEmpty()) break;
                try {
                    this.packetsToReceive.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            DatagramPacket packetToReceive = this.packetsToReceive.remove(0);
            MultiplexingXXXSocketSupport.copy(packetToReceive, p);
            this.packetsToReceive.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runInReceiveChannelDataThread() throws SocketException {
        DatagramPacket p = null;
        while (!this.closed) {
            char length;
            int receiveBufferSize = 1500;
            if (p == null) {
                p = new DatagramPacket(new byte[receiveBufferSize], receiveBufferSize);
            } else {
                byte[] pData = p.getData();
                if (pData == null || pData.length < receiveBufferSize) {
                    p.setData(new byte[receiveBufferSize]);
                } else {
                    p.setLength(receiveBufferSize);
                }
            }
            try {
                this.channelDataSocket.receive(p);
            }
            catch (Throwable t) {
                if (t instanceof ThreadDeath) {
                    throw (ThreadDeath)t;
                }
                if (t instanceof SocketException) {
                    throw (SocketException)t;
                }
                if (!logger.isLoggable(Level.WARNING)) continue;
                logger.log(Level.WARNING, "Ignoring error while receiving from ChannelData socket", t);
                continue;
            }
            if (this.closed) break;
            int channelDataLength = p.getLength();
            if (channelDataLength < 4) continue;
            byte[] channelData = p.getData();
            int channelDataOffset = p.getOffset();
            char channelNumber = (char)(channelData[channelDataOffset++] << 8 | channelData[channelDataOffset++] & 0xFF);
            channelDataLength -= 2;
            if ((length = (char)(channelData[channelDataOffset++] << 8 | channelData[channelDataOffset++] & 0xFF)) > (channelDataLength -= 2)) continue;
            TransportAddress peerAddress = null;
            List<DatagramPacket> list = this.packetsToSend;
            synchronized (list) {
                int channelCount = this.channels.size();
                for (int channelIndex = 0; channelIndex < channelCount; ++channelIndex) {
                    Channel channel = this.channels.get(channelIndex);
                    if (!channel.channelNumberEquals(channelNumber)) continue;
                    peerAddress = channel.peerAddress;
                    break;
                }
            }
            if (peerAddress == null) continue;
            byte[] data2 = new byte[length];
            System.arraycopy(channelData, channelDataOffset, data2, 0, length);
            DatagramPacket packetToReceive = new DatagramPacket(data2, 0, length, peerAddress);
            List<DatagramPacket> list2 = this.packetsToReceive;
            synchronized (list2) {
                this.packetsToReceive.add(packetToReceive);
                this.packetsToReceive.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runInSendThread() {
        List<DatagramPacket> list = this.packetsToSend;
        synchronized (list) {
            while (!this.closed) {
                if (this.packetsToSend.isEmpty()) {
                    try {
                        this.packetsToSend.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                int packetToSendCount = this.packetsToSend.size();
                for (int packetToSendIndex = 0; packetToSendIndex < packetToSendCount; ++packetToSendIndex) {
                    DatagramPacket packetToSend = this.packetsToSend.get(packetToSendIndex);
                    int channelCount = this.channels.size();
                    TransportAddress peerAddress = new TransportAddress(packetToSend.getAddress(), packetToSend.getPort(), Transport.UDP);
                    Channel channel = null;
                    for (int channelIndex = 0; channelIndex < channelCount; ++channelIndex) {
                        Channel aChannel = this.channels.get(channelIndex);
                        if (!aChannel.peerAddressEquals(peerAddress)) continue;
                        channel = aChannel;
                        break;
                    }
                    if (channel == null) {
                        channel = new Channel(peerAddress);
                        this.channels.add(channel);
                    }
                    boolean forceBind = false;
                    if (this.channelDataSocket != null && !channel.getChannelDataIsPreferred() && !connectivityCheckRecognizer.accept(packetToSend)) {
                        channel.setChannelDataIsPreferred(true);
                        forceBind = true;
                    }
                    if (!forceBind && channel.isBound()) {
                        this.packetsToSend.remove(packetToSendIndex);
                        try {
                            channel.send(packetToSend, peerAddress);
                        }
                        catch (StunException sex) {
                            if (!logger.isLoggable(Level.INFO)) break;
                            logger.log(Level.INFO, "Failed to send through " + RelayedCandidateDatagramSocket.class.getSimpleName() + " channel.", sex);
                        }
                        break;
                    }
                    if (!forceBind && channel.isBinding()) continue;
                    try {
                        channel.bind();
                    }
                    catch (StunException sex) {
                        if (logger.isLoggable(Level.INFO)) {
                            logger.log(Level.INFO, "Failed to bind " + RelayedCandidateDatagramSocket.class.getSimpleName() + " channel.", sex);
                        }
                        this.packetsToSend.remove(packetToSendIndex);
                        break;
                    }
                    if (forceBind) break;
                }
                if (this.packetsToSend.size() != packetToSendCount) continue;
                try {
                    this.packetsToSend.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(DatagramPacket p) throws IOException {
        List<DatagramPacket> list = this.packetsToSend;
        synchronized (list) {
            if (this.closed) {
                throw new IOException(RelayedCandidateDatagramSocket.class.getSimpleName() + " has been closed.");
            }
            this.packetsToSend.add(MultiplexingXXXSocketSupport.clone(p));
            if (this.sendThread == null) {
                this.createSendThread();
            } else {
                this.packetsToSend.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setChannelBound(Request request, boolean bound) {
        XorPeerAddressAttribute peerAddressAttribute = (XorPeerAddressAttribute)request.getAttribute('\u0012');
        byte[] transactionID = request.getTransactionID();
        TransportAddress peerAddress = peerAddressAttribute.getAddress(transactionID);
        List<DatagramPacket> list = this.packetsToSend;
        synchronized (list) {
            int channelCount = this.channels.size();
            for (int channelIndex = 0; channelIndex < channelCount; ++channelIndex) {
                Channel channel = this.channels.get(channelIndex);
                if (!channel.peerAddressEquals(peerAddress)) continue;
                channel.setBound(bound, transactionID);
                this.packetsToSend.notifyAll();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setChannelNumberIsConfirmed(Request request, boolean channelNumberIsConfirmed) {
        XorPeerAddressAttribute peerAddressAttribute = (XorPeerAddressAttribute)request.getAttribute('\u0012');
        byte[] transactionID = request.getTransactionID();
        TransportAddress peerAddress = peerAddressAttribute.getAddress(transactionID);
        List<DatagramPacket> list = this.packetsToSend;
        synchronized (list) {
            int channelCount = this.channels.size();
            for (int channelIndex = 0; channelIndex < channelCount; ++channelIndex) {
                Channel channel = this.channels.get(channelIndex);
                if (!channel.peerAddressEquals(peerAddress)) continue;
                channel.setChannelNumberIsConfirmed(channelNumberIsConfirmed, transactionID);
                this.packetsToSend.notifyAll();
                break;
            }
        }
    }

    private class Channel {
        private long bindingTimeStamp = -1L;
        private byte[] bindingTransactionID;
        private boolean bound = false;
        private byte[] channelData;
        private boolean channelDataIsPreferred = false;
        private DatagramPacket channelDataPacket;
        private char channelNumber = '\u0000';
        private boolean channelNumberIsConfirmed;
        public final TransportAddress peerAddress;

        public Channel(TransportAddress peerAddress) {
            this.peerAddress = peerAddress;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void bind() throws StunException {
            byte[] createPermissionTransactionID = TransactionID.createNewTransactionID().getBytes();
            Request createPermissionRequest = MessageFactory.createCreatePermissionRequest(this.peerAddress, createPermissionTransactionID);
            createPermissionRequest.setTransactionID(createPermissionTransactionID);
            RelayedCandidateDatagramSocket.this.turnCandidateHarvest.sendRequest(RelayedCandidateDatagramSocket.this, createPermissionRequest);
            this.bindingTransactionID = createPermissionTransactionID;
            this.bindingTimeStamp = System.currentTimeMillis();
            if (this.channelDataIsPreferred) {
                if (this.channelNumber == '\u0000') {
                    this.channelNumber = RelayedCandidateDatagramSocket.this.getNextChannelNumber();
                    this.channelNumberIsConfirmed = false;
                }
                if (this.channelNumber != '\u0000') {
                    byte[] channelBindTransactionID = TransactionID.createNewTransactionID().getBytes();
                    Request channelBindRequest = MessageFactory.createChannelBindRequest(this.channelNumber, this.peerAddress, channelBindTransactionID);
                    channelBindRequest.setTransactionID(channelBindTransactionID);
                    List list = RelayedCandidateDatagramSocket.this.packetsToReceive;
                    synchronized (list) {
                        if (!RelayedCandidateDatagramSocket.this.closed && RelayedCandidateDatagramSocket.this.receiveChannelDataThread == null) {
                            RelayedCandidateDatagramSocket.this.createReceiveChannelDataThread();
                        }
                    }
                    RelayedCandidateDatagramSocket.this.turnCandidateHarvest.sendRequest(RelayedCandidateDatagramSocket.this, channelBindRequest);
                }
            }
        }

        public boolean channelNumberEquals(char channelNumber) {
            return this.channelNumber == channelNumber;
        }

        public boolean getChannelDataIsPreferred() {
            return this.channelDataIsPreferred;
        }

        public boolean isBinding() {
            return this.bindingTransactionID != null;
        }

        public boolean isBound() {
            if (this.bindingTimeStamp == -1L || this.bindingTimeStamp + 300000L - 60000L < System.currentTimeMillis()) {
                return false;
            }
            return this.bindingTransactionID == null && this.bound;
        }

        public boolean peerAddressEquals(TransportAddress peerAddress) {
            if (RelayedCandidateDatagramSocket.this.channelDataSocket != null) {
                return this.peerAddress.equals(peerAddress);
            }
            return this.peerAddress.getAddress().equals(peerAddress.getAddress());
        }

        public void send(DatagramPacket p, TransportAddress peerAddress) throws StunException {
            byte[] data2;
            byte[] pData = p.getData();
            int pOffset = p.getOffset();
            int pLength = p.getLength();
            if (pOffset == 0 && pLength == pData.length) {
                data2 = pData;
            } else {
                data2 = new byte[pLength];
                System.arraycopy(pData, pOffset, data2, 0, pLength);
            }
            if (this.channelDataIsPreferred && this.channelNumber != '\u0000' && this.channelNumberIsConfirmed) {
                char length = (char)data2.length;
                int channelDataLength = 4 + length;
                if (this.channelData == null || this.channelData.length < channelDataLength) {
                    this.channelData = new byte[channelDataLength];
                    if (this.channelDataPacket != null) {
                        this.channelDataPacket.setData(this.channelData);
                    }
                }
                this.channelData[0] = (byte)(this.channelNumber >> 8);
                this.channelData[1] = (byte)(this.channelNumber & 0xFF);
                this.channelData[2] = (byte)(length >> 8);
                this.channelData[3] = (byte)(length & 0xFF);
                System.arraycopy(data2, 0, this.channelData, 4, length);
                try {
                    if (this.channelDataPacket == null) {
                        this.channelDataPacket = new DatagramPacket(this.channelData, 0, channelDataLength, ((RelayedCandidateDatagramSocket)RelayedCandidateDatagramSocket.this).turnCandidateHarvest.harvester.stunServer);
                    } else {
                        this.channelDataPacket.setData(this.channelData, 0, channelDataLength);
                    }
                    RelayedCandidateDatagramSocket.this.channelDataSocket.send(this.channelDataPacket);
                }
                catch (IOException ioex) {
                    throw new StunException(4, "Failed to send TURN ChannelData message", ioex);
                }
            } else {
                byte[] transactionID = TransactionID.createNewTransactionID().getBytes();
                Indication sendIndication = MessageFactory.createSendIndication(peerAddress, data2, transactionID);
                sendIndication.setTransactionID(transactionID);
                ((RelayedCandidateDatagramSocket)RelayedCandidateDatagramSocket.this).turnCandidateHarvest.harvester.getStunStack().sendIndication(sendIndication, ((RelayedCandidateDatagramSocket)RelayedCandidateDatagramSocket.this).turnCandidateHarvest.harvester.stunServer, ((RelayedCandidateDatagramSocket)RelayedCandidateDatagramSocket.this).turnCandidateHarvest.hostCandidate.getTransportAddress());
            }
        }

        public void setBound(boolean bound, byte[] boundTransactionID) {
            if (this.bindingTransactionID != null) {
                this.bindingTransactionID = null;
                this.bound = bound;
            }
        }

        public void setChannelDataIsPreferred(boolean channelDataIsPreferred) {
            this.channelDataIsPreferred = channelDataIsPreferred;
        }

        public void setChannelNumberIsConfirmed(boolean channelNumberIsConfirmed, byte[] channelNumberIsConfirmedTransactionID) {
            this.channelNumberIsConfirmed = channelNumberIsConfirmed;
        }
    }
}

