/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.ice4j.socket;

import gg.essential.lib.ice4j.socket.DatagramPacketFilter;
import gg.essential.lib.ice4j.socket.MultiplexedXXXSocket;
import gg.essential.lib.ice4j.socket.SocketReceiveBuffer;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

abstract class MultiplexingXXXSocketSupport<MultiplexedXXXSocketT extends MultiplexedXXXSocket> {
    private static final Logger logger = Logger.getLogger(MultiplexingXXXSocketSupport.class.getName());
    private static final int RECEIVE_DATAGRAM_PACKETS_POOL_SIZE = 64;
    private static final int POOLED_DATAGRAM_PACKET_SIZE = 1500;
    private final BlockingQueue<DatagramPacket> receiveDatagramPacketsPool = new ArrayBlockingQueue<DatagramPacket>(64);
    private boolean inReceive = false;
    private int receiveBufferSize;
    private final Object receiveSyncRoot = new Object();
    private boolean setReceiveBufferSize = false;
    private final List<MultiplexedXXXSocketT> sockets = new ArrayList<MultiplexedXXXSocketT>();

    public static DatagramPacket clone(DatagramPacket p) {
        return MultiplexingXXXSocketSupport.clone(p, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DatagramPacket clone(DatagramPacket p, boolean arraycopy) {
        int port;
        InetAddress address;
        int len;
        int off;
        byte[] data2;
        DatagramPacket datagramPacket = p;
        synchronized (datagramPacket) {
            data2 = p.getData();
            off = p.getOffset();
            len = p.getLength();
            byte[] dataClone = new byte[data2.length];
            if (arraycopy && len > 0) {
                int arraycopyLen;
                int arraycopyOff;
                if (off >= 0 && off < data2.length && off + len <= data2.length) {
                    arraycopyOff = off;
                    arraycopyLen = len;
                } else {
                    arraycopyOff = 0;
                    arraycopyLen = data2.length;
                }
                System.arraycopy(data2, arraycopyOff, dataClone, arraycopyOff, arraycopyLen);
            }
            data2 = dataClone;
            address = p.getAddress();
            port = p.getPort();
        }
        DatagramPacket c = new DatagramPacket(data2, off, len);
        if (address != null) {
            c.setAddress(address);
        }
        if (port >= 0) {
            c.setPort(port);
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(DatagramPacket src, DatagramPacket dest) {
        DatagramPacket datagramPacket = dest;
        synchronized (datagramPacket) {
            dest.setAddress(src.getAddress());
            dest.setPort(src.getPort());
            byte[] srcData = src.getData();
            if (srcData == null) {
                dest.setLength(0);
            } else {
                byte[] destData = dest.getData();
                if (destData == null) {
                    dest.setLength(0);
                } else {
                    int srcLength;
                    int destOffset = dest.getOffset();
                    int destLength = destData.length - destOffset;
                    if (destLength >= (srcLength = src.getLength())) {
                        destLength = srcLength;
                    } else if (logger.isLoggable(Level.WARNING)) {
                        logger.log(Level.WARNING, "Truncating received DatagramPacket data!");
                    }
                    System.arraycopy(srcData, src.getOffset(), destData, destOffset, destLength);
                    dest.setLength(destLength);
                }
            }
        }
    }

    protected MultiplexingXXXSocketSupport() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acceptBySocketsOrThis(DatagramPacket p) {
        List<MultiplexedXXXSocketT> list = this.sockets;
        synchronized (list) {
            boolean accepted = false;
            for (MultiplexedXXXSocket socket : this.sockets) {
                SocketReceiveBuffer socketReceived;
                if (!this.getFilter(socket).accept(p)) continue;
                SocketReceiveBuffer socketReceiveBuffer = socketReceived = this.getReceived(socket);
                synchronized (socketReceiveBuffer) {
                    socketReceived.add(accepted ? MultiplexingXXXSocketSupport.clone(p, true) : p);
                    socketReceived.notifyAll();
                }
                accepted = true;
            }
            if (!accepted) {
                SocketReceiveBuffer thisReceived;
                SocketReceiveBuffer socketReceiveBuffer = thisReceived = this.getReceived();
                synchronized (socketReceiveBuffer) {
                    thisReceived.add(p);
                    thisReceived.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean close(MultiplexedXXXSocketT multiplexed) {
        List<MultiplexedXXXSocketT> list = this.sockets;
        synchronized (list) {
            this.sockets.remove(multiplexed);
            return !this.sockets.isEmpty();
        }
    }

    protected abstract MultiplexedXXXSocketT createSocket(DatagramPacketFilter var1) throws SocketException;

    protected abstract void doReceive(DatagramPacket var1) throws IOException;

    protected abstract void doSetReceiveBufferSize(int var1) throws SocketException;

    protected DatagramPacketFilter getFilter(MultiplexedXXXSocketT socket) {
        return socket.getFilter();
    }

    protected abstract SocketReceiveBuffer getReceived();

    protected abstract SocketReceiveBuffer getReceived(MultiplexedXXXSocketT var1);

    public MultiplexedXXXSocketT getSocket(DatagramPacketFilter filter2) throws SocketException {
        return this.getSocket(filter2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiplexedXXXSocketT getSocket(DatagramPacketFilter filter2, boolean create) throws SocketException {
        if (filter2 == null) {
            throw new NullPointerException("filter");
        }
        List<MultiplexedXXXSocketT> list = this.sockets;
        synchronized (list) {
            for (MultiplexedXXXSocket socket : this.sockets) {
                if (!filter2.equals(this.getFilter(socket))) continue;
                return (MultiplexedXXXSocketT)socket;
            }
            if (!create) {
                return null;
            }
            MultiplexedXXXSocketT socket = this.createSocket(filter2);
            if (socket != null) {
                this.sockets.add(socket);
                this.moveReceivedFromThisToSocket(socket);
            }
            return socket;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveReceivedFromThisToSocket(MultiplexedXXXSocketT socket) {
        List<DatagramPacket> toMove;
        SocketReceiveBuffer thisReceived = this.getReceived();
        DatagramPacketFilter socketFilter = this.getFilter(socket);
        SocketReceiveBuffer socketReceiveBuffer = thisReceived;
        synchronized (socketReceiveBuffer) {
            toMove = thisReceived.scan(socketFilter);
        }
        if (!toMove.isEmpty()) {
            SocketReceiveBuffer socketReceived;
            SocketReceiveBuffer socketReceiveBuffer2 = socketReceived = this.getReceived(socket);
            synchronized (socketReceiveBuffer2) {
                for (DatagramPacket datagramPacket : toMove) {
                    socketReceived.add(datagramPacket);
                }
                socketReceived.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void receive(SocketReceiveBuffer received, DatagramPacket p, int timeout2) throws IOException {
        Object object;
        long startTime = System.currentTimeMillis();
        while (true) {
            DatagramPacket receivePacket;
            block34: {
                boolean wait;
                long remainingTimeout;
                long now = System.currentTimeMillis();
                SocketReceiveBuffer socketReceiveBuffer = received;
                // MONITORENTER : socketReceiveBuffer
                DatagramPacket receivedPacket = received.poll();
                if (receivedPacket != null) {
                    // MONITOREXIT : socketReceiveBuffer
                    MultiplexingXXXSocketSupport.copy(receivedPacket, p);
                    this.receiveDatagramPacketsPool.offer(receivedPacket);
                    return;
                }
                // MONITOREXIT : socketReceiveBuffer
                if (timeout2 > 0) {
                    remainingTimeout = (long)timeout2 - (now - startTime);
                    if (remainingTimeout <= 0L) {
                        throw new SocketTimeoutException(Long.toString(remainingTimeout));
                    }
                } else {
                    remainingTimeout = 1000L;
                }
                object = this.receiveSyncRoot;
                // MONITORENTER : object
                if (this.inReceive) {
                    wait = true;
                } else {
                    wait = false;
                    this.inReceive = true;
                }
                // MONITOREXIT : object
                if (wait) {
                    object = received;
                    // MONITORENTER : object
                    if (received.isEmpty()) {
                        try {
                            received.wait(remainingTimeout);
                        }
                        catch (InterruptedException interruptedException) {}
                    } else {
                        received.notifyAll();
                    }
                    // MONITOREXIT : object
                    continue;
                }
                receivePacket = (DatagramPacket)this.receiveDatagramPacketsPool.poll();
                if (receivePacket == null) {
                    receivePacket = new DatagramPacket(new byte[1500], 1500);
                }
                receivePacket.setLength(1500);
                Object object2 = this.receiveSyncRoot;
                // MONITORENTER : object2
                if (this.setReceiveBufferSize) {
                    this.setReceiveBufferSize = false;
                    try {
                        this.doSetReceiveBufferSize(this.receiveBufferSize);
                    }
                    catch (Throwable t) {
                        if (!(t instanceof ThreadDeath)) break block34;
                        throw (ThreadDeath)t;
                    }
                }
            }
            // MONITOREXIT : object2
            this.doReceive(receivePacket);
            this.acceptBySocketsOrThis(receivePacket);
            continue;
            break;
        }
        finally {
            object = this.receiveSyncRoot;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReceiveBufferSize(int receiveBufferSize) throws SocketException {
        Object object = this.receiveSyncRoot;
        synchronized (object) {
            this.receiveBufferSize = receiveBufferSize;
            if (this.inReceive) {
                this.setReceiveBufferSize = true;
            } else {
                this.doSetReceiveBufferSize(receiveBufferSize);
                this.setReceiveBufferSize = false;
            }
        }
    }
}

