/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.ice4j.socket;

import gg.essential.lib.ice4j.socket.DatagramPacketFilter;
import gg.essential.lib.ice4j.socket.MultiplexedDatagramSocket;
import gg.essential.lib.ice4j.socket.MultiplexingXXXSocketSupport;
import gg.essential.lib.ice4j.socket.SafeCloseDatagramSocket;
import gg.essential.lib.ice4j.socket.SocketReceiveBuffer;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.SocketException;

public class MultiplexingDatagramSocket
extends SafeCloseDatagramSocket {
    private final MultiplexingXXXSocketSupport<MultiplexedDatagramSocket> multiplexingXXXSocketSupport = new MultiplexingXXXSocketSupport<MultiplexedDatagramSocket>(){

        @Override
        protected MultiplexedDatagramSocket createSocket(DatagramPacketFilter filter2) throws SocketException {
            return new MultiplexedDatagramSocket(MultiplexingDatagramSocket.this, filter2);
        }

        @Override
        protected void doReceive(DatagramPacket p) throws IOException {
            MultiplexingDatagramSocket.this.multiplexingXXXSocketSupportDoReceive(p);
        }

        @Override
        protected void doSetReceiveBufferSize(int receiveBufferSize) throws SocketException {
            MultiplexingDatagramSocket.this.multiplexingXXXSocketSupportDoSetReceiveBufferSize(receiveBufferSize);
        }

        @Override
        protected SocketReceiveBuffer getReceived() {
            return MultiplexingDatagramSocket.this.received;
        }

        @Override
        protected SocketReceiveBuffer getReceived(MultiplexedDatagramSocket socket) {
            return socket.received;
        }
    };
    private final SocketReceiveBuffer received = new SocketReceiveBuffer(this::getReceiveBufferSize);
    private int soTimeout = 0;
    private final boolean persistent;

    public MultiplexingDatagramSocket() throws SocketException {
        this(false);
    }

    public MultiplexingDatagramSocket(boolean persistent) throws SocketException {
        this.persistent = persistent;
    }

    public MultiplexingDatagramSocket(DatagramSocket delegate) throws SocketException {
        this(delegate, false);
    }

    public MultiplexingDatagramSocket(DatagramSocket delegate, boolean persistent) throws SocketException {
        super(delegate);
        this.persistent = persistent;
    }

    public MultiplexingDatagramSocket(int port) throws SocketException {
        this(port, false);
    }

    public MultiplexingDatagramSocket(int port, boolean persistent) throws SocketException {
        super(port);
        this.persistent = persistent;
    }

    public MultiplexingDatagramSocket(int port, InetAddress laddr) throws SocketException {
        this(port, laddr, false);
    }

    public MultiplexingDatagramSocket(int port, InetAddress laddr, boolean persistent) throws SocketException {
        super(port, laddr);
        this.persistent = persistent;
    }

    public MultiplexingDatagramSocket(SocketAddress bindaddr) throws SocketException {
        this(bindaddr, false);
    }

    public MultiplexingDatagramSocket(SocketAddress bindaddr, boolean persistent) throws SocketException {
        super(bindaddr);
        this.persistent = persistent;
    }

    void close(MultiplexedDatagramSocket multiplexed) {
        if (!this.multiplexingXXXSocketSupport.close(multiplexed) && !this.persistent) {
            this.close();
        }
    }

    public MultiplexedDatagramSocket getSocket(DatagramPacketFilter filter2) throws SocketException {
        return this.getSocket(filter2, true);
    }

    public MultiplexedDatagramSocket getSocket(DatagramPacketFilter filter2, boolean create) throws SocketException {
        return this.multiplexingXXXSocketSupport.getSocket(filter2, create);
    }

    @Override
    public int getSoTimeout() {
        return this.soTimeout;
    }

    private void multiplexingXXXSocketSupportDoReceive(DatagramPacket p) throws IOException {
        super.receive(p);
    }

    private void multiplexingXXXSocketSupportDoSetReceiveBufferSize(int receiveBufferSize) throws SocketException {
        super.setReceiveBufferSize(receiveBufferSize);
    }

    @Override
    public void receive(DatagramPacket p) throws IOException {
        this.multiplexingXXXSocketSupport.receive(this.received, p, this.soTimeout);
    }

    void receive(MultiplexedDatagramSocket multiplexed, DatagramPacket p) throws IOException {
        this.multiplexingXXXSocketSupport.receive(multiplexed.received, p, multiplexed.getSoTimeout());
    }

    @Override
    public void setReceiveBufferSize(int receiveBufferSize) throws SocketException {
        this.multiplexingXXXSocketSupport.setReceiveBufferSize(receiveBufferSize);
    }

    @Override
    public void setSoTimeout(int timeout2) throws SocketException {
        super.setSoTimeout(timeout2);
        this.soTimeout = timeout2;
    }
}

