/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.ice4j.socket;

import gg.essential.lib.ice4j.StunResponseEvent;
import gg.essential.lib.ice4j.TransportAddress;
import gg.essential.lib.ice4j.ice.CandidatePair;
import gg.essential.lib.ice4j.ice.GoogleRelayedCandidate;
import gg.essential.lib.ice4j.ice.harvest.GoogleTurnCandidateHarvest;
import gg.essential.lib.ice4j.message.Request;
import gg.essential.lib.ice4j.message.Response;
import gg.essential.lib.ice4j.socket.DelegatingSocket;
import gg.essential.lib.ice4j.socket.GoogleRelayedCandidateDelegate;
import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.util.logging.Logger;

public class GoogleRelayedCandidateSocket
extends DelegatingSocket {
    private static final Logger logger = Logger.getLogger(GoogleRelayedCandidateSocket.class.getName());
    private boolean closed = false;
    private final GoogleRelayedCandidate relayedCandidate;
    private final GoogleRelayedCandidateDelegate socketDelegate;
    private TCPOutputStream outputStream = null;

    public GoogleRelayedCandidateSocket(GoogleRelayedCandidate relayedCandidate, GoogleTurnCandidateHarvest turnCandidateHarvest, String username) throws SocketException {
        this.relayedCandidate = relayedCandidate;
        this.socketDelegate = new GoogleRelayedCandidateDelegate(turnCandidateHarvest, username);
        logger.finest("Create new GoogleRelayedCandidateSocket");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        GoogleRelayedCandidateSocket googleRelayedCandidateSocket = this;
        synchronized (googleRelayedCandidateSocket) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        this.socketDelegate.close();
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.getLocalSocketAddress().getAddress();
    }

    @Override
    public int getLocalPort() {
        return this.getLocalSocketAddress().getPort();
    }

    @Override
    public InetSocketAddress getLocalSocketAddress() {
        return this.getRelayedCandidate().getTransportAddress();
    }

    public final GoogleRelayedCandidate getRelayedCandidate() {
        return this.relayedCandidate;
    }

    public void processSuccess(Response response2, Request request) {
        this.socketDelegate.processSuccess(response2, request);
    }

    public void processResponse(StunResponseEvent response2) {
        this.socketDelegate.processResponse(response2);
    }

    @Override
    public void receive(DatagramPacket p) throws IOException {
        this.socketDelegate.receive(p);
    }

    @Override
    public void send(DatagramPacket p) throws IOException {
        this.socketDelegate.send(p);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.outputStream == null) {
            CandidatePair pair = this.relayedCandidate.getParentComponent().getSelectedPair();
            if (pair.getLocalCandidate() == this.relayedCandidate) {
                TransportAddress target = pair.getRemoteCandidate().getTransportAddress();
                this.outputStream = new TCPOutputStream(target);
            } else {
                throw new IOException("TURN-TCP socket is not selected");
            }
        }
        return this.outputStream;
    }

    protected class TCPOutputStream
    extends OutputStream {
        private final TransportAddress target;

        public TCPOutputStream(TransportAddress target) {
            this.target = target;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            DatagramPacket p = new DatagramPacket(b, off, len, this.target);
            GoogleRelayedCandidateSocket.this.send(p);
        }

        @Override
        public void write(int arg0) throws IOException {
        }
    }
}

