/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.ice4j.ice.harvest;

import gg.essential.lib.ice4j.TransportAddress;
import gg.essential.lib.ice4j.ice.harvest.MappingCandidateHarvester;
import gg.essential.lib.ice4j.socket.IceSocketWrapper;
import gg.essential.lib.ice4j.socket.IceUdpSocketWrapper;
import gg.essential.lib.ice4j.stunclient.SimpleAddressDetector;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StunMappingCandidateHarvester
extends MappingCandidateHarvester {
    private static final Logger logger = Logger.getLogger(StunMappingCandidateHarvester.class.getName());
    private final TransportAddress stunServerAddress;
    @NotNull
    private TransportAddress localAddress;
    private TransportAddress publicAddress = null;

    public StunMappingCandidateHarvester(@NotNull TransportAddress localAddress, TransportAddress stunServerAddress) {
        super("stun");
        this.localAddress = localAddress;
        this.stunServerAddress = stunServerAddress;
    }

    public void discover() {
        try {
            SimpleAddressDetector sad = new SimpleAddressDetector(this.stunServerAddress);
            sad.start();
            IceUdpSocketWrapper localSocket = new IceUdpSocketWrapper(new DatagramSocket(this.localAddress));
            this.publicAddress = sad.getMappingFor(localSocket);
            SocketAddress boundAddr = ((IceSocketWrapper)localSocket).getLocalSocketAddress();
            if (boundAddr instanceof InetSocketAddress) {
                this.localAddress = new TransportAddress((InetSocketAddress)boundAddr, this.localAddress.getTransport());
            }
            if (this.publicAddress != null) {
                logger.info("Discovered public address " + this.publicAddress + " from STUN server " + this.stunServerAddress + " using local address " + localSocket);
            }
        }
        catch (Exception exc) {
            logger.log(Level.INFO, "We failed to obtain addresses for the following reason: ", exc);
        }
    }

    @Override
    @Nullable
    public TransportAddress getFace() {
        return this.localAddress;
    }

    @Override
    @Nullable
    public TransportAddress getMask() {
        return this.publicAddress;
    }
}

