/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.ice4j.ice.harvest;

import gg.essential.lib.ice4j.Transport;
import gg.essential.lib.ice4j.TransportAddress;
import gg.essential.lib.ice4j.attribute.Attribute;
import gg.essential.lib.ice4j.attribute.LifetimeAttribute;
import gg.essential.lib.ice4j.attribute.MappedAddressAttribute;
import gg.essential.lib.ice4j.ice.ComponentSocket;
import gg.essential.lib.ice4j.ice.GoogleRelayedCandidate;
import gg.essential.lib.ice4j.ice.HostCandidate;
import gg.essential.lib.ice4j.ice.harvest.GoogleTurnCandidateHarvester;
import gg.essential.lib.ice4j.ice.harvest.StunCandidateHarvest;
import gg.essential.lib.ice4j.message.MessageFactory;
import gg.essential.lib.ice4j.message.Request;
import gg.essential.lib.ice4j.message.Response;
import gg.essential.lib.ice4j.socket.GoogleRelayedCandidateDatagramSocket;
import gg.essential.lib.ice4j.socket.GoogleRelayedCandidateSocket;
import gg.essential.lib.ice4j.socket.IceSocketWrapper;
import gg.essential.lib.ice4j.socket.RelayedCandidateDatagramSocket;
import gg.essential.lib.ice4j.stack.TransactionID;
import java.util.logging.Logger;

public class GoogleTurnCandidateHarvest
extends StunCandidateHarvest {
    private static final Logger logger = Logger.getLogger(GoogleTurnCandidateHarvest.class.getName());
    private Request requestToStartResolvingCandidate;
    private String password;

    public GoogleTurnCandidateHarvest(GoogleTurnCandidateHarvester harvester, HostCandidate hostCandidate, String password) {
        super(harvester, hostCandidate);
        this.password = password;
    }

    @Override
    protected void createCandidates(Response response2) {
        this.createRelayedCandidate(response2);
    }

    private void createRelayedCandidate(Response response2) {
        Attribute attribute = response2.getAttribute('\u0001');
        if (attribute != null) {
            GoogleRelayedCandidate relayedCandidate;
            TransportAddress relayedAddress = ((MappedAddressAttribute)attribute).getAddress();
            if (this.harvester.stunServer.getTransport() == Transport.TCP) {
                relayedAddress = new TransportAddress(relayedAddress.getAddress(), this.harvester.stunServer.getPort(), Transport.TCP);
            }
            if ((relayedCandidate = this.createRelayedCandidate(relayedAddress, this.getMappedAddress(response2))) != null) {
                this.harvester.getStunStack().addSocket(relayedCandidate.getStunSocket(null));
                IceSocketWrapper candidateSocket = relayedCandidate.getCandidateIceSocketWrapper();
                ComponentSocket componentSocket = relayedCandidate.getParentComponent().getComponentSocket();
                if (componentSocket != null) {
                    componentSocket.add(candidateSocket);
                }
                this.addCandidate(relayedCandidate);
            }
        }
    }

    protected GoogleRelayedCandidate createRelayedCandidate(TransportAddress transportAddress, TransportAddress mappedAddress) {
        GoogleRelayedCandidate candidate = new GoogleRelayedCandidate(transportAddress, this, mappedAddress, this.harvester.getShortTermCredentialUsername(), this.password);
        candidate.setUfrag(this.harvester.getShortTermCredentialUsername());
        return candidate;
    }

    @Override
    protected Request createRequestToStartResolvingCandidate() {
        if (this.requestToStartResolvingCandidate == null) {
            this.requestToStartResolvingCandidate = MessageFactory.createGoogleAllocateRequest(this.harvester.getShortTermCredentialUsername());
            return this.requestToStartResolvingCandidate;
        }
        return null;
    }

    @Override
    protected boolean addShortTermCredentialAttributes(Request request) {
        return false;
    }

    @Override
    protected boolean completedResolvingCandidate(Request request, Response response2) {
        if (response2 == null || !response2.isSuccessResponse() && request.getMessageType() == '\u0003') {
            try {
                if (this.startResolvingCandidate()) {
                    return false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.completedResolvingCandidate(request, response2);
    }

    public void close(GoogleRelayedCandidateDatagramSocket relayedCandidateSocket) {
        this.setSendKeepAliveMessageInterval(0L);
    }

    @Override
    protected boolean processErrorOrFailure(Response response2, Request request, TransactionID transactionID) {
        logger.info("Google TURN processErrorOrFailure");
        Object applicationData = transactionID.getApplicationData();
        if (applicationData instanceof GoogleRelayedCandidateDatagramSocket && ((RelayedCandidateDatagramSocket)applicationData).processErrorOrFailure(response2, request)) {
            return true;
        }
        if (applicationData instanceof GoogleRelayedCandidateDatagramSocket && ((RelayedCandidateDatagramSocket)applicationData).processErrorOrFailure(response2, request)) {
            return true;
        }
        return super.processErrorOrFailure(response2, request, transactionID);
    }

    @Override
    protected void processSuccess(Response response2, Request request, TransactionID transactionID) {
        Object applicationData;
        super.processSuccess(response2, request, transactionID);
        int lifetime = -1;
        switch (response2.getMessageType()) {
            case '\u0103': {
                LifetimeAttribute lifetimeAttribute = (LifetimeAttribute)response2.getAttribute('\r');
                lifetime = lifetimeAttribute == null ? 600 : lifetimeAttribute.getLifetime();
                logger.info("Successful Google TURN allocate");
                break;
            }
        }
        if (lifetime >= 0) {
            this.setSendKeepAliveMessageInterval(1000L * (long)lifetime);
        }
        if ((applicationData = transactionID.getApplicationData()) instanceof GoogleRelayedCandidateDatagramSocket) {
            ((GoogleRelayedCandidateDatagramSocket)applicationData).processSuccess(response2, request);
        } else if (applicationData instanceof GoogleRelayedCandidateSocket) {
            ((GoogleRelayedCandidateSocket)applicationData).processSuccess(response2, request);
        }
    }
}

