/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.ice4j.ice.harvest;

import gg.essential.lib.ice4j.ice.Component;
import gg.essential.lib.ice4j.ice.harvest.CandidateHarvesterSetElement;
import gg.essential.lib.ice4j.ice.harvest.TrickleCallback;
import java.util.Collection;
import java.util.logging.Logger;

class CandidateHarvesterSetTask
implements Runnable {
    private static final Logger logger = Logger.getLogger(CandidateHarvesterSetTask.class.getName());
    private CandidateHarvesterSetElement harvester;
    private Collection<Component> components;
    private final TrickleCallback trickleCallback;

    public CandidateHarvesterSetTask(CandidateHarvesterSetElement harvester, Collection<Component> components, TrickleCallback trickleCallback) {
        this.harvester = harvester;
        this.components = components;
        this.trickleCallback = trickleCallback;
    }

    public CandidateHarvesterSetElement getHarvester() {
        return this.harvester;
    }

    @Override
    public void run() {
        if (this.harvester == null || !this.harvester.isEnabled()) {
            return;
        }
        for (Component component2 : this.components) {
            try {
                this.harvester.harvest(component2, this.trickleCallback);
            }
            catch (Throwable t) {
                logger.info("disabling harvester due to exception: " + t.getLocalizedMessage());
                this.harvester.setEnabled(false);
                if (!(t instanceof ThreadDeath)) continue;
                throw (ThreadDeath)t;
            }
        }
        this.harvester = null;
    }
}

