/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.ice4j.ice.harvest;

import gg.essential.lib.ice4j.ice.Component;
import gg.essential.lib.ice4j.ice.LocalCandidate;
import gg.essential.lib.ice4j.ice.harvest.CandidateHarvester;
import gg.essential.lib.ice4j.ice.harvest.TrickleCallback;
import java.util.Collection;
import java.util.logging.Logger;

class CandidateHarvesterSetElement {
    private static final Logger logger = Logger.getLogger(CandidateHarvesterSetElement.class.getName());
    private boolean enabled = true;
    private final CandidateHarvester harvester;

    public CandidateHarvesterSetElement(CandidateHarvester harvester) {
        this.harvester = harvester;
        harvester.getHarvestStatistics().harvesterName = harvester.toString();
    }

    public void harvest(Component component2, TrickleCallback trickleCallback) {
        if (!this.isEnabled()) {
            return;
        }
        this.startHarvestTiming();
        Collection<LocalCandidate> candidates = this.harvester.harvest(component2);
        this.stopHarvestTiming(candidates);
        if (candidates == null || candidates.isEmpty()) {
            this.setEnabled(false);
        } else if (trickleCallback != null) {
            trickleCallback.onIceCandidates(candidates);
        }
    }

    public boolean harvesterEquals(CandidateHarvester harvester) {
        return this.harvester.equals(harvester);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        logger.fine((enabled ? "Enabling: " : "Disabling: ") + this.harvester);
        this.enabled = enabled;
    }

    public CandidateHarvester getHarvester() {
        return this.harvester;
    }

    private void startHarvestTiming() {
        this.harvester.getHarvestStatistics().startHarvestTiming();
    }

    private void stopHarvestTiming(Collection<LocalCandidate> harvest) {
        this.harvester.getHarvestStatistics().stopHarvestTiming(harvest);
    }
}

