/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.ice4j.ice;

import gg.essential.lib.ice4j.TransportAddress;
import gg.essential.lib.ice4j.ice.CandidateExtendedType;
import gg.essential.lib.ice4j.ice.CandidateType;
import gg.essential.lib.ice4j.ice.Component;
import gg.essential.lib.ice4j.ice.LocalCandidate;
import gg.essential.lib.ice4j.socket.IceSocketWrapper;
import gg.essential.lib.weupnp.GatewayDevice;

public class UPNPCandidate
extends LocalCandidate {
    private GatewayDevice device = null;

    public UPNPCandidate(TransportAddress transportAddress, LocalCandidate base, Component parentComponent, GatewayDevice device) {
        super(transportAddress, parentComponent, CandidateType.SERVER_REFLEXIVE_CANDIDATE, CandidateExtendedType.UPNP_CANDIDATE, base);
        this.setBase(base);
        this.device = device;
        this.setStunServerAddress(transportAddress);
    }

    @Override
    protected void free() {
        try {
            this.device.deletePortMapping(this.getTransportAddress().getPort(), "UDP");
        }
        catch (Exception exception) {
            // empty catch block
        }
        IceSocketWrapper socket = this.getCandidateIceSocketWrapper();
        if (socket != null) {
            socket.close();
        }
        this.device = null;
    }

    @Override
    public IceSocketWrapper getCandidateIceSocketWrapper() {
        return ((LocalCandidate)this.getBase()).getCandidateIceSocketWrapper();
    }

    @Override
    protected IceSocketWrapper getIceSocketWrapper() {
        return ((LocalCandidate)this.getBase()).getIceSocketWrapper();
    }
}

