/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.ice4j.ice;

import gg.essential.lib.ice4j.Transport;
import gg.essential.lib.ice4j.TransportAddress;
import gg.essential.lib.ice4j.ice.Component;
import gg.essential.lib.ice4j.ice.HostCandidate;
import gg.essential.lib.ice4j.socket.IceSocketWrapper;
import gg.essential.lib.ice4j.stack.StunStack;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.LinkedList;
import java.util.List;

public class TcpHostCandidate
extends HostCandidate {
    private final List<IceSocketWrapper> sockets = new LinkedList<IceSocketWrapper>();

    public TcpHostCandidate(TransportAddress transportAddress, Component parentComponent) {
        super(transportAddress, parentComponent);
    }

    @Override
    protected IceSocketWrapper getCandidateIceSocketWrapper(SocketAddress remoteAddress) {
        for (IceSocketWrapper socket : this.sockets) {
            if (!socket.getTCPSocket().getRemoteSocketAddress().equals(remoteAddress)) continue;
            return socket;
        }
        return null;
    }

    public void addSocket(IceSocketWrapper socket) {
        this.sockets.add(socket);
    }

    @Override
    protected void free() {
        StunStack stunStack = this.getStunStack();
        TransportAddress localAddr = this.getTransportAddress();
        for (IceSocketWrapper socket : this.sockets) {
            Socket tcpSocket = socket.getTCPSocket();
            stunStack.removeSocket(localAddr, new TransportAddress(tcpSocket.getInetAddress(), tcpSocket.getPort(), Transport.TCP));
            socket.close();
        }
        super.free();
    }
}

