/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.ice4j.ice;

import gg.essential.lib.ice4j.TransportAddress;
import gg.essential.lib.ice4j.ice.Candidate;
import gg.essential.lib.ice4j.ice.CandidateExtendedType;
import gg.essential.lib.ice4j.ice.CandidateType;
import gg.essential.lib.ice4j.ice.Component;
import gg.essential.lib.ice4j.ice.HostCandidate;
import gg.essential.lib.ice4j.socket.IceSocketWrapper;
import gg.essential.lib.ice4j.socket.IceTcpSocketWrapper;
import gg.essential.lib.ice4j.socket.IceUdpSocketWrapper;
import gg.essential.lib.ice4j.socket.MultiplexedDatagramSocket;
import gg.essential.lib.ice4j.socket.MultiplexedSocket;
import gg.essential.lib.ice4j.socket.MultiplexingDatagramSocket;
import gg.essential.lib.ice4j.socket.MultiplexingSocket;
import gg.essential.lib.ice4j.socket.StunDatagramPacketFilter;
import gg.essential.lib.ice4j.stack.StunStack;
import gg.essential.lib.jitsi.utils.logging2.Logger;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;

public abstract class LocalCandidate
extends Candidate<LocalCandidate> {
    private static final java.util.logging.Logger classLogger = java.util.logging.Logger.getLogger(HostCandidate.class.getName());
    private CandidateExtendedType extendedType = null;
    private String ufrag = null;
    private boolean isSSL = false;
    private final Logger logger;

    public LocalCandidate(TransportAddress transportAddress, Component parentComponent, CandidateType type2, CandidateExtendedType extendedType, LocalCandidate relatedCandidate) {
        super(transportAddress, parentComponent, type2, relatedCandidate);
        this.logger = parentComponent.getLogger().createChildLogger(this.getClass().getName());
        this.extendedType = extendedType;
    }

    @Deprecated
    public DatagramSocket getDatagramSocket() {
        IceSocketWrapper wrapper = this.getIceSocketWrapper();
        return wrapper == null ? null : wrapper.getUDPSocket();
    }

    @Deprecated
    public Socket getSocket() {
        return null;
    }

    protected IceSocketWrapper getIceSocketWrapper() {
        return this.getParentComponent().getSocketWrapper();
    }

    protected abstract IceSocketWrapper getCandidateIceSocketWrapper();

    protected IceSocketWrapper getCandidateIceSocketWrapper(SocketAddress remoteAddress) {
        return this.getCandidateIceSocketWrapper();
    }

    public IceSocketWrapper getStunSocket(TransportAddress serverAddress) {
        IceSocketWrapper hostSocket = this.getCandidateIceSocketWrapper();
        if (hostSocket != null && hostSocket.getTCPSocket() != null) {
            Socket tcpSocket = hostSocket.getTCPSocket();
            MultiplexedSocket tcpStunSocket = null;
            if (tcpSocket instanceof MultiplexingSocket) {
                StunDatagramPacketFilter stunDatagramPacketFilter = this.createStunDatagramPacketFilter(serverAddress);
                SocketException exception = null;
                try {
                    tcpStunSocket = ((MultiplexingSocket)tcpSocket).getSocket(stunDatagramPacketFilter);
                }
                catch (SocketException sex) {
                    this.logger.error("Failed to acquire Socket specific to STUN communication.", sex);
                    exception = sex;
                }
                if (tcpStunSocket == null) {
                    throw new IllegalStateException("Failed to acquire Socket specific to STUN communication", exception);
                }
            } else {
                throw new IllegalStateException("The socket of " + this.getClass().getSimpleName() + " must be a MultiplexingSocket instance");
            }
            IceTcpSocketWrapper stunSocket = null;
            try {
                stunSocket = new IceTcpSocketWrapper(tcpStunSocket);
            }
            catch (IOException e) {
                this.logger.info("Failed to create IceTcpSocketWrapper " + e);
            }
            return stunSocket;
        }
        if (hostSocket != null && hostSocket.getUDPSocket() != null) {
            DatagramSocket udpSocket = hostSocket.getUDPSocket();
            MultiplexedDatagramSocket udpStunSocket = null;
            if (udpSocket instanceof MultiplexingDatagramSocket) {
                StunDatagramPacketFilter stunDatagramPacketFilter = this.createStunDatagramPacketFilter(serverAddress);
                SocketException exception = null;
                try {
                    udpStunSocket = ((MultiplexingDatagramSocket)udpSocket).getSocket(stunDatagramPacketFilter);
                }
                catch (SocketException sex) {
                    this.logger.error("Failed to acquire DatagramSocket specific to STUN communication.", sex);
                    exception = sex;
                }
                if (udpStunSocket == null) {
                    throw new IllegalStateException("Failed to acquire DatagramSocket specific to STUN communication", exception);
                }
            } else {
                throw new IllegalStateException("The socket of " + this.getClass().getSimpleName() + " must be a MultiplexingDatagramSocket instance");
            }
            return new IceUdpSocketWrapper(udpStunSocket);
        }
        return null;
    }

    public StunStack getStunStack() {
        return this.getParentComponent().getParentStream().getParentAgent().getStunStack();
    }

    protected StunDatagramPacketFilter createStunDatagramPacketFilter(TransportAddress serverAddress) {
        return new StunDatagramPacketFilter(serverAddress);
    }

    protected void free() {
        LocalCandidate base;
        IceSocketWrapper socket = this.getCandidateIceSocketWrapper();
        if (socket != null && ((base = (LocalCandidate)this.getBase()) == null || base == this || base.getCandidateIceSocketWrapper() != socket)) {
            this.getStunStack().removeSocket(this.getTransportAddress());
            socket.close();
        }
    }

    @Override
    public boolean isDefault() {
        Component parentCmp = this.getParentComponent();
        return parentCmp != null && this.equals(parentCmp.getDefaultCandidate());
    }

    public void setUfrag(String ufrag) {
        this.ufrag = ufrag;
    }

    @Override
    public String getUfrag() {
        return this.ufrag;
    }

    public CandidateExtendedType getExtendedType() {
        return this.extendedType;
    }

    public void setExtendedType(CandidateExtendedType extendedType) {
        this.extendedType = extendedType;
    }

    @Override
    protected LocalCandidate findRelatedCandidate(TransportAddress relatedAddress) {
        return this.getParentComponent().findLocalCandidate(relatedAddress);
    }

    public boolean isSSL() {
        return this.isSSL;
    }

    public void setSSL(boolean isSSL) {
        this.isSSL = isSSL;
    }
}

