/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.ice4j.ice;

import gg.essential.lib.ice4j.StunMessageEvent;
import gg.essential.lib.ice4j.attribute.AttributeFactory;
import gg.essential.lib.ice4j.attribute.IceControlAttribute;
import gg.essential.lib.ice4j.attribute.MessageIntegrityAttribute;
import gg.essential.lib.ice4j.attribute.PriorityAttribute;
import gg.essential.lib.ice4j.attribute.UsernameAttribute;
import gg.essential.lib.ice4j.ice.Agent;
import gg.essential.lib.ice4j.ice.IceMediaStream;
import gg.essential.lib.ice4j.message.Message;
import gg.essential.lib.ice4j.message.MessageFactory;
import gg.essential.lib.ice4j.message.Request;
import gg.essential.lib.ice4j.message.Response;
import gg.essential.lib.ice4j.security.CredentialsAuthority;
import gg.essential.lib.ice4j.stack.RequestListener;
import gg.essential.lib.ice4j.stack.StunStack;
import gg.essential.lib.jitsi.utils.logging2.Logger;

class ConnectivityCheckServer
implements RequestListener,
CredentialsAuthority {
    private final Agent parentAgent;
    private boolean started = false;
    private final StunStack stunStack;
    private boolean alive = false;
    private Logger logger;

    public ConnectivityCheckServer(Agent parentAgent) {
        this.parentAgent = parentAgent;
        this.logger = parentAgent.getLogger().createChildLogger(this.getClass().getName());
        this.stunStack = this.parentAgent.getStunStack();
        this.stunStack.getCredentialsManager().registerAuthority(this);
        this.start();
    }

    boolean isAlive() {
        return this.alive;
    }

    @Override
    public void processRequest(StunMessageEvent evt) throws IllegalArgumentException {
        this.logger.trace(() -> "Received request " + evt);
        this.alive = true;
        Request request = (Request)evt.getMessage();
        UsernameAttribute uname = (UsernameAttribute)request.getAttribute('\u0006');
        if (uname == null || !this.checkLocalUserName(new String(uname.getUsername()))) {
            return;
        }
        if ((this.parentAgent.isControlling() && request.containsAttribute('\u802a') || !this.parentAgent.isControlling() && request.containsAttribute('\u8029')) && !this.repairRoleConflict(evt)) {
            return;
        }
        long priority = 0L;
        boolean useCandidate = request.containsAttribute('%');
        String username = new String(uname.getUsername());
        String remoteUfrag = null;
        String localUFrag = null;
        priority = this.extractPriority(request);
        int colon = username.indexOf(":");
        remoteUfrag = username.substring(0, colon);
        this.parentAgent.incomingCheckReceived(evt.getRemoteAddress(), evt.getLocalAddress(), priority, remoteUfrag, localUFrag, useCandidate);
        Response response2 = MessageFactory.createBindingResponse(request, evt.getRemoteAddress());
        UsernameAttribute usernameAttribute = AttributeFactory.createUsernameAttribute(uname.getUsername());
        response2.putAttribute(usernameAttribute);
        MessageIntegrityAttribute messageIntegrityAttribute = AttributeFactory.createMessageIntegrityAttribute(new String(uname.getUsername()));
        response2.putAttribute(messageIntegrityAttribute);
        try {
            this.stunStack.sendResponse(evt.getTransactionID().getBytes(), response2, evt.getLocalAddress(), evt.getRemoteAddress());
        }
        catch (Exception e) {
            this.logger.info("Failed to send " + response2 + " through " + evt.getLocalAddress() + "\n" + e.toString());
            throw new RuntimeException("Failed to send a response", e);
        }
    }

    private long extractPriority(Request request) throws IllegalArgumentException {
        PriorityAttribute priorityAttr = (PriorityAttribute)request.getAttribute('$');
        if (priorityAttr == null) {
            this.logger.debug(() -> "Received a connectivity check withno PRIORITY attribute. Discarding.");
            throw new IllegalArgumentException("Missing PRIORITY attribute!");
        }
        return priorityAttr.getPriority();
    }

    private boolean repairRoleConflict(StunMessageEvent evt) {
        IceControlAttribute theirIceControl;
        long theirTieBreaker;
        boolean bothControlledConflict;
        Message req = evt.getMessage();
        boolean selfIceControlling = this.parentAgent.isControlling();
        boolean bothControllingConflict = selfIceControlling && req.containsAttribute('\u802a');
        boolean bl = bothControlledConflict = !selfIceControlling && req.containsAttribute('\u8029');
        if (!bothControllingConflict && !bothControlledConflict) {
            return true;
        }
        long selfTieBreaker = this.parentAgent.getTieBreaker();
        if (Long.compareUnsigned(selfTieBreaker, theirTieBreaker = (theirIceControl = bothControllingConflict ? (IceControlAttribute)req.getAttribute('\u802a') : (IceControlAttribute)req.getAttribute('\u8029')).getTieBreaker()) >= 0) {
            UsernameAttribute requestUserName = (UsernameAttribute)req.getAttribute('\u0006');
            Response response2 = MessageFactory.createBindingErrorResponse('\u01e7');
            MessageIntegrityAttribute messageIntegrityAttribute = AttributeFactory.createMessageIntegrityAttribute(new String(requestUserName.getUsername()));
            response2.putAttribute(messageIntegrityAttribute);
            try {
                this.stunStack.sendResponse(evt.getTransactionID().getBytes(), response2, evt.getLocalAddress(), evt.getRemoteAddress());
                return false;
            }
            catch (Exception exc) {
                throw new RuntimeException("Failed to send a 487", exc);
            }
        }
        String selfNextControlState = selfIceControlling ? "controlled" : "controlling";
        this.logger.trace(() -> "Switching to " + selfNextControlState + " because  theirTieBreaker= " + theirTieBreaker + " and selfTieBreaker= " + selfTieBreaker);
        this.parentAgent.setControlling(!selfIceControlling);
        return true;
    }

    @Override
    public boolean checkLocalUserName(String username) {
        String ufrag = null;
        int colon = username.indexOf(":");
        ufrag = colon < 0 ? username : username.substring(0, colon);
        return ufrag.equals(this.parentAgent.getLocalUfrag());
    }

    @Override
    public byte[] getLocalKey(String username) {
        return this.checkLocalUserName(username) ? this.parentAgent.getLocalPassword().getBytes() : null;
    }

    @Override
    public byte[] getRemoteKey(String username, String media) {
        IceMediaStream stream = this.parentAgent.getStream(media);
        if (stream == null) {
            return null;
        }
        int colon = username.indexOf(":");
        if (colon < 0 ? username.equals(stream.getRemoteUfrag()) : username.equals(this.parentAgent.generateLocalUserName(media)) && stream.getRemotePassword() != null) {
            return stream.getRemotePassword().getBytes();
        }
        return null;
    }

    public void start() {
        if (!this.started) {
            this.stunStack.addRequestListener(this);
            this.started = true;
        }
    }

    public void stop() {
        this.stunStack.removeRequestListener(this);
        this.started = false;
    }
}

