/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.ice4j.attribute;

import gg.essential.lib.ice4j.StunException;
import gg.essential.lib.ice4j.attribute.Attribute;

public class RequestedAddressFamilyAttribute
extends Attribute {
    public static final String NAME = "REQUESTED-ADDRESS-FAMILY";
    public static final char DATA_LENGTH = '\u0001';
    public static final char IPv4 = '\u0001';
    public static final char IPv6 = '\u0002';
    char family = '\u0001';

    protected RequestedAddressFamilyAttribute() {
        super('\u0017');
    }

    @Override
    public char getDataLength() {
        return '\u0001';
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof RequestedAddressFamilyAttribute)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        RequestedAddressFamilyAttribute att = (RequestedAddressFamilyAttribute)obj;
        return att.getAttributeType() == this.getAttributeType() && att.getDataLength() == this.getDataLength() && att.family == this.family;
    }

    @Override
    public byte[] encode() {
        byte[] binValue = new byte[]{(byte)(this.getAttributeType() >> 8), (byte)(this.getAttributeType() & 0xFF), (byte)(this.getDataLength() >> 8), (byte)(this.getDataLength() & 0xFF), (byte)this.family};
        return binValue;
    }

    @Override
    void decodeAttributeBody(byte[] attributeValue, char offset, char length) throws StunException {
        if (length != '\u0001') {
            throw new StunException("length invalid: " + length);
        }
        this.family = (char)(attributeValue[offset] & 0xFF);
        if (this.family != '\u0001' && this.family != '\u0002') {
            throw new StunException("invalid family value: " + this.family);
        }
    }

    public char getFamily() {
        return this.family;
    }

    public boolean setFamily(char family) {
        if (family == '\u0001' || family == '\u0002') {
            this.family = family;
            return true;
        }
        return false;
    }
}

