/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.ice4j.attribute;

import gg.essential.lib.ice4j.StunException;
import gg.essential.lib.ice4j.attribute.Attribute;

public class MagicCookieAttribute
extends Attribute {
    public static final String NAME = "MAGIC-COOKIE";
    public static final char DATA_LENGTH = '\u0004';
    private int value = 1925598150;

    MagicCookieAttribute() {
        super('\u000f');
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public char getDataLength() {
        return '\u0004';
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof MagicCookieAttribute)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        MagicCookieAttribute att = (MagicCookieAttribute)obj;
        return att.getAttributeType() == this.getAttributeType() && att.getDataLength() == this.getDataLength() && att.value == this.value;
    }

    @Override
    public byte[] encode() {
        byte[] binValue = new byte[]{(byte)(this.getAttributeType() >> 8), (byte)(this.getAttributeType() & 0xFF), (byte)(this.getDataLength() >> 8), (byte)(this.getDataLength() & 0xFF), (byte)(this.value >> 24 & 0xFF), (byte)(this.value >> 16 & 0xFF), (byte)(this.value >> 8 & 0xFF), (byte)(this.value & 0xFF)};
        return binValue;
    }

    @Override
    void decodeAttributeBody(byte[] attributeValue, char offset, char length) throws StunException {
        if (length != '\u0004') {
            throw new StunException("length invalid");
        }
        this.value = (attributeValue[0] << 24 & 0xFF000000) + (attributeValue[1] << 16 & 0xFF0000) + (attributeValue[2] << 8 & 0xFF00) + (attributeValue[3] & 0xFF);
    }
}

