/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.ice4j.attribute;

import gg.essential.lib.ice4j.StunException;
import gg.essential.lib.ice4j.attribute.Attribute;
import java.util.Arrays;

public class DataAttribute
extends Attribute {
    public static final String NAME = "DATA";
    private byte[] data = null;
    private final boolean padding;

    protected DataAttribute() {
        this(true);
    }

    protected DataAttribute(boolean padding) {
        super('\u0013');
        this.padding = padding;
    }

    @Override
    void decodeAttributeBody(byte[] attributeValue, char offset, char length) throws StunException {
        this.data = new byte[length];
        System.arraycopy(attributeValue, offset, this.data, 0, length);
    }

    @Override
    public byte[] encode() {
        char dataLength = this.getDataLength();
        char type2 = this.getAttributeType();
        byte[] binary = new byte[4 + dataLength + (this.padding ? (4 - dataLength % 4) % 4 : 0)];
        binary[0] = (byte)(type2 >> 8);
        binary[1] = (byte)(type2 & 0xFF);
        binary[2] = (byte)(dataLength >> 8);
        binary[3] = (byte)(dataLength & 0xFF);
        System.arraycopy(this.data, 0, binary, 4, dataLength);
        return binary;
    }

    @Override
    public char getDataLength() {
        return (char)this.data.length;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public byte[] getData() {
        return this.data == null ? null : (byte[])this.data.clone();
    }

    public void setData(byte[] data2) {
        if (data2 == null) {
            this.data = null;
            return;
        }
        this.data = new byte[data2.length];
        System.arraycopy(data2, 0, this.data, 0, data2.length);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof DataAttribute)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        DataAttribute att = (DataAttribute)obj;
        return att.getAttributeType() == this.getAttributeType() && att.getDataLength() == this.getDataLength() && Arrays.equals(att.data, this.data);
    }
}

