/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.ice4j;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StackProperties {
    private static final Logger logger = Logger.getLogger(StackProperties.class.getName());
    public static final String BIND_RETRIES = "gg.essential.lib.ice4j.BIND_RETRIES";
    public static final int BIND_RETRIES_DEFAULT_VALUE = 50;
    public static final String BIND_WILDCARD = "gg.essential.lib.ice4j.BIND_WILDCARD";
    public static final String FIRST_CTRAN_RETRANS_AFTER = "gg.essential.lib.ice4j.FIRST_CTRAN_RETRANS_AFTER";
    public static final String MAX_CTRAN_RETRANS_TIMER = "gg.essential.lib.ice4j.MAX_CTRAN_RETRANS_TIMER";
    public static final String KEEP_CRANS_AFTER_A_RESPONSE = "gg.essential.lib.ice4j.KEEP_CRANS_AFTER_A_RESPONSE";
    public static final String MAX_CTRAN_RETRANSMISSIONS = "gg.essential.lib.ice4j.MAX_RETRANSMISSIONS";
    public static final String SOFTWARE = "gg.essential.lib.ice4j.SOFTWARE";
    public static final String PROPAGATE_RECEIVED_RETRANSMISSIONS = "gg.essential.lib.ice4j.PROPAGATE_RECEIVED_RETRANSMISSIONS";
    public static final String ALLOW_LINK_TO_GLOBAL_REACHABILITY = "gg.essential.lib.ice4j.ALLOW_LINK_TO_GLOBAL_REACHABILITY";
    public static final String ALWAYS_SIGN = "gg.essential.lib.ice4j.ALWAYS_SIGN";
    public static final String REQUIRE_MESSAGE_INTEGRITY = "gg.essential.lib.ice4j.REQUIRE_MESSAGE_INTEGRITY";
    public static final String NO_KEEP_ALIVES = "gg.essential.lib.ice4j.NO_KEEP_ALIVES";
    public static final String NOMINATION_TIMER = "gg.essential.lib.ice4j.NOMINATION_TIMER";
    public static final String ALLOWED_INTERFACES = "gg.essential.lib.ice4j.ice.harvest.ALLOWED_INTERFACES";
    public static final String BLOCKED_INTERFACES = "gg.essential.lib.ice4j.ice.harvest.BLOCKED_INTERFACES";
    public static final String ALLOWED_ADDRESSES = "gg.essential.lib.ice4j.ice.harvest.ALLOWED_ADDRESSES";
    public static final String BLOCKED_ADDRESSES = "gg.essential.lib.ice4j.ice.harvest.BLOCKED_ADDRESSES";
    public static final String USE_COMPONENT_SOCKET = "gg.essential.lib.ice4j.ice.USE_COMPONENT_SOCKET";

    public static String getString(String propertyName) {
        String str;
        String obj = System.getProperty(propertyName);
        if (obj == null) {
            str = null;
        } else {
            str = obj.toString().trim();
            if (str.length() == 0) {
                str = null;
            }
        }
        return str;
    }

    public static String[] getStringArray(String propertyName, String regex) {
        String str = StackProperties.getString(propertyName);
        if (str == null) {
            return null;
        }
        String[] parts = str.split(regex);
        ArrayList<String> res = new ArrayList<String>();
        for (String s : parts) {
            if (s == null || s.trim().length() == 0) continue;
            res.add(s);
        }
        if (res.size() == 0) {
            return null;
        }
        return res.toArray(new String[res.size()]);
    }

    public static int getInt(String propertyName, int defaultValue) {
        String stringValue = StackProperties.getString(propertyName);
        int intValue = defaultValue;
        if (stringValue != null && stringValue.length() > 0) {
            try {
                intValue = Integer.parseInt(stringValue);
            }
            catch (NumberFormatException ex) {
                logger.log(Level.FINE, propertyName + " does not appear to be an integer. Defaulting to " + defaultValue + ".", ex);
            }
        }
        return intValue;
    }

    public static boolean getBoolean(String propertyName, boolean defaultValue) {
        String str = StackProperties.getString(propertyName);
        return str == null ? defaultValue : Boolean.parseBoolean(str);
    }
}

