/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.discordgamesdk.lobby;

import gg.essential.lib.discordgamesdk.GameSDKException;
import gg.essential.lib.discordgamesdk.Result;
import gg.essential.lib.discordgamesdk.lobby.LobbyType;

public class LobbyTransaction {
    private final long pointer;

    LobbyTransaction(long pointer) {
        this.pointer = pointer;
    }

    public long getPointer() {
        return this.pointer;
    }

    public void setType(LobbyType type2) {
        Result result2 = this.setType(this.pointer, type2.ordinal() + 1);
        if (result2 != Result.OK) {
            throw new GameSDKException(result2);
        }
    }

    public void setOwner(long ownerId) {
        Result result2 = this.setOwner(this.pointer, ownerId);
        if (result2 != Result.OK) {
            throw new GameSDKException(result2);
        }
    }

    public void setCapacity(int capacity) {
        Result result2 = this.setCapacity(this.pointer, capacity);
        if (result2 != Result.OK) {
            throw new GameSDKException(result2);
        }
    }

    public void setMetadata(String key, String value2) {
        if (key.getBytes().length >= 256) {
            throw new IllegalArgumentException("max key length is 255");
        }
        if (value2.getBytes().length >= 4096) {
            throw new IllegalArgumentException("max value length is 4095");
        }
        Result result2 = this.setMetadata(this.pointer, key, value2);
        if (result2 != Result.OK) {
            throw new GameSDKException(result2);
        }
    }

    public void deleteMetadata(String key) {
        if (key.getBytes().length >= 256) {
            throw new IllegalArgumentException("max key length is 255");
        }
        Result result2 = this.deleteMetadata(this.pointer, key);
        if (result2 != Result.OK) {
            throw new GameSDKException(result2);
        }
    }

    public void setLocked(boolean locked) {
        Result result2 = this.setLocked(this.pointer, locked);
        if (result2 != Result.OK) {
            throw new GameSDKException(result2);
        }
    }

    private native Result setType(long var1, int var3);

    private native Result setOwner(long var1, long var3);

    private native Result setCapacity(long var1, int var3);

    private native Result setMetadata(long var1, String var3, String var4);

    private native Result deleteMetadata(long var1, String var3);

    private native Result setLocked(long var1, boolean var3);
}

