/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.discordgamesdk.image;

import gg.essential.lib.discordgamesdk.image.ImageType;
import java.util.Objects;

public class ImageHandle {
    private ImageType type;
    private long id;
    private int size;

    public ImageHandle(ImageType type2, long id2, int size) {
        this.type = Objects.requireNonNull(type2);
        this.id = id2;
        if (size < 16) {
            throw new IllegalArgumentException("size is smaller than 16: " + size);
        }
        if (size > 256) {
            throw new IllegalArgumentException("size is greater than 2048: " + size);
        }
        if ((size & size - 1) != 0) {
            throw new IllegalArgumentException("size is not a power of 2: " + size);
        }
        this.size = size;
    }

    ImageHandle(int type2, long id2, int size) {
        this(ImageType.values()[type2], id2, size);
    }

    public ImageType getType() {
        return this.type;
    }

    public void setType(ImageType type2) {
        this.type = Objects.requireNonNull(type2);
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id2) {
        this.id = id2;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        if ((size & size - 1) != 0) {
            throw new IllegalArgumentException("size is not a power of 2: " + size);
        }
        this.size = size;
    }

    public String toString() {
        return "ImageHandle{type=" + (Object)((Object)this.type) + ", id=" + this.id + ", size=" + this.size + '}';
    }
}

