/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.discordgamesdk;

import gg.essential.lib.discordgamesdk.Core;
import gg.essential.lib.discordgamesdk.GameSDKException;
import gg.essential.lib.discordgamesdk.Result;

public class NetworkManager {
    private final long pointer;
    private final Core core;

    NetworkManager(long pointer, Core core) {
        this.pointer = pointer;
        this.core = core;
    }

    public long getPeerId() {
        return this.core.execute(() -> this.getPeerId(this.pointer));
    }

    public void flush() {
        Result result2 = this.core.execute(() -> this.flush(this.pointer));
        if (result2 != Result.OK) {
            throw new GameSDKException(result2);
        }
    }

    public void openPeer(long peerId, String routeData) {
        Result result2 = this.core.execute(() -> this.openPeer(this.pointer, peerId, routeData));
        if (result2 != Result.OK) {
            throw new GameSDKException(result2);
        }
    }

    public void updatePeer(long peerId, String routeData) {
        Result result2 = this.core.execute(() -> this.updatePeer(this.pointer, peerId, routeData));
        if (result2 != Result.OK) {
            throw new GameSDKException(result2);
        }
    }

    public void closePeer(long peerId) {
        Result result2 = this.core.execute(() -> this.closePeer(this.pointer, peerId));
        if (result2 != Result.OK) {
            throw new GameSDKException(result2);
        }
    }

    public void openChannel(long peerId, byte channelId, boolean reliable) {
        Result result2 = this.core.execute(() -> this.openChannel(this.pointer, peerId, channelId, reliable));
        if (result2 != Result.OK) {
            throw new GameSDKException(result2);
        }
    }

    public void closeChannel(long peerId, byte channelId) {
        Result result2 = this.core.execute(() -> this.closeChannel(this.pointer, peerId, channelId));
        if (result2 != Result.OK) {
            throw new GameSDKException(result2);
        }
    }

    public void sendMessage(long peerId, byte channelId, byte[] data2) {
        Result result2 = this.core.execute(() -> this.sendMessage(this.pointer, peerId, channelId, data2, 0, data2.length));
        if (result2 != Result.OK) {
            throw new GameSDKException(result2);
        }
    }

    private native long getPeerId(long var1);

    private native Result flush(long var1);

    private native Result openPeer(long var1, long var3, String var5);

    private native Result updatePeer(long var1, long var3, String var5);

    private native Result closePeer(long var1, long var3);

    private native Result openChannel(long var1, long var3, byte var5, boolean var6);

    private native Result closeChannel(long var1, long var3, byte var5);

    private native Result sendMessage(long var1, long var3, byte var5, byte[] var6, int var7, int var8);
}

