/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.caffeine.cache;

import gg.essential.lib.caffeine.cache.DisabledFuture;
import gg.essential.lib.caffeine.cache.Scheduler;
import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;

final class GuardedScheduler
implements Scheduler,
Serializable {
    static final Logger logger = Logger.getLogger(GuardedScheduler.class.getName());
    static final long serialVersionUID = 1L;
    final Scheduler delegate;

    GuardedScheduler(Scheduler delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public @NonNull Future<?> schedule(@NonNull Executor executor, @NonNull Runnable command2, long delay2, @NonNull TimeUnit unit) {
        try {
            Future<?> future2 = this.delegate.schedule(executor, command2, delay2, unit);
            return future2 == null ? DisabledFuture.INSTANCE : future2;
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "Exception thrown by scheduler; discarded task", t);
            return DisabledFuture.INSTANCE;
        }
    }
}

