/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.key;

import gg.essential.Essential;
import gg.essential.api.utils.GuiUtil;
import gg.essential.commands.impl.CommandInviteFriends;
import gg.essential.config.EssentialConfig;
import gg.essential.connectionmanager.common.packet.cosmetic.ClientCosmeticsUserEquippedVisibilityTogglePacket;
import gg.essential.elementa.WindowScreen;
import gg.essential.elementa.components.Window;
import gg.essential.elementa.components.inspector.Inspector;
import gg.essential.elementa.utils.OptionsKt;
import gg.essential.event.client.ClientTickEvent;
import gg.essential.gui.friends.FriendsGui;
import gg.essential.gui.notification.Notifications;
import gg.essential.gui.studio.CosmeticStudio;
import gg.essential.handlers.ZoomHandler;
import gg.essential.key.EssentialKeybinding;
import gg.essential.lib.kbrewster.eventbus.Subscribe;
import gg.essential.network.connectionmanager.ConnectionManager;
import gg.essential.network.connectionmanager.cosmetics.CosmeticEquipVisibilityResponse;
import gg.essential.network.connectionmanager.cosmetics.CosmeticsManager;
import gg.essential.network.connectionmanager.relationship.FriendRequestState;
import gg.essential.universal.UKeyboard;
import gg.essential.universal.UMinecraft;
import gg.essential.util.ExtensionsKt;
import gg.essential.util.MinecraftUtils;
import gg.essential.util.Multithreading;
import gg.essential.util.OptiFineUtil;
import gg.essential.util.UUIDUtil;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_742;
import org.jetbrains.annotations.NotNull;

public class EssentialKeybindingRegistry {
    public static final String CATEGORY = "Essential";
    private EssentialKeybinding cosmetics_visibility_toggle;
    private boolean holdingChatPeek;

    public void refreshBinds() {
        CosmeticsManager cosmeticsManager = Essential.getInstance().getConnectionManager().getCosmeticsManager();
        for (EssentialKeybinding bind2 : EssentialKeybinding.ALL_BINDS) {
            if (bind2.getRequiresEssentialFull() && !EssentialConfig.INSTANCE.getEssentialFull()) {
                bind2.unregister();
                continue;
            }
            if (bind2.isRegisteredWithMinecraft()) continue;
            if (bind2.getCustomUnlockStatus() != null && bind2.getCustomUnlockStatus().get() != false || bind2.getRequiresUnlocked() != null && cosmeticsManager.hasEquipped(bind2.getRequiresUnlocked()) || bind2.getCustomUnlockStatus() == null && bind2.getRequiresUnlocked() == null) {
                bind2.register();
                continue;
            }
            bind2.unregister();
        }
    }

    public class_304[] registerKeyBinds(class_304[] allBindings) {
        new EssentialKeybinding("ESSENTIAL_FRIENDS", CATEGORY, UKeyboard.KEY_H).requiresEssentialFull().withInitialPress(() -> {
            if (!UKeyboard.isKeyDown(UKeyboard.KEY_F3) && UMinecraft.getMinecraft().field_1755 == null) {
                Multithreading.runAsync(() -> GuiUtil.open(new FriendsGui()));
            }
        });
        new EssentialKeybinding("COSMETIC_STUDIO", CATEGORY, UKeyboard.KEY_B).withInitialPress(() -> {
            if (!UKeyboard.isKeyDown(UKeyboard.KEY_F3) && UMinecraft.getMinecraft().field_1755 == null) {
                Multithreading.runAsync(() -> GuiUtil.open(new CosmeticStudio()));
            }
        });
        if (System.getProperty("elementa.dev", "false").equals("true")) {
            new EssentialKeybinding("INSERT_INSPECTOR", CATEGORY, UKeyboard.KEY_EQUALS, true).withInitialPress(() -> {
                if (UKeyboard.isShiftKeyDown()) {
                    OptionsKt.setElementaDebug(!OptionsKt.getElementaDebug());
                } else {
                    class_437 openedScreen = GuiUtil.getOpenedScreen();
                    if (!(openedScreen instanceof WindowScreen)) {
                        return;
                    }
                    Window window = ((WindowScreen)openedScreen).getWindow();
                    List<Inspector> inspectors = window.childrenOfType(Inspector.class);
                    if (inspectors.size() > 0) {
                        for (Inspector inspector : inspectors) {
                            window.removeChild(inspector);
                        }
                    } else {
                        window.addChild(new Inspector(window));
                    }
                }
            });
            if (MinecraftUtils.INSTANCE.isDevelopment()) {
                new EssentialKeybinding("ESSENTIAL_DEBUG_KEY", CATEGORY, UKeyboard.KEY_MINUS, true).withInitialPress(() -> Essential.getInstance().debugKeyFunction());
                new EssentialKeybinding("TOGGLE_DEBUG", CATEGORY, UKeyboard.KEY_BACKSLASH).withInitialPress(ExtensionsKt::toggleElementaDebug);
            }
        }
        this.cosmetics_visibility_toggle = new EssentialKeybinding("COSMETICS_VISIBILITY_TOGGLE", CATEGORY, UKeyboard.KEY_O, false).withInitialPress(() -> {
            Essential instance2 = Essential.getInstance();
            ConnectionManager connectionManager = instance2.getConnectionManager();
            CosmeticsManager cosmeticsManager = connectionManager.getCosmeticsManager();
            boolean currentState = cosmeticsManager.getOwnCosmeticsVisible();
            boolean nextState = !currentState;
            connectionManager.send(new ClientCosmeticsUserEquippedVisibilityTogglePacket(nextState), new CosmeticEquipVisibilityResponse(nextState, true));
        });
        new EssentialKeybinding("ADD_FRIEND", CATEGORY, UKeyboard.KEY_NONE).requiresEssentialFull().withInitialPress(() -> {
            class_1297 pointedEntity = UMinecraft.getMinecraft().field_1692;
            if (!(pointedEntity instanceof class_742)) {
                MinecraftUtils.INSTANCE.sendChatMessageAndFormat("keybind.feedback.lookatplayerfriend");
                return;
            }
            UUID targetUUID = pointedEntity.method_5667();
            if (targetUUID.version() != 4) {
                MinecraftUtils.INSTANCE.sendChatMessageAndFormat("keybind.error.nonplayer");
                return;
            }
            ConnectionManager connectionManager = Essential.getInstance().getConnectionManager();
            connectionManager.getRelationshipManager().createFriendRelationship(targetUUID, false).thenAcceptAsync(friendRequestState -> {
                if (friendRequestState.getFriendRequestState() == FriendRequestState.SENT) {
                    UUIDUtil.getName(targetUUID).thenAcceptAsync(s -> Notifications.INSTANCE.push("Friend Request", String.format("Sent a friend request to %s", s)), ExtensionsKt.getExecutor(class_310.method_1551()));
                } else if (friendRequestState.getFriendRequestState() == FriendRequestState.ERROR_UNHANDLED) {
                    Notifications.INSTANCE.push("Friend Request", friendRequestState.getMessage() != null ? friendRequestState.getMessage() : "An unknown error occurred");
                }
            }, ExtensionsKt.getExecutor(class_310.method_1551()));
        });
        new EssentialKeybinding("CHAT_PEEK", CATEGORY, UKeyboard.KEY_Z).withRepeatedHold(() -> {
            this.holdingChatPeek = true;
        }).withRelease(() -> {
            this.holdingChatPeek = false;
        });
        new EssentialKeybinding("INVITE_FRIENDS", CATEGORY, UKeyboard.KEY_NONE).withInitialPress(CommandInviteFriends::openFriendsPopup);
        if (!OptiFineUtil.isLoaded()) {
            ZoomHandler.getInstance().zoomKeybinding = new EssentialKeybinding((String)"ZOOM", (String)CATEGORY, (int)UKeyboard.KEY_C).keyBinding;
        }
        for (EssentialKeybinding binding : EssentialKeybinding.ALL_BINDS) {
            allBindings = binding.register(allBindings);
        }
        return allBindings;
    }

    @Subscribe
    public void tick(ClientTickEvent event) {
        for (EssentialKeybinding essentialKeybinding : EssentialKeybinding.ALL_BINDS) {
            essentialKeybinding.tickEvents();
        }
    }

    @NotNull
    public EssentialKeybinding getToggleCosmetics() {
        return this.cosmetics_visibility_toggle;
    }

    public boolean isHoldingChatPeek() {
        return this.holdingChatPeek;
    }
}

