/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.key;

import com.google.common.collect.ImmutableMap;
import gg.essential.api.utils.GuiUtil;
import gg.essential.config.EssentialConfig;
import gg.essential.mixins.transformers.client.options.GameOptionsAccessor;
import gg.essential.mixins.transformers.client.options.KeyBindingAccessor;
import gg.essential.universal.UKeyboard;
import gg.essential.universal.UMinecraft;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3675;
import net.minecraft.class_442;
import org.apache.commons.lang3.ArrayUtils;

public class EssentialKeybinding {
    public static final List<EssentialKeybinding> ALL_BINDS = new ArrayList<EssentialKeybinding>();
    public static boolean cancelKeybinds = false;
    public final class_304 keyBinding;
    private final String keyId;
    private final boolean alwaysTick;
    private Runnable onInitialPress;
    private Runnable onRepeatedHold;
    private Runnable onRelease;
    private boolean registeredWithMinecraft = false;
    private boolean pressed = false;
    private String requiresUnlocked;
    private Supplier<Boolean> customUnlockStatus;
    private boolean requiresEssentialFull = false;
    private static final Map<String, String> LEGACY_IDS = ImmutableMap.builder().build();

    public EssentialKeybinding(String keyId, String category, int keyCode) {
        this(keyId, category, keyCode, false);
    }

    public EssentialKeybinding(String keyId, String category, int keyCode, boolean alwaysTick) {
        this.keyId = keyId;
        this.keyBinding = new class_304(LEGACY_IDS.getOrDefault(keyId, "keybind.name." + keyId), keyCode, category);
        this.alwaysTick = alwaysTick;
        ALL_BINDS.add(this);
    }

    public String getKeyId() {
        return this.keyId;
    }

    public int getKeyCode() {
        return ((KeyBindingAccessor)this.keyBinding).getBoundKey().method_1444();
    }

    public void register() {
        class_315 settings = class_310.method_1551().field_1690;
        ((GameOptionsAccessor)settings).setKeyBindings(this.register(settings.field_1839));
    }

    class_304[] register(class_304[] allBindings) {
        if (this.registeredWithMinecraft) {
            return allBindings;
        }
        this.registeredWithMinecraft = true;
        return (class_304[])ArrayUtils.add((Object[])allBindings, (Object)this.keyBinding);
    }

    public EssentialKeybinding withInitialPress(Runnable runnable) {
        this.onInitialPress = runnable;
        return this;
    }

    public EssentialKeybinding withCustomUnlockStatus(Supplier<Boolean> booleanSupplier) {
        this.customUnlockStatus = booleanSupplier;
        return this;
    }

    @Deprecated
    public EssentialKeybinding withRequiredPackage(String cosmeticId) {
        this.requiresUnlocked = cosmeticId;
        return this;
    }

    public EssentialKeybinding requiresEssentialFull() {
        this.requiresEssentialFull = true;
        return this;
    }

    public EssentialKeybinding withRelease(Runnable runnable) {
        this.onRelease = runnable;
        return this;
    }

    public EssentialKeybinding withRepeatedHold(Runnable runnable) {
        this.onRepeatedHold = runnable;
        return this;
    }

    public void tickEvents() {
        if (this.alwaysTick) {
            this.tickMainMenu();
        } else if (GuiUtil.getOpenedScreen() instanceof class_442 ^ cancelKeybinds) {
            cancelKeybinds = false;
            this.tickMainMenu();
        } else if (UMinecraft.getWorld() != null) {
            this.tickWorld();
        }
    }

    private void tickMainMenu() {
        boolean keyDown;
        if (this.getRequiresEssentialFull() && !EssentialConfig.INSTANCE.getEssentialFull()) {
            return;
        }
        int keyCode = this.getKeyCode();
        boolean bl = keyDown = keyCode != UKeyboard.KEY_NONE && UKeyboard.isKeyDown(keyCode);
        if (!this.pressed && keyDown) {
            this.pressed = true;
            if (this.onInitialPress != null) {
                this.onInitialPress.run();
            }
        } else if (this.pressed && keyDown) {
            if (this.onRepeatedHold != null) {
                this.onRepeatedHold.run();
            }
        } else if (this.pressed) {
            this.pressed = false;
            if (this.onRelease != null) {
                this.onRelease.run();
            }
        }
    }

    private void tickWorld() {
        if (this.getRequiresEssentialFull() && !EssentialConfig.INSTANCE.getEssentialFull()) {
            return;
        }
        if (this.keyBinding.method_1436() && this.onInitialPress != null) {
            this.onInitialPress.run();
        } else if (this.keyBinding.method_1434() && this.onRepeatedHold != null) {
            this.onRepeatedHold.run();
        } else if (this.pressed && !this.keyBinding.method_1434() && this.onRelease != null) {
            this.onRelease.run();
        }
        this.pressed = this.keyBinding.method_1434();
    }

    public boolean isRegisteredWithMinecraft() {
        return this.registeredWithMinecraft;
    }

    public void setKeyCode(int keyCode) {
        this.keyBinding.method_1422(class_3675.method_15985((int)keyCode, (int)-1));
    }

    public boolean isBound() {
        return !this.keyBinding.method_1415();
    }

    public void unregister() {
        if (!this.registeredWithMinecraft) {
            return;
        }
        class_315 settings = class_310.method_1551().field_1690;
        int i = ArrayUtils.indexOf((Object[])settings.field_1839, (Object)this.keyBinding);
        if (i > 0) {
            ((GameOptionsAccessor)settings).setKeyBindings((class_304[])ArrayUtils.removeAll((Object[])settings.field_1839, (int[])new int[]{i}));
        }
        this.registeredWithMinecraft = false;
    }

    public String getRequiresUnlocked() {
        return this.requiresUnlocked;
    }

    public Supplier<Boolean> getCustomUnlockStatus() {
        return this.customUnlockStatus;
    }

    public boolean getRequiresEssentialFull() {
        return this.requiresEssentialFull;
    }
}

