/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.handlers.discord.activities;

import com.mojang.authlib.GameProfile;
import gg.essential.Essential;
import gg.essential.api.utils.Multithreading;
import gg.essential.connectionmanager.common.packet.social.SocialDiscordRequestJoinServerPacket;
import gg.essential.handlers.discord.DiscordActivity;
import gg.essential.handlers.discord.DiscordIntegration;
import gg.essential.lib.discordgamesdk.Core;
import gg.essential.network.connectionmanager.ConnectionManager;
import gg.essential.network.connectionmanager.sps.SPSManager;
import gg.essential.universal.UMinecraft;
import gg.essential.upnp.model.UPnPSession;
import gg.essential.util.ExtensionsKt;
import gg.essential.util.UUIDUtil;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.class_634;
import net.minecraft.class_640;
import net.minecraft.class_642;
import org.apache.commons.codec.binary.Base64;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u001c\u001a\u00020\u001b\u00a2\u0006\u0004\b \u0010!J\u000f\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001f\u0010\t\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\r\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001f\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015R8\u0010\u0019\u001a&\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\u000b0\u000b \u0017*\u0012\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\u000b0\u000b\u0018\u00010\u00180\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\u0017\u0010\u001c\u001a\u00020\u001b8\u0006\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006\""}, d2={"Lgg/essential/handlers/discord/activities/JoiningActivityAdapter;", "Lgg/essential/handlers/discord/DiscordIntegration$ActivityAdapter;", "", "applicable", "()Z", "", "joinSecret", "", "peerId", "join", "(Ljava/lang/String;J)Z", "Ljava/util/UUID;", "invitee", "removeInviteNotification", "(Ljava/util/UUID;)Z", "Lgg/essential/lib/discordgamesdk/Core;", "core", "Lgg/essential/handlers/discord/DiscordActivity;", "activity", "", "update", "(Lgg/essential/lib/discordgamesdk/Core;Lgg/essential/handlers/discord/DiscordActivity;)V", "", "kotlin.jvm.PlatformType", "", "cooldowns", "Ljava/util/Set;", "Lgg/essential/handlers/discord/DiscordIntegration$Provider;", "provider", "Lgg/essential/handlers/discord/DiscordIntegration$Provider;", "getProvider", "()Lgg/essential/handlers/discord/DiscordIntegration$Provider;", "<init>", "(Lgg/essential/handlers/discord/DiscordIntegration$Provider;)V", "Essential 1.19-fabric"})
public final class JoiningActivityAdapter
implements DiscordIntegration.ActivityAdapter {
    @NotNull
    private final DiscordIntegration.Provider provider;
    private final Set<UUID> cooldowns;

    public JoiningActivityAdapter(@NotNull DiscordIntegration.Provider provider2) {
        Intrinsics.checkNotNullParameter(provider2, "provider");
        this.provider = provider2;
        this.cooldowns = Collections.newSetFromMap(new ConcurrentHashMap());
    }

    @NotNull
    public final DiscordIntegration.Provider getProvider() {
        return this.provider;
    }

    @Override
    public boolean applicable() {
        DiscordIntegration.ServerState serverState = DiscordIntegration.INSTANCE.getCurrentServerState();
        return (serverState == null ? null : serverState.getType()) == DiscordIntegration.ServerStateType.JOINED_MULTIPLAYER;
    }

    @Override
    public void update(@NotNull Core core, @NotNull DiscordActivity activity) {
        Intrinsics.checkNotNullParameter(core, "core");
        Intrinsics.checkNotNullParameter(activity, "activity");
        activity.setDetails("Playing Minecraft");
        activity.setState("Multiplayer: With Friends");
        SPSManager sPSManager = Essential.getInstance().getConnectionManager().getSpsManager();
        Intrinsics.checkNotNullExpressionValue(sPSManager, "getInstance().connectionManager.spsManager");
        SPSManager spsManager = sPSManager;
        class_642 class_6422 = UMinecraft.getMinecraft().method_1558();
        if (class_6422 == null) {
            return;
        }
        class_642 serverData = class_6422;
        UPnPSession spsSession = spsManager.getSessionFromSpsAddress(serverData.field_3761);
        if (spsSession != null) {
            UUID uUID = spsSession.getHostUUID();
            Intrinsics.checkNotNullExpressionValue(uUID, "spsSession.hostUUID");
            UUID hostUUID = uUID;
            activity.setPartyId("multiplayer|" + (UMinecraft.getMinecraft().method_1515().hashCode() ^ hostUUID.hashCode()));
            class_634 class_6342 = UMinecraft.getMinecraft().method_1562();
            if (class_6342 != null) {
                class_640 class_6402 = class_6342.method_2871(hostUUID);
                if (class_6402 != null) {
                    GameProfile gameProfile = class_6402.method_2966();
                    if (gameProfile != null) {
                        String string = gameProfile.getName();
                        if (string != null) {
                            String string2;
                            String it = string2 = string;
                            boolean bl = false;
                            activity.setState("Multiplayer: Playing on " + it + "'s world");
                        }
                    }
                }
            }
        }
    }

    @Override
    public boolean join(@NotNull String joinSecret, long peerId) {
        Intrinsics.checkNotNullParameter(joinSecret, "joinSecret");
        if (StringsKt.startsWith$default(joinSecret, "hosted|", false, 2, null)) {
            byte[] data2 = Base64.decodeBase64((String)StringsKt.substringBefore$default(StringsKt.substringAfter$default(joinSecret, "hosted|", null, 2, null), '|', null, 2, null));
            if (!Essential.getInstance().getConnectionManager().isOpen() || !Essential.getInstance().getConnectionManager().isAuthenticated()) {
                ExtensionsKt.getExecutor(UMinecraft.getMinecraft()).execute(JoiningActivityAdapter::join$lambda-1);
                return true;
            }
            Intrinsics.checkNotNullExpressionValue(data2, "data");
            UUID ownerUuid = DiscordIntegration.INSTANCE.bytesToUUID(data2, 16);
            String username = (String)((CompletableFuture)UUIDUtil.getName(ownerUuid).exceptionally(JoiningActivityAdapter::join$lambda-2)).join();
            if (this.cooldowns.contains(ownerUuid)) {
                Essential.logger.info("Cooldown reached while attempting to join " + username + "'s world");
                ExtensionsKt.getExecutor(UMinecraft.getMinecraft()).execute(() -> JoiningActivityAdapter.join$lambda-3(username));
                return true;
            }
            ConnectionManager connectionManager = Essential.getInstance().getConnectionManager();
            Intrinsics.checkNotNullExpressionValue(connectionManager, "getInstance().connectionManager");
            ConnectionManager connectionManager2 = connectionManager;
            Essential.logger.info("Attempting to join " + username + "'s world");
            this.cooldowns.add(ownerUuid);
            Multithreading.schedule(() -> JoiningActivityAdapter.join$lambda-4(this, ownerUuid), 7L, TimeUnit.SECONDS);
            connectionManager2.send(new SocialDiscordRequestJoinServerPacket(ownerUuid, joinSecret));
            return true;
        }
        return false;
    }

    @Override
    public boolean removeInviteNotification(@NotNull UUID invitee) {
        Intrinsics.checkNotNullParameter(invitee, "invitee");
        return this.cooldowns.contains(invitee);
    }

    private static final void join$lambda-1() {
        Essential.getInstance().notifications().push("Failed to join someone else's game", "You are not connected to the Essential Network. This is required to continue.");
    }

    private static final String join$lambda-2(Throwable it) {
        return "ERROR";
    }

    private static final void join$lambda-3(String $username) {
        Essential.getInstance().notifications().push("Failed to join " + $username + "'s game", "You are joining too fast! Please wait a few seconds.");
    }

    private static final void join$lambda-4(JoiningActivityAdapter this$0, UUID $ownerUuid) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($ownerUuid, "$ownerUuid");
        this$0.cooldowns.remove($ownerUuid);
    }
}

