/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.handlers.discord;

import com.google.common.primitives.Longs;
import gg.essential.Essential;
import gg.essential.api.utils.Multithreading;
import gg.essential.event.client.PostInitializationEvent;
import gg.essential.handlers.discord.DiscordActivity;
import gg.essential.handlers.discord.activities.FallbackActivityAdapter;
import gg.essential.handlers.discord.activities.HostingActivityAdapter;
import gg.essential.handlers.discord.activities.JoiningActivityAdapter;
import gg.essential.handlers.discord.activities.MenuActivityAdapter;
import gg.essential.handlers.discord.activities.RealmsActivityAdapter;
import gg.essential.handlers.discord.activities.ThirdPartyActivityAdapter;
import gg.essential.lib.discordgamesdk.Core;
import gg.essential.lib.discordgamesdk.CreateParams;
import gg.essential.lib.discordgamesdk.DiscordEventAdapter;
import gg.essential.lib.discordgamesdk.activity.Activity;
import gg.essential.lib.discordgamesdk.activity.ActivityJoinRequestReply;
import gg.essential.lib.discordgamesdk.user.DiscordUser;
import gg.essential.lib.kbrewster.eventbus.Subscribe;
import gg.essential.network.connectionmanager.sps.SPSManager;
import gg.essential.universal.UMinecraft;
import gg.essential.universal.wrappers.UPlayer;
import gg.essential.upnp.model.UPnPSession;
import gg.essential.util.ExtensionsKt;
import gg.essential.util.OperatingSystem;
import gg.essential.util.WebUtil;
import java.io.Closeable;
import java.io.File;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_412;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_634;
import net.minecraft.class_638;
import net.minecraft.class_639;
import net.minecraft.class_642;
import org.apache.commons.codec.binary.Base64;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0005()*+,B\t\b\u0002\u00a2\u0006\u0004\b&\u0010'J\u001f\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\f\u0010\rJ\r\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0015\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0017\u001a\u0004\u0018\u00010\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001d\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00140\u00188\u0006\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001cR\u0013\u0010 \u001a\u0004\u0018\u00010\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0017\u0010\"\u001a\u00020!8\u0006\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010%\u00a8\u0006-"}, d2={"Lgg/essential/handlers/discord/DiscordIntegration;", "", "", "bytes", "", "offset", "Ljava/util/UUID;", "bytesToUUID", "([BI)Ljava/util/UUID;", "Lgg/essential/event/client/PostInitializationEvent;", "event", "", "onPostInit", "(Lgg/essential/event/client/PostInitializationEvent;)V", "Ljava/io/File;", "prepareNatives", "()Ljava/io/File;", "uuid", "uuidToBytes", "(Ljava/util/UUID;)[B", "Lgg/essential/handlers/discord/DiscordIntegration$ActivityAdapter;", "getActivityAdapter", "()Lgg/essential/handlers/discord/DiscordIntegration$ActivityAdapter;", "activityAdapter", "", "activityAdapters", "Ljava/util/List;", "getActivityAdapters", "()Ljava/util/List;", "Lgg/essential/handlers/discord/DiscordIntegration$ServerState;", "getCurrentServerState", "()Lgg/essential/handlers/discord/DiscordIntegration$ServerState;", "currentServerState", "Lgg/essential/handlers/discord/DiscordIntegration$Provider;", "provider", "Lgg/essential/handlers/discord/DiscordIntegration$Provider;", "getProvider", "()Lgg/essential/handlers/discord/DiscordIntegration$Provider;", "<init>", "()V", "ActivityAdapter", "AvailableProvider", "Provider", "ServerState", "ServerStateType", "Essential 1.19-fabric"})
public final class DiscordIntegration {
    @NotNull
    public static final DiscordIntegration INSTANCE = new DiscordIntegration();
    @NotNull
    private static final Provider provider = new AvailableProvider();
    @NotNull
    private static final List<ActivityAdapter> activityAdapters;

    private DiscordIntegration() {
    }

    @NotNull
    public final Provider getProvider() {
        return provider;
    }

    @NotNull
    public final List<ActivityAdapter> getActivityAdapters() {
        return activityAdapters;
    }

    @Nullable
    public final ActivityAdapter getActivityAdapter() {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = activityAdapters;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ActivityAdapter it = (ActivityAdapter)element$iv;
                boolean bl = false;
                if (!it.applicable()) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @NotNull
    public final byte[] uuidToBytes(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        byte[] byArray = Longs.toByteArray((long)uuid.getLeastSignificantBits());
        Intrinsics.checkNotNullExpressionValue(byArray, "toByteArray(uuid.leastSignificantBits)");
        byte[] byArray2 = byArray;
        byArray = Longs.toByteArray((long)uuid.getMostSignificantBits());
        Intrinsics.checkNotNullExpressionValue(byArray, "toByteArray(uuid.mostSignificantBits)");
        return ArraysKt.plus(byArray2, byArray);
    }

    @NotNull
    public final UUID bytesToUUID(@NotNull byte[] bytes, int offset) {
        Intrinsics.checkNotNullParameter(bytes, "bytes");
        byte[] byArray = bytes;
        int n = offset + 8;
        int n2 = offset + 16;
        long l = Longs.fromByteArray((byte[])ArraysKt.copyOfRange(byArray, n, n2));
        byArray = bytes;
        n = offset + 0;
        n2 = offset + 8;
        return new UUID(l, Longs.fromByteArray((byte[])ArraysKt.copyOfRange(byArray, n, n2)));
    }

    public static /* synthetic */ UUID bytesToUUID$default(DiscordIntegration discordIntegration, byte[] byArray, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return discordIntegration.bytesToUUID(byArray, n);
    }

    @Subscribe
    public final void onPostInit(@NotNull PostInitializationEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        provider.init();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ServerState getCurrentServerState() {
        ServerState serverState;
        if (!UPlayer.hasPlayer() || UMinecraft.getWorld() == null || UMinecraft.getNetHandler() == null) {
            return null;
        }
        class_310 minecraft = UMinecraft.getMinecraft();
        if (minecraft.method_1589()) {
            serverState = new ServerState(ServerStateType.REALMS, null);
        } else if (minecraft.method_1542() && Essential.getInstance().getConnectionManager().isOpen() && Essential.getInstance().getConnectionManager().isAuthenticated()) {
            String string;
            ServerStateType serverStateType = ServerStateType.HOSTING_MULTIPLAYER;
            UPnPSession uPnPSession = Essential.getInstance().getConnectionManager().getSpsManager().getLocalSession();
            if (uPnPSession == null) {
                string = null;
            } else {
                void it;
                UPnPSession uPnPSession2 = uPnPSession;
                ServerStateType serverStateType2 = serverStateType;
                boolean bl = false;
                string = it.getIp() + ":" + it.getPort();
                serverStateType = serverStateType2;
            }
            String string2 = string;
            ServerStateType serverStateType3 = serverStateType;
            serverState = new ServerState(serverStateType3, string2);
        } else {
            if (minecraft.method_1558() != null) {
                ServerState serverState2;
                class_642 class_6422 = minecraft.method_1558();
                Intrinsics.checkNotNull(class_6422);
                class_642 class_6423 = class_6422;
                Intrinsics.checkNotNullExpressionValue(class_6423, "minecraft.currentServerEntry!!");
                class_642 serverData = class_6423;
                String it = serverData.field_3761;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue(it, "it");
                String serverIP = StringsKt.endsWith$default(it, ":25565", false, 2, null) ? StringsKt.substringBeforeLast$default(it, ":25565", null, 2, null) : it;
                SPSManager sPSManager = Essential.getInstance().getConnectionManager().getSpsManager();
                Intrinsics.checkNotNullExpressionValue(sPSManager, "getInstance().connectionManager.spsManager");
                SPSManager spsManager = sPSManager;
                if (!spsManager.isSpsAddress(serverIP) && !serverData.method_2994()) {
                    serverState2 = new ServerState(ServerStateType.THIRD_PARTY_MULTIPLAYER, serverIP);
                } else {
                    UPnPSession uPnPSession = spsManager.getSessionFromSpsAddress(serverIP);
                    if (uPnPSession == null) {
                        serverState2 = null;
                    } else {
                        UPnPSession session = uPnPSession;
                        boolean bl2 = false;
                        serverState2 = new ServerState(ServerStateType.JOINED_MULTIPLAYER, session.getIp() + ":" + session.getPort());
                    }
                }
                return serverState2;
            }
            serverState = null;
        }
        return serverState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final File prepareNatives() {
        File nativeFile;
        block24: {
            String sdkVersion = "2.5.6";
            File sdkFolder = new File(Essential.getInstance().getBaseDir(), "discord-sdk/" + sdkVersion);
            sdkFolder.mkdirs();
            String fileExtension = switch (WhenMappings.$EnumSwitchMapping$0[ExtensionsKt.getOs().ordinal()]) {
                case 1 -> ".dll";
                case 2 -> ".dylib";
                case 3 -> ".so";
                default -> throw new IllegalStateException("Unsupported system operating system!");
            };
            nativeFile = new File(sdkFolder, "discord_game_sdk" + fileExtension);
            if (nativeFile.exists()) break block24;
            File sdkZip = new File(sdkFolder, "discord_game_sdk.zip");
            if (!sdkZip.exists()) {
                WebUtil.downloadToFile("https://dl-game-sdk.discordapp.net/" + sdkVersion + "/discord_game_sdk.zip", sdkZip, "Mozilla/4.76 (Essential)");
            }
            Object object = System.getProperty("os.arch");
            Intrinsics.checkNotNullExpressionValue(object, "getProperty(\"os.arch\")");
            Object object2 = ((String)object).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(object2, "this as java.lang.String).toLowerCase(Locale.ROOT)");
            String arch = switch (object2) {
                case "x86_64", "amd64" -> "x86_64";
                case "x86" -> {
                    if (ExtensionsKt.getOs() == OperatingSystem.WINDOWS) {
                        yield "x86";
                    }
                    throw new IllegalStateException("32-bit discord integration is not supported on macOS and Linux!");
                }
                default -> throw new IllegalStateException("Unsupported system architecture!");
            };
            URI sdkZipUri = sdkZip.toURI();
            object = FileSystems.newFileSystem(new URI("jar:" + sdkZipUri.getScheme(), sdkZipUri.getHost(), sdkZipUri.getPath(), sdkZipUri.getFragment()), MapsKt.mapOf(TuplesKt.to("create", false)));
            object2 = null;
            try {
                FileSystem fs = (FileSystem)object;
                boolean bl = false;
                CopyOption[] copyOptionArray = fs.getPath("lib/" + arch + "/discord_game_sdk" + fileExtension, new String[0]);
                Intrinsics.checkNotNullExpressionValue(copyOptionArray, "fs.getPath(\"lib/$arch/di\u2026_game_sdk$fileExtension\")");
                CopyOption[] fsPath = copyOptionArray;
                copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES};
                Path path = Files.copy((Path)fsPath, nativeFile.toPath(), copyOptionArray);
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
        }
        return nativeFile;
    }

    static {
        ActivityAdapter[] activityAdapterArray = new ActivityAdapter[6];
        activityAdapterArray[0] = new HostingActivityAdapter(provider);
        activityAdapterArray[1] = new JoiningActivityAdapter(provider);
        activityAdapterArray[2] = new RealmsActivityAdapter(provider);
        activityAdapterArray[3] = new ThirdPartyActivityAdapter(provider);
        activityAdapterArray[4] = new MenuActivityAdapter(provider);
        activityAdapterArray[5] = new FallbackActivityAdapter(provider);
        activityAdapters = CollectionsKt.listOf(activityAdapterArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\bf\u0018\u00002\u00020\u0001J\u000f\u0010\u0003\u001a\u00020\u0002H&\u00a2\u0006\u0004\b\u0003\u0010\u0004J'\u0010\n\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\bH&\u00a2\u0006\u0004\b\n\u0010\u000bJ#\u0010\u000f\u001a\u00020\u00022\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00020\fH&\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0013\u001a\u00020\b8&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0014\u00c0\u0006\u0001"}, d2={"Lgg/essential/handlers/discord/DiscordIntegration$Provider;", "", "", "init", "()V", "", "name", "ipAddress", "", "isLan", "joinServer", "(Ljava/lang/String;Ljava/lang/String;Z)V", "Lkotlin/Function1;", "Lgg/essential/lib/discordgamesdk/Core;", "action", "next", "(Lkotlin/jvm/functions/Function1;)V", "getInitialized", "()Z", "initialized", "Essential 1.19-fabric"})
    public static interface Provider {
        public boolean getInitialized();

        public void init();

        public void next(@NotNull Function1<? super Core, Unit> var1);

        public void joinServer(@NotNull String var1, @NotNull String var2, boolean var3);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lgg/essential/handlers/discord/DiscordIntegration$ServerStateType;", "", "<init>", "(Ljava/lang/String;I)V", "REALMS", "HOSTING_MULTIPLAYER", "JOINED_MULTIPLAYER", "THIRD_PARTY_MULTIPLAYER", "Essential 1.19-fabric"})
    public static final class ServerStateType
    extends Enum<ServerStateType> {
        public static final /* enum */ ServerStateType REALMS = new ServerStateType();
        public static final /* enum */ ServerStateType HOSTING_MULTIPLAYER = new ServerStateType();
        public static final /* enum */ ServerStateType JOINED_MULTIPLAYER = new ServerStateType();
        public static final /* enum */ ServerStateType THIRD_PARTY_MULTIPLAYER = new ServerStateType();
        private static final /* synthetic */ ServerStateType[] $VALUES;

        public static ServerStateType[] values() {
            return (ServerStateType[])$VALUES.clone();
        }

        public static ServerStateType valueOf(String value2) {
            return Enum.valueOf(ServerStateType.class, value2);
        }

        static {
            $VALUES = serverStateTypeArray = new ServerStateType[]{ServerStateType.REALMS, ServerStateType.HOSTING_MULTIPLAYER, ServerStateType.JOINED_MULTIPLAYER, ServerStateType.THIRD_PARTY_MULTIPLAYER};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\b\u001a\u00020\u0002\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0010\u0010\u0003\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J&\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\b\u001a\u00020\u00022\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001a\u0010\u000e\u001a\u00020\r2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0011\u001a\u00020\u0010H\u00d6\u0001\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0007R\u0019\u0010\t\u001a\u0004\u0018\u00010\u00058\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u0014\u001a\u0004\b\u0015\u0010\u0007R\u0017\u0010\b\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\u0016\u001a\u0004\b\u0017\u0010\u0004\u00a8\u0006\u001a"}, d2={"Lgg/essential/handlers/discord/DiscordIntegration$ServerState;", "", "Lgg/essential/handlers/discord/DiscordIntegration$ServerStateType;", "component1", "()Lgg/essential/handlers/discord/DiscordIntegration$ServerStateType;", "", "component2", "()Ljava/lang/String;", "type", "ip", "copy", "(Lgg/essential/handlers/discord/DiscordIntegration$ServerStateType;Ljava/lang/String;)Lgg/essential/handlers/discord/DiscordIntegration$ServerState;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "Ljava/lang/String;", "getIp", "Lgg/essential/handlers/discord/DiscordIntegration$ServerStateType;", "getType", "<init>", "(Lgg/essential/handlers/discord/DiscordIntegration$ServerStateType;Ljava/lang/String;)V", "Essential 1.19-fabric"})
    public static final class ServerState {
        @NotNull
        private final ServerStateType type;
        @Nullable
        private final String ip;

        public ServerState(@NotNull ServerStateType type2, @Nullable String ip) {
            Intrinsics.checkNotNullParameter((Object)type2, "type");
            this.type = type2;
            this.ip = ip;
        }

        @NotNull
        public final ServerStateType getType() {
            return this.type;
        }

        @Nullable
        public final String getIp() {
            return this.ip;
        }

        @NotNull
        public final ServerStateType component1() {
            return this.type;
        }

        @Nullable
        public final String component2() {
            return this.ip;
        }

        @NotNull
        public final ServerState copy(@NotNull ServerStateType type2, @Nullable String ip) {
            Intrinsics.checkNotNullParameter((Object)type2, "type");
            return new ServerState(type2, ip);
        }

        public static /* synthetic */ ServerState copy$default(ServerState serverState, ServerStateType serverStateType, String string, int n, Object object) {
            if ((n & 1) != 0) {
                serverStateType = serverState.type;
            }
            if ((n & 2) != 0) {
                string = serverState.ip;
            }
            return serverState.copy(serverStateType, string);
        }

        @NotNull
        public String toString() {
            return "ServerState(type=" + this.type + ", ip=" + this.ip + ")";
        }

        public int hashCode() {
            int result2 = this.type.hashCode();
            result2 = result2 * 31 + (this.ip == null ? 0 : this.ip.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ServerState)) {
                return false;
            }
            ServerState serverState = (ServerState)other;
            if (this.type != serverState.type) {
                return false;
            }
            return Intrinsics.areEqual(this.ip, serverState.ip);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J\u000f\u0010\u0003\u001a\u00020\u0002H&\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001f\u0010\t\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\r\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J5\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00052\u0014\u0010\u0017\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u00020\u00110\u0016H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0018J\u001f\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001bH&\u00a2\u0006\u0004\b\u001d\u0010\u001e\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u001f\u00c0\u0006\u0001"}, d2={"Lgg/essential/handlers/discord/DiscordIntegration$ActivityAdapter;", "", "", "applicable", "()Z", "", "joinSecret", "", "peerId", "join", "(Ljava/lang/String;J)Z", "Ljava/util/UUID;", "invitee", "removeInviteNotification", "(Ljava/util/UUID;)Z", "Lgg/essential/lib/discordgamesdk/user/DiscordUser;", "user", "", "requestJoin", "(Lgg/essential/lib/discordgamesdk/user/DiscordUser;)V", "userUUID", "secret", "Lkotlin/Function1;", "action", "(Ljava/util/UUID;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "Lgg/essential/lib/discordgamesdk/Core;", "core", "Lgg/essential/handlers/discord/DiscordActivity;", "activity", "update", "(Lgg/essential/lib/discordgamesdk/Core;Lgg/essential/handlers/discord/DiscordActivity;)V", "Essential 1.19-fabric"})
    public static interface ActivityAdapter {
        public boolean applicable();

        public void update(@NotNull Core var1, @NotNull DiscordActivity var2);

        default public void requestJoin(@NotNull DiscordUser user) {
            Intrinsics.checkNotNullParameter(user, "user");
        }

        default public boolean join(@NotNull String joinSecret, long peerId) {
            Intrinsics.checkNotNullParameter(joinSecret, "joinSecret");
            return false;
        }

        default public void requestJoin(@NotNull UUID userUUID, @NotNull String secret, @NotNull Function1<? super String, Unit> action) {
            Intrinsics.checkNotNullParameter(userUUID, "userUUID");
            Intrinsics.checkNotNullParameter(secret, "secret");
            Intrinsics.checkNotNullParameter(action, "action");
            action.invoke(null);
        }

        default public boolean removeInviteNotification(@NotNull UUID invitee) {
            Intrinsics.checkNotNullParameter(invitee, "invitee");
            return false;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0000\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b+\u0010\u0005J\u000f\u0010\u0004\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0005J'\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ#\u0010\u0010\u001a\u00020\u00032\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00030\rH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001f\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dR8\u0010!\u001a&\u0012\f\u0012\n \u001f*\u0004\u0018\u00010\u00060\u0006 \u001f*\u0012\u0012\f\u0012\n \u001f*\u0004\u0018\u00010\u00060\u0006\u0018\u00010 0\u001e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020\t8\u0016X\u0096D\u00a2\u0006\f\n\u0004\b#\u0010$\u001a\u0004\b%\u0010&R)\u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00030\r0'8\u0006\u00a2\u0006\f\n\u0004\b\u0010\u0010(\u001a\u0004\b)\u0010*\u00a8\u0006,"}, d2={"Lgg/essential/handlers/discord/DiscordIntegration$AvailableProvider;", "Lgg/essential/handlers/discord/DiscordIntegration$Provider;", "Lgg/essential/lib/discordgamesdk/DiscordEventAdapter;", "", "init", "()V", "", "name", "ipAddress", "", "isLan", "joinServer", "(Ljava/lang/String;Ljava/lang/String;Z)V", "Lkotlin/Function1;", "Lgg/essential/lib/discordgamesdk/Core;", "action", "next", "(Lkotlin/jvm/functions/Function1;)V", "secret", "onActivityJoin", "(Ljava/lang/String;)V", "Lgg/essential/lib/discordgamesdk/user/DiscordUser;", "user", "onActivityJoinRequest", "(Lgg/essential/lib/discordgamesdk/user/DiscordUser;)V", "core", "Lgg/essential/handlers/discord/DiscordActivity;", "activity", "updateDefault", "(Lgg/essential/lib/discordgamesdk/Core;Lgg/essential/handlers/discord/DiscordActivity;)V", "", "kotlin.jvm.PlatformType", "", "cooldowns", "Ljava/util/Set;", "initialized", "Z", "getInitialized", "()Z", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Ljava/util/concurrent/CopyOnWriteArrayList;", "getNext", "()Ljava/util/concurrent/CopyOnWriteArrayList;", "<init>", "Essential 1.19-fabric"})
    public static final class AvailableProvider
    extends DiscordEventAdapter
    implements Provider {
        private final boolean initialized;
        @NotNull
        private final CopyOnWriteArrayList<Function1<Core, Unit>> next = new CopyOnWriteArrayList();
        private final Set<String> cooldowns = Collections.newSetFromMap(new ConcurrentHashMap());

        @Override
        public boolean getInitialized() {
            return this.initialized;
        }

        @NotNull
        public final CopyOnWriteArrayList<Function1<Core, Unit>> getNext() {
            return this.next;
        }

        @Override
        public void init() {
            if (!this.getInitialized()) {
                Thread thread2;
                Thread it = thread2 = new Thread(() -> AvailableProvider.init$lambda-4(this), "Essentials-Discord-SDK");
                boolean bl = false;
                it.setDaemon(true);
                it.start();
            }
        }

        private final void updateDefault(Core core, DiscordActivity activity) {
            block8: {
                block9: {
                    ServerState serverState;
                    ServerState serverState2;
                    ServerState serverState3;
                    ServerState serverState4 = INSTANCE.getCurrentServerState();
                    if (serverState4 == null) break block8;
                    ServerState it = serverState3 = serverState4;
                    boolean bl = false;
                    ServerState serverState5 = serverState2 = UMinecraft.getMinecraft().method_1562() != null ? serverState3 : null;
                    if (serverState2 == null) break block8;
                    ServerState it2 = serverState = serverState2;
                    boolean bl2 = false;
                    class_642 serverData = UMinecraft.getMinecraft().method_1558();
                    ServerState serverState6 = serverState3 = !(serverData == null || Essential.getInstance().getConnectionManager().getSpsManager().isSpsAddress(serverData.field_3761)) ? serverState : null;
                    if (serverState3 == null) break block8;
                    it2 = serverState = serverState3;
                    boolean bl3 = false;
                    class_634 class_6342 = UMinecraft.getMinecraft().method_1562();
                    Intrinsics.checkNotNull(class_6342);
                    class_634 class_6343 = class_6342;
                    Intrinsics.checkNotNullExpressionValue(class_6343, "getMinecraft().networkHandler!!");
                    class_634 connection = class_6343;
                    if (activity.getPartySize() == null && activity.getPartyCapacity() == null) {
                        Integer n;
                        String string;
                        String string2;
                        class_2561 class_25612;
                        activity.setPartySize(connection.method_2880().size());
                        class_6343 = UMinecraft.getMinecraft().method_1558();
                        if (class_6343 != null && (class_25612 = class_6343.field_3753) != null && (string2 = class_25612.getString()) != null && (string = StringsKt.substringAfter$default(string2, '/', null, 2, null)) != null && (n = StringsKt.toIntOrNull(string)) != null) {
                            Integer n2;
                            Integer n3 = n;
                            int it3 = ((Number)n3).intValue();
                            boolean bl4 = false;
                            Integer n4 = n2 = it3 > 0 ? n3 : null;
                            if (n2 != null) {
                                n3 = n2;
                                it3 = ((Number)n3).intValue();
                                boolean bl5 = false;
                                activity.setPartyCapacity(it3);
                            }
                        }
                    }
                    if (activity.getPartySize() != null) {
                        Integer n = activity.getPartySize();
                        Intrinsics.checkNotNull(n);
                        activity.setPartySize(Math.max(1, n));
                    }
                    if (activity.getPartySize() == null || activity.getPartyCapacity() == null) break block8;
                    Integer n = activity.getPartySize();
                    Intrinsics.checkNotNull(n);
                    int n5 = n;
                    Integer n6 = activity.getPartyCapacity();
                    Intrinsics.checkNotNull(n6);
                    if (n5 >= n6) break block9;
                    Integer n7 = activity.getPartyCapacity();
                    Intrinsics.checkNotNull(n7);
                    if (n7 > 0) break block8;
                }
                Integer n = activity.getPartyCapacity();
                Intrinsics.checkNotNull(n);
                activity.setPartyCapacity(Math.max(1, n + 1));
            }
            if (activity.getJoinSecret() != null) {
                activity.setJoinSecret(Base64.encodeBase64URLSafeString((byte[])Longs.toByteArray((long)core.networkManager().getPeerId())) + "|" + activity.getJoinSecret());
            }
        }

        @Override
        public void next(@NotNull Function1<? super Core, Unit> action) {
            Intrinsics.checkNotNullParameter(action, "action");
            this.next.add(action);
        }

        @Override
        public void onActivityJoin(@NotNull String secret) {
            Intrinsics.checkNotNullParameter(secret, "secret");
            long peerId = Longs.fromByteArray((byte[])Base64.decodeBase64((String)StringsKt.substringBefore$default(secret, '|', null, 2, null)));
            Iterable $this$firstOrNull$iv = INSTANCE.getActivityAdapters();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ActivityAdapter it = (ActivityAdapter)element$iv;
                boolean bl = false;
                if (!it.join(StringsKt.substringAfter$default(secret, '|', null, 2, null), peerId)) continue;
                break;
            }
        }

        @Override
        public void onActivityJoinRequest(@NotNull DiscordUser user) {
            Intrinsics.checkNotNullParameter(user, "user");
            if (INSTANCE.getActivityAdapter() == null) {
                this.next.add(new Function1<Core, Unit>(user){
                    final /* synthetic */ DiscordUser $user;
                    {
                        this.$user = $user;
                        super(1);
                    }

                    public final void invoke(@NotNull Core core) {
                        Intrinsics.checkNotNullParameter(core, "core");
                        core.activityManager().sendRequestReply(this.$user.getUserId(), ActivityJoinRequestReply.NO);
                    }
                });
            } else {
                ActivityAdapter activityAdapter = INSTANCE.getActivityAdapter();
                if (activityAdapter != null) {
                    activityAdapter.requestJoin(user);
                }
            }
        }

        @Override
        public void joinServer(@NotNull String name, @NotNull String ipAddress, boolean isLan) {
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(ipAddress, "ipAddress");
            String it = ipAddress;
            boolean bl = false;
            String string = StringsKt.endsWith$default(it, ":25565", false, 2, null) ? StringsKt.substringBeforeLast$default(it, ":25565", null, 2, null) : it;
            String serverIP = string;
            if (this.cooldowns.contains(serverIP)) {
                return;
            }
            this.cooldowns.add(serverIP);
            Multithreading.schedule(() -> AvailableProvider.joinServer$lambda-13(this, serverIP), 7L, TimeUnit.SECONDS);
            ExtensionsKt.getExecutor(UMinecraft.getMinecraft()).execute(() -> AvailableProvider.joinServer$lambda-15(name, serverIP, isLan));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final void init$lambda-4(AvailableProvider this$0) {
            Intrinsics.checkNotNullParameter(this$0, "this$0");
            try {
                File natives = INSTANCE.prepareNatives();
                Core.init(natives);
                AutoCloseable autoCloseable = new CreateParams();
                Throwable throwable = null;
                try {
                    try {
                        CreateParams params = (CreateParams)autoCloseable;
                        boolean bl = false;
                        params.setClientID(894984875755597825L);
                        Object object = new CreateParams.Flags[]{CreateParams.Flags.NO_REQUIRE_DISCORD};
                        params.setFlags(CreateParams.Flags.toLong(object));
                        params.registerEventHandler(this$0);
                        object = new Core(params);
                        Throwable throwable2 = null;
                        try {
                            try {
                                Core core = (Core)object;
                                boolean bl2 = false;
                                DiscordActivity lastActivity = null;
                                while (true) {
                                    try {
                                        DiscordActivity discordActivity = new DiscordActivity(null, null, null, null, null, null, 63, null);
                                        ActivityAdapter activityAdapter = INSTANCE.getActivityAdapter();
                                        if (activityAdapter != null) {
                                            activityAdapter.update(core, discordActivity);
                                        }
                                        this$0.updateDefault(core, discordActivity);
                                        if (!Intrinsics.areEqual(lastActivity, discordActivity)) {
                                            lastActivity = discordActivity;
                                            if (INSTANCE.getActivityAdapter() != null && Essential.getInstance().config().getDiscordRichPresence()) {
                                                AutoCloseable autoCloseable2 = new Activity();
                                                Throwable throwable3 = null;
                                                try {
                                                    Activity activity = (Activity)autoCloseable2;
                                                    boolean bl3 = false;
                                                    discordActivity.setTo(activity);
                                                    core.activityManager().updateActivity(activity);
                                                    Unit unit = Unit.INSTANCE;
                                                }
                                                catch (Throwable throwable4) {
                                                    throwable3 = throwable4;
                                                    throw throwable4;
                                                }
                                                finally {
                                                    AutoCloseableKt.closeFinally(autoCloseable2, throwable3);
                                                }
                                            } else {
                                                core.activityManager().clearActivity();
                                            }
                                        }
                                        Iterable $this$forEach$iv = this$0.getNext();
                                        boolean $i$f$forEach = false;
                                        for (Object element$iv : $this$forEach$iv) {
                                            Function1 it = (Function1)element$iv;
                                            boolean bl4 = false;
                                            it.invoke(core);
                                        }
                                    }
                                    catch (Throwable throwable5) {
                                        throwable5.printStackTrace();
                                        this$0.getNext().clear();
                                    }
                                    try {
                                        core.runCallbacks();
                                        Thread.sleep(1000L);
                                    }
                                    catch (Throwable throwable6) {
                                        throwable6.printStackTrace();
                                    }
                                }
                            }
                            catch (Throwable throwable7) {
                                throwable2 = throwable7;
                                throw throwable7;
                            }
                        }
                        catch (Throwable throwable8) {
                            AutoCloseableKt.closeFinally((AutoCloseable)object, throwable2);
                            throw throwable8;
                        }
                    }
                    catch (Throwable throwable9) {
                        throwable = throwable9;
                        throw throwable9;
                    }
                }
                catch (Throwable throwable10) {
                    AutoCloseableKt.closeFinally(autoCloseable, throwable);
                    throw throwable10;
                }
            }
            catch (Throwable outerThrowable) {
                outerThrowable.printStackTrace();
                return;
            }
        }

        private static final void joinServer$lambda-13(AvailableProvider this$0, String $serverIP) {
            Intrinsics.checkNotNullParameter(this$0, "this$0");
            Intrinsics.checkNotNullParameter($serverIP, "$serverIP");
            this$0.cooldowns.remove($serverIP);
        }

        private static final void joinServer$lambda-15(String $name, String $serverIP, boolean $isLan) {
            class_642 class_6422;
            Intrinsics.checkNotNullParameter($name, "$name");
            Intrinsics.checkNotNullParameter($serverIP, "$serverIP");
            class_642 $this$joinServer_u24lambda_u2d15_u24lambda_u2d14 = class_6422 = new class_642($name, $serverIP, $isLan);
            boolean bl = false;
            $this$joinServer_u24lambda_u2d15_u24lambda_u2d14.method_2995(class_642.class_643.field_3767);
            class_642 serverData = class_6422;
            class_638 class_6382 = UMinecraft.getWorld();
            if (class_6382 != null) {
                class_6382.method_8525();
            }
            UMinecraft.getMinecraft().method_1481((class_638)null);
            class_442 parent = new class_442();
            class_412.method_36877((class_437)((class_437)parent), (class_310)UMinecraft.getMinecraft(), (class_639)class_639.method_2950((String)serverData.field_3761), (class_642)serverData);
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OperatingSystem.values().length];
            nArray[OperatingSystem.WINDOWS.ordinal()] = 1;
            nArray[OperatingSystem.MACOS.ordinal()] = 2;
            nArray[OperatingSystem.LINUX.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

