/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.handlers;

import gg.essential.Essential;
import gg.essential.lib.weupnp.GatewayDevice;
import gg.essential.lib.weupnp.GatewayDiscover;
import gg.essential.lib.weupnp.PortMappingEntry;
import gg.essential.util.UUIDUtil;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class UPnPWrapper {
    public static final boolean ICE = Boolean.parseBoolean(System.getenv().getOrDefault("ESSENTIAL_ICE", "true"));
    public static final boolean FAKE_UPNP = Boolean.parseBoolean(System.getenv().getOrDefault("ESSENTIAL_FAKE_UPNP", "false"));
    public static transient GatewayDevice device;
    public static String ip;
    public static int port;
    private static UPnPCompatibility compatibility;

    public static UPnPCompatibility getCompatibility() {
        return compatibility;
    }

    public static void checkCompatibility() {
        if (ICE || FAKE_UPNP) {
            compatibility = UPnPCompatibility.COMPATIBLE;
            return;
        }
        try {
            GatewayDiscover discover = new GatewayDiscover();
            discover.discover();
            compatibility = discover.getValidGateway() != null ? UPnPCompatibility.COMPATIBLE : UPnPCompatibility.INCOMPATIBLE;
        }
        catch (Exception e) {
            Essential.logger.error("Exception during UPnP compatibility check, assuming incompatible.", (Throwable)e);
            compatibility = UPnPCompatibility.INCOMPATIBLE;
        }
    }

    public static UPnPStatus openOnPort(int port) {
        if (ICE) {
            ip = UUIDUtil.getClientUUID() + ".essential-sps";
            return UPnPStatus.SUCCESS;
        }
        UPnPWrapper.port = port;
        if (FAKE_UPNP) {
            ip = "localhost";
            return UPnPStatus.SUCCESS;
        }
        try {
            GatewayDiscover discover = new GatewayDiscover();
            Map<InetAddress, GatewayDevice> values2 = discover.discover();
            if (values2.size() == 0) {
                Essential.logger.error("Unable to forward port: UPnP is not enabled on your router!");
                return UPnPStatus.UNAVAILABLE;
            }
            System.out.println(values2.size());
            Iterator<GatewayDevice> iterator2 = values2.values().iterator();
            while (iterator2.hasNext()) {
                GatewayDevice device;
                UPnPWrapper.device = device = iterator2.next();
                String localIp = device.getLocalAddress().getHostAddress();
                boolean run = true;
                try {
                    PortMappingEntry entry;
                    int i = 0;
                    while (device.getGenericPortMappingEntry(i++, entry = new PortMappingEntry())) {
                        if (entry.getExternalPort() != port && (entry.getInternalPort() != port || !entry.getInternalClient().equals(localIp)) || entry.getPortMappingDescription().equals("ESSENTIAL") && entry.getInternalClient().equals(localIp)) continue;
                        Essential.logger.error("Unable to forward port: {} has already claimed port {} for {}.", (Object)entry.getPortMappingDescription(), (Object)port, (Object)entry.getInternalClient());
                        run = false;
                        break;
                    }
                }
                catch (Exception ex) {
                    Essential.logger.error("thrown exception during searching, assuming we're ok", (Throwable)ex);
                    continue;
                }
                if (!run) continue;
                Essential.logger.info("Attempting UPnP on " + device.getFriendlyName() + " " + device.getDeviceType() + " " + device.getManufacturer() + " " + device.getModelNumber() + " " + device.getModelDescription());
                if (!device.addPortMapping(port, port, localIp, "tcp", "essential")) {
                    Essential.logger.error("Unable to forward port: unknown error while adding port mapping. Trying next device if available");
                    continue;
                }
                Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                    try {
                        if (device != null) {
                            device.deletePortMapping(port, "tcp");
                        }
                    }
                    catch (IOException | SAXException e) {
                        Essential.logger.error("Failed to delete port mapping for {}", (Object)port);
                    }
                }));
                ip = device.getExternalIPAddress();
                Essential.logger.info("External UPnP IP: " + ip);
                return UPnPStatus.SUCCESS;
            }
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            Essential.logger.error("Unable to forward port: {}", (Object)ex.getLocalizedMessage(), (Object)ex);
            return UPnPStatus.FAILED;
        }
        return UPnPStatus.FAILED;
    }

    public static String refreshIp() {
        if (ICE) {
            return UUIDUtil.getClientUUID() + ".essential-sps";
        }
        if (FAKE_UPNP) {
            return "localhost";
        }
        if (device != null) {
            try {
                String updatedIP = device.getExternalIPAddress();
                if (updatedIP != null) {
                    ip = updatedIP;
                    return updatedIP;
                }
            }
            catch (IOException | SAXException e) {
                e.printStackTrace();
            }
        }
        return ip;
    }

    public static boolean close(int port) {
        if (device == null) {
            return true;
        }
        try {
            device.deletePortMapping(port, "tcp");
            device = null;
            return true;
        }
        catch (IOException | SAXException e) {
            e.printStackTrace();
            return false;
        }
    }

    static {
        compatibility = UPnPCompatibility.UNCHECKED;
    }

    public static enum UPnPCompatibility {
        UNCHECKED,
        CHECKING,
        INCOMPATIBLE,
        COMPATIBLE;

    }

    public static enum UPnPStatus {
        UNAVAILABLE,
        FAILED,
        SUCCESS;

    }
}

