/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.handlers;

import com.mojang.authlib.GameProfile;
import gg.essential.Essential;
import gg.essential.config.EssentialConfig;
import gg.essential.connectionmanager.common.enums.ProfileStatus;
import gg.essential.data.OnboardingData;
import gg.essential.elementa.utils.ExtensionsKt;
import gg.essential.mixins.ext.client.network.NetHandlerPlayClientExt;
import gg.essential.network.connectionmanager.ConnectionManager;
import gg.essential.network.connectionmanager.profile.ProfileManager;
import gg.essential.universal.UGraphics;
import gg.essential.universal.UMatrixStack;
import gg.essential.universal.UMinecraft;
import gg.essential.universal.shader.BlendState;
import java.awt.Color;
import java.util.Map;
import java.util.UUID;
import kotlin.text.StringsKt;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.minecraft.class_640;

public class OnlineIndicator {
    public static final String DIAMOND = "\u25c6";
    public static class_1297 nametagEntity;
    private static final Color STANDARD_GREEN;
    private static final Color FRIEND_BLUE;

    public static void drawNametagIndicator(UMatrixStack matrixStack, class_1297 entity, String str) {
        UUID playerId;
        if (!(OnboardingData.hasAcceptedTos() && EssentialConfig.INSTANCE.getShowEssentialIndicatorOnNametag() && entity instanceof class_1657)) {
            return;
        }
        ConnectionManager connectionManager = Essential.getInstance().getConnectionManager();
        ProfileManager profileManager = connectionManager.getProfileManager();
        ProfileStatus status = profileManager.getStatus(playerId = ((class_1657)entity).method_7334().getId());
        if (status == ProfileStatus.OFFLINE) {
            return;
        }
        int stringWidth = class_310.method_1551().field_1772.method_1727(str);
        boolean isFriend = connectionManager.getRelationshipManager().isFriend(playerId);
        Color color = isFriend ? FRIEND_BLUE : STANDARD_GREEN;
        UGraphics.enableAlpha();
        UGraphics.disableLighting();
        UGraphics.depthMask(false);
        UGraphics buffer = UGraphics.getFromTessellator();
        float x1 = -(stringWidth >> 1) - 11;
        float y1 = -1.0f;
        float x2 = -(stringWidth >> 1) - 1;
        float y2 = 8.0f;
        if (!entity.method_5715()) {
            UGraphics.disableDepth();
        }
        UGraphics.enableBlend();
        UGraphics.tryBlendFuncSeparate(770, 771, 1, 0);
        buffer.beginWithDefaultShader(UGraphics.DrawMode.QUADS, class_290.field_1576);
        buffer.pos(matrixStack, x1, y1, 0.0).color(0, 0, 0, 64).endVertex();
        buffer.pos(matrixStack, x1, y2, 0.0).color(0, 0, 0, 64).endVertex();
        buffer.pos(matrixStack, x2, y2, 0.0).color(0, 0, 0, 64).endVertex();
        buffer.pos(matrixStack, x2, y1, 0.0).color(0, 0, 0, 64).endVertex();
        buffer.drawDirect();
        if (!entity.method_5715()) {
            OnlineIndicator.drawDiamond(matrixStack, 6, -(stringWidth >> 1) + -6, 3.5f, ExtensionsKt.withAlpha(color, 32).getRGB());
            UGraphics.enableDepth();
        }
        UGraphics.depthMask(true);
        OnlineIndicator.drawDiamond(matrixStack, 6, -(stringWidth >> 1) + -6, 3.5f, color.getRGB());
        UGraphics.enableLighting();
    }

    public static void drawTabIndicator(UMatrixStack matrixStack, class_640 networkPlayerInfo, int x, int y) {
        ProfileStatus status;
        class_2561 displayName;
        if (!OnboardingData.hasAcceptedTos() || !EssentialConfig.INSTANCE.getShowEssentialIndicatorOnTab() || networkPlayerInfo == null) {
            return;
        }
        ConnectionManager connectionManager = Essential.getInstance().getConnectionManager();
        ProfileManager profileManager = connectionManager.getProfileManager();
        GameProfile gameProfile = networkPlayerInfo.method_2966();
        if (gameProfile == null) {
            return;
        }
        UUID playerUuid = gameProfile.getId();
        if (playerUuid == null) {
            return;
        }
        if (playerUuid.version() == 2 && (displayName = networkPlayerInfo.method_2971()) != null) {
            String unformattedText = displayName.getString();
            String displayNameString = StringsKt.substringBefore(unformattedText, ' ', unformattedText);
            class_634 netHandler = UMinecraft.getNetHandler();
            if (netHandler != null) {
                Map<String, UUID> nameToIdCache = ((NetHandlerPlayClientExt)netHandler).essential$getNameIdCache();
                if (!displayNameString.isEmpty() && nameToIdCache.containsKey(displayNameString)) {
                    playerUuid = nameToIdCache.get(displayNameString);
                }
            }
        }
        if ((status = profileManager.getStatus(playerUuid)) == ProfileStatus.OFFLINE) {
            return;
        }
        matrixStack.push();
        matrixStack.translate(0.0f, 0.0f, 5.0f);
        boolean isFriend = connectionManager.getRelationshipManager().isFriend(playerUuid);
        OnlineIndicator.drawDiamond(matrixStack, 5, x + 1, y + 2, isFriend ? FRIEND_BLUE.getRGB() : Color.GREEN.getRGB());
        matrixStack.pop();
    }

    public static void drawDiamond(UMatrixStack matrixStack, int faceSize, float xCenter, float yCenter, int color) {
        float left2 = xCenter - (float)faceSize;
        float top = yCenter - (float)faceSize;
        BlendState prevBlendState = BlendState.active();
        BlendState.NORMAL.activate();
        double d = 0.5;
        int alpha = color >> 24 & 0xFF;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        UGraphics buffer = UGraphics.getFromTessellator();
        buffer.beginWithDefaultShader(UGraphics.DrawMode.QUADS, class_290.field_1576);
        for (float x = left2; x < xCenter + (float)faceSize; x += 1.0f) {
            for (float y = top; y < yCenter + (float)faceSize; y += 1.0f) {
                if (!(Math.abs(x - xCenter) + Math.abs(y - yCenter) < (float)(1 + faceSize / 2))) continue;
                buffer.pos(matrixStack, (double)x - d, (double)y - d, 0.0).color(red, green, blue, alpha).endVertex();
                buffer.pos(matrixStack, (double)x - d, (double)y + d, 0.0).color(red, green, blue, alpha).endVertex();
                buffer.pos(matrixStack, (double)x + d, (double)y + d, 0.0).color(red, green, blue, alpha).endVertex();
                buffer.pos(matrixStack, (double)x + d, (double)y - d, 0.0).color(red, green, blue, alpha).endVertex();
            }
        }
        buffer.drawDirect();
        prevBlendState.activate();
    }

    static {
        STANDARD_GREEN = new Color(43, 198, 84);
        FRIEND_BLUE = new Color(18, 154, 255);
    }
}

