/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.handlers;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.InsecureTextureException;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.authlib.yggdrasil.ServicesKeyInfo;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import gg.essential.api.utils.JsonHolder;
import gg.essential.network.connectionmanager.subscription.SubscriptionManager;
import gg.essential.util.ExtensionsKt;
import gg.essential.util.UUIDUtil;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.security.PublicKey;
import java.security.Signature;
import java.util.Base64;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;
import sun.misc.Unsafe;

public class GameProfileManager
implements SubscriptionManager.Listener {
    public static final String SKIN_URL = "https://textures.minecraft.net/texture/%s";
    private final Map<UUID, Overwrites> uuidToOverwrites = new ConcurrentHashMap<UUID, Overwrites>();

    public GameProfile handleGameProfile(GameProfile profile) {
        Overwrites overwrites = this.uuidToOverwrites.get(profile.getId());
        if (overwrites == null) {
            return null;
        }
        Property property = profile.getProperties().get((Object)"textures").stream().findFirst().orElse(null);
        if (property == null || ManagedTexturesProperty.hasOverwrites(property, overwrites)) {
            return null;
        }
        return overwrites.apply(profile);
    }

    public void updatePlayerSkin(UUID uuid, String hash, String type2) {
        this.updatePlayerSkin(uuid, new Overwrites(hash, type2));
    }

    private void updatePlayerSkin(UUID uuid, Overwrites overwrites) {
        this.uuidToOverwrites.put(uuid, overwrites);
    }

    @Override
    public void onSubscriptionRemoved(@NotNull Set<UUID> uuids) {
        for (UUID uuid : uuids) {
            this.uuidToOverwrites.remove(uuid);
        }
    }

    public static void updatePropertyMap(PropertyMap profileProperties, Property property) {
        profileProperties.removeAll((Object)"textures");
        profileProperties.put((Object)"textures", (Object)property);
    }

    public static String getSafeTexturesValue(GameProfile profile) {
        Iterator textures;
        class_310 mc = class_310.method_1551();
        PropertyMap properties2 = null;
        try {
            if (!mc.method_1495().getTextures(profile, true).isEmpty()) {
                properties2 = profile.getProperties();
            }
        }
        catch (InsecureTextureException insecureTextureException) {
            // empty catch block
        }
        if (properties2 == null && UUIDUtil.getClientUUID().equals(profile.getId())) {
            properties2 = mc.method_1539();
        }
        if (properties2 != null && (textures = properties2.get((Object)"textures").iterator()).hasNext()) {
            return ((Property)textures.next()).getValue();
        }
        return "e30=";
    }

    public static void register(YggdrasilAuthenticationService authenticationService) throws ReflectiveOperationException {
        Field theUnsafeField = Unsafe.class.getDeclaredField("theUnsafe");
        theUnsafeField.setAccessible(true);
        Unsafe unsafe = (Unsafe)theUnsafeField.get(null);
        Field servicesKeyField = YggdrasilAuthenticationService.class.getDeclaredField("servicesKey");
        long servicesKeyOffset = unsafe.objectFieldOffset(servicesKeyField);
        ServicesKeyInfo originalKey = (ServicesKeyInfo)unsafe.getObject(authenticationService, servicesKeyOffset);
        TrustingServicesKeyInfo wrapperKey = new TrustingServicesKeyInfo(originalKey);
        unsafe.putObject(authenticationService, servicesKeyOffset, wrapperKey);
    }

    public static class Overwrites {
        private final String skinHash;
        private final String skinType;

        public Overwrites(String skinHash, String skinType) {
            this.skinHash = skinHash;
            this.skinType = skinType;
        }

        public String apply(String originalValue, UUID id2) {
            JsonHolder root = new JsonHolder(new String(Base64.getDecoder().decode(originalValue)));
            if (!root.optString("profileId").isEmpty() && !id2.equals(UUIDUtil.formatWithDashes(root.optString("profileId")))) {
                return originalValue;
            }
            JsonHolder textures = root.optOrCreateJsonHolder("textures");
            if (this.skinHash != null || this.skinType != null) {
                String url;
                JsonHolder skin = textures.optOrCreateJsonHolder("SKIN");
                if (this.skinHash != null && !(url = skin.optString("url")).endsWith(this.skinHash)) {
                    skin.put("url", String.format(GameProfileManager.SKIN_URL, this.skinHash));
                }
                if (this.skinType != null) {
                    if (this.skinType.equals("default")) {
                        skin.remove("metadata");
                    } else {
                        skin.optOrCreateJsonHolder("metadata").put("model", this.skinType);
                    }
                }
            }
            return Base64.getEncoder().encodeToString(root.toString().getBytes(StandardCharsets.UTF_8));
        }

        public GameProfile apply(GameProfile originalProfile) {
            GameProfile updatedProfile = ExtensionsKt.copy(originalProfile);
            GameProfileManager.updatePropertyMap(updatedProfile.getProperties(), new ManagedTexturesProperty(originalProfile, this));
            return updatedProfile;
        }
    }

    private static class ManagedTexturesProperty
    extends TrustedProperty {
        private final Overwrites overwrites;

        private ManagedTexturesProperty(GameProfile originalProfile, Overwrites overwrites) {
            super("textures", overwrites.apply(GameProfileManager.getSafeTexturesValue(originalProfile), originalProfile.getId()));
            this.overwrites = overwrites;
        }

        public static boolean hasOverwrites(Property property, Overwrites overwrites) {
            return property instanceof ManagedTexturesProperty && ((ManagedTexturesProperty)property).overwrites == overwrites;
        }
    }

    private record TrustingServicesKeyInfo(ServicesKeyInfo inner) implements ServicesKeyInfo
    {
        public int keyBitCount() {
            return this.inner.keyBitCount();
        }

        public int signatureBitCount() {
            return this.inner.signatureBitCount();
        }

        public Signature signature() {
            return this.inner.signature();
        }

        public boolean validateProperty(Property property) {
            return property instanceof TrustedProperty || this.inner.validateProperty(property);
        }
    }

    private static class TrustedProperty
    extends Property {
        public TrustedProperty(String name, String value2) {
            super(name, value2, "trusted");
        }

        public boolean isSignatureValid(PublicKey publicKey) {
            return true;
        }
    }
}

