/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.handlers;

import com.google.gson.JsonObject;
import com.mojang.authlib.properties.Property;
import gg.essential.api.utils.JsonHolder;
import gg.essential.api.utils.mojang.Model;
import gg.essential.api.utils.mojang.SkinResponse;
import gg.essential.gui.notification.Notifications;
import gg.essential.handlers.GameProfileManager;
import gg.essential.util.MojangAPI;
import gg.essential.util.Skin;
import gg.essential.util.UUIDUtil;
import gg.essential.util.WebUtil;
import java.io.File;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BooleanSupplier;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EssentialSkinManager {
    public static final String SESSION_URL = "https://sessionserver.mojang.com/session/minecraft/profile/%s?unsigned=false";
    private final GameProfileManager gameProfileManager;
    private final BooleanSupplier delayChanges;
    private SkinUpdate queuedSkinChange;
    @NotNull
    private Skin activeSkin;

    public EssentialSkinManager(GameProfileManager gameProfileManager, BooleanSupplier delayChanges) {
        this.gameProfileManager = gameProfileManager;
        this.delayChanges = delayChanges;
        this.activeSkin = class_310.method_1551().method_1539().get((Object)"textures").stream().findFirst().map(Skin::fromProperty).orElse(new Skin("", Model.STEVE));
    }

    @NotNull
    public Skin getActiveSkin() {
        return this.activeSkin;
    }

    @Nullable
    public synchronized Skin fetchActiveSkin() {
        Property textures = EssentialSkinManager.getTextureProperty(UUIDUtil.getClientUUID());
        if (textures == null) {
            return null;
        }
        this.activeSkin = Skin.fromProperty(textures);
        return this.activeSkin;
    }

    @Nullable
    public static Property getTextureProperty(UUID uuid) {
        JsonHolder jsonHolder = WebUtil.fetchJSON(String.format(SESSION_URL, uuid.toString().replace("-", "")));
        if (jsonHolder.getKeys().isEmpty()) {
            return null;
        }
        JsonObject properties2 = jsonHolder.optJSONArray("properties").get(0).getAsJsonObject();
        return new Property("textures", properties2.get("value").getAsString(), properties2.get("signature").getAsString());
    }

    @Nullable
    public Skin uploadSkin(String accessToken, Model model, File file) {
        this.queuedSkinChange = new SkinUpload(accessToken, model, file);
        return this.updateSkinNow(true, true);
    }

    public void changeSkin(String accessToken, Model model, String url) {
        this.queuedSkinChange = new SkinChange(accessToken, model, url);
        if (this.delayChanges.getAsBoolean()) {
            return;
        }
        this.updateSkinNow(false, false);
    }

    public void flushChanges() {
        this.updateSkinNow(true, false);
    }

    @Nullable
    private synchronized Skin updateSkinNow(boolean notification, boolean userSet) {
        SkinUpdate queuedSkinChange = this.queuedSkinChange;
        this.queuedSkinChange = null;
        if (queuedSkinChange == null) {
            return null;
        }
        if (queuedSkinChange.matches(this.activeSkin)) {
            return null;
        }
        SkinResponse updateSkinWithMojang = queuedSkinChange.execute();
        Optional<Skin> maybeSkin = Optional.ofNullable(updateSkinWithMojang).flatMap(response2 -> Optional.ofNullable(response2.getSkins())).flatMap(skins -> skins.stream().filter(it -> "ACTIVE".equals(it.getState())).findFirst()).map(Skin::fromApi);
        if (maybeSkin.isPresent()) {
            Skin skin = maybeSkin.get();
            this.gameProfileManager.updatePlayerSkin(UUIDUtil.getClientUUID(), skin.getHash(), skin.getModel().getType());
            this.activeSkin = skin;
            if (notification) {
                Notifications.INSTANCE.push("Skin", "Skin updated successfully");
            }
            return skin;
        }
        if (notification) {
            Notifications.INSTANCE.push("Skin", "Failed to upload skin, please try again");
        }
        return null;
    }

    private static class SkinUpload
    extends SkinUpdate {
        private final File file;

        protected SkinUpload(String accessToken, Model model, File file) {
            super(accessToken, model);
            this.file = file;
        }

        @Override
        public boolean matches(Skin activeSkin) {
            return false;
        }

        @Override
        public SkinResponse execute() {
            return MojangAPI.INSTANCE.uploadSkin(this.accessToken, this.model, this.file);
        }
    }

    private static abstract class SkinUpdate {
        protected final String accessToken;
        protected final Model model;

        protected SkinUpdate(String accessToken, Model model) {
            this.accessToken = accessToken;
            this.model = model;
        }

        public abstract boolean matches(Skin var1);

        public abstract SkinResponse execute();
    }

    private static class SkinChange
    extends SkinUpdate {
        private final String url;

        protected SkinChange(String accessToken, Model model, String url) {
            super(accessToken, model);
            this.url = url;
        }

        @Override
        public boolean matches(Skin activeSkin) {
            return activeSkin.getHash().equals(Skin.hashFromUrl(this.url)) && activeSkin.getModel() == this.model;
        }

        @Override
        public SkinResponse execute() {
            return MojangAPI.INSTANCE.changeSkin(this.accessToken, UUIDUtil.getClientUUID(), this.model, this.url);
        }
    }
}

