/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.handlers;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public class CertChain {
    private final CertificateFactory cf = CertificateFactory.getInstance("X.509");
    private final KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());

    public CertChain() throws Exception {
        Path ksPath = Paths.get(System.getProperty("java.home"), "lib", "security", "cacerts");
        this.keyStore.load(Files.newInputStream(ksPath, new OpenOption[0]), null);
    }

    public CertChain load(String filename) throws Exception {
        try (InputStream cert = CertChain.class.getResourceAsStream("/assets/essential/certs/" + filename + ".der");){
            BufferedInputStream caInput = new BufferedInputStream(cert);
            Certificate crt = this.cf.generateCertificate(caInput);
            this.keyStore.setCertificateEntry(filename, crt);
        }
        return this;
    }

    public SSLContext done() throws Exception {
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(this.keyStore);
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, tmf.getTrustManagers(), null);
        return sslContext;
    }
}

