/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.multiplayer;

import gg.essential.Essential;
import gg.essential.config.EssentialConfig;
import gg.essential.connectionmanager.common.enums.ActivityType;
import gg.essential.elementa.components.UIImage;
import gg.essential.elementa.utils.ExtensionsKt;
import gg.essential.network.connectionmanager.ConnectionManager;
import gg.essential.network.connectionmanager.social.SocialManager;
import gg.essential.serverdiscovery.model.ServerDiscovery;
import gg.essential.universal.UMatrixStack;
import gg.essential.util.CachedAvatarImage;
import gg.essential.util.UUIDUtil;
import gg.essential.vigilance.gui.VigilancePalette;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_642;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010(\u001a\u00020'\u00a2\u0006\u0004\b,\u0010-J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006JG\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0015\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0006R\u0019\u0010\u0019\u001a\u00070\u0017\u00a2\u0006\u0002\b\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\u001b\u0010\u001d\u001a\t\u0018\u00010\u001b\u00a2\u0006\u0002\b\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR5\u0010#\u001a \u0012\u0004\u0012\u00020\u0002\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020!\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\"0 0\u001f8\u0006\u00a2\u0006\f\n\u0004\b#\u0010$\u001a\u0004\b%\u0010&R\u0017\u0010(\u001a\u00020'8\u0006\u00a2\u0006\f\n\u0004\b(\u0010)\u001a\u0004\b*\u0010+\u00a8\u0006."}, d2={"Lgg/essential/gui/multiplayer/FriendsIndicator;", "", "Ljava/util/UUID;", "uuid", "", "addIcon", "(Ljava/util/UUID;)V", "Lgg/essential/universal/UMatrixStack;", "matrixStack", "", "x", "y", "listWidth", "mouseX", "mouseY", "populationInfoText", "", "draw", "(Lgg/essential/universal/UMatrixStack;IIIIII)Ljava/lang/String;", "", "isPlayingOnServer", "(Ljava/util/UUID;)Z", "updatePlayerStatus", "Lgg/essential/network/connectionmanager/ConnectionManager;", "Lorg/jetbrains/annotations/NotNull;", "connectionManager", "Lgg/essential/network/connectionmanager/ConnectionManager;", "Lgg/essential/serverdiscovery/model/ServerDiscovery;", "Lorg/jetbrains/annotations/Nullable;", "discoveryServer", "Lgg/essential/serverdiscovery/model/ServerDiscovery;", "", "Lkotlin/Pair;", "Lgg/essential/elementa/components/UIImage;", "Ljava/util/concurrent/CompletableFuture;", "friendsOnServer", "Ljava/util/Map;", "getFriendsOnServer", "()Ljava/util/Map;", "Lnet/minecraft/class_642;", "server", "Lnet/minecraft/class_642;", "getServer", "()Lnet/minecraft/class_642;", "<init>", "(Lnet/minecraft/class_642;)V", "Essential 1.19-fabric"})
public final class FriendsIndicator {
    @NotNull
    private final class_642 server;
    @NotNull
    private final ConnectionManager connectionManager;
    @Nullable
    private final ServerDiscovery discoveryServer;
    @NotNull
    private final Map<UUID, Pair<UIImage, CompletableFuture<String>>> friendsOnServer;

    public FriendsIndicator(@NotNull class_642 server) {
        Intrinsics.checkNotNullParameter(server, "server");
        this.server = server;
        ConnectionManager connectionManager = Essential.getInstance().getConnectionManager();
        Intrinsics.checkNotNullExpressionValue(connectionManager, "getInstance().connectionManager");
        this.connectionManager = connectionManager;
        this.discoveryServer = this.connectionManager.getServerDiscoveryManager().findServerByAddress(this.server.field_3761);
        this.friendsOnServer = new LinkedHashMap();
        Iterable $this$forEach$iv = this.connectionManager.getRelationshipManager().getFriends().keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UUID it = (UUID)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(it, "it");
            if (!this.isPlayingOnServer(it)) continue;
            this.addIcon(it);
        }
    }

    @NotNull
    public final class_642 getServer() {
        return this.server;
    }

    @NotNull
    public final Map<UUID, Pair<UIImage, CompletableFuture<String>>> getFriendsOnServer() {
        return this.friendsOnServer;
    }

    private final boolean isPlayingOnServer(UUID uuid) {
        org.apache.commons.lang3.tuple.Pair pair = this.connectionManager.getProfileManager().getActivity(uuid).orElse(null);
        if (pair == null) {
            return false;
        }
        org.apache.commons.lang3.tuple.Pair pair2 = pair;
        ActivityType activity = (ActivityType)((Object)((Map.Entry)pair2).getKey());
        String metadata2 = (String)((Map.Entry)pair2).getValue();
        if (activity != ActivityType.PLAYING) {
            return false;
        }
        if (Intrinsics.areEqual(metadata2, this.server.field_3761)) {
            return true;
        }
        return this.discoveryServer != null && Intrinsics.areEqual(this.discoveryServer, this.connectionManager.getServerDiscoveryManager().findServerByAddress(metadata2));
    }

    private final void addIcon(UUID uuid) {
        Map<UUID, Pair<UIImage, CompletableFuture<String>>> map2 = this.friendsOnServer;
        Pair<UIImage, CompletableFuture<String>> pair = TuplesKt.to(CachedAvatarImage.ofUUID(uuid), UUIDUtil.getName(uuid));
        map2.put(uuid, pair);
    }

    public final void updatePlayerStatus(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        if (this.isPlayingOnServer(uuid)) {
            if (!this.friendsOnServer.containsKey(uuid)) {
                this.addIcon(uuid);
            }
        } else {
            this.friendsOnServer.remove(uuid);
        }
    }

    @Nullable
    public final String draw(@NotNull UMatrixStack matrixStack, int x, int y, int listWidth, int mouseX, int mouseY, int populationInfoText) {
        Intrinsics.checkNotNullParameter(matrixStack, "matrixStack");
        if (!EssentialConfig.INSTANCE.getEssentialFull()) {
            return null;
        }
        double i = 0.0;
        i = 2.6;
        String tooltip2 = null;
        Iterable $this$forEach$iv = this.friendsOnServer.entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry $dstr$uuid$pair = (Map.Entry)element$iv;
            boolean bl = false;
            UUID uuid = (UUID)$dstr$uuid$pair.getKey();
            Pair pair = (Pair)$dstr$uuid$pair.getValue();
            UIImage image2 = (UIImage)pair.getFirst();
            CompletableFuture nameFuture = (CompletableFuture)pair.getSecond();
            double nx = (double)(x + listWidth - populationInfoText) - i * 11.0;
            double d = nx + (double)8;
            double d2 = mouseX;
            boolean bl2 = nx <= d2 ? d2 <= d : false;
            if (bl2) {
                boolean bl3 = y <= mouseY ? mouseY <= y + 8 : false;
                if (bl3) {
                    String string = nameFuture.getNow("Loading username\u2026");
                    Intrinsics.checkNotNullExpressionValue(string, "nameFuture.getNow(\"Loading username\u2026\")");
                    Object name = string;
                    if (nameFuture.isDone()) {
                        SocialManager socialManager = Essential.getInstance().getConnectionManager().getSocialManager();
                        Intrinsics.checkNotNullExpressionValue(socialManager, "getInstance().connectionManager.socialManager");
                        SocialManager socialManager2 = socialManager;
                        Optional<String> optional = socialManager2.getIncomingServerInvite(uuid);
                        Intrinsics.checkNotNullExpressionValue(optional, "socialManager.getIncomingServerInvite(uuid)");
                        Optional<String> incomingServerInvite = optional;
                        if (incomingServerInvite.isPresent() && this.getServer().field_3761.equals(incomingServerInvite.get())) {
                            name = (String)name + " (Invite)";
                        }
                    }
                    tooltip2 = name;
                }
            }
            image2.drawImage(matrixStack, ExtensionsKt.roundToRealPixels(nx), ExtensionsKt.roundToRealPixels((double)y + 0.5), 8.0, 8.0, VigilancePalette.INSTANCE.getBrightText());
            d = i;
            i = d + 1.0;
        }
        return tooltip2;
    }
}

