/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.common;

import gg.essential.elementa.UIComponent;
import gg.essential.elementa.UIConstraints;
import gg.essential.elementa.components.UIImage;
import gg.essential.elementa.dsl.UtilitiesKt;
import gg.essential.elementa.state.BasicState;
import gg.essential.gui.common.StateExtensionsKt;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0015\u001a\u00020\u0014\u0012\u0006\u0010\u000f\u001a\u00020\u0002\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0004\b\u001e\u0010\u001fR\u0016\u0010\u0003\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0004R\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\tR\u0017\u0010\u000b\u001a\u00020\n8\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0004\u001a\u0004\b\u0010\u0010\u0011R\u001d\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0007\u001a\u0004\b\u0013\u0010\tR\u0017\u0010\u0015\u001a\u00020\u00148\u0006\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\u001a\u001a\u00020\u00198\u0006\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006 "}, d2={"Lgg/essential/gui/common/SequenceAnimatedUIImage;", "Lgg/essential/elementa/UIComponent;", "", "activeTimer", "I", "Lgg/essential/elementa/state/BasicState;", "currentFrame", "Lgg/essential/elementa/state/BasicState;", "getCurrentFrame", "()Lgg/essential/elementa/state/BasicState;", "", "delay", "J", "getDelay", "()J", "frameCount", "getFrameCount", "()I", "frameDelay", "getFrameDelay", "", "location", "Ljava/lang/String;", "getLocation", "()Ljava/lang/String;", "Ljava/util/concurrent/TimeUnit;", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "getTimeUnit", "()Ljava/util/concurrent/TimeUnit;", "<init>", "(Ljava/lang/String;IJLjava/util/concurrent/TimeUnit;)V", "Essential 1.19-fabric"})
public final class SequenceAnimatedUIImage
extends UIComponent {
    @NotNull
    private final String location;
    private final int frameCount;
    private final long delay;
    @NotNull
    private final TimeUnit timeUnit;
    @NotNull
    private final BasicState<Integer> currentFrame;
    @NotNull
    private final BasicState<Long> frameDelay;
    private int activeTimer;

    /*
     * WARNING - void declaration
     */
    public SequenceAnimatedUIImage(@NotNull String location, int frameCount, long delay2, @NotNull TimeUnit timeUnit) {
        Intrinsics.checkNotNullParameter(location, "location");
        Intrinsics.checkNotNullParameter((Object)timeUnit, "timeUnit");
        this.location = location;
        this.frameCount = frameCount;
        this.delay = delay2;
        this.timeUnit = timeUnit;
        this.currentFrame = new BasicState<Integer>(0);
        this.frameDelay = new BasicState<Long>(1L);
        this.activeTimer = -1;
        int n = 0;
        int n2 = this.frameCount;
        UIImage[] uIImageArray = new UIImage[n2];
        while (n < n2) {
            void $this$_init__u24lambda_u2d0;
            int n3 = n++;
            Object[] objectArray = new Object[]{n3 + 1};
            Object object = String.format(this.location, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(object, "format(this, *args)");
            UIComponent $this$constrain$iv = UIImage.Companion.ofResourceCached((String)object);
            boolean $i$f$constrain = false;
            Object $this$constrain_u24lambda_u2d0$iv = object = $this$constrain$iv;
            boolean bl = false;
            UIConstraints uIConstraints = ((UIComponent)$this$constrain_u24lambda_u2d0$iv).getConstraints();
            int n4 = n3;
            UIImage[] uIImageArray2 = uIImageArray;
            boolean bl2 = false;
            $this$_init__u24lambda_u2d0.setWidth(UtilitiesKt.percent(100));
            $this$_init__u24lambda_u2d0.setHeight(UtilitiesKt.percent(100));
            Unit unit = Unit.INSTANCE;
            uIImageArray2[n4] = (UIImage)object;
        }
        final UIImage[] frames = uIImageArray;
        StateExtensionsKt.onSetValueAndNow(this.currentFrame, (Function1)new Function1<Integer, Unit>(){

            @Override
            public final void invoke(int it) {
                this.clearChildren();
                this.addChild(frames[it]);
            }
        });
        this.frameDelay.onSetValue(new Function1<Long, Unit>(){

            @Override
            public final void invoke(long it) {
                if (activeTimer != -1) {
                    this.stopTimer(activeTimer);
                }
                activeTimer = this.startTimer(it, 0L, (Function1<? super Integer, Unit>)new Function1<Integer, Unit>(){

                    @Override
                    public final void invoke(int it) {
                        this.getCurrentFrame().set((Integer)((Object)new Function1<Integer, Integer>(){

                            @Override
                            @NotNull
                            public final Integer invoke(int current) {
                                return (1 + current + this.getFrameCount()) % this.getFrameCount();
                            }
                        }));
                    }
                });
            }
        });
        this.frameDelay.set(this.timeUnit.toMillis(this.delay));
    }

    @NotNull
    public final String getLocation() {
        return this.location;
    }

    public final int getFrameCount() {
        return this.frameCount;
    }

    public final long getDelay() {
        return this.delay;
    }

    @NotNull
    public final TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    @NotNull
    public final BasicState<Integer> getCurrentFrame() {
        return this.currentFrame;
    }

    @NotNull
    public final BasicState<Long> getFrameDelay() {
        return this.frameDelay;
    }
}

