/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.account.factory;

import com.google.gson.Gson;
import com.mojang.authlib.Agent;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.UserAuthentication;
import com.mojang.authlib.exceptions.InvalidCredentialsException;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import gg.essential.Essential;
import gg.essential.gui.account.factory.ManagedSessionFactory;
import gg.essential.universal.UMinecraft;
import gg.essential.util.ExtensionsKt;
import gg.essential.util.UUIDUtil;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import net.minecraft.class_320;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0002'(B\u000f\u0012\u0006\u0010\u001c\u001a\u00020\u0012\u00a2\u0006\u0004\b%\u0010&J\u001d\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001f\u0010\u000b\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0014\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0017\u001a\u00020\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R\u0014\u0010\u001a\u001a\u00020\u00198\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR \u0010!\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00050\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u001c\u0010#\u001a\n \u0013*\u0004\u0018\u00010\"0\"8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010$\u00a8\u0006)"}, d2={"Lgg/essential/gui/account/factory/MojangAccountSessionFactory;", "Lgg/essential/gui/account/factory/ManagedSessionFactory;", "", "username", "password", "Lnet/minecraft/class_320;", "login", "(Ljava/lang/String;Ljava/lang/String;)Lnet/minecraft/class_320;", "session", "", "force", "refresh", "(Lnet/minecraft/class_320;Z)Lnet/minecraft/class_320;", "Ljava/util/UUID;", "uuid", "", "remove", "(Ljava/util/UUID;)V", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "save", "()Ljava/nio/file/Path;", "Lcom/mojang/authlib/yggdrasil/YggdrasilAuthenticationService;", "authService", "Lcom/mojang/authlib/yggdrasil/YggdrasilAuthenticationService;", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "savePath", "Ljava/nio/file/Path;", "", "getSessions", "()Ljava/util/Map;", "sessions", "Lgg/essential/gui/account/factory/MojangAccountSessionFactory$State;", "state", "Lgg/essential/gui/account/factory/MojangAccountSessionFactory$State;", "<init>", "(Ljava/nio/file/Path;)V", "MojangAccount", "State", "Essential 1.19-fabric"})
public final class MojangAccountSessionFactory
implements ManagedSessionFactory {
    @NotNull
    private final Path savePath;
    @NotNull
    private final ReentrantReadWriteLock lock;
    private final State state;
    @NotNull
    private final YggdrasilAuthenticationService authService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MojangAccountSessionFactory(@NotNull Path savePath) {
        State state;
        Intrinsics.checkNotNullParameter(savePath, "savePath");
        this.savePath = savePath;
        this.lock = new ReentrantReadWriteLock();
        MojangAccountSessionFactory mojangAccountSessionFactory = this;
        if (Files.exists(this.savePath, new LinkOption[0])) {
            State state2;
            Closeable closeable = Files.newBufferedReader(this.savePath);
            MojangAccountSessionFactory mojangAccountSessionFactory2 = mojangAccountSessionFactory;
            Throwable throwable = null;
            try {
                BufferedReader it = (BufferedReader)closeable;
                boolean bl = false;
                state2 = (State)new Gson().fromJson((Reader)it, State.class);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
            state = state2;
            mojangAccountSessionFactory = mojangAccountSessionFactory2;
        } else {
            UUID uUID = UUID.randomUUID();
            Intrinsics.checkNotNullExpressionValue(uUID, "randomUUID()");
            State state3 = new State(ExtensionsKt.toDashlessString(uUID), new ArrayList());
            state = state3;
        }
        mojangAccountSessionFactory.state = state;
        this.authService = new YggdrasilAuthenticationService(UMinecraft.getMinecraft().method_1487(), this.state.getClientToken());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Path save() {
        Path path;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2++;
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            String string = new Gson().toJson((Object)this.state);
            Intrinsics.checkNotNullExpressionValue(string, "Gson().toJson(state)");
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue(byArray, "this as java.lang.String).getBytes(charset)");
            path = Files.write(this.savePath, byArray, new OpenOption[0]);
        }
        finally {
            int n4 = 0;
            while (n4 < n) {
                int n5 = n4++;
                readLock.lock();
            }
            writeLock.unlock();
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2++;
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            MojangAccount mojangAccount;
            Object v0;
            block10: {
                boolean bl = false;
                for (Object t : (Iterable)this.state.getAccounts()) {
                    MojangAccount it = (MojangAccount)t;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(it.getUuid(), uuid)) continue;
                    v0 = t;
                    break block10;
                }
                v0 = null;
            }
            if ((MojangAccount)v0 == null) {
                return;
            }
            MojangAccount account = mojangAccount;
            this.state.getAccounts().remove(account);
            this.save();
            try {
                UserAuthentication userAuthService = this.authService.createUserAuthentication(Agent.MINECRAFT);
                userAuthService.loadFromStorage(account.getStorage());
                userAuthService.logOut();
            }
            catch (Exception e) {
                Essential.logger.warn("Failed to log out " + account.getName() + ":", (Throwable)e);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            int n4 = 0;
            while (n4 < n) {
                int n5 = n4++;
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final class_320 login(@NotNull String username, @NotNull String password) {
        class_320 class_3202;
        Intrinsics.checkNotNullParameter(username, "username");
        Intrinsics.checkNotNullParameter(password, "password");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2++;
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            UserAuthentication userAuthService = this.authService.createUserAuthentication(Agent.MINECRAFT);
            userAuthService.setUsername(username);
            userAuthService.setPassword(password);
            userAuthService.logIn();
            GameProfile gameProfile = userAuthService.getSelectedProfile();
            Intrinsics.checkNotNull(gameProfile);
            GameProfile profile = gameProfile;
            Object object = profile.getId();
            Intrinsics.checkNotNullExpressionValue(object, "profile.id");
            UUID uUID = object;
            object = profile.getName();
            Intrinsics.checkNotNullExpressionValue(object, "profile.name");
            Object object2 = object;
            object = userAuthService.getAuthenticatedToken();
            Intrinsics.checkNotNullExpressionValue(object, "userAuthService.authenticatedToken");
            Object object3 = object;
            object = userAuthService.saveForStorage();
            Intrinsics.checkNotNullExpressionValue(object, "userAuthService.saveForStorage()");
            MojangAccount account = new MojangAccount(uUID, (String)object2, (String)object3, (Map<String, ? extends Object>)object);
            this.state.getAccounts().removeIf(arg_0 -> MojangAccountSessionFactory.login$lambda-5$lambda-4(profile, arg_0));
            this.state.getAccounts().add(account);
            this.save();
            class_3202 = account.toSession();
        }
        finally {
            int n4 = 0;
            while (n4 < n) {
                int n5 = n4++;
                readLock.lock();
            }
            writeLock.unlock();
        }
        return class_3202;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public class_320 refresh(@NotNull class_320 session, boolean force) {
        class_320 class_3202;
        Intrinsics.checkNotNullParameter(session, "session");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2++;
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            Object v0;
            block7: {
                boolean bl = false;
                UUID uuid = UUIDUtil.formatWithDashes(session.method_1673());
                for (Object t : (Iterable)this.state.getAccounts()) {
                    MojangAccount it = (MojangAccount)t;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(it.getUuid(), uuid)) continue;
                    v0 = t;
                    break block7;
                }
                v0 = null;
            }
            MojangAccount mojangAccount = v0;
            if (mojangAccount == null) {
                throw new InvalidCredentialsException();
            }
            MojangAccount account = mojangAccount;
            UserAuthentication userAuthService = this.authService.createUserAuthentication(Agent.MINECRAFT);
            userAuthService.loadFromStorage(account.getStorage());
            userAuthService.logIn();
            GameProfile gameProfile = userAuthService.getSelectedProfile();
            Intrinsics.checkNotNull(gameProfile);
            GameProfile profile = gameProfile;
            Object object = profile.getName();
            Intrinsics.checkNotNullExpressionValue(object, "profile.name");
            account.setName((String)object);
            object = userAuthService.getAuthenticatedToken();
            Intrinsics.checkNotNullExpressionValue(object, "userAuthService.authenticatedToken");
            account.setAccessToken((String)object);
            object = userAuthService.saveForStorage();
            Intrinsics.checkNotNullExpressionValue(object, "userAuthService.saveForStorage()");
            account.setStorage((Map<String, ? extends Object>)object);
            this.save();
            class_3202 = account.toSession();
        }
        finally {
            int n4 = 0;
            while (n4 < n) {
                int n5 = n4++;
                readLock.lock();
            }
            writeLock.unlock();
        }
        return class_3202;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<UUID, class_320> getSessions() {
        Map map2;
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            void $this$associateTo$iv$iv;
            boolean bl = false;
            Iterable $this$associate$iv = this.state.getAccounts();
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map3 = destination$iv$iv;
                MojangAccount it = (MojangAccount)element$iv$iv;
                boolean bl2 = false;
                Pair<UUID, class_320> pair = TuplesKt.to(it.getUuid(), it.toSession());
                map3.put(pair.getFirst(), pair.getSecond());
            }
            map2 = destination$iv$iv;
        }
        finally {
            readLock.unlock();
        }
        return map2;
    }

    private static final boolean login$lambda-5$lambda-4(GameProfile $profile, MojangAccount it) {
        Intrinsics.checkNotNullParameter($profile, "$profile");
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it.getUuid(), $profile.getId());
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\t\u001a\u00020\u0002\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0010\u0010\u0003\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ*\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\t\u001a\u00020\u00022\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001a\u0010\u000f\u001a\u00020\u000e2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0012\u001a\u00020\u0011H\u00d6\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0004R\u001d\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\u0015\u001a\u0004\b\u0016\u0010\bR\u0017\u0010\t\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u0017\u001a\u0004\b\u0018\u0010\u0004\u00a8\u0006\u001b"}, d2={"Lgg/essential/gui/account/factory/MojangAccountSessionFactory$State;", "", "", "component1", "()Ljava/lang/String;", "", "Lgg/essential/gui/account/factory/MojangAccountSessionFactory$MojangAccount;", "component2", "()Ljava/util/List;", "clientToken", "accounts", "copy", "(Ljava/lang/String;Ljava/util/List;)Lgg/essential/gui/account/factory/MojangAccountSessionFactory$State;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "Ljava/util/List;", "getAccounts", "Ljava/lang/String;", "getClientToken", "<init>", "(Ljava/lang/String;Ljava/util/List;)V", "Essential 1.19-fabric"})
    private static final class State {
        @NotNull
        private final String clientToken;
        @NotNull
        private final List<MojangAccount> accounts;

        public State(@NotNull String clientToken, @NotNull List<MojangAccount> accounts) {
            Intrinsics.checkNotNullParameter(clientToken, "clientToken");
            Intrinsics.checkNotNullParameter(accounts, "accounts");
            this.clientToken = clientToken;
            this.accounts = accounts;
        }

        @NotNull
        public final String getClientToken() {
            return this.clientToken;
        }

        @NotNull
        public final List<MojangAccount> getAccounts() {
            return this.accounts;
        }

        @NotNull
        public final String component1() {
            return this.clientToken;
        }

        @NotNull
        public final List<MojangAccount> component2() {
            return this.accounts;
        }

        @NotNull
        public final State copy(@NotNull String clientToken, @NotNull List<MojangAccount> accounts) {
            Intrinsics.checkNotNullParameter(clientToken, "clientToken");
            Intrinsics.checkNotNullParameter(accounts, "accounts");
            return new State(clientToken, accounts);
        }

        public static /* synthetic */ State copy$default(State state, String string, List list, int n, Object object) {
            if ((n & 1) != 0) {
                string = state.clientToken;
            }
            if ((n & 2) != 0) {
                list = state.accounts;
            }
            return state.copy(string, list);
        }

        @NotNull
        public String toString() {
            return "State(clientToken=" + this.clientToken + ", accounts=" + this.accounts + ")";
        }

        public int hashCode() {
            int result2 = this.clientToken.hashCode();
            result2 = result2 * 31 + ((Object)this.accounts).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof State)) {
                return false;
            }
            State state = (State)other;
            if (!Intrinsics.areEqual(this.clientToken, state.clientToken)) {
                return false;
            }
            return Intrinsics.areEqual(this.accounts, state.accounts);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\b\u0082\b\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\f\u001a\u00020\u0002\u0012\u0006\u0010\r\u001a\u00020\u0005\u0012\u0006\u0010\u000e\u001a\u00020\u0005\u0012\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\t\u00a2\u0006\u0004\b)\u0010*J\u0010\u0010\u0003\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0006\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\b\u0010\u0007J\u001c\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\tH\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJD\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\f\u001a\u00020\u00022\b\b\u0002\u0010\r\u001a\u00020\u00052\b\b\u0002\u0010\u000e\u001a\u00020\u00052\u0014\b\u0002\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\tH\u00c6\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001a\u0010\u0014\u001a\u00020\u00132\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0010\u0010\u0017\u001a\u00020\u0016H\u00d6\u0001\u00a2\u0006\u0004\b\u0017\u0010\u0018J\r\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0010\u0010\u001c\u001a\u00020\u0005H\u00d6\u0001\u00a2\u0006\u0004\b\u001c\u0010\u0007R\"\u0010\u000e\u001a\u00020\u00058\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000e\u0010\u001d\u001a\u0004\b\u001e\u0010\u0007\"\u0004\b\u001f\u0010 R\"\u0010\r\u001a\u00020\u00058\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\r\u0010\u001d\u001a\u0004\b!\u0010\u0007\"\u0004\b\"\u0010 R.\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\t8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000f\u0010#\u001a\u0004\b$\u0010\u000b\"\u0004\b%\u0010&R\u0017\u0010\f\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\f\u0010'\u001a\u0004\b(\u0010\u0004\u00a8\u0006+"}, d2={"Lgg/essential/gui/account/factory/MojangAccountSessionFactory$MojangAccount;", "", "Ljava/util/UUID;", "component1", "()Ljava/util/UUID;", "", "component2", "()Ljava/lang/String;", "component3", "", "component4", "()Ljava/util/Map;", "uuid", "name", "accessToken", "storage", "copy", "(Ljava/util/UUID;Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;)Lgg/essential/gui/account/factory/MojangAccountSessionFactory$MojangAccount;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "Lnet/minecraft/class_320;", "toSession", "()Lnet/minecraft/class_320;", "toString", "Ljava/lang/String;", "getAccessToken", "setAccessToken", "(Ljava/lang/String;)V", "getName", "setName", "Ljava/util/Map;", "getStorage", "setStorage", "(Ljava/util/Map;)V", "Ljava/util/UUID;", "getUuid", "<init>", "(Ljava/util/UUID;Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;)V", "Essential 1.19-fabric"})
    private static final class MojangAccount {
        @NotNull
        private final UUID uuid;
        @NotNull
        private String name;
        @NotNull
        private String accessToken;
        @NotNull
        private Map<String, ? extends Object> storage;

        public MojangAccount(@NotNull UUID uuid, @NotNull String name, @NotNull String accessToken, @NotNull Map<String, ? extends Object> storage2) {
            Intrinsics.checkNotNullParameter(uuid, "uuid");
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(accessToken, "accessToken");
            Intrinsics.checkNotNullParameter(storage2, "storage");
            this.uuid = uuid;
            this.name = name;
            this.accessToken = accessToken;
            this.storage = storage2;
        }

        @NotNull
        public final UUID getUuid() {
            return this.uuid;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final void setName(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            this.name = string;
        }

        @NotNull
        public final String getAccessToken() {
            return this.accessToken;
        }

        public final void setAccessToken(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            this.accessToken = string;
        }

        @NotNull
        public final Map<String, Object> getStorage() {
            return this.storage;
        }

        public final void setStorage(@NotNull Map<String, ? extends Object> map2) {
            Intrinsics.checkNotNullParameter(map2, "<set-?>");
            this.storage = map2;
        }

        @NotNull
        public final class_320 toSession() {
            String string = this.uuid.toString();
            Intrinsics.checkNotNullExpressionValue(string, "uuid.toString()");
            return new class_320(this.name, StringsKt.replace$default(string, "-", "", false, 4, null), this.accessToken, Optional.empty(), Optional.empty(), class_320.class_321.field_1988);
        }

        @NotNull
        public final UUID component1() {
            return this.uuid;
        }

        @NotNull
        public final String component2() {
            return this.name;
        }

        @NotNull
        public final String component3() {
            return this.accessToken;
        }

        @NotNull
        public final Map<String, Object> component4() {
            return this.storage;
        }

        @NotNull
        public final MojangAccount copy(@NotNull UUID uuid, @NotNull String name, @NotNull String accessToken, @NotNull Map<String, ? extends Object> storage2) {
            Intrinsics.checkNotNullParameter(uuid, "uuid");
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(accessToken, "accessToken");
            Intrinsics.checkNotNullParameter(storage2, "storage");
            return new MojangAccount(uuid, name, accessToken, storage2);
        }

        public static /* synthetic */ MojangAccount copy$default(MojangAccount mojangAccount, UUID uUID, String string, String string2, Map map2, int n, Object object) {
            if ((n & 1) != 0) {
                uUID = mojangAccount.uuid;
            }
            if ((n & 2) != 0) {
                string = mojangAccount.name;
            }
            if ((n & 4) != 0) {
                string2 = mojangAccount.accessToken;
            }
            if ((n & 8) != 0) {
                map2 = mojangAccount.storage;
            }
            return mojangAccount.copy(uUID, string, string2, map2);
        }

        @NotNull
        public String toString() {
            return "MojangAccount(uuid=" + this.uuid + ", name=" + this.name + ", accessToken=" + this.accessToken + ", storage=" + this.storage + ")";
        }

        public int hashCode() {
            int result2 = this.uuid.hashCode();
            result2 = result2 * 31 + this.name.hashCode();
            result2 = result2 * 31 + this.accessToken.hashCode();
            result2 = result2 * 31 + ((Object)this.storage).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MojangAccount)) {
                return false;
            }
            MojangAccount mojangAccount = (MojangAccount)other;
            if (!Intrinsics.areEqual(this.uuid, mojangAccount.uuid)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.name, mojangAccount.name)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.accessToken, mojangAccount.accessToken)) {
                return false;
            }
            return Intrinsics.areEqual(this.storage, mojangAccount.storage);
        }
    }
}

