/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.account;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import com.mojang.authlib.exceptions.InvalidCredentialsException;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpServer;
import gg.essential.api.utils.Multithreading;
import gg.essential.handlers.CertChain;
import gg.essential.universal.UDesktop;
import gg.essential.util.UUIDUtil;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.net.ssl.SSLContext;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.reflect.KMutableProperty0;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0013\u0018\u0000 K2\u00020\u0001:\u0002KLB\u0007\u00a2\u0006\u0004\bI\u0010JJ\u000f\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\u0005\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0004J\u0017\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0019\u0010\u000e\u001a\u00020\u00022\b\b\u0002\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0019\u0010\u0010\u001a\u00020\u00022\b\b\u0002\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u000fJ%\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00112\b\b\u0002\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J#\u0010\u0019\u001a\u00020\u00022\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0017H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ#\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00020\u00112\b\b\u0002\u0010\u001b\u001a\u00020\f\u00a2\u0006\u0004\b\u001c\u0010\u0013J!\u0010 \u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u0001H\u0002\u00a2\u0006\u0004\b \u0010!JR\u0010*\u001a\u00028\u0001\"\u0004\b\u0000\u0010\"\"\u0004\b\u0001\u0010#*\u00020\f2\u000e\u0010%\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000$2!\u0010)\u001a\u001d\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b'\u0012\b\b(\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00028\u00010&H\u0002\u00a2\u0006\u0004\b*\u0010+J\u0015\u0010-\u001a\u0004\u0018\u00010\u001f*\u00020,H\u0002\u00a2\u0006\u0004\b-\u0010.J9\u00103\u001a\u000201*\u0004\u0018\u00010/2!\u00102\u001a\u001d\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b'\u0012\b\b(\u0012\u0004\b\b(0\u0012\u0004\u0012\u0002010&H\u0082\b\u00a2\u0006\u0004\b3\u00104J\u001b\u00106\u001a\n 5*\u0004\u0018\u00010\u00020\u0002*\u00020\u0002H\u0002\u00a2\u0006\u0004\b6\u0010\bR\u0018\u00107\u001a\u0004\u0018\u00010/8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b7\u00108R\u0018\u00109\u001a\u0004\u0018\u00010/8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b9\u00108R$\u0010;\u001a\u0004\u0018\u00010:8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b;\u0010<\u001a\u0004\b=\u0010>\"\u0004\b?\u0010@R\u0018\u0010A\u001a\u0004\u0018\u00010\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bA\u0010BR\u0018\u0010C\u001a\u0004\u0018\u00010\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bC\u0010DR\u0018\u0010E\u001a\u0004\u0018\u00010\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bE\u0010DR\u0018\u0010F\u001a\u0004\u0018\u00010\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bF\u0010DR\u0018\u0010G\u001a\u0004\u0018\u00010/8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bG\u00108R\u0018\u0010H\u001a\u0004\u0018\u00010/8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bH\u00108\u00a8\u0006M"}, d2={"Lgg/essential/gui/account/MicrosoftUserAuthentication;", "", "", "acquireAccessToken", "()Ljava/lang/String;", "acquireAccessTokenViaOAuth", "codeVerifier", "acquireAuthorizationCode", "(Ljava/lang/String;)Ljava/lang/String;", "Lcom/mojang/authlib/GameProfile;", "acquireGameProfile", "()Lcom/mojang/authlib/GameProfile;", "", "retry", "acquireMCToken", "(Z)Ljava/lang/String;", "acquireXBLToken", "Lkotlin/Pair;", "acquireXSTSToken", "(Z)Lkotlin/Pair;", "Lorg/apache/http/impl/client/CloseableHttpClient;", "createHttpClient", "()Lorg/apache/http/impl/client/CloseableHttpClient;", "", "props", "fetchAccessToken", "(Ljava/util/Map;)Ljava/lang/String;", "forceRefresh", "logIn", "uri", "content", "Lcom/google/gson/JsonObject;", "post", "(Ljava/lang/String;Ljava/lang/Object;)Lcom/google/gson/JsonObject;", "P", "T", "Lkotlin/reflect/KMutableProperty0;", "invalidToken", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "func", "attempt", "(ZLkotlin/reflect/KMutableProperty0;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "Lorg/apache/http/client/methods/HttpUriRequest;", "execute", "(Lorg/apache/http/client/methods/HttpUriRequest;)Lcom/google/gson/JsonObject;", "Lgg/essential/gui/account/MicrosoftUserAuthentication$Token;", "token", "", "block", "ifValid", "(Lgg/essential/gui/account/MicrosoftUserAuthentication$Token;Lkotlin/jvm/functions/Function1;)V", "kotlin.jvm.PlatformType", "urlEncode", "accessToken", "Lgg/essential/gui/account/MicrosoftUserAuthentication$Token;", "mcToken", "Ljava/net/URI;", "openUri", "Ljava/net/URI;", "getOpenUri", "()Ljava/net/URI;", "setOpenUri", "(Ljava/net/URI;)V", "profile", "Lcom/mojang/authlib/GameProfile;", "redirectUri", "Ljava/lang/String;", "refreshToken", "uhs", "xblToken", "xstsToken", "<init>", "()V", "Companion", "Token", "Essential 1.19-fabric"})
public final class MicrosoftUserAuthentication {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private String redirectUri;
    @Nullable
    private Token accessToken;
    @Nullable
    private String refreshToken;
    @Nullable
    private Token xblToken;
    @Nullable
    private Token xstsToken;
    @Nullable
    private String uhs;
    @Nullable
    private Token mcToken;
    @Nullable
    private GameProfile profile;
    @Nullable
    private URI openUri;
    private static final boolean DEBUG = false;
    @NotNull
    private static final String CLIENT_ID = "e39cc675-eb52-4475-b5f8-82aaae14eeba";
    @NotNull
    private static final String SCOPE = "Xboxlive.signin Xboxlive.offline_access";
    @NotNull
    private static final String URL_OAUTH_START = "https://login.live.com/oauth20_authorize.srf";
    @NotNull
    private static final String URL_OAUTH_TOKEN = "https://login.live.com/oauth20_token.srf";
    @NotNull
    private static final String URL_XBL = "https://user.auth.xboxlive.com/user/authenticate";
    @NotNull
    private static final String URL_XSTS = "https://xsts.auth.xboxlive.com/xsts/authorize";
    @NotNull
    private static final String URL_MINECRAFT = "https://api.minecraftservices.com/authentication/login_with_xbox";
    @NotNull
    private static final String URL_PROFILE = "https://api.minecraftservices.com/minecraft/profile";

    @Nullable
    public final URI getOpenUri() {
        return this.openUri;
    }

    public final void setOpenUri(@Nullable URI uRI) {
        this.openUri = uRI;
    }

    @NotNull
    public final Pair<GameProfile, String> logIn(boolean forceRefresh) {
        if (forceRefresh) {
            this.mcToken = null;
        }
        GameProfile profile = this.acquireGameProfile();
        String token = MicrosoftUserAuthentication.acquireMCToken$default(this, false, 1, null);
        return new Pair<GameProfile, String>(profile, token);
    }

    public static /* synthetic */ Pair logIn$default(MicrosoftUserAuthentication microsoftUserAuthentication, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return microsoftUserAuthentication.logIn(bl);
    }

    private final String acquireAccessToken() {
        MicrosoftUserAuthentication microsoftUserAuthentication = this;
        Token $this$ifValid$iv = this.accessToken;
        boolean $i$f$ifValid = false;
        if ($this$ifValid$iv != null && !$this$ifValid$iv.getExpired()) {
            String it = $this$ifValid$iv.getValue();
            boolean bl = false;
            return it;
        }
        String string = this.refreshToken;
        if (string == null) {
            return this.acquireAccessTokenViaOAuth();
        }
        String refreshToken = string;
        Pair[] pairArray = new Pair[]{TuplesKt.to("grant_type", "refresh_token"), TuplesKt.to("refresh_token", refreshToken)};
        return this.fetchAccessToken(MapsKt.mapOf(pairArray));
    }

    private final String acquireAccessTokenViaOAuth() {
        byte[] byArray;
        byte[] it = byArray = new byte[32];
        boolean bl = false;
        new SecureRandom().nextBytes(it);
        String codeVerifier = Base64.encodeBase64URLSafeString((byte[])byArray);
        Intrinsics.checkNotNullExpressionValue(codeVerifier, "codeVerifier");
        String code = this.acquireAuthorizationCode(codeVerifier);
        Pair[] pairArray = new Pair[]{TuplesKt.to("code_verifier", codeVerifier), TuplesKt.to("grant_type", "authorization_code"), TuplesKt.to("code", code)};
        return this.fetchAccessToken(MapsKt.mapOf(pairArray));
    }

    /*
     * WARNING - void declaration
     */
    private final String acquireAuthorizationCode(String codeVerifier) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        HttpServer server = HttpServer.create(new InetSocketAddress("localhost", 0), 0);
        CompletableFuture future2 = new CompletableFuture();
        server.createContext("/", arg_0 -> MicrosoftUserAuthentication.acquireAuthorizationCode$lambda-5(future2, arg_0));
        server.setExecutor(Multithreading.getPool());
        server.start();
        int port = server.getAddress().getPort();
        String redirectUri = "http://localhost:" + port;
        this.redirectUri = redirectUri;
        Object object = new Pair[]{TuplesKt.to("client_id", CLIENT_ID), TuplesKt.to("scope", SCOPE), TuplesKt.to("code_challenge_method", "S256"), TuplesKt.to("code_challenge", Base64.encodeBase64URLSafeString((byte[])DigestUtils.sha256((String)codeVerifier))), TuplesKt.to("response_type", "code"), TuplesKt.to("redirect_uri", redirectUri)};
        object = MapsKt.mapOf(object);
        boolean $i$f$map = false;
        void var9_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void $dstr$key$value;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String key = (String)$dstr$key$value.getKey();
            String value2 = (String)$dstr$key$value.getValue();
            Intrinsics.checkNotNullExpressionValue(value2, "value");
            collection.add(key + "=" + this.urlEncode(value2));
        }
        String string = "https://login.live.com/oauth20_authorize.srf?" + CollectionsKt.joinToString$default((List)destination$iv$iv, "&", null, null, 0, null, null, 62, null);
        URI uri = new URI(string);
        UDesktop.browse(uri);
        this.openUri = uri;
        object = future2.join();
        Intrinsics.checkNotNullExpressionValue(object, "future.join()");
        return (String)object;
    }

    /*
     * WARNING - void declaration
     */
    private final String fetchAccessToken(Map<String, String> props) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$fetchAccessToken_u24lambda_u2d8;
        HttpPost httpPost;
        Pair[] pairArray = new Pair[3];
        pairArray[0] = TuplesKt.to("client_id", CLIENT_ID);
        pairArray[1] = TuplesKt.to("scope", SCOPE);
        String string = this.redirectUri;
        if (string == null) {
            string = "";
        }
        pairArray[2] = TuplesKt.to("redirect_uri", string);
        Map<String, String> fullProps = MapsKt.plus(props, MapsKt.mapOf(pairArray));
        HttpPost httpPost2 = httpPost = new HttpPost(URL_OAUTH_TOKEN);
        MicrosoftUserAuthentication microsoftUserAuthentication = this;
        boolean bl = false;
        $this$fetchAccessToken_u24lambda_u2d8.setHeader("Content-Type", "application/x-www-form-urlencoded");
        Object object = fullProps;
        void var9_10 = $this$fetchAccessToken_u24lambda_u2d8;
        boolean $i$f$map = false;
        void var11_12 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void $dstr$name$value;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            String name = (String)$dstr$name$value.getKey();
            String value2 = (String)$dstr$name$value.getValue();
            collection.add(new BasicNameValuePair(name, value2));
        }
        List list = (List)destination$iv$iv;
        var9_10.setEntity((HttpEntity)new UrlEncodedFormEntity(list));
        JsonObject jsonObject = microsoftUserAuthentication.execute((HttpUriRequest)httpPost);
        if (jsonObject == null) {
            throw new InvalidCredentialsException();
        }
        JsonObject response2 = jsonObject;
        String accessToken = response2.get("access_token").getAsString();
        String refreshToken = response2.get("refresh_token").getAsString();
        long expiresIn = response2.get("expires_in").getAsLong();
        Intrinsics.checkNotNullExpressionValue(accessToken, "accessToken");
        object = Instant.now().plus(Duration.ofSeconds(expiresIn));
        Intrinsics.checkNotNullExpressionValue(object, "Instant.now() + Duration.ofSeconds(expiresIn)");
        this.accessToken = new Token(accessToken, (Instant)object);
        this.refreshToken = refreshToken;
        return accessToken;
    }

    private final String acquireXBLToken(boolean retry2) {
        MicrosoftUserAuthentication microsoftUserAuthentication = this;
        Token $this$ifValid$iv = this.xblToken;
        boolean $i$f$ifValid22 = false;
        if ($this$ifValid$iv != null && !$this$ifValid$iv.getExpired()) {
            String it = $this$ifValid$iv.getValue();
            boolean bl = false;
            return it;
        }
        String accessToken = this.acquireAccessToken();
        Pair[] it = new Pair[3];
        Pair[] pairArray = new Pair[]{TuplesKt.to("AuthMethod", "RPS"), TuplesKt.to("SiteName", "user.auth.xboxlive.com"), TuplesKt.to("RpsTicket", "d=" + accessToken)};
        it[0] = TuplesKt.to("Properties", MapsKt.mapOf(pairArray));
        it[1] = TuplesKt.to("RelyingParty", "http://auth.xboxlive.com");
        it[2] = TuplesKt.to("TokenType", "JWT");
        JsonObject $i$f$ifValid22 = this.post(URL_XBL, MapsKt.mapOf(it));
        if ($i$f$ifValid22 == null) {
            return (String)this.attempt(retry2, new MutablePropertyReference0Impl(this){

                @Nullable
                public Object get() {
                    return MicrosoftUserAuthentication.access$getAccessToken$p((MicrosoftUserAuthentication)this.receiver);
                }

                public void set(@Nullable Object value2) {
                    MicrosoftUserAuthentication.access$setAccessToken$p((MicrosoftUserAuthentication)this.receiver, (Token)value2);
                }
            }, (Function1)new Function1<Boolean, String>((Object)this){

                @NotNull
                public final String invoke(boolean p0) {
                    return MicrosoftUserAuthentication.access$acquireXBLToken((MicrosoftUserAuthentication)this.receiver, p0);
                }
            });
        }
        JsonObject response2 = $i$f$ifValid22;
        String token = response2.get("Token").getAsString();
        Instant expires = Instant.parse(response2.get("NotAfter").getAsString());
        Intrinsics.checkNotNullExpressionValue(token, "token");
        Intrinsics.checkNotNullExpressionValue(expires, "expires");
        this.xblToken = new Token(token, expires);
        return token;
    }

    static /* synthetic */ String acquireXBLToken$default(MicrosoftUserAuthentication microsoftUserAuthentication, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return microsoftUserAuthentication.acquireXBLToken(bl);
    }

    private final Pair<String, String> acquireXSTSToken(boolean retry2) {
        MicrosoftUserAuthentication microsoftUserAuthentication = this;
        Token $this$ifValid$iv = this.xstsToken;
        boolean $i$f$ifValid22 = false;
        if ($this$ifValid$iv != null && !$this$ifValid$iv.getExpired()) {
            String it = $this$ifValid$iv.getValue();
            boolean bl = false;
            String string = this.uhs;
            Intrinsics.checkNotNull(string);
            return new Pair<String, String>(it, string);
        }
        String xblToken = MicrosoftUserAuthentication.acquireXBLToken$default(this, false, 1, null);
        Pair[] it = new Pair[3];
        Pair[] bl = new Pair[]{TuplesKt.to("SandboxId", "RETAIL"), TuplesKt.to("UserTokens", CollectionsKt.listOf(xblToken))};
        it[0] = TuplesKt.to("Properties", MapsKt.mapOf(bl));
        it[1] = TuplesKt.to("RelyingParty", "rp://api.minecraftservices.com/");
        it[2] = TuplesKt.to("TokenType", "JWT");
        JsonObject $i$f$ifValid22 = this.post(URL_XSTS, MapsKt.mapOf(it));
        if ($i$f$ifValid22 == null) {
            return (Pair)this.attempt(retry2, new MutablePropertyReference0Impl(this){

                @Nullable
                public Object get() {
                    return MicrosoftUserAuthentication.access$getXblToken$p((MicrosoftUserAuthentication)this.receiver);
                }

                public void set(@Nullable Object value2) {
                    MicrosoftUserAuthentication.access$setXblToken$p((MicrosoftUserAuthentication)this.receiver, (Token)value2);
                }
            }, (Function1)new Function1<Boolean, Pair<? extends String, ? extends String>>((Object)this){

                @NotNull
                public final Pair<String, String> invoke(boolean p0) {
                    return MicrosoftUserAuthentication.access$acquireXSTSToken((MicrosoftUserAuthentication)this.receiver, p0);
                }
            });
        }
        JsonObject response2 = $i$f$ifValid22;
        String token = response2.get("Token").getAsString();
        Instant expires = Instant.parse(response2.get("NotAfter").getAsString());
        String uhs = response2.get("DisplayClaims").getAsJsonObject().get("xui").getAsJsonArray().get(0).getAsJsonObject().get("uhs").getAsString();
        Intrinsics.checkNotNullExpressionValue(token, "token");
        Intrinsics.checkNotNullExpressionValue(expires, "expires");
        this.xstsToken = new Token(token, expires);
        this.uhs = uhs;
        return new Pair<String, String>(token, uhs);
    }

    static /* synthetic */ Pair acquireXSTSToken$default(MicrosoftUserAuthentication microsoftUserAuthentication, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return microsoftUserAuthentication.acquireXSTSToken(bl);
    }

    private final String acquireMCToken(boolean retry2) {
        Object object = this;
        Token $this$ifValid$iv = this.mcToken;
        boolean $i$f$ifValid = false;
        if ($this$ifValid$iv != null && !$this$ifValid$iv.getExpired()) {
            String it = $this$ifValid$iv.getValue();
            boolean bl = false;
            return it;
        }
        object = MicrosoftUserAuthentication.acquireXSTSToken$default(this, false, 1, null);
        String xstsToken = (String)((Pair)object).component1();
        String uhs = (String)((Pair)object).component2();
        JsonObject bl = this.post(URL_MINECRAFT, MapsKt.mapOf(TuplesKt.to("identityToken", "XBL3.0 x=" + uhs + ";" + xstsToken)));
        if (bl == null) {
            return (String)this.attempt(retry2, new MutablePropertyReference0Impl(this){

                @Nullable
                public Object get() {
                    return MicrosoftUserAuthentication.access$getXstsToken$p((MicrosoftUserAuthentication)this.receiver);
                }

                public void set(@Nullable Object value2) {
                    MicrosoftUserAuthentication.access$setXstsToken$p((MicrosoftUserAuthentication)this.receiver, (Token)value2);
                }
            }, (Function1)new Function1<Boolean, String>((Object)this){

                @NotNull
                public final String invoke(boolean p0) {
                    return MicrosoftUserAuthentication.access$acquireMCToken((MicrosoftUserAuthentication)this.receiver, p0);
                }
            });
        }
        JsonObject response2 = bl;
        String token = response2.get("access_token").getAsString();
        long expiresIn = response2.get("expires_in").getAsLong();
        Intrinsics.checkNotNullExpressionValue(token, "token");
        Instant instant = Instant.now().plus(Duration.ofSeconds(expiresIn));
        Intrinsics.checkNotNullExpressionValue(instant, "Instant.now() + Duration.ofSeconds(expiresIn)");
        this.mcToken = new Token(token, instant);
        this.profile = null;
        return token;
    }

    static /* synthetic */ String acquireMCToken$default(MicrosoftUserAuthentication microsoftUserAuthentication, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return microsoftUserAuthentication.acquireMCToken(bl);
    }

    /*
     * WARNING - void declaration
     */
    private final GameProfile acquireGameProfile() {
        GameProfile profile;
        void $this$acquireGameProfile_u24lambda_u2d13;
        HttpGet it2;
        String token = MicrosoftUserAuthentication.acquireMCToken$default(this, false, 1, null);
        GameProfile gameProfile = this.profile;
        if (gameProfile != null) {
            GameProfile it2 = gameProfile;
            boolean bl = false;
            return it2;
        }
        HttpGet bl = it2 = new HttpGet(URL_PROFILE);
        MicrosoftUserAuthentication microsoftUserAuthentication = this;
        boolean bl2 = false;
        $this$acquireGameProfile_u24lambda_u2d13.setHeader("Authorization", "Bearer " + token);
        JsonObject jsonObject = microsoftUserAuthentication.execute((HttpUriRequest)it2);
        if (jsonObject == null) {
            throw new InvalidCredentialsException();
        }
        JsonObject response2 = jsonObject;
        JsonElement jsonElement = response2.get("error");
        if (jsonElement != null) {
            String string = jsonElement.getAsString();
            if (string != null) {
                String it3 = string;
                boolean bl3 = false;
                if (Intrinsics.areEqual(it3, "NOT_FOUND")) {
                    throw new InvalidCredentialsException("This account does not own Minecraft");
                }
                System.out.println((Object)new Gson().toJson((JsonElement)response2));
                throw new IOException(response2.get("errorMessage").getAsString());
            }
        }
        UUID uuid = UUIDUtil.formatWithDashes(response2.get("id").getAsString());
        String name = response2.get("name").getAsString();
        this.profile = profile = new GameProfile(uuid, name);
        return profile;
    }

    /*
     * WARNING - void declaration
     */
    private final JsonObject post(String uri, Object content) {
        void $this$post_u24lambda_u2d15;
        EntityBuilder entityBuilder;
        HttpPost request = new HttpPost(uri);
        EntityBuilder entityBuilder2 = entityBuilder = EntityBuilder.create();
        HttpPost httpPost = request;
        boolean bl = false;
        $this$post_u24lambda_u2d15.setText(new Gson().toJson(content));
        $this$post_u24lambda_u2d15.setContentType(ContentType.APPLICATION_JSON);
        httpPost.setEntity(entityBuilder.build());
        return this.execute((HttpUriRequest)request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final JsonObject execute(HttpUriRequest $this$execute) {
        JsonObject json2;
        String string;
        $this$execute.setHeader("Accept", "application/json");
        CloseableHttpResponse response2 = this.createHttpClient().execute($this$execute);
        int status = response2.getStatusLine().getStatusCode();
        Closeable closeable = response2.getEntity().getContent();
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(it, "it");
            InputStream inputStream = it;
            Charset charset = Charsets.UTF_8;
            Closeable closeable2 = inputStream;
            closeable2 = new InputStreamReader((InputStream)closeable2, charset);
            int n = 8192;
            string = TextStreamsKt.readText(closeable2 instanceof BufferedReader ? (BufferedReader)closeable2 : new BufferedReader((Reader)closeable2, n));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        String content = string;
        if (status >= 300) {
            System.out.println((Object)(status + ": " + content));
        }
        if ((json2 = (JsonObject)new Gson().fromJson(content, JsonObject.class)).has("error")) {
            System.out.println((Object)new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)json2));
        }
        return switch (status) {
            case 400, 401 -> null;
            default -> json2;
        };
    }

    private final CloseableHttpClient createHttpClient() {
        SSLContext sslContext = new CertChain().load("baltimore-cybertrust-root").load("digicert-global-root-g2").load("digicert-global-root-ca").load("d-trust-root-class-3-ca-2-2009").load("microsoft-rsa-root-ca-2017").load("microsoft-ecc-root-ca-2017").load("amazon-root-ca-1").done();
        CloseableHttpClient closeableHttpClient = HttpClientBuilder.create().setSslcontext(sslContext).build();
        Intrinsics.checkNotNullExpressionValue(closeableHttpClient, "create()\n            .se\u2026ext)\n            .build()");
        return closeableHttpClient;
    }

    private final String urlEncode(String $this$urlEncode) {
        return URLEncoder.encode($this$urlEncode, "utf-8");
    }

    private final <P, T> T attempt(boolean $this$attempt, KMutableProperty0<P> invalidToken, Function1<? super Boolean, ? extends T> func) {
        if (!$this$attempt) {
            throw new AuthenticationUnavailableException();
        }
        invalidToken.set(null);
        return func.invoke(false);
    }

    private final void ifValid(Token $this$ifValid, Function1<? super String, Unit> block) {
        boolean $i$f$ifValid = false;
        if ($this$ifValid != null && !$this$ifValid.getExpired()) {
            block.invoke($this$ifValid.getValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void acquireAuthorizationCode$lambda-5(CompletableFuture $future, HttpExchange exchange) {
        Object v1;
        Object object;
        Object object2;
        block3: {
            Iterator $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter($future, "$future");
            exchange.sendResponseHeaders(200, 0L);
            object2 = exchange.getRequestURI().getQuery();
            Intrinsics.checkNotNullExpressionValue(object2, "exchange.requestURI.query");
            CharSequence charSequence = (CharSequence)object2;
            object2 = new String[]{"&"};
            Iterable $this$map$iv = StringsKt.split$default(charSequence, object2, false, 0, 6, null);
            boolean $i$f$map = false;
            object = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it;
                Object item$iv$iv = iterator2.next();
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String[] stringArray = new String[]{"="};
                collection.add(StringsKt.split$default((CharSequence)it, stringArray, false, 2, 2, null));
            }
            for (Object object3 : (Iterable)((List)destination$iv$iv)) {
                List $dstr$key$_u24__u24 = (List)object3;
                boolean bl = false;
                String key = (String)$dstr$key$_u24__u24.get(0);
                if (!Intrinsics.areEqual(key, "code")) continue;
                v1 = object3;
                break block3;
            }
            v1 = null;
        }
        List list = v1;
        if (list == null) {
            Object object3;
            Object it = object2 = Unit.INSTANCE;
            boolean bl = false;
            OutputStream outputStream = exchange.getResponseBody();
            object3 = "Login failed. Permission with Microsoft denied?".getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue(object3, "this as java.lang.String).getBytes(charset)");
            outputStream.write((byte[])object3);
            exchange.getResponseBody().close();
            $future.cancel(true);
            return;
        }
        String code = (String)list.get(1);
        OutputStream outputStream = exchange.getResponseBody();
        object = "Login successful. Please close this window and return to Minecraft".getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(object, "this as java.lang.String).getBytes(charset)");
        outputStream.write((byte[])object);
        exchange.getResponseBody().close();
        $future.complete(code);
    }

    public static final /* synthetic */ Token access$getAccessToken$p(MicrosoftUserAuthentication $this) {
        return $this.accessToken;
    }

    public static final /* synthetic */ void access$setAccessToken$p(MicrosoftUserAuthentication $this, Token token) {
        $this.accessToken = token;
    }

    public static final /* synthetic */ String access$acquireXBLToken(MicrosoftUserAuthentication $this, boolean retry2) {
        return $this.acquireXBLToken(retry2);
    }

    public static final /* synthetic */ Token access$getXblToken$p(MicrosoftUserAuthentication $this) {
        return $this.xblToken;
    }

    public static final /* synthetic */ void access$setXblToken$p(MicrosoftUserAuthentication $this, Token token) {
        $this.xblToken = token;
    }

    public static final /* synthetic */ Pair access$acquireXSTSToken(MicrosoftUserAuthentication $this, boolean retry2) {
        return $this.acquireXSTSToken(retry2);
    }

    public static final /* synthetic */ Token access$getXstsToken$p(MicrosoftUserAuthentication $this) {
        return $this.xstsToken;
    }

    public static final /* synthetic */ void access$setXstsToken$p(MicrosoftUserAuthentication $this, Token token) {
        $this.xstsToken = token;
    }

    public static final /* synthetic */ String access$acquireMCToken(MicrosoftUserAuthentication $this, boolean retry2) {
        return $this.acquireMCToken(retry2);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\f\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0004R\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\b\u0010\u0004R\u0014\u0010\t\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0004R\u0014\u0010\n\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\n\u0010\u0004R\u0014\u0010\u000b\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u0004R\u0014\u0010\f\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\f\u0010\u0004R\u0014\u0010\r\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\r\u0010\u0004R\u0014\u0010\u000e\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u0004\u00a8\u0006\u0011"}, d2={"Lgg/essential/gui/account/MicrosoftUserAuthentication$Companion;", "", "", "CLIENT_ID", "Ljava/lang/String;", "", "DEBUG", "Z", "SCOPE", "URL_MINECRAFT", "URL_OAUTH_START", "URL_OAUTH_TOKEN", "URL_PROFILE", "URL_XBL", "URL_XSTS", "<init>", "()V", "Essential 1.19-fabric"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\r\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\b\u001a\u00020\u0002\u0012\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0010\u0010\u0003\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0006\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J$\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\b\u001a\u00020\u00022\b\b\u0002\u0010\t\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001a\u0010\u000e\u001a\u00020\r2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0011\u001a\u00020\u0010H\u00d6\u0001\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0004R\u0011\u0010\u0016\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\t\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u0017\u001a\u0004\b\u0018\u0010\u0007R\u0017\u0010\b\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\u0019\u001a\u0004\b\u001a\u0010\u0004\u00a8\u0006\u001d"}, d2={"Lgg/essential/gui/account/MicrosoftUserAuthentication$Token;", "", "", "component1", "()Ljava/lang/String;", "Ljava/time/Instant;", "component2", "()Ljava/time/Instant;", "value", "expires", "copy", "(Ljava/lang/String;Ljava/time/Instant;)Lgg/essential/gui/account/MicrosoftUserAuthentication$Token;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "getExpired", "()Z", "expired", "Ljava/time/Instant;", "getExpires", "Ljava/lang/String;", "getValue", "<init>", "(Ljava/lang/String;Ljava/time/Instant;)V", "Essential 1.19-fabric"})
    public static final class Token {
        @NotNull
        private final String value;
        @NotNull
        private final Instant expires;

        public Token(@NotNull String value2, @NotNull Instant expires) {
            Intrinsics.checkNotNullParameter(value2, "value");
            Intrinsics.checkNotNullParameter(expires, "expires");
            this.value = value2;
            this.expires = expires;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        @NotNull
        public final Instant getExpires() {
            return this.expires;
        }

        public final boolean getExpired() {
            return this.expires.isBefore(Instant.now());
        }

        @NotNull
        public final String component1() {
            return this.value;
        }

        @NotNull
        public final Instant component2() {
            return this.expires;
        }

        @NotNull
        public final Token copy(@NotNull String value2, @NotNull Instant expires) {
            Intrinsics.checkNotNullParameter(value2, "value");
            Intrinsics.checkNotNullParameter(expires, "expires");
            return new Token(value2, expires);
        }

        public static /* synthetic */ Token copy$default(Token token, String string, Instant instant, int n, Object object) {
            if ((n & 1) != 0) {
                string = token.value;
            }
            if ((n & 2) != 0) {
                instant = token.expires;
            }
            return token.copy(string, instant);
        }

        @NotNull
        public String toString() {
            return "Token(value=" + this.value + ", expires=" + this.expires + ")";
        }

        public int hashCode() {
            int result2 = this.value.hashCode();
            result2 = result2 * 31 + this.expires.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Token)) {
                return false;
            }
            Token token = (Token)other;
            if (!Intrinsics.areEqual(this.value, token.value)) {
                return false;
            }
            return Intrinsics.areEqual(this.expires, token.expires);
        }
    }
}

