/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui;

import gg.essential.Essential;
import gg.essential.connectionmanager.common.packet.pingproxy.ClientPingProxyPacket;
import gg.essential.connectionmanager.common.packet.pingproxy.ServerPingProxyResponsePacket;
import gg.essential.elementa.components.Window;
import gg.essential.elementa.dsl.ComponentsKt;
import gg.essential.gui.common.modal.ConfirmationModal;
import gg.essential.gui.sps.InviteFriendsPane;
import gg.essential.gui.sps.WorldSettingsPane;
import gg.essential.handlers.UPnPWrapper;
import gg.essential.network.connectionmanager.ConnectionManager;
import gg.essential.network.connectionmanager.social.SocialManager;
import gg.essential.network.connectionmanager.sps.SPSManager;
import gg.essential.universal.UMinecraft;
import gg.essential.upnp.UPnPPrivacy;
import gg.essential.upnp.model.UPnPSession;
import gg.essential.util.ExtensionsKt;
import gg.essential.util.MinecraftUtils;
import gg.essential.util.Multithreading;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Unit;
import net.minecraft.class_1934;
import net.minecraft.class_310;
import net.minecraft.class_642;

public class InviteFriendsPopup {
    public static void openInviteToFriendsMenu(Window window) {
        ConnectionManager connectionManager = Essential.getInstance().getConnectionManager();
        SocialManager socialManager = connectionManager.getSocialManager();
        SPSManager spsManager = connectionManager.getSpsManager();
        UPnPSession localSession = spsManager.getLocalSession();
        if (localSession != null) {
            ComponentsKt.childOf(new WorldSettingsPane(spsManager.getInvitedUsers(), UPnPPrivacy.INVITE_ONLY, false), window);
        } else {
            class_642 serverData = class_310.method_1551().method_1558();
            if (serverData != null) {
                Set invites = socialManager.getInvitesOnServer(serverData.field_3761).orElseGet(Collections::emptySet);
                ComponentsKt.childOf(new InviteFriendsPane(invites, null, false), window);
            } else {
                ConfirmationModal modal2 = new ConfirmationModal("This world will be hosted through your internet. Your host's IP will be visible through network logs! Do you want to proceed?", null, 100, "Next", "Cancel", 250, null, 25, -1, () -> Unit.INSTANCE, string -> {
                    Window.Companion.enqueueRenderOperation(() -> {
                        CompletableFuture<Void> compatibilityFuture = new CompletableFuture<Void>();
                        ConfirmationModal newModal2 = new ConfirmationModal(UPnPWrapper.ICE ? "Starting integrated server" : "Checking UPnP Compatibility", null, 150, "", "Cancel");
                        ComponentsKt.childOf(newModal2, window);
                        newModal2.hideConfirmButton();
                        InviteFriendsPopup.animate(newModal2, compatibilityFuture);
                        ExtensionsKt.logExceptions(spsManager.startLocalSession(class_1934.field_9216, UMinecraft.getMinecraft().field_1687.method_8407(), false, UPnPPrivacy.INVITE_ONLY).thenAccept(success -> {
                            if (success.booleanValue()) {
                                Runnable complete2 = () -> Window.Companion.enqueueRenderOperation(() -> {
                                    window.removeChild(newModal2);
                                    window.removeFloatingComponent(newModal2);
                                    ComponentsKt.childOf(new WorldSettingsPane(spsManager.getInvitedUsers(), UPnPPrivacy.INVITE_ONLY, true), window);
                                });
                                if (UPnPWrapper.ICE) {
                                    complete2.run();
                                    return;
                                }
                                connectionManager.send(new ClientPingProxyPacket(UPnPWrapper.ip, UPnPWrapper.port, MinecraftUtils.getCurrentProtocolVersion()), packet -> {
                                    if (packet.orElse(null) instanceof ServerPingProxyResponsePacket || UPnPWrapper.FAKE_UPNP) {
                                        complete2.run();
                                    } else {
                                        newModal2.getConfirmationTextState().set("Unable to verify UPnP status.");
                                        newModal2.getButtonContainer().getDenyButton().setButtonText("Back");
                                    }
                                    compatibilityFuture.complete(null);
                                });
                            } else {
                                newModal2.getConfirmationTextState().set(spsManager.getError());
                                newModal2.getButtonContainer().getDenyButton().setButtonText("Back");
                                compatibilityFuture.complete(null);
                            }
                        }));
                    });
                    return Unit.INSTANCE;
                });
                ComponentsKt.childOf(modal2, window);
                modal2.fadeIn(null);
            }
        }
    }

    private static void animate(ConfirmationModal modal2, CompletableFuture<Void> completableFuture) {
        int i;
        String state;
        int length;
        if (!completableFuture.isDone()) {
            Multithreading.schedule(() -> InviteFriendsPopup.animate(modal2, completableFuture), 500L, TimeUnit.MILLISECONDS);
        }
        if ((length = (state = modal2.getConfirmationTextState().get()).length()) > (i = state.indexOf(".")) + 2 && i != -1) {
            modal2.getConfirmationTextState().set(state.substring(0, i));
        } else {
            modal2.getConfirmationTextState().set(state + ".");
        }
    }
}

