/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui;

import gg.essential.Essential;
import gg.essential.config.EssentialConfig;
import gg.essential.data.OnboardingData;
import gg.essential.elementa.ElementaVersion;
import gg.essential.elementa.components.UIBlock;
import gg.essential.elementa.components.Window;
import gg.essential.elementa.font.DefaultFonts;
import gg.essential.elementa.font.FontProvider;
import gg.essential.event.gui.GuiClickEvent;
import gg.essential.event.gui.GuiDrawScreenEvent;
import gg.essential.event.gui.GuiKeyTypedEvent;
import gg.essential.event.gui.GuiOpenEvent;
import gg.essential.event.gui.InitGuiEvent;
import gg.essential.event.gui.MouseScrollEvent;
import gg.essential.gui.InviteFriendsPopup;
import gg.essential.handlers.UPnPWrapper;
import gg.essential.lib.kbrewster.eventbus.Subscribe;
import gg.essential.network.connectionmanager.ConnectionManager;
import gg.essential.network.connectionmanager.sps.SPSState;
import gg.essential.universal.UMatrixStack;
import gg.essential.universal.UMinecraft;
import gg.essential.util.HelpersKt;
import gg.essential.util.Multithreading;
import gg.essential.vigilance.gui.VigilancePalette;
import java.util.stream.Stream;
import kotlin.ranges.RangesKt;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_433;
import net.minecraft.class_437;

public class GuiIngameMenuEditor {
    private Window window = null;
    private class_4185 openToFriends;
    private String reason = "you should not see this ever :(";

    public GuiIngameMenuEditor() {
        Multithreading.runAsync(UPnPWrapper::checkCompatibility);
    }

    @Subscribe
    public void editGuiIngameMenu(InitGuiEvent event) {
        boolean buttonEnabled;
        if (!(EssentialConfig.INSTANCE.getOpenToFriends() && event.getScreen() instanceof class_433 && OnboardingData.hasAcceptedTos() && EssentialConfig.INSTANCE.getEssentialFull())) {
            return;
        }
        this.window = new Window(ElementaVersion.V1);
        ConnectionManager connectionManager = Essential.getInstance().getConnectionManager();
        if (class_310.method_1551().method_1542()) {
            boolean compatible = UPnPWrapper.getCompatibility() == UPnPWrapper.UPnPCompatibility.COMPATIBLE;
            boolean opening = connectionManager.getSpsManager().getLocalState() == SPSState.OPENING;
            boolean bl = buttonEnabled = compatible && !opening;
            if (!buttonEnabled) {
                this.reason = compatible ? "Currently opening your world" : "UPnP isn't supported on your router";
            }
        } else if (class_310.method_1551().method_1558() != null) {
            String serverAddress = class_310.method_1551().method_1558().field_3761;
            boolean isSPSServer = connectionManager.getSpsManager().isSpsAddress(serverAddress);
            boolean bl = buttonEnabled = !isSPSServer && !UMinecraft.getMinecraft().method_1589();
            if (!buttonEnabled) {
                this.reason = "Inviting Friends is not supported in this world";
            }
        } else {
            return;
        }
        class_437 screen = event.getScreen();
        class_339 button2 = Stream.of("menu.reportBugs", "menu.sendFeedback").map(label -> HelpersKt.textTranslatable(label)).flatMap(text -> event.getButtonList().stream().filter(it -> text.equals((Object)it.method_25369()))).findFirst().orElse(null);
        if (button2 == null) {
            this.openToFriends = null;
            return;
        }
        int index2 = event.getButtonList().indexOf(button2);
        int x = button2.field_22760;
        int y = button2.field_22761;
        int width = button2.method_25368();
        int height = button2.method_25364();
        String buttonText = "Invite Friends";
        this.openToFriends = new class_4185(x, y, width, height, (class_2561)HelpersKt.textLiteral(buttonText), __ -> {});
        this.openToFriends.field_22763 = buttonEnabled;
        event.getButtonList().set(index2, (class_339)this.openToFriends);
    }

    @Subscribe
    public void drawScreen(GuiDrawScreenEvent.Priority event) {
        UMatrixStack matrixStack = event.getMatrixStack();
        if (event.getScreen() instanceof class_433) {
            if (this.openToFriends != null && !this.openToFriends.field_22763 && this.openToFriends.method_25405((double)event.getMouseX(), (double)event.getMouseY())) {
                int buttonWidth = this.openToFriends.method_25368();
                int buttonHeight = this.openToFriends.method_25364();
                FontProvider f = DefaultFonts.getVANILLA_FONT_RENDERER();
                int w = (int)f.getStringWidth(this.reason, 10.0f);
                int mid = this.openToFriends.field_22760 + (buttonWidth >> 1);
                int w2 = w >> 1;
                int x1 = mid - w2;
                int h = this.openToFriends.field_22761 + buttonHeight;
                UIBlock.Companion.drawBlock(matrixStack, VigilancePalette.INSTANCE.getDarkHighlight(), x1 - 10, h + 3, mid + w2 + 10, h + 23);
                int y = h + 13 - ((int)f.getStringHeight(this.reason, 10.0f) >> 1);
                f.drawString(matrixStack, this.reason, VigilancePalette.INSTANCE.getBrightText(), x1, y, 10.0f, 1.0f, false, null);
            }
            if (event.isPost() && this.window != null) {
                this.window.draw(matrixStack);
            }
        }
    }

    @Subscribe
    public void keyTyped(GuiKeyTypedEvent event) {
        if (event.getScreen() instanceof class_433 && this.window != null) {
            this.window.keyType(event.getTypedChar(), event.getKeyCode());
        }
    }

    @Subscribe
    public void mouseScrolled(MouseScrollEvent event) {
        if (event.getScreen() instanceof class_433 && this.window != null) {
            this.window.mouseScroll(RangesKt.coerceIn(event.getAmount(), -1.0, 1.0));
        }
    }

    @Subscribe
    public void guiClose(GuiOpenEvent event) {
        this.window = null;
    }

    @Subscribe
    public void actionPerformedInPopup(GuiClickEvent.Priority event) {
        if (!(event.getGui() instanceof class_433)) {
            return;
        }
        if (this.window == null || this.window.getChildren().isEmpty()) {
            return;
        }
        this.window.mouseClick(event.getMouseX(), event.getMouseY(), event.getButton());
        event.setCancelled(true);
    }

    @Subscribe
    public void actionPerformed(GuiClickEvent event) {
        if (!(event.getGui() instanceof class_433)) {
            return;
        }
        if (this.openToFriends != null && this.openToFriends.method_25405(event.getMouseX(), event.getMouseY()) && this.openToFriends.field_22763 && this.window != null) {
            InviteFriendsPopup.openInviteToFriendsMenu(this.window);
            event.setCancelled(true);
        }
    }
}

