/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.elementa.svg.data;

import gg.essential.elementa.svg.data.Point;
import gg.essential.elementa.svg.data.SVGElement;
import java.nio.FloatBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0016\b\u0086\b\u0018\u0000 >2\u00020\u0001:\u0001>B?\u0012\u0006\u0010\u0011\u001a\u00020\u0002\u0012\u0006\u0010\u0012\u001a\u00020\u0005\u0012\u0006\u0010\u0013\u001a\u00020\u0005\u0012\u0006\u0010\u0014\u001a\u00020\t\u0012\u0006\u0010\u0015\u001a\u00020\f\u0012\u0006\u0010\u0016\u001a\u00020\f\u0012\u0006\u0010\u0017\u001a\u00020\u0002\u00a2\u0006\u0004\b<\u0010=J\u0010\u0010\u0003\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0006\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\b\u0010\u0007J\u0010\u0010\n\u001a\u00020\tH\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\r\u001a\u00020\fH\u00c6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\fH\u00c6\u0003\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\u0010\u0010\u0010\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0004JV\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0011\u001a\u00020\u00022\b\b\u0002\u0010\u0012\u001a\u00020\u00052\b\b\u0002\u0010\u0013\u001a\u00020\u00052\b\b\u0002\u0010\u0014\u001a\u00020\t2\b\b\u0002\u0010\u0015\u001a\u00020\f2\b\b\u0002\u0010\u0016\u001a\u00020\f2\b\b\u0002\u0010\u0017\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001aH\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u000f\u0010\u001e\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u001e\u0010\u000eJ\u001a\u0010!\u001a\u00020\f2\b\u0010 \u001a\u0004\u0018\u00010\u001fH\u00d6\u0003\u00a2\u0006\u0004\b!\u0010\"J\u000f\u0010#\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b#\u0010\u000bJ\u0010\u0010$\u001a\u00020\tH\u00d6\u0001\u00a2\u0006\u0004\b$\u0010\u000bJ\u0017\u0010'\u001a\u00020%2\u0006\u0010&\u001a\u00020%H\u0002\u00a2\u0006\u0004\b'\u0010(J\u0010\u0010*\u001a\u00020)H\u00d6\u0001\u00a2\u0006\u0004\b*\u0010+R\u0016\u0010,\u001a\u00020%8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b,\u0010-R\u0016\u0010.\u001a\u00020%8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b.\u0010-R\u0017\u0010\u0017\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0017\u0010/\u001a\u0004\b0\u0010\u0004R\u0017\u0010\u0015\u001a\u00020\f8\u0006\u00a2\u0006\f\n\u0004\b\u0015\u00101\u001a\u0004\b2\u0010\u000eR\u0017\u0010\u0012\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0012\u00103\u001a\u0004\b4\u0010\u0007R\u0017\u0010\u0013\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0013\u00103\u001a\u0004\b5\u0010\u0007R\u0017\u0010\u0011\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0011\u0010/\u001a\u0004\b6\u0010\u0004R\u0016\u00107\u001a\u00020%8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b7\u0010-R\u0017\u0010\u0016\u001a\u00020\f8\u0006\u00a2\u0006\f\n\u0004\b\u0016\u00101\u001a\u0004\b8\u0010\u000eR\u0016\u00109\u001a\u00020%8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b9\u0010-R\u0017\u0010\u0014\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\u0014\u0010:\u001a\u0004\b;\u0010\u000b\u00a8\u0006?"}, d2={"Lgg/essential/elementa/svg/data/SVGArc;", "Lgg/essential/elementa/svg/data/SVGElement;", "Lgg/essential/elementa/svg/data/Point;", "component1", "()Lgg/essential/elementa/svg/data/Point;", "", "component2", "()F", "component3", "", "component4", "()I", "", "component5", "()Z", "component6", "component7", "startPoint", "rx", "ry", "xAxisRotation", "largeArc", "sweep", "endPoint", "copy", "(Lgg/essential/elementa/svg/data/Point;FFIZZLgg/essential/elementa/svg/data/Point;)Lgg/essential/elementa/svg/data/SVGArc;", "Ljava/nio/FloatBuffer;", "buffer", "createBuffer", "(Ljava/nio/FloatBuffer;)I", "drawSmoothPoints", "", "other", "equals", "(Ljava/lang/Object;)Z", "getVertexCount", "hashCode", "", "value", "safeAcos", "(D)D", "", "toString", "()Ljava/lang/String;", "cx", "D", "cy", "Lgg/essential/elementa/svg/data/Point;", "getEndPoint", "Z", "getLargeArc", "F", "getRx", "getRy", "getStartPoint", "startTheta", "getSweep", "thetaDifference", "I", "getXAxisRotation", "<init>", "(Lgg/essential/elementa/svg/data/Point;FFIZZLgg/essential/elementa/svg/data/Point;)V", "Companion", "Elementa"})
public final class SVGArc
extends SVGElement {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Point startPoint;
    private final float rx;
    private final float ry;
    private final int xAxisRotation;
    private final boolean largeArc;
    private final boolean sweep;
    @NotNull
    private final Point endPoint;
    private double cx;
    private double cy;
    private double startTheta;
    private double thetaDifference;
    private static final double TWO_PI = Math.PI * 2;

    public SVGArc(@NotNull Point startPoint, float rx, float ry, int xAxisRotation, boolean largeArc, boolean sweep, @NotNull Point endPoint) {
        Intrinsics.checkNotNullParameter(startPoint, "startPoint");
        Intrinsics.checkNotNullParameter(endPoint, "endPoint");
        this.startPoint = startPoint;
        this.rx = rx;
        this.ry = ry;
        this.xAxisRotation = xAxisRotation;
        this.largeArc = largeArc;
        this.sweep = sweep;
        this.endPoint = endPoint;
        double angleRad = Math.toRadians((double)this.xAxisRotation % 360.0);
        double cosAngle = Math.cos(angleRad);
        double sinAngle = Math.sin(angleRad);
        double dx2 = (double)(this.startPoint.getX() - this.endPoint.getX()) / 2.0;
        double dy2 = (double)(this.startPoint.getY() - this.endPoint.getY()) / 2.0;
        double x1 = cosAngle * dx2 + sinAngle * dy2;
        double y1 = -sinAngle * dx2 + cosAngle * dy2;
        double radiusX = this.rx;
        double radiusY = this.ry;
        double squareRX = radiusX * radiusX;
        double squareRY = radiusY * radiusY;
        double squareX1 = x1 * x1;
        double squareY1 = y1 * y1;
        double radiiCheck = squareX1 / squareRX + squareY1 / squareRY;
        if (radiiCheck > 0.99999) {
            double radiiScale = Math.sqrt(radiiCheck) * 1.00001;
            radiusX = radiiScale * radiusX;
            radiusY = radiiScale * radiusY;
            squareRX = radiusX * radiusX;
            squareRY = radiusY * radiusY;
        }
        double sign = this.largeArc == this.sweep ? -1.0 : 1.0;
        double sq = RangesKt.coerceAtLeast((squareRX * squareRY - squareRX * squareY1 - squareRY * squareX1) / (squareRX * squareY1 + squareRY * squareX1), 0.0);
        double coefficient = sign * Math.sqrt(sq);
        double cx1 = coefficient * (radiusX * y1 / radiusY);
        double cy1 = coefficient * -(radiusY * x1 / radiusX);
        double sx2 = (double)(this.startPoint.getX() + this.endPoint.getX()) / 2.0;
        double sy2 = (double)(this.startPoint.getY() + this.endPoint.getY()) / 2.0;
        this.cx = sx2 + (cosAngle * cx1 - sinAngle * cy1);
        this.cy = sy2 + (sinAngle * cx1 + cosAngle * cy1);
        double ux = (x1 - cx1) / radiusX;
        double uy = (y1 - cy1) / radiusY;
        double vx = (-x1 - cx1) / radiusX;
        double vy = (-y1 - cy1) / radiusY;
        double n = Math.sqrt(ux * ux + uy * uy);
        double p = ux;
        sign = uy < 0.0 ? -1.0 : 1.0;
        this.startTheta = sign * Math.acos(p / n);
        n = Math.sqrt((ux * ux + uy * uy) * (vx * vx + vy * vy));
        p = ux * vx + uy * vy;
        sign = ux * vy - uy * vx < 0.0 ? -1.0 : 1.0;
        this.thetaDifference = sign * this.safeAcos(p / n);
        if (!this.sweep && this.thetaDifference > 0.0) {
            this.thetaDifference -= Math.PI * 2;
        } else if (this.sweep && this.thetaDifference < 0.0) {
            this.thetaDifference += Math.PI * 2;
        }
        this.thetaDifference %= Math.PI * 2;
        this.startTheta %= Math.PI * 2;
    }

    @NotNull
    public final Point getStartPoint() {
        return this.startPoint;
    }

    public final float getRx() {
        return this.rx;
    }

    public final float getRy() {
        return this.ry;
    }

    public final int getXAxisRotation() {
        return this.xAxisRotation;
    }

    public final boolean getLargeArc() {
        return this.largeArc;
    }

    public final boolean getSweep() {
        return this.sweep;
    }

    @NotNull
    public final Point getEndPoint() {
        return this.endPoint;
    }

    @Override
    public int getVertexCount() {
        return (int)Math.ceil(Math.abs(this.thetaDifference) / (Math.PI * 2) * (double)25) + 1;
    }

    @Override
    public int createBuffer(@NotNull FloatBuffer buffer) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        int numVertices = this.getVertexCount();
        double thetaPerVertex = this.thetaDifference / (double)(numVertices - 1);
        double currTheta = 0.0;
        currTheta = this.startTheta;
        int n = 0;
        int n2 = numVertices;
        while (n < n2) {
            int it = n++;
            boolean bl = false;
            buffer.put((float)(this.cx + (double)this.getRx() * Math.cos(currTheta)));
            buffer.put((float)(this.cy + (double)this.getRy() * Math.sin(currTheta)));
            currTheta += thetaPerVertex;
        }
        return 3;
    }

    private final double safeAcos(double value2) {
        return value2 < -1.0 ? Math.PI : (value2 > 1.0 ? 0.0 : Math.acos(value2));
    }

    @Override
    public boolean drawSmoothPoints() {
        return false;
    }

    @NotNull
    public final Point component1() {
        return this.startPoint;
    }

    public final float component2() {
        return this.rx;
    }

    public final float component3() {
        return this.ry;
    }

    public final int component4() {
        return this.xAxisRotation;
    }

    public final boolean component5() {
        return this.largeArc;
    }

    public final boolean component6() {
        return this.sweep;
    }

    @NotNull
    public final Point component7() {
        return this.endPoint;
    }

    @NotNull
    public final SVGArc copy(@NotNull Point startPoint, float rx, float ry, int xAxisRotation, boolean largeArc, boolean sweep, @NotNull Point endPoint) {
        Intrinsics.checkNotNullParameter(startPoint, "startPoint");
        Intrinsics.checkNotNullParameter(endPoint, "endPoint");
        return new SVGArc(startPoint, rx, ry, xAxisRotation, largeArc, sweep, endPoint);
    }

    public static /* synthetic */ SVGArc copy$default(SVGArc sVGArc, Point point, float f, float f2, int n, boolean bl, boolean bl2, Point point2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            point = sVGArc.startPoint;
        }
        if ((n2 & 2) != 0) {
            f = sVGArc.rx;
        }
        if ((n2 & 4) != 0) {
            f2 = sVGArc.ry;
        }
        if ((n2 & 8) != 0) {
            n = sVGArc.xAxisRotation;
        }
        if ((n2 & 0x10) != 0) {
            bl = sVGArc.largeArc;
        }
        if ((n2 & 0x20) != 0) {
            bl2 = sVGArc.sweep;
        }
        if ((n2 & 0x40) != 0) {
            point2 = sVGArc.endPoint;
        }
        return sVGArc.copy(point, f, f2, n, bl, bl2, point2);
    }

    @NotNull
    public String toString() {
        return "SVGArc(startPoint=" + this.startPoint + ", rx=" + this.rx + ", ry=" + this.ry + ", xAxisRotation=" + this.xAxisRotation + ", largeArc=" + this.largeArc + ", sweep=" + this.sweep + ", endPoint=" + this.endPoint + ')';
    }

    public int hashCode() {
        int result2 = this.startPoint.hashCode();
        result2 = result2 * 31 + Float.hashCode(this.rx);
        result2 = result2 * 31 + Float.hashCode(this.ry);
        result2 = result2 * 31 + Integer.hashCode(this.xAxisRotation);
        int n = this.largeArc ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result2 = result2 * 31 + n;
        int n2 = this.sweep ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        result2 = result2 * 31 + n2;
        result2 = result2 * 31 + this.endPoint.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SVGArc)) {
            return false;
        }
        SVGArc sVGArc = (SVGArc)other;
        if (!Intrinsics.areEqual(this.startPoint, sVGArc.startPoint)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.rx), (Object)Float.valueOf(sVGArc.rx))) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.ry), (Object)Float.valueOf(sVGArc.ry))) {
            return false;
        }
        if (this.xAxisRotation != sVGArc.xAxisRotation) {
            return false;
        }
        if (this.largeArc != sVGArc.largeArc) {
            return false;
        }
        if (this.sweep != sVGArc.sweep) {
            return false;
        }
        return Intrinsics.areEqual(this.endPoint, sVGArc.endPoint);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0007"}, d2={"Lgg/essential/elementa/svg/data/SVGArc$Companion;", "", "", "TWO_PI", "D", "<init>", "()V", "Elementa"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

