/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.elementa.svg;

import gg.essential.elementa.impl.dom4j.Document;
import gg.essential.elementa.impl.dom4j.Element;
import gg.essential.elementa.impl.dom4j.io.SAXReader;
import gg.essential.elementa.svg.PathParser;
import gg.essential.elementa.svg.data.Rotation;
import gg.essential.elementa.svg.data.SVG;
import gg.essential.elementa.svg.data.SVGCircle;
import gg.essential.elementa.svg.data.SVGElement;
import gg.essential.elementa.svg.data.SVGLine;
import gg.essential.elementa.svg.data.SVGPolyline;
import gg.essential.elementa.svg.data.SVGRect;
import gg.essential.elementa.svg.data.Transform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001dB\t\b\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\t\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u001d\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001b\u0010\u0016\u001a\u0004\u0018\u00010\u00152\b\u0010\u0011\u001a\u0004\u0018\u00010\u0007H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0019\u001a\u00020\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001e"}, d2={"Lgg/essential/elementa/svg/SVGParser;", "", "Lgg/essential/elementa/impl/dom4j/Document;", "document", "Lgg/essential/elementa/svg/data/SVG;", "parseDocument", "(Lgg/essential/elementa/impl/dom4j/Document;)Lgg/essential/elementa/svg/data/SVG;", "", "file", "parseFromResource", "(Ljava/lang/String;)Lgg/essential/elementa/svg/data/SVG;", "Lgg/essential/elementa/impl/dom4j/Element;", "el", "", "Lgg/essential/elementa/svg/data/SVGElement;", "parsePath", "(Lgg/essential/elementa/impl/dom4j/Element;)Ljava/util/List;", "attributeString", "Lgg/essential/elementa/svg/data/Transform;", "parseTransform", "(Ljava/lang/String;)Lgg/essential/elementa/svg/data/Transform;", "Lgg/essential/elementa/svg/SVGParser$Viewbox;", "parseViewbox", "(Ljava/lang/String;)Lgg/essential/elementa/svg/SVGParser$Viewbox;", "Lkotlin/text/Regex;", "VIEWBOX_WHITESPACE", "Lkotlin/text/Regex;", "<init>", "()V", "Viewbox", "Elementa"})
public final class SVGParser {
    @NotNull
    public static final SVGParser INSTANCE = new SVGParser();
    @NotNull
    private static final Regex VIEWBOX_WHITESPACE = new Regex("[ ,]+");

    private SVGParser() {
    }

    @NotNull
    public final SVG parseFromResource(@NotNull String file) {
        Intrinsics.checkNotNullParameter(file, "file");
        SAXReader reader = new SAXReader();
        Document document = reader.read(this.getClass().getResourceAsStream(file));
        Intrinsics.checkNotNullExpressionValue(document, "document");
        return this.parseDocument(document);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final SVG parseDocument(Document document) {
        Element svg = document.getRootElement();
        String string = svg.attributeValue("stroke-width", "1");
        Intrinsics.checkNotNullExpressionValue(string, "svg.attributeValue(\"stroke-width\", \"1\")");
        float svgStrokeWidth = Float.parseFloat(string);
        boolean svgRoundLineCaps = svg.attributeValue("stroke-linecap") != null;
        boolean svgRoundLineJoins = svg.attributeValue("stroke-linejoin") != null;
        Viewbox viewBox = this.parseViewbox(svg.attributeValue("viewBox"));
        List elements = new ArrayList();
        block16: for (Element element : svg.elements()) {
            List<SVGElement> list;
            String string2 = element.getName();
            if (string2 == null) throw new UnsupportedOperationException("Element type " + element.getName() + " is not supported!");
            int n = -1;
            switch (string2.hashCode()) {
                case 3433509: {
                    if (string2.equals("path")) {
                        n = 1;
                    }
                    break;
                }
                case 3496420: {
                    if (string2.equals("rect")) {
                        n = 2;
                    }
                    break;
                }
                case 3321844: {
                    if (string2.equals("line")) {
                        n = 3;
                    }
                    break;
                }
                case -1360216880: {
                    if (string2.equals("circle")) {
                        n = 4;
                    }
                    break;
                }
                case 561938880: {
                    if (string2.equals("polyline")) {
                        n = 5;
                    }
                    break;
                }
            }
            switch (n) {
                case 4: {
                    Intrinsics.checkNotNullExpressionValue(element, "element");
                    list = CollectionsKt.listOf(SVGCircle.Companion.from$Elementa(element));
                    break;
                }
                case 3: {
                    Intrinsics.checkNotNullExpressionValue(element, "element");
                    list = CollectionsKt.listOf(SVGLine.Companion.from$Elementa(element));
                    break;
                }
                case 5: {
                    Intrinsics.checkNotNullExpressionValue(element, "element");
                    list = CollectionsKt.listOf(SVGPolyline.Companion.from$Elementa(element));
                    break;
                }
                case 1: {
                    List<SVGElement> list2;
                    try {
                        Intrinsics.checkNotNullExpressionValue(element, "element");
                        list2 = this.parsePath(element);
                    }
                    catch (PathParser.PathParseException e) {
                        e.printStackTrace();
                        break block16;
                    }
                    list = list2;
                    break;
                }
                case 2: {
                    Intrinsics.checkNotNullExpressionValue(element, "element");
                    list = CollectionsKt.listOf(SVGRect.Companion.from$Elementa(element));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Element type " + element.getName() + " is not supported!");
                }
            }
            List<SVGElement> list3 = list;
            if (element.attributeValue("transform") != null) {
                String attribute;
                boolean bl = false;
                Transform transform2 = INSTANCE.parseTransform(attribute);
                Iterable $this$forEach$iv = list3;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    SVGElement el = (SVGElement)element$iv;
                    boolean bl2 = false;
                    el.getAttributes().setTransform(transform2);
                }
            }
            elements.addAll((Collection)list3);
        }
        Viewbox viewbox2 = viewBox;
        viewbox2 = viewBox;
        return new SVG(elements, viewbox == null ? null : Float.valueOf(viewbox.getWidth()), viewbox2 == null ? null : Float.valueOf(viewbox2.getHeight()), svgStrokeWidth, svgRoundLineCaps, svgRoundLineJoins);
    }

    /*
     * WARNING - void declaration
     */
    private final Transform parseTransform(String attributeString) {
        Object attributes = attributeString;
        Transform transform2 = new Transform(null, 1, null);
        while (((CharSequence)attributes).length() > 0) {
            String[] stringArray;
            int n;
            int n2;
            int firstOpenParen;
            int n3;
            int n4;
            block11: {
                int n5;
                block10: {
                    CharSequence $this$indexOfFirst$iv = (CharSequence)attributes;
                    boolean $i$f$indexOfFirst = false;
                    n4 = 0;
                    n3 = $this$indexOfFirst$iv.length();
                    while (n4 < n3) {
                        void index$iv;
                        char it = $this$indexOfFirst$iv.charAt((int)index$iv);
                        boolean bl = false;
                        if (it == '(') {
                            n5 = index$iv;
                            break block10;
                        }
                        ++index$iv;
                    }
                    n5 = -1;
                }
                firstOpenParen = n5;
                CharSequence $this$indexOfFirst$iv = (CharSequence)attributes;
                boolean $i$f$indexOfFirst = false;
                n3 = 0;
                n2 = $this$indexOfFirst$iv.length();
                while (n3 < n2) {
                    void index$iv;
                    char it = $this$indexOfFirst$iv.charAt((int)index$iv);
                    boolean bl = false;
                    if (it == ')') {
                        n = index$iv;
                        break block11;
                    }
                    ++index$iv;
                }
                n = -1;
            }
            int firstCloseParen = n;
            String[] $i$f$indexOfFirst = attributes;
            n3 = 0;
            if ($i$f$indexOfFirst == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string = $i$f$indexOfFirst.substring(n3, firstOpenParen);
            Intrinsics.checkNotNullExpressionValue(string, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            if (Intrinsics.areEqual(string, "rotate")) {
                stringArray = attributes;
                n2 = firstOpenParen + 1;
                if (stringArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
            } else {
                throw (Throwable)new NotImplementedError(null, 1, null);
            }
            String string2 = stringArray.substring(n2, firstCloseParen);
            Intrinsics.checkNotNullExpressionValue(string2, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            stringArray = new String[]{" "};
            List parameters2 = StringsKt.split$default((CharSequence)string2, stringArray, false, 0, 6, null);
            String string3 = (String)CollectionsKt.getOrNull(parameters2, 1);
            String string4 = (String)CollectionsKt.getOrNull(parameters2, 2);
            transform2.setRotation(new Rotation(Integer.parseInt((String)CollectionsKt.first(parameters2)), (Float)(string3 == null ? null : StringsKt.toFloatOrNull(string3)), (Float)(string4 == null ? null : StringsKt.toFloatOrNull(string4))));
            String[] stringArray2 = attributes;
            n4 = firstCloseParen + 1;
            if (stringArray2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkNotNullExpressionValue(stringArray2.substring(n4), "(this as java.lang.String).substring(startIndex)");
        }
        return transform2;
    }

    /*
     * WARNING - void declaration
     */
    private final Viewbox parseViewbox(String attributeString) {
        if (attributeString == null) {
            return null;
        }
        try {
            void $this$mapTo$iv$iv;
            String[] stringArray = (String[])attributeString;
            Regex regex = VIEWBOX_WHITESPACE;
            Object object = " ";
            CharSequence charSequence = regex.replace((CharSequence)stringArray, (String)object);
            stringArray = new String[]{" "};
            Iterable $this$map$iv = StringsKt.split$default(charSequence, stringArray, false, 0, 6, null);
            boolean $i$f$map = false;
            object = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Float.valueOf(Float.parseFloat((String)it)));
            }
            List splits = (List)destination$iv$iv;
            if (splits.size() >= 3 && ((Number)splits.get(2)).floatValue() <= 0.0f) {
                return null;
            }
            if (splits.size() >= 4 && ((Number)splits.get(3)).floatValue() <= 0.0f) {
                return null;
            }
            return new Viewbox(((Number)splits.get(0)).floatValue(), ((Number)splits.get(1)).floatValue(), ((Number)splits.get(2)).floatValue(), ((Number)splits.get(3)).floatValue());
        }
        catch (Exception e) {
            return null;
        }
    }

    private final List<SVGElement> parsePath(Element el) {
        String string = el.attributeValue("d");
        Intrinsics.checkNotNullExpressionValue(string, "el.attributeValue(\"d\")");
        return new PathParser(((Object)StringsKt.trim((CharSequence)string)).toString()).parse();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0007\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\b\u0082\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\b\u001a\u00020\u0002\u0012\u0006\u0010\t\u001a\u00020\u0002\u0012\u0006\u0010\n\u001a\u00020\u0002\u0012\u0006\u0010\u000b\u001a\u00020\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0010\u0010\u0003\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0004J\u0010\u0010\u0006\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0007\u0010\u0004J8\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\b\u001a\u00020\u00022\b\b\u0002\u0010\t\u001a\u00020\u00022\b\b\u0002\u0010\n\u001a\u00020\u00022\b\b\u0002\u0010\u000b\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010\u0010\u001a\u00020\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0013\u001a\u00020\u0012H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0016\u001a\u00020\u0015H\u00d6\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u0017\u0010\u000b\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010\u0018\u001a\u0004\b\u0019\u0010\u0004R\u0017\u0010\n\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\u0018\u001a\u0004\b\u001a\u0010\u0004R\u0017\u0010\b\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\u0018\u001a\u0004\b\u001b\u0010\u0004R\u0017\u0010\t\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u0018\u001a\u0004\b\u001c\u0010\u0004\u00a8\u0006\u001f"}, d2={"Lgg/essential/elementa/svg/SVGParser$Viewbox;", "", "", "component1", "()F", "component2", "component3", "component4", "x", "y", "width", "height", "copy", "(FFFF)Lgg/essential/elementa/svg/SVGParser$Viewbox;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "F", "getHeight", "getWidth", "getX", "getY", "<init>", "(FFFF)V", "Elementa"})
    private static final class Viewbox {
        private final float x;
        private final float y;
        private final float width;
        private final float height;

        public Viewbox(float x, float y, float width, float height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        public final float getX() {
            return this.x;
        }

        public final float getY() {
            return this.y;
        }

        public final float getWidth() {
            return this.width;
        }

        public final float getHeight() {
            return this.height;
        }

        public final float component1() {
            return this.x;
        }

        public final float component2() {
            return this.y;
        }

        public final float component3() {
            return this.width;
        }

        public final float component4() {
            return this.height;
        }

        @NotNull
        public final Viewbox copy(float x, float y, float width, float height) {
            return new Viewbox(x, y, width, height);
        }

        public static /* synthetic */ Viewbox copy$default(Viewbox viewbox, float f, float f2, float f3, float f4, int n, Object object) {
            if ((n & 1) != 0) {
                f = viewbox.x;
            }
            if ((n & 2) != 0) {
                f2 = viewbox.y;
            }
            if ((n & 4) != 0) {
                f3 = viewbox.width;
            }
            if ((n & 8) != 0) {
                f4 = viewbox.height;
            }
            return viewbox.copy(f, f2, f3, f4);
        }

        @NotNull
        public String toString() {
            return "Viewbox(x=" + this.x + ", y=" + this.y + ", width=" + this.width + ", height=" + this.height + ')';
        }

        public int hashCode() {
            int result2 = Float.hashCode(this.x);
            result2 = result2 * 31 + Float.hashCode(this.y);
            result2 = result2 * 31 + Float.hashCode(this.width);
            result2 = result2 * 31 + Float.hashCode(this.height);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Viewbox)) {
                return false;
            }
            Viewbox viewbox = (Viewbox)other;
            if (!Intrinsics.areEqual((Object)Float.valueOf(this.x), (Object)Float.valueOf(viewbox.x))) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)Float.valueOf(this.y), (Object)Float.valueOf(viewbox.y))) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)Float.valueOf(this.width), (Object)Float.valueOf(viewbox.width))) {
                return false;
            }
            return Intrinsics.areEqual((Object)Float.valueOf(this.height), (Object)Float.valueOf(viewbox.height));
        }
    }
}

