/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.elementa.shaders;

import gg.essential.elementa.shaders.Shaders;
import gg.essential.universal.UGraphics;
import java.net.URL;
import java.nio.charset.Charset;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.GL20;

@Deprecated(message="Use UniversalCraft's UShader instead.")
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\r\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\"\u001a\u00020\u0006\u0012\u0006\u0010\u0010\u001a\u00020\u0006\u00a2\u0006\u0004\b&\u0010'J\r\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\u0005\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0004J\u0015\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\r\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\r\u0010\u000f\u001a\u00020\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0004R\u0014\u0010\u0010\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011R\"\u0010\u0012\u001a\u00020\b8\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\"\u0010\u0018\u001a\u00020\b8\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0013\u001a\u0004\b\u0019\u0010\u0015\"\u0004\b\u001a\u0010\u0017R\"\u0010\u001c\u001a\u00020\u001b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010\u0011R\"\u0010#\u001a\u00020\b8\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\b#\u0010\u0013\u001a\u0004\b$\u0010\u0015\"\u0004\b%\u0010\u0017\u00a8\u0006("}, d2={"Lgg/essential/elementa/shaders/Shader;", "", "", "bindIfUsable", "()V", "createShader", "", "uniformName", "", "getUniformLocation", "(Ljava/lang/String;)I", "name", "ext", "readShader", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "unbindIfUsable", "fragName", "Ljava/lang/String;", "fragShader", "I", "getFragShader", "()I", "setFragShader", "(I)V", "program", "getProgram", "setProgram", "", "usable", "Z", "getUsable", "()Z", "setUsable", "(Z)V", "vertName", "vertShader", "getVertShader", "setVertShader", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "Elementa"})
public class Shader {
    @NotNull
    private final String vertName;
    @NotNull
    private final String fragName;
    private int vertShader;
    private int fragShader;
    private int program;
    private boolean usable;

    public Shader(@NotNull String vertName, @NotNull String fragName) {
        Intrinsics.checkNotNullParameter(vertName, "vertName");
        Intrinsics.checkNotNullParameter(fragName, "fragName");
        this.vertName = vertName;
        this.fragName = fragName;
        this.createShader();
    }

    protected final int getVertShader() {
        return this.vertShader;
    }

    protected final void setVertShader(int n) {
        this.vertShader = n;
    }

    protected final int getFragShader() {
        return this.fragShader;
    }

    protected final void setFragShader(int n) {
        this.fragShader = n;
    }

    protected final int getProgram() {
        return this.program;
    }

    protected final void setProgram(int n) {
        this.program = n;
    }

    public final boolean getUsable() {
        return this.usable;
    }

    public final void setUsable(boolean bl) {
        this.usable = bl;
    }

    public final void bindIfUsable() {
        if (this.usable) {
            UGraphics.glUseProgram(this.program);
        }
    }

    public final void unbindIfUsable() {
        if (this.usable) {
            UGraphics.glUseProgram(0);
        }
    }

    public final int getUniformLocation(@NotNull String uniformName) {
        Intrinsics.checkNotNullParameter(uniformName, "uniformName");
        return Shaders.INSTANCE.getNewShaders() ? GL20.glGetUniformLocation((int)this.program, (CharSequence)uniformName) : ARBShaderObjects.glGetUniformLocationARB((int)this.program, (CharSequence)uniformName);
    }

    private final void createShader() {
        this.program = UGraphics.glCreateProgram();
        this.vertShader = UGraphics.glCreateShader(35633);
        if (Shaders.INSTANCE.getNewShaders()) {
            GL20.glShaderSource((int)this.vertShader, (CharSequence)this.readShader(this.vertName, "vsh"));
        } else {
            ARBShaderObjects.glShaderSourceARB((int)this.vertShader, (CharSequence)this.readShader(this.vertName, "vsh"));
        }
        UGraphics.glCompileShader(this.vertShader);
        if (UGraphics.glGetShaderi(this.vertShader, 35713) != 1) {
            System.out.println((Object)UGraphics.glGetShaderInfoLog(this.vertShader, 32768));
            return;
        }
        this.fragShader = UGraphics.glCreateShader(35632);
        if (Shaders.INSTANCE.getNewShaders()) {
            GL20.glShaderSource((int)this.fragShader, (CharSequence)this.readShader(this.fragName, "fsh"));
        } else {
            ARBShaderObjects.glShaderSourceARB((int)this.fragShader, (CharSequence)this.readShader(this.fragName, "fsh"));
        }
        UGraphics.glCompileShader(this.fragShader);
        if (UGraphics.glGetShaderi(this.fragShader, 35713) != 1) {
            System.out.println((Object)UGraphics.glGetShaderInfoLog(this.fragShader, 32768));
            return;
        }
        UGraphics.glAttachShader(this.program, this.vertShader);
        UGraphics.glAttachShader(this.program, this.fragShader);
        UGraphics.glLinkProgram(this.program);
        if (Shaders.INSTANCE.getNewShaders()) {
            GL20.glDetachShader((int)this.program, (int)this.vertShader);
            GL20.glDetachShader((int)this.program, (int)this.fragShader);
            GL20.glDeleteShader((int)this.vertShader);
            GL20.glDeleteShader((int)this.fragShader);
        } else {
            ARBShaderObjects.glDetachObjectARB((int)this.program, (int)this.vertShader);
            ARBShaderObjects.glDetachObjectARB((int)this.program, (int)this.fragShader);
            ARBShaderObjects.glDeleteObjectARB((int)this.vertShader);
            ARBShaderObjects.glDeleteObjectARB((int)this.fragShader);
        }
        if (UGraphics.glGetProgrami(this.program, 35714) != 1) {
            System.out.println((Object)UGraphics.glGetProgramInfoLog(this.program, 32768));
            return;
        }
        if (Shaders.INSTANCE.getNewShaders()) {
            GL20.glValidateProgram((int)this.program);
        } else {
            ARBShaderObjects.glValidateProgramARB((int)this.program);
        }
        if (UGraphics.glGetProgrami(this.program, 35715) != 1) {
            System.out.println((Object)UGraphics.glGetProgramInfoLog(this.program, 32768));
            return;
        }
        this.usable = true;
    }

    private final String readShader(String name, String ext) {
        URL uRL = this.getClass().getResource("/shaders/" + name + '.' + ext);
        Intrinsics.checkNotNullExpressionValue(uRL, "this::class.java.getReso\u2026ce(\"/shaders/$name.$ext\")");
        Charset charset = Charsets.UTF_8;
        byte[] byArray = TextStreamsKt.readBytes(uRL);
        return new String(byArray, charset);
    }
}

