/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.elementa.markdown.drawables;

import gg.essential.elementa.components.UIBlock;
import gg.essential.elementa.components.UIRoundedRectangle;
import gg.essential.elementa.dsl.UtilitiesKt;
import gg.essential.elementa.font.FontProvider;
import gg.essential.elementa.markdown.DrawState;
import gg.essential.elementa.markdown.HeaderLevelConfig;
import gg.essential.elementa.markdown.InlineCodeConfig;
import gg.essential.elementa.markdown.MarkdownComponent;
import gg.essential.elementa.markdown.MarkdownConfig;
import gg.essential.elementa.markdown.drawables.Drawable;
import gg.essential.elementa.markdown.selection.TextCursor;
import gg.essential.universal.UMatrixStack;
import gg.essential.universal.UMouse;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 _2\u00020\u0001:\u0004_`abB\u001f\u0012\u0006\u0010[\u001a\u00020Z\u0012\u0006\u0010\\\u001a\u00020!\u0012\u0006\u0010R\u001a\u00020Q\u00a2\u0006\u0004\b]\u0010^J\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J/\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0014\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0013J\u001f\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\r\u0010\u0019\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0019\u0010\u001aJ'\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0007H\u0014\u00a2\u0006\u0004\b\u001f\u0010 J\r\u0010\"\u001a\u00020!\u00a2\u0006\u0004\b\"\u0010#J\u0017\u0010%\u001a\u00020!2\u0006\u0010$\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b%\u0010&J-\u0010*\u001a\u0010\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u0000\u0018\u00010)2\u0006\u0010'\u001a\u00020\u00072\b\b\u0002\u0010(\u001a\u00020\n\u00a2\u0006\u0004\b*\u0010+J\u000f\u0010,\u001a\u00020!H\u0016\u00a2\u0006\u0004\b,\u0010#J\r\u0010\u001d\u001a\u00020\u0007\u00a2\u0006\u0004\b\u001d\u0010-R$\u0010/\u001a\u00020!2\u0006\u0010.\u001a\u00020!8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b/\u00100\u001a\u0004\b1\u0010#R.\u00104\u001a\u0004\u0018\u0001022\b\u00103\u001a\u0004\u0018\u0001028\u0000@@X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b4\u00105\u001a\u0004\b6\u00107\"\u0004\b8\u00109R\u0016\u0010:\u001a\u00020\n8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b:\u0010;R$\u0010=\u001a\u0004\u0018\u00010<8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b=\u0010>\u001a\u0004\b?\u0010@\"\u0004\bA\u0010BR\"\u0010C\u001a\u00020\u00078\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bC\u0010D\u001a\u0004\bE\u0010-\"\u0004\bF\u0010GR\"\u0010H\u001a\u00020\f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bH\u0010I\u001a\u0004\bJ\u0010K\"\u0004\bL\u0010MR\"\u0010N\u001a\u00020\f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bN\u0010I\u001a\u0004\bO\u0010K\"\u0004\bP\u0010MR\u0017\u0010R\u001a\u00020Q8\u0006\u00a2\u0006\f\n\u0004\bR\u0010S\u001a\u0004\bT\u0010UR\u001c\u0010X\u001a\b\u0012\u0004\u0012\u00020W0V8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bX\u0010Y\u00a8\u0006c"}, d2={"Lgg/essential/elementa/markdown/drawables/TextDrawable;", "Lgg/essential/elementa/markdown/drawables/Drawable;", "Lgg/essential/elementa/markdown/DrawState;", "state", "", "beforeDraw", "(Lgg/essential/elementa/markdown/DrawState;)V", "", "mouseX", "mouseY", "", "dragged", "", "mouseButton", "", "cursorAt", "(FFZI)Ljava/lang/Void;", "Lgg/essential/elementa/markdown/selection/TextCursor;", "cursorAtEnd", "()Lgg/essential/elementa/markdown/selection/TextCursor;", "cursorAtStart", "Lgg/essential/universal/UMatrixStack;", "matrixStack", "draw", "(Lgg/essential/universal/UMatrixStack;Lgg/essential/elementa/markdown/DrawState;)V", "ensureTrimmed", "()V", "x", "y", "width", "Lgg/essential/elementa/markdown/drawables/Drawable$Layout;", "layoutImpl", "(FFF)Lgg/essential/elementa/markdown/drawables/Drawable$Layout;", "", "plainText", "()Ljava/lang/String;", "asMarkdown", "selectedText", "(Z)Ljava/lang/String;", "maxWidth", "breakWords", "Lkotlin/Pair;", "split", "(FZ)Lkotlin/Pair;", "toString", "()F", "<set-?>", "formattedText", "Ljava/lang/String;", "getFormattedText", "Lgg/essential/elementa/markdown/HeaderLevelConfig;", "value", "headerConfig", "Lgg/essential/elementa/markdown/HeaderLevelConfig;", "getHeaderConfig$Elementa", "()Lgg/essential/elementa/markdown/HeaderLevelConfig;", "setHeaderConfig$Elementa", "(Lgg/essential/elementa/markdown/HeaderLevelConfig;)V", "isHovered", "Z", "Lgg/essential/elementa/markdown/drawables/TextDrawable$LinkedTexts;", "linkedTexts", "Lgg/essential/elementa/markdown/drawables/TextDrawable$LinkedTexts;", "getLinkedTexts", "()Lgg/essential/elementa/markdown/drawables/TextDrawable$LinkedTexts;", "setLinkedTexts", "(Lgg/essential/elementa/markdown/drawables/TextDrawable$LinkedTexts;)V", "scaleModifier", "F", "getScaleModifier", "setScaleModifier", "(F)V", "selectionEnd", "I", "getSelectionEnd", "()I", "setSelectionEnd", "(I)V", "selectionStart", "getSelectionStart", "setSelectionStart", "Lgg/essential/elementa/markdown/drawables/TextDrawable$Style;", "style", "Lgg/essential/elementa/markdown/drawables/TextDrawable$Style;", "getStyle", "()Lgg/essential/elementa/markdown/drawables/TextDrawable$Style;", "", "Lgg/essential/elementa/markdown/drawables/TextDrawable$Text;", "texts", "Ljava/util/List;", "Lgg/essential/elementa/markdown/MarkdownComponent;", "md", "text", "<init>", "(Lgg/essential/elementa/markdown/MarkdownComponent;Ljava/lang/String;Lgg/essential/elementa/markdown/drawables/TextDrawable$Style;)V", "Companion", "LinkedTexts", "Style", "Text", "Elementa"})
public final class TextDrawable
extends Drawable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Style style;
    private float scaleModifier;
    @Nullable
    private HeaderLevelConfig headerConfig;
    @NotNull
    private String formattedText;
    private int selectionStart;
    private int selectionEnd;
    @NotNull
    private List<Text> texts;
    private boolean isHovered;
    @Nullable
    private LinkedTexts linkedTexts;

    public TextDrawable(@NotNull MarkdownComponent md, @NotNull String text, @NotNull Style style) {
        Intrinsics.checkNotNullParameter(md, "md");
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(style, "style");
        super(md);
        this.style = style;
        this.scaleModifier = 1.0f;
        this.formattedText = Intrinsics.stringPlus(this.style.getFormattingSymbols(), text);
        this.selectionStart = -1;
        this.selectionEnd = -1;
        this.texts = new ArrayList();
    }

    @NotNull
    public final Style getStyle() {
        return this.style;
    }

    public final float getScaleModifier() {
        return this.scaleModifier;
    }

    public final void setScaleModifier(float f) {
        this.scaleModifier = f;
    }

    @Nullable
    public final HeaderLevelConfig getHeaderConfig$Elementa() {
        return this.headerConfig;
    }

    public final void setHeaderConfig$Elementa(@Nullable HeaderLevelConfig value2) {
        this.headerConfig = value2;
        HeaderLevelConfig headerLevelConfig = value2;
        Float f = headerLevelConfig == null ? null : Float.valueOf(headerLevelConfig.getTextScale());
        this.scaleModifier = f == null ? this.scaleModifier : f.floatValue();
    }

    @NotNull
    public final String getFormattedText() {
        return this.formattedText;
    }

    public final int getSelectionStart() {
        return this.selectionStart;
    }

    public final void setSelectionStart(int n) {
        this.selectionStart = n;
    }

    public final int getSelectionEnd() {
        return this.selectionEnd;
    }

    public final void setSelectionEnd(int n) {
        this.selectionEnd = n;
    }

    @Nullable
    public final LinkedTexts getLinkedTexts() {
        return this.linkedTexts;
    }

    public final void setLinkedTexts(@Nullable LinkedTexts linkedTexts) {
        this.linkedTexts = linkedTexts;
    }

    @NotNull
    public final String plainText() {
        return StringsKt.drop(this.formattedText, this.style.getNumFormattingChars());
    }

    public final void ensureTrimmed() {
        int styleChars = this.style.getNumFormattingChars();
        String string = this.formattedText;
        int n = 0;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, styleChars);
        Intrinsics.checkNotNullExpressionValue(string3, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        string = this.formattedText;
        n = this.formattedText.length();
        String string4 = string;
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.substring(styleChars, n);
        Intrinsics.checkNotNullExpressionValue(string5, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        if (string5 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        this.formattedText = Intrinsics.stringPlus(string3, ((Object)StringsKt.trimStart((CharSequence)string5)).toString());
    }

    public final float width() {
        float f;
        float f2 = UtilitiesKt.width$default(this.formattedText, this.scaleModifier, null, 2, null);
        if (this.style.isCode()) {
            InlineCodeConfig it = this.getConfig().getInlineCodeConfig();
            float f3 = f2;
            boolean bl = false;
            float f4 = (it.getOutlineWidth() + it.getHorizontalPadding()) * 2.0f;
            f2 = f3;
            f = f4;
        } else {
            f = 0.0f;
        }
        return f2 + f;
    }

    @Nullable
    public final Pair<TextDrawable, TextDrawable> split(float maxWidth, boolean breakWords) {
        LinkedTexts linkedTexts;
        Object v2;
        Object $this$firstOrNull$iv2;
        String plainText;
        int styleChars;
        block12: {
            styleChars = this.style.getNumFormattingChars();
            plainText = this.plainText();
            if (plainText.length() <= 1) {
                return null;
            }
            $this$firstOrNull$iv2 = CollectionsKt.drop(StringsKt.getIndices(this.formattedText), styleChars);
            boolean $i$f$firstOrNull = false;
            Iterator iterator2 = $this$firstOrNull$iv2.iterator();
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                int it = ((Number)element$iv).intValue();
                boolean bl = false;
                String string = this.getFormattedText();
                int n = 0;
                int n2 = it + 1;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(n, n2);
                Intrinsics.checkNotNullExpressionValue(string3, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                if (!(UtilitiesKt.width$default(string3, this.getScaleModifier(), null, 2, null) > maxWidth)) continue;
                v2 = element$iv;
                break block12;
            }
            v2 = null;
        }
        Integer splitPoint = v2;
        if (splitPoint == null) {
            throw new IllegalStateException("TextDrawable#split called when it should not have been called");
        }
        splitPoint = splitPoint - 1 - styleChars;
        if (!breakWords) {
            while (splitPoint > styleChars && this.formattedText.charAt(splitPoint - 1) != ' ') {
                $this$firstOrNull$iv2 = splitPoint;
                splitPoint = (Integer)$this$firstOrNull$iv2 + -1;
            }
            int $this$firstOrNull$iv2 = styleChars;
            if (splitPoint == $this$firstOrNull$iv2) {
                return null;
            }
        }
        if (splitPoint <= 0) {
            splitPoint = 1;
        }
        MarkdownComponent markdownComponent = this.getMd();
        String $i$f$firstOrNull = plainText;
        int n = 0;
        int n3 = splitPoint;
        String string = $i$f$firstOrNull;
        if (string == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string.substring(n, n3);
        Intrinsics.checkNotNullExpressionValue(string4, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        TextDrawable first2 = new TextDrawable(markdownComponent, string4, this.style);
        MarkdownComponent markdownComponent2 = this.getMd();
        String string5 = plainText;
        n3 = splitPoint;
        int n4 = plainText.length();
        String string6 = string5;
        if (string6 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string7 = string6.substring(n3, n4);
        Intrinsics.checkNotNullExpressionValue(string7, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        TextDrawable second2 = new TextDrawable(markdownComponent2, string7, this.style);
        LinkedTexts linkedTexts2 = this.linkedTexts;
        if (linkedTexts2 == null) {
            linkedTexts = null;
        } else {
            LinkedTexts linkedTexts3;
            LinkedTexts it = linkedTexts3 = linkedTexts2;
            boolean bl = false;
            it.unlinkText(this);
            linkedTexts = linkedTexts3;
        }
        LinkedTexts linkedTexts4 = linkedTexts;
        LinkedTexts linkedTexts5 = linkedTexts4 == null ? new LinkedTexts() : linkedTexts4;
        linkedTexts5.linkText(first2);
        linkedTexts5.linkText(second2);
        first2.linkedTexts = linkedTexts5;
        second2.linkedTexts = linkedTexts5;
        first2.scaleModifier = this.scaleModifier;
        second2.scaleModifier = this.scaleModifier;
        return TuplesKt.to(first2, second2);
    }

    public static /* synthetic */ Pair split$default(TextDrawable textDrawable, float f, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return textDrawable.split(f, bl);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected Drawable.Layout layoutImpl(float x, float y, float width) {
        float f;
        float f2 = x;
        float f3 = y;
        float f4 = width;
        float f5 = 9.0f * this.scaleModifier;
        if (this.style.isCode()) {
            void it;
            InlineCodeConfig inlineCodeConfig = this.getConfig().getInlineCodeConfig();
            float f6 = f5;
            float f7 = f4;
            float f8 = f3;
            float f9 = f2;
            boolean bl = false;
            float f10 = it.getVerticalPadding() + it.getOutlineWidth();
            f2 = f9;
            f3 = f8;
            f4 = f7;
            f5 = f6;
            f = f10 * 2.0f;
        } else {
            f = 0.0f;
        }
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 16;
        Drawable.Margin margin = null;
        float f11 = f5 + f;
        float f12 = f4;
        float f13 = f3;
        float f14 = f2;
        return new Drawable.Layout(f14, f13, f12, f11, margin, n, defaultConstructorMarker);
    }

    public final void beforeDraw(@NotNull DrawState state) {
        Intrinsics.checkNotNullParameter(state, "state");
        this.texts.clear();
        if (this.selectionStart == -1 && this.selectionEnd == -1) {
            this.texts.add(new Text(this.formattedText, this.getX(), this.getY(), false));
        } else {
            float f;
            if (this.selectionStart == -1 || this.selectionEnd == -1) {
                throw new IllegalStateException();
            }
            int start = this.selectionStart + this.style.getNumFormattingChars();
            int end = this.selectionEnd + this.style.getNumFormattingChars();
            String string = this.formattedText;
            int n = 0;
            int n2 = this.style.getNumFormattingChars();
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue(string3, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String formatChars = string3;
            if (this.selectionStart > 0) {
                String string4 = this.formattedText;
                n2 = 0;
                String string5 = string4;
                if (string5 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string6 = string5.substring(n2, start);
                Intrinsics.checkNotNullExpressionValue(string6, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                this.texts.add(new Text(string6, this.getX(), this.getY(), false));
                float f2 = this.getX();
                string4 = this.formattedText;
                n2 = 0;
                String string7 = string4;
                if (string7 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string8 = string7.substring(n2, start);
                Intrinsics.checkNotNullExpressionValue(string8, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                f = f2 + UtilitiesKt.width$default(string8, this.scaleModifier, null, 2, null);
            } else {
                f = this.getX();
            }
            float nextX = f;
            String string9 = this.formattedText;
            if (string9 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string10 = string9.substring(start, end);
            Intrinsics.checkNotNullExpressionValue(string10, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String selectedString = Intrinsics.stringPlus(formatChars, string10);
            this.texts.add(new Text(selectedString, nextX, this.getY(), true));
            if (end < this.formattedText.length()) {
                String string11 = this.formattedText;
                if (string11 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string12 = string11.substring(end);
                Intrinsics.checkNotNullExpressionValue(string12, "(this as java.lang.String).substring(startIndex)");
                this.texts.add(new Text(Intrinsics.stringPlus(formatChars, string12), nextX + UtilitiesKt.width$default(selectedString, this.scaleModifier, null, 2, null), this.getY(), false));
            }
        }
        double mouseX = UMouse.Scaled.getX() - (double)state.getXShift();
        double mouseY = UMouse.Scaled.getY() - (double)state.getYShift();
        this.isHovered = this.style.getLinkLocation() != null ? this.isHovered((float)mouseX, (float)mouseY) : false;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void draw(@NotNull UMatrixStack matrixStack, @NotNull DrawState state) {
        Intrinsics.checkNotNullParameter(matrixStack, "matrixStack");
        Intrinsics.checkNotNullParameter(state, "state");
        if (this.isHovered) ** GOTO lbl-1000
        v0 = this.linkedTexts;
        if (v0 == null ? false : (var5_3 = v0.isHovered())) lbl-1000:
        // 2 sources

        {
            v1 = true;
        } else {
            v1 = hovered = false;
        }
        if (this.style.isCode()) {
            x1 = this.getX() + state.getXShift();
            y1 = this.getY() + state.getYShift() - 1.0f;
            x2 = x1 + this.getWidth();
            y2 = y1 + this.getHeight() + this.getConfig().getInlineCodeConfig().getVerticalPadding() * (float)2 - 1.0f;
            outlineWidth = this.getConfig().getInlineCodeConfig().getOutlineWidth();
            UIRoundedRectangle.Companion.drawRoundedRectangle(matrixStack, x1, y1, x2, y2, this.getConfig().getInlineCodeConfig().getCornerRadius(), this.getConfig().getInlineCodeConfig().getOutlineColor());
            UIRoundedRectangle.Companion.drawRoundedRectangle(matrixStack, x1 + outlineWidth, y1 + outlineWidth, x2 - outlineWidth, y2 - outlineWidth, this.getConfig().getInlineCodeConfig().getCornerRadius(), this.getConfig().getInlineCodeConfig().getBackgroundColor());
        }
        xShift = state.getXShift() + (this.style.isCode() != false ? this.getConfig().getInlineCodeConfig().getHorizontalPadding() : 0.0f);
        yShift = state.getYShift() + (this.style.isCode() != false ? this.getConfig().getInlineCodeConfig().getVerticalPadding() : 0.0f);
        $this$forEach$iv = this.texts;
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            it = (Text)element$iv;
            $i$a$-forEach-TextDrawable$draw$1 = false;
            matrixStack.scale(this.getScaleModifier(), this.getScaleModifier(), 1.0f);
            TextDrawable.Companion.drawString(matrixStack, this.getConfig(), this.getMd().getFontProvider(), it.getString(), (it.getX() + xShift) / this.getScaleModifier(), (it.getY() + yShift) / this.getScaleModifier(), it.getSelected(), this.getStyle().getLinkLocation() != null, hovered, this.getHeaderConfig$Elementa());
            matrixStack.scale(1.0f / this.getScaleModifier(), 1.0f / this.getScaleModifier(), 1.0f);
        }
    }

    @NotNull
    public Void cursorAt(float mouseX, float mouseY, boolean dragged, int mouseButton) {
        throw new IllegalStateException("never called");
    }

    @NotNull
    public TextCursor cursorAtStart() {
        return new TextCursor(this, 0);
    }

    @NotNull
    public TextCursor cursorAtEnd() {
        return new TextCursor(this, this.plainText().length());
    }

    @Override
    @NotNull
    public String selectedText(boolean asMarkdown) {
        if (this.selectionStart == -1 || this.selectionEnd == -1) {
            return "";
        }
        String string = this.plainText();
        int n = this.selectionStart;
        int n2 = this.selectionEnd;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue(string3, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String selectedText2 = string3;
        if (!asMarkdown) {
            return selectedText2;
        }
        return this.style.getMarkdownSymbols() + selectedText2 + this.style.getMarkdownSymbols();
    }

    @NotNull
    public String toString() {
        return this.formattedText;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\r\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\f\u001a\u00020\u0002\u0012\u0006\u0010\r\u001a\u00020\u0005\u0012\u0006\u0010\u000e\u001a\u00020\u0005\u0012\u0006\u0010\u000f\u001a\u00020\t\u00a2\u0006\u0004\b \u0010!J\u0010\u0010\u0003\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0006\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\b\u0010\u0007J\u0010\u0010\n\u001a\u00020\tH\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ8\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\f\u001a\u00020\u00022\b\b\u0002\u0010\r\u001a\u00020\u00052\b\b\u0002\u0010\u000e\u001a\u00020\u00052\b\b\u0002\u0010\u000f\u001a\u00020\tH\u00c6\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001a\u0010\u0013\u001a\u00020\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0016\u001a\u00020\u0015H\u00d6\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0010\u0010\u0018\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0018\u0010\u0004R\u0017\u0010\u000f\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0019\u001a\u0004\b\u001a\u0010\u000bR\u0017\u0010\f\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\f\u0010\u001b\u001a\u0004\b\u001c\u0010\u0004R\u0017\u0010\r\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\u001d\u001a\u0004\b\u001e\u0010\u0007R\u0017\u0010\u000e\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010\u001d\u001a\u0004\b\u001f\u0010\u0007\u00a8\u0006\""}, d2={"Lgg/essential/elementa/markdown/drawables/TextDrawable$Text;", "", "", "component1", "()Ljava/lang/String;", "", "component2", "()F", "component3", "", "component4", "()Z", "string", "x", "y", "selected", "copy", "(Ljava/lang/String;FFZ)Lgg/essential/elementa/markdown/drawables/TextDrawable$Text;", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "Z", "getSelected", "Ljava/lang/String;", "getString", "F", "getX", "getY", "<init>", "(Ljava/lang/String;FFZ)V", "Elementa"})
    public static final class Text {
        @NotNull
        private final String string;
        private final float x;
        private final float y;
        private final boolean selected;

        public Text(@NotNull String string, float x, float y, boolean selected2) {
            Intrinsics.checkNotNullParameter(string, "string");
            this.string = string;
            this.x = x;
            this.y = y;
            this.selected = selected2;
        }

        @NotNull
        public final String getString() {
            return this.string;
        }

        public final float getX() {
            return this.x;
        }

        public final float getY() {
            return this.y;
        }

        public final boolean getSelected() {
            return this.selected;
        }

        @NotNull
        public final String component1() {
            return this.string;
        }

        public final float component2() {
            return this.x;
        }

        public final float component3() {
            return this.y;
        }

        public final boolean component4() {
            return this.selected;
        }

        @NotNull
        public final Text copy(@NotNull String string, float x, float y, boolean selected2) {
            Intrinsics.checkNotNullParameter(string, "string");
            return new Text(string, x, y, selected2);
        }

        public static /* synthetic */ Text copy$default(Text text, String string, float f, float f2, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = text.string;
            }
            if ((n & 2) != 0) {
                f = text.x;
            }
            if ((n & 4) != 0) {
                f2 = text.y;
            }
            if ((n & 8) != 0) {
                bl = text.selected;
            }
            return text.copy(string, f, f2, bl);
        }

        @NotNull
        public String toString() {
            return "Text(string=" + this.string + ", x=" + this.x + ", y=" + this.y + ", selected=" + this.selected + ')';
        }

        public int hashCode() {
            int result2 = this.string.hashCode();
            result2 = result2 * 31 + Float.hashCode(this.x);
            result2 = result2 * 31 + Float.hashCode(this.y);
            int n = this.selected ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result2 = result2 * 31 + n;
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Text)) {
                return false;
            }
            Text text = (Text)other;
            if (!Intrinsics.areEqual(this.string, text.string)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)Float.valueOf(this.x), (Object)Float.valueOf(text.x))) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)Float.valueOf(this.y), (Object)Float.valueOf(text.y))) {
                return false;
            }
            return this.selected == text.selected;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0006\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\r\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0015\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\n\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\n\u0010\tR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010\r\u00a8\u0006\u0011"}, d2={"Lgg/essential/elementa/markdown/drawables/TextDrawable$LinkedTexts;", "", "", "isHovered", "()Z", "Lgg/essential/elementa/markdown/drawables/TextDrawable;", "text", "", "linkText", "(Lgg/essential/elementa/markdown/drawables/TextDrawable;)V", "unlinkText", "", "texts", "Ljava/util/Set;", "<init>", "()V", "Companion", "Elementa"})
    public static final class LinkedTexts {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Set<TextDrawable> texts = new LinkedHashSet();

        public final boolean isHovered() {
            boolean bl;
            block3: {
                Iterable $this$any$iv = this.texts;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        TextDrawable it = (TextDrawable)element$iv;
                        boolean bl2 = false;
                        if (!it.isHovered) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        public final void linkText(@NotNull TextDrawable text) {
            Intrinsics.checkNotNullParameter(text, "text");
            this.texts.add(text);
        }

        public final void unlinkText(@NotNull TextDrawable text) {
            Intrinsics.checkNotNullParameter(text, "text");
            this.texts.remove(text);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ!\u0010\u0005\u001a\u00020\u00022\b\u0010\u0003\u001a\u0004\u0018\u00010\u00022\b\u0010\u0004\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lgg/essential/elementa/markdown/drawables/TextDrawable$LinkedTexts$Companion;", "", "Lgg/essential/elementa/markdown/drawables/TextDrawable$LinkedTexts;", "linked1", "linked2", "merge", "(Lgg/essential/elementa/markdown/drawables/TextDrawable$LinkedTexts;Lgg/essential/elementa/markdown/drawables/TextDrawable$LinkedTexts;)Lgg/essential/elementa/markdown/drawables/TextDrawable$LinkedTexts;", "<init>", "()V", "Elementa"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final LinkedTexts merge(@Nullable LinkedTexts linked1, @Nullable LinkedTexts linked2) {
                LinkedTexts linkedTexts;
                if (linked1 == null && linked2 == null) {
                    linkedTexts = new LinkedTexts();
                } else if (linked1 == null) {
                    LinkedTexts linkedTexts2 = linked2;
                    linkedTexts = linkedTexts2;
                    Intrinsics.checkNotNull(linkedTexts2);
                } else if (linked2 == null) {
                    linkedTexts = linked1;
                } else {
                    Iterable $this$forEach$iv = linked2.texts;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        TextDrawable it = (TextDrawable)element$iv;
                        boolean bl = false;
                        linked1.linkText(it);
                    }
                    linkedTexts = linked1;
                }
                return linkedTexts;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0010\b\u0086\b\u0018\u0000 &2\u00020\u0001:\u0001&B9\u0012\u0006\u0010\f\u001a\u00020\u0002\u0012\u0006\u0010\r\u001a\u00020\u0002\u0012\u0006\u0010\u000e\u001a\u00020\u0002\u0012\u0006\u0010\u000f\u001a\u00020\u0002\u0012\u0006\u0010\u0010\u001a\u00020\u0002\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b$\u0010%J\u0010\u0010\u0003\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0004J\u0010\u0010\u0006\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0007\u0010\u0004J\u0010\u0010\b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\b\u0010\u0004J\u0012\u0010\n\u001a\u0004\u0018\u00010\tH\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJN\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\f\u001a\u00020\u00022\b\b\u0002\u0010\r\u001a\u00020\u00022\b\b\u0002\u0010\u000e\u001a\u00020\u00022\b\b\u0002\u0010\u000f\u001a\u00020\u00022\b\b\u0002\u0010\u0010\u001a\u00020\u00022\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\tH\u00c6\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001a\u0010\u0015\u001a\u00020\u00022\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0010\u0010\u0018\u001a\u00020\u0017H\u00d6\u0001\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\tH\u00d6\u0001\u00a2\u0006\u0004\b\u001a\u0010\u000bR\u0017\u0010\u001b\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\u000bR\u0017\u0010\f\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\f\u0010\u001e\u001a\u0004\b\f\u0010\u0004R\u0017\u0010\u0010\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0010\u0010\u001e\u001a\u0004\b\u0010\u0010\u0004R\u0017\u0010\r\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\u001e\u001a\u0004\b\r\u0010\u0004R\u0017\u0010\u000e\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010\u001e\u001a\u0004\b\u000e\u0010\u0004R\u0017\u0010\u000f\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010\u001e\u001a\u0004\b\u000f\u0010\u0004R\u0019\u0010\u0011\u001a\u0004\u0018\u00010\t8\u0006\u00a2\u0006\f\n\u0004\b\u0011\u0010\u001c\u001a\u0004\b\u001f\u0010\u000bR\u0017\u0010 \u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b \u0010\u001c\u001a\u0004\b!\u0010\u000bR\u0011\u0010#\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0019\u00a8\u0006'"}, d2={"Lgg/essential/elementa/markdown/drawables/TextDrawable$Style;", "", "", "component1", "()Z", "component2", "component3", "component4", "component5", "", "component6", "()Ljava/lang/String;", "isBold", "isItalic", "isStrikethrough", "isUnderline", "isCode", "linkLocation", "copy", "(ZZZZZLjava/lang/String;)Lgg/essential/elementa/markdown/drawables/TextDrawable$Style;", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "formattingSymbols", "Ljava/lang/String;", "getFormattingSymbols", "Z", "getLinkLocation", "markdownSymbols", "getMarkdownSymbols", "getNumFormattingChars", "numFormattingChars", "<init>", "(ZZZZZLjava/lang/String;)V", "Companion", "Elementa"})
    public static final class Style {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final boolean isBold;
        private final boolean isItalic;
        private final boolean isStrikethrough;
        private final boolean isUnderline;
        private final boolean isCode;
        @Nullable
        private final String linkLocation;
        @NotNull
        private final String formattingSymbols;
        @NotNull
        private final String markdownSymbols;
        @NotNull
        private static final Style EMPTY = new Style(false, false, false, false, false, null);

        /*
         * WARNING - void declaration
         */
        public Style(boolean isBold, boolean isItalic, boolean isStrikethrough, boolean isUnderline, boolean isCode, @Nullable String linkLocation) {
            void $this$markdownSymbols_u24lambda_u2d1;
            StringBuilder $this$formattingSymbols_u24lambda_u2d0;
            StringBuilder stringBuilder;
            this.isBold = isBold;
            this.isItalic = isItalic;
            this.isStrikethrough = isStrikethrough;
            this.isUnderline = isUnderline;
            this.isCode = isCode;
            this.linkLocation = linkLocation;
            StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
            Style style = this;
            boolean bl = false;
            if (!this.isCode()) {
                if (this.isBold()) {
                    $this$formattingSymbols_u24lambda_u2d0.append("\u00a7l");
                }
                if (this.isItalic()) {
                    $this$formattingSymbols_u24lambda_u2d0.append("\u00a7o");
                }
                if (this.isStrikethrough()) {
                    $this$formattingSymbols_u24lambda_u2d0.append("\u00a7m");
                }
                if (this.isUnderline()) {
                    $this$formattingSymbols_u24lambda_u2d0.append("\u00a7n");
                }
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
            style.formattingSymbols = string;
            $this$formattingSymbols_u24lambda_u2d0 = stringBuilder = new StringBuilder();
            style = this;
            boolean bl2 = false;
            if (this.isCode()) {
                $this$markdownSymbols_u24lambda_u2d1.append("`");
            }
            if (this.isBold()) {
                $this$markdownSymbols_u24lambda_u2d1.append("**");
            }
            if (this.isItalic()) {
                $this$markdownSymbols_u24lambda_u2d1.append("*");
            }
            if (this.isStrikethrough()) {
                $this$markdownSymbols_u24lambda_u2d1.append("~~");
            }
            if (this.isUnderline()) {
                $this$markdownSymbols_u24lambda_u2d1.append("++");
            }
            String string2 = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
            style.markdownSymbols = string2;
        }

        public final boolean isBold() {
            return this.isBold;
        }

        public final boolean isItalic() {
            return this.isItalic;
        }

        public final boolean isStrikethrough() {
            return this.isStrikethrough;
        }

        public final boolean isUnderline() {
            return this.isUnderline;
        }

        public final boolean isCode() {
            return this.isCode;
        }

        @Nullable
        public final String getLinkLocation() {
            return this.linkLocation;
        }

        @NotNull
        public final String getFormattingSymbols() {
            return this.formattingSymbols;
        }

        @NotNull
        public final String getMarkdownSymbols() {
            return this.markdownSymbols;
        }

        public final int getNumFormattingChars() {
            return this.formattingSymbols.length();
        }

        public final boolean component1() {
            return this.isBold;
        }

        public final boolean component2() {
            return this.isItalic;
        }

        public final boolean component3() {
            return this.isStrikethrough;
        }

        public final boolean component4() {
            return this.isUnderline;
        }

        public final boolean component5() {
            return this.isCode;
        }

        @Nullable
        public final String component6() {
            return this.linkLocation;
        }

        @NotNull
        public final Style copy(boolean isBold, boolean isItalic, boolean isStrikethrough, boolean isUnderline, boolean isCode, @Nullable String linkLocation) {
            return new Style(isBold, isItalic, isStrikethrough, isUnderline, isCode, linkLocation);
        }

        public static /* synthetic */ Style copy$default(Style style, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, String string, int n, Object object) {
            if ((n & 1) != 0) {
                bl = style.isBold;
            }
            if ((n & 2) != 0) {
                bl2 = style.isItalic;
            }
            if ((n & 4) != 0) {
                bl3 = style.isStrikethrough;
            }
            if ((n & 8) != 0) {
                bl4 = style.isUnderline;
            }
            if ((n & 0x10) != 0) {
                bl5 = style.isCode;
            }
            if ((n & 0x20) != 0) {
                string = style.linkLocation;
            }
            return style.copy(bl, bl2, bl3, bl4, bl5, string);
        }

        @NotNull
        public String toString() {
            return "Style(isBold=" + this.isBold + ", isItalic=" + this.isItalic + ", isStrikethrough=" + this.isStrikethrough + ", isUnderline=" + this.isUnderline + ", isCode=" + this.isCode + ", linkLocation=" + this.linkLocation + ')';
        }

        public int hashCode() {
            int n;
            int result2;
            int n2 = this.isBold ? 1 : 0;
            if (n2 != 0) {
                n2 = result2 = 1;
            }
            if ((n = this.isItalic) != 0) {
                n = 1;
            }
            result2 = result2 * 31 + n;
            int n3 = this.isStrikethrough ? 1 : 0;
            if (n3 != 0) {
                n3 = 1;
            }
            result2 = result2 * 31 + n3;
            int n4 = this.isUnderline ? 1 : 0;
            if (n4 != 0) {
                n4 = 1;
            }
            result2 = result2 * 31 + n4;
            int n5 = this.isCode ? 1 : 0;
            if (n5 != 0) {
                n5 = 1;
            }
            result2 = result2 * 31 + n5;
            result2 = result2 * 31 + (this.linkLocation == null ? 0 : this.linkLocation.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Style)) {
                return false;
            }
            Style style = (Style)other;
            if (this.isBold != style.isBold) {
                return false;
            }
            if (this.isItalic != style.isItalic) {
                return false;
            }
            if (this.isStrikethrough != style.isStrikethrough) {
                return false;
            }
            if (this.isUnderline != style.isUnderline) {
                return false;
            }
            if (this.isCode != style.isCode) {
                return false;
            }
            return Intrinsics.areEqual(this.linkLocation, style.linkLocation);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0007\u0010\bR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0004\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lgg/essential/elementa/markdown/drawables/TextDrawable$Style$Companion;", "", "Lgg/essential/elementa/markdown/drawables/TextDrawable$Style;", "EMPTY", "Lgg/essential/elementa/markdown/drawables/TextDrawable$Style;", "getEMPTY", "()Lgg/essential/elementa/markdown/drawables/TextDrawable$Style;", "<init>", "()V", "Elementa"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Style getEMPTY() {
                return EMPTY;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018JU\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\b\b\u0002\u0010\f\u001a\u00020\u000b2\b\b\u0002\u0010\r\u001a\u00020\u000b2\b\b\u0002\u0010\u000e\u001a\u00020\u000bH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011Jg\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\b\b\u0002\u0010\f\u001a\u00020\u000b2\b\b\u0002\u0010\r\u001a\u00020\u000b2\b\b\u0002\u0010\u000e\u001a\u00020\u000b2\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0014\u00a2\u0006\u0004\b\u0010\u0010\u0016\u00a8\u0006\u0019"}, d2={"Lgg/essential/elementa/markdown/drawables/TextDrawable$Companion;", "", "Lgg/essential/elementa/markdown/MarkdownConfig;", "config", "Lgg/essential/elementa/font/FontProvider;", "fontProvider", "", "string", "", "x", "y", "", "selected", "isLink", "isHovered", "", "drawString", "(Lgg/essential/elementa/markdown/MarkdownConfig;Lgg/essential/elementa/font/FontProvider;Ljava/lang/String;FFZZZ)V", "Lgg/essential/universal/UMatrixStack;", "matrixStack", "Lgg/essential/elementa/markdown/HeaderLevelConfig;", "headerConfig", "(Lgg/essential/universal/UMatrixStack;Lgg/essential/elementa/markdown/MarkdownConfig;Lgg/essential/elementa/font/FontProvider;Ljava/lang/String;FFZZZLgg/essential/elementa/markdown/HeaderLevelConfig;)V", "<init>", "()V", "Elementa"})
    public static final class Companion {
        private Companion() {
        }

        @Deprecated(message="For 1.17 this method requires you pass a UMatrixStack as the first argument.\n\nIf you are currently extending this method, you should instead extend the method with the added argument.\nNote however for this to be non-breaking, your parent class needs to transition before you do.\n\nIf you are calling this method and you cannot guarantee that your target class has been fully updated (such as when\ncalling an open method on an open class), you should instead call the method with the \"Compat\" suffix, which will\ncall both methods, the new and the deprecated one.\nIf you are sure that your target class has been updated (such as when calling the super method), you should\n(for super calls you must!) instead just call the method with the original name and added argument.", replaceWith=@ReplaceWith(expression="drawString(matrixStack, config, fontProvider, string, x, y, selected, isLink, isHovered)", imports={}))
        public final void drawString(@NotNull MarkdownConfig config, @NotNull FontProvider fontProvider, @NotNull String string, float x, float y, boolean selected2, boolean isLink, boolean isHovered) {
            Intrinsics.checkNotNullParameter(config, "config");
            Intrinsics.checkNotNullParameter(fontProvider, "fontProvider");
            Intrinsics.checkNotNullParameter(string, "string");
            gg.essential.elementa.markdown.drawables.TextDrawable$Companion.drawString$default(this, new UMatrixStack(), config, fontProvider, string, x, y, selected2, isLink, isHovered, null, 512, null);
        }

        public static /* synthetic */ void drawString$default(Companion companion, MarkdownConfig markdownConfig, FontProvider fontProvider, String string, float f, float f2, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
            if ((n & 0x20) != 0) {
                bl = false;
            }
            if ((n & 0x40) != 0) {
                bl2 = false;
            }
            if ((n & 0x80) != 0) {
                bl3 = false;
            }
            companion.drawString(markdownConfig, fontProvider, string, f, f2, bl, bl2, bl3);
        }

        public final void drawString(@NotNull UMatrixStack matrixStack, @NotNull MarkdownConfig config, @NotNull FontProvider fontProvider, @NotNull String string, float x, float y, boolean selected2, boolean isLink, boolean isHovered, @Nullable HeaderLevelConfig headerConfig) {
            int foregroundColor;
            Intrinsics.checkNotNullParameter(matrixStack, "matrixStack");
            Intrinsics.checkNotNullParameter(config, "config");
            Intrinsics.checkNotNullParameter(fontProvider, "fontProvider");
            Intrinsics.checkNotNullParameter(string, "string");
            if (selected2) {
                UIBlock.Companion.drawBlockSized(matrixStack, config.getTextConfig().getSelectionBackgroundColor(), x, y, UtilitiesKt.width(string, 1.0f, fontProvider), 9.0);
            }
            int n = isLink ? config.getTextConfig().getLinkColor().getRGB() : (selected2 ? config.getTextConfig().getSelectionForegroundColor().getRGB() : (foregroundColor = headerConfig != null ? headerConfig.getFontColor().getRGB() : config.getTextConfig().getColor().getRGB()));
            if (config.getTextConfig().getHasShadow()) {
                fontProvider.drawString(matrixStack, string, new Color(foregroundColor), x, y, 10.0f, 1.0f, true, new Color(config.getTextConfig().getShadowColor().getRGB()));
            } else {
                FontProvider.drawString$default(fontProvider, matrixStack, string, new Color(foregroundColor), x, y, 10.0f, 1.0f, false, null, 256, null);
            }
            if (isLink && isHovered) {
                UIBlock.Companion.drawBlockSized(matrixStack, config.getTextConfig().getLinkColor(), x, (double)y + (double)8, UtilitiesKt.width$default(string, 0.0f, null, 3, null), 1.0);
            }
        }

        public static /* synthetic */ void drawString$default(Companion companion, UMatrixStack uMatrixStack, MarkdownConfig markdownConfig, FontProvider fontProvider, String string, float f, float f2, boolean bl, boolean bl2, boolean bl3, HeaderLevelConfig headerLevelConfig, int n, Object object) {
            if ((n & 0x40) != 0) {
                bl = false;
            }
            if ((n & 0x80) != 0) {
                bl2 = false;
            }
            if ((n & 0x100) != 0) {
                bl3 = false;
            }
            if ((n & 0x200) != 0) {
                headerLevelConfig = null;
            }
            companion.drawString(uMatrixStack, markdownConfig, fontProvider, string, f, f2, bl, bl2, bl3, headerLevelConfig);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

