/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.elementa.markdown.drawables;

import gg.essential.elementa.dsl.UtilitiesKt;
import gg.essential.elementa.markdown.DrawState;
import gg.essential.elementa.markdown.HeaderLevelConfig;
import gg.essential.elementa.markdown.MarkdownComponent;
import gg.essential.elementa.markdown.drawables.Drawable;
import gg.essential.elementa.markdown.drawables.DrawableList;
import gg.essential.elementa.markdown.drawables.HardBreakDrawable;
import gg.essential.elementa.markdown.drawables.ImageDrawable;
import gg.essential.elementa.markdown.drawables.SoftBreakDrawable;
import gg.essential.elementa.markdown.drawables.TextDrawable;
import gg.essential.elementa.markdown.selection.Cursor;
import gg.essential.elementa.markdown.selection.ImageCursor;
import gg.essential.elementa.markdown.selection.TextCursor;
import gg.essential.elementa.utils.ExtensionsKt;
import gg.essential.universal.UDesktop;
import gg.essential.universal.UMatrixStack;
import java.awt.Color;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010E\u001a\u00020D\u0012\u0006\u00108\u001a\u00020)\u00a2\u0006\u0004\bF\u0010GJ3\u0010\n\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0013\u0010\f\u001a\u0006\u0012\u0002\b\u00030\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u0013\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\tH\u0016\u00a2\u0006\u0004\b\u000e\u0010\rJ\u001f\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J'\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u000f\u0010\u001d\u001a\u00020\u001cH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u000f\u0010\u001f\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u001f\u0010 J\u0017\u0010#\u001a\u00020\"2\u0006\u0010!\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b#\u0010$R\u001a\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00010%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R \u0010*\u001a\u00020)8\u0006X\u0087\u0004\u00a2\u0006\u0012\n\u0004\b*\u0010+\u0012\u0004\b.\u0010/\u001a\u0004\b,\u0010-R.\u00102\u001a\u0004\u0018\u0001002\b\u00101\u001a\u0004\u0018\u0001008\u0000@@X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b2\u00103\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\u0014\u00108\u001a\u00020)8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b8\u0010+R\u0014\u00109\u001a\u00020\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b9\u0010:R*\u0010;\u001a\u00020\u00022\u0006\u00101\u001a\u00020\u00028\u0006@FX\u0086\u000e\u00a2\u0006\u0012\n\u0004\b;\u0010<\u001a\u0004\b=\u0010>\"\u0004\b?\u0010@R\u0017\u0010C\u001a\b\u0012\u0004\u0012\u00020A0%8F\u00a2\u0006\u0006\u001a\u0004\bB\u0010'\u00a8\u0006H"}, d2={"Lgg/essential/elementa/markdown/drawables/ParagraphDrawable;", "Lgg/essential/elementa/markdown/drawables/Drawable;", "", "mouseX", "mouseY", "", "dragged", "", "mouseButton", "Lgg/essential/elementa/markdown/selection/Cursor;", "cursorAt", "(FFZI)Lgg/essential/elementa/markdown/selection/Cursor;", "cursorAtEnd", "()Lgg/essential/elementa/markdown/selection/Cursor;", "cursorAtStart", "Lgg/essential/universal/UMatrixStack;", "matrixStack", "Lgg/essential/elementa/markdown/DrawState;", "state", "", "draw", "(Lgg/essential/universal/UMatrixStack;Lgg/essential/elementa/markdown/DrawState;)V", "x", "y", "width", "Lgg/essential/elementa/markdown/drawables/Drawable$Layout;", "layoutImpl", "(FFF)Lgg/essential/elementa/markdown/drawables/Drawable$Layout;", "Ljava/awt/Color;", "randomColor", "()Ljava/awt/Color;", "randomComponent", "()I", "asMarkdown", "", "selectedText", "(Z)Ljava/lang/String;", "", "getChildren", "()Ljava/util/List;", "children", "Lgg/essential/elementa/markdown/drawables/DrawableList;", "drawables", "Lgg/essential/elementa/markdown/drawables/DrawableList;", "getDrawables", "()Lgg/essential/elementa/markdown/drawables/DrawableList;", "getDrawables$annotations", "()V", "Lgg/essential/elementa/markdown/HeaderLevelConfig;", "value", "headerConfig", "Lgg/essential/elementa/markdown/HeaderLevelConfig;", "getHeaderConfig$Elementa", "()Lgg/essential/elementa/markdown/HeaderLevelConfig;", "setHeaderConfig$Elementa", "(Lgg/essential/elementa/markdown/HeaderLevelConfig;)V", "originalDrawables", "rc", "Ljava/awt/Color;", "scaleModifier", "F", "getScaleModifier", "()F", "setScaleModifier", "(F)V", "Lgg/essential/elementa/markdown/drawables/TextDrawable;", "getTextDrawables", "textDrawables", "Lgg/essential/elementa/markdown/MarkdownComponent;", "md", "<init>", "(Lgg/essential/elementa/markdown/MarkdownComponent;Lgg/essential/elementa/markdown/drawables/DrawableList;)V", "Elementa"})
public final class ParagraphDrawable
extends Drawable {
    @NotNull
    private final DrawableList originalDrawables;
    @NotNull
    private final DrawableList drawables;
    @Nullable
    private HeaderLevelConfig headerConfig;
    private float scaleModifier;
    @NotNull
    private final Color rc;

    public ParagraphDrawable(@NotNull MarkdownComponent md, @NotNull DrawableList originalDrawables) {
        Intrinsics.checkNotNullParameter(md, "md");
        Intrinsics.checkNotNullParameter(originalDrawables, "originalDrawables");
        super(md);
        this.originalDrawables = originalDrawables;
        this.drawables = new DrawableList(md, this.originalDrawables);
        this.scaleModifier = 1.0f;
        this.originalDrawables.setParent(this);
        this.drawables.setParent(this);
        this.rc = ExtensionsKt.withAlpha(this.randomColor(), 100);
    }

    @NotNull
    public final DrawableList getDrawables() {
        return this.drawables;
    }

    @Deprecated(message="Use children instead", replaceWith=@ReplaceWith(expression="children", imports={}))
    public static /* synthetic */ void getDrawables$annotations() {
    }

    @Override
    @NotNull
    public List<Drawable> getChildren() {
        return this.drawables;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<TextDrawable> getTextDrawables() {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = this.getChildren();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof TextDrawable)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final HeaderLevelConfig getHeaderConfig$Elementa() {
        return this.headerConfig;
    }

    public final void setHeaderConfig$Elementa(@Nullable HeaderLevelConfig value2) {
        this.headerConfig = value2;
        HeaderLevelConfig headerLevelConfig = value2;
        Float f = headerLevelConfig == null ? null : Float.valueOf(headerLevelConfig.getTextScale());
        this.setScaleModifier(f == null ? this.scaleModifier : f.floatValue());
        Iterable $this$forEach$iv = this.getTextDrawables();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TextDrawable it = (TextDrawable)element$iv;
            boolean bl = false;
            it.setHeaderConfig$Elementa(value2);
        }
    }

    public final float getScaleModifier() {
        return this.scaleModifier;
    }

    /*
     * WARNING - void declaration
     */
    public final void setScaleModifier(float value2) {
        void $this$filterIsInstanceTo$iv$iv;
        this.scaleModifier = value2;
        Iterable $this$filterIsInstance$iv = this.drawables;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof TextDrawable)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TextDrawable it = (TextDrawable)element$iv;
            boolean bl = false;
            it.setScaleModifier(value2);
        }
    }

    @Override
    @NotNull
    protected Drawable.Layout layoutImpl(float x, float y, float width) {
        Drawable splitResult3;
        TextDrawable it;
        float marginTop = this.getInsertSpaceBefore() ? this.getConfig().getParagraphConfig().getSpaceBefore() : 0.0f;
        float marginBottom = this.getInsertSpaceAfter() ? this.getConfig().getParagraphConfig().getSpaceAfter() : 0.0f;
        List newDrawables = new ArrayList();
        Ref.FloatRef currX = new Ref.FloatRef();
        currX.element = x;
        Ref.FloatRef currY = new Ref.FloatRef();
        currY.element = y + marginTop;
        Ref.FloatRef widthRemaining = new Ref.FloatRef();
        widthRemaining.element = width;
        boolean centered = this.getConfig().getParagraphConfig().getCentered();
        Ref.BooleanRef trimNextText = new Ref.BooleanRef();
        trimNextText.element = true;
        List lines = new ArrayList();
        List currentLine = new ArrayList();
        Ref.FloatRef maxLineHeight = new Ref.FloatRef();
        maxLineHeight.element = Float.MIN_VALUE;
        Iterator<Drawable> iterator2 = this.originalDrawables.iterator();
        int n = 0;
        block0: while (iterator2.hasNext()) {
            float targetWidth;
            int index2 = n++;
            Drawable text = iterator2.next();
            if (text instanceof SoftBreakDrawable || text instanceof HardBreakDrawable) {
                TextDrawable.Style style;
                Object t;
                block25: {
                    Object v0;
                    if (this.getConfig().getParagraphConfig().getSoftBreakIsNewline() || text instanceof HardBreakDrawable) {
                        ParagraphDrawable.layoutImpl$gotoNextLine(currX, x, currY, maxLineHeight, this, currentLine, widthRemaining, width, lines, trimNextText);
                        continue;
                    }
                    List $this$lastOrNull$iv = newDrawables;
                    boolean $i$f$lastOrNull = false;
                    ListIterator iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        Object element$iv = iterator$iv.previous();
                        Drawable it2 = (Drawable)element$iv;
                        boolean bl = false;
                        if (!(it2 instanceof TextDrawable)) continue;
                        v0 = element$iv;
                        break block25;
                    }
                    t = null;
                    v0 = t;
                }
                if ((t instanceof TextDrawable ? (TextDrawable)t : null) == null) {
                    style = null;
                } else {
                    it = it;
                    boolean bl = false;
                    style = TextDrawable.Style.copy$default(it.getStyle(), false, false, false, false, false, null, 47, null);
                }
                TextDrawable.Style style2 = style;
                TextDrawable.Style previousStyle = style2 == null ? TextDrawable.Style.Companion.getEMPTY() : style2;
                TextDrawable newText = new TextDrawable(this.getMd(), " ", previousStyle);
                if (!((Collection)newDrawables).isEmpty() && index2 != CollectionsKt.getLastIndex(this.originalDrawables)) {
                    Drawable previous = (Drawable)CollectionsKt.last(newDrawables);
                    Drawable next = this.originalDrawables.get(index2 + 1);
                    if (previous instanceof TextDrawable && next instanceof TextDrawable && Intrinsics.areEqual(((TextDrawable)previous).getStyle(), ((TextDrawable)next).getStyle())) {
                        TextDrawable.LinkedTexts linkedTexts = TextDrawable.LinkedTexts.Companion.merge(((TextDrawable)previous).getLinkedTexts(), ((TextDrawable)next).getLinkedTexts());
                        linkedTexts.linkText((TextDrawable)previous);
                        linkedTexts.linkText(newText);
                        linkedTexts.linkText((TextDrawable)next);
                        ((TextDrawable)previous).setLinkedTexts(linkedTexts);
                        newText.setLinkedTexts(linkedTexts);
                        ((TextDrawable)next).setLinkedTexts(linkedTexts);
                    }
                }
                ParagraphDrawable.layoutImpl$layout(trimNextText, currX, currY, widthRemaining, currentLine, newDrawables, maxLineHeight, newText, newText.width());
                if (widthRemaining.element <= 0.0f) {
                    ParagraphDrawable.layoutImpl$gotoNextLine(currX, x, currY, maxLineHeight, this, currentLine, widthRemaining, width, lines, trimNextText);
                }
                trimNextText.element = true;
                continue;
            }
            if (text instanceof ImageDrawable) {
                ParagraphDrawable.layoutImpl$gotoNextLine(currX, x, currY, maxLineHeight, this, currentLine, widthRemaining, width, lines, trimNextText);
                ParagraphDrawable.layoutImpl$layout(trimNextText, currX, currY, widthRemaining, currentLine, newDrawables, maxLineHeight, text, width);
                ParagraphDrawable.layoutImpl$gotoNextLine(currX, x, currY, maxLineHeight, this, currentLine, widthRemaining, width, lines, trimNextText);
                continue;
            }
            if (!(text instanceof TextDrawable)) {
                throw (Throwable)new NotImplementedError(null, 1, null);
            }
            Object target = (TextDrawable)text;
            while (true) {
                if ((targetWidth = ((TextDrawable)target).width()) <= widthRemaining.element) {
                    ParagraphDrawable.layoutImpl$layout(trimNextText, currX, currY, widthRemaining, currentLine, newDrawables, maxLineHeight, (Drawable)target, targetWidth);
                    if (!(widthRemaining.element <= 0.0f)) continue block0;
                    ParagraphDrawable.layoutImpl$gotoNextLine(currX, x, currY, maxLineHeight, this, currentLine, widthRemaining, width, lines, trimNextText);
                    continue block0;
                }
                Pair splitResult = TextDrawable.split$default((TextDrawable)target, widthRemaining.element, false, 2, null);
                if (splitResult != null) {
                    ParagraphDrawable.layoutImpl$layout(trimNextText, currX, currY, widthRemaining, currentLine, newDrawables, maxLineHeight, (Drawable)splitResult.getFirst(), targetWidth);
                    ParagraphDrawable.layoutImpl$gotoNextLine(currX, x, currY, maxLineHeight, this, currentLine, widthRemaining, width, lines, trimNextText);
                    target = (TextDrawable)splitResult.getSecond();
                    continue;
                }
                if (!((Collection)currentLine).isEmpty()) {
                    ParagraphDrawable.layoutImpl$gotoNextLine(currX, x, currY, maxLineHeight, this, currentLine, widthRemaining, width, lines, trimNextText);
                }
                if (!(targetWidth > width)) break;
                Pair splitResult2 = TextDrawable.split$default((TextDrawable)target, width, false, 2, null);
                if (splitResult2 == null) {
                    if (((TextDrawable)target).split(width, true) == null) {
                        throw new IllegalStateException("MarkdownComponent's width (" + this.getMd().getWidth() + ") is too small to render its content");
                    }
                    ParagraphDrawable.layoutImpl$layout(trimNextText, currX, currY, widthRemaining, currentLine, newDrawables, maxLineHeight, (Drawable)((Pair)((Object)splitResult3)).getFirst(), ((TextDrawable)((Pair)((Object)splitResult3)).getFirst()).width());
                    ParagraphDrawable.layoutImpl$gotoNextLine(currX, x, currY, maxLineHeight, this, currentLine, widthRemaining, width, lines, trimNextText);
                    target = (TextDrawable)((Pair)((Object)splitResult3)).getSecond();
                    continue;
                }
                ParagraphDrawable.layoutImpl$layout(trimNextText, currX, currY, widthRemaining, currentLine, newDrawables, maxLineHeight, (Drawable)splitResult2.getFirst(), ((TextDrawable)splitResult2.getFirst()).width());
                ParagraphDrawable.layoutImpl$gotoNextLine(currX, x, currY, maxLineHeight, this, currentLine, widthRemaining, width, lines, trimNextText);
                target = (TextDrawable)splitResult2.getSecond();
            }
            ParagraphDrawable.layoutImpl$layout(trimNextText, currX, currY, widthRemaining, currentLine, newDrawables, maxLineHeight, (Drawable)target, targetWidth);
        }
        if (!((Collection)currentLine).isEmpty()) {
            lines.add(CollectionsKt.toList(currentLine));
        }
        if (centered) {
            for (List line2 : lines) {
                Iterable text = line2;
                double target = 0.0;
                for (Object t : text) {
                    Double d;
                    splitResult3 = (Drawable)t;
                    double d2 = target;
                    boolean bl = false;
                    TextDrawable textDrawable = it instanceof TextDrawable ? it : null;
                    if (textDrawable == null) {
                        d = null;
                    } else {
                        float f = textDrawable.width();
                        d = f;
                    }
                    double d3 = d == null ? (double)it.getWidth() : d;
                    target = d2 + d3;
                }
                float totalWidth = (float)target;
                float shift = (width - totalWidth) / 2.0f;
                for (Drawable text2 : line2) {
                    text2.setX(text2.getX() + shift);
                }
            }
        }
        Iterable $this$forEach$iv = newDrawables;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Drawable it3 = (Drawable)element$iv;
            boolean bl = false;
            if (!(it3 instanceof TextDrawable)) continue;
            ((TextDrawable)it3).setScaleModifier(this.getScaleModifier());
        }
        this.drawables.setDrawables(newDrawables);
        float height = currY.element - y + 9.0f * this.scaleModifier + (this.getInsertSpaceAfter() ? this.getConfig().getParagraphConfig().getSpaceAfter() : 0.0f);
        return new Drawable.Layout(x, y, width, height, new Drawable.Margin(0.0f, marginTop, 0.0f, marginBottom));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void draw(@NotNull UMatrixStack matrixStack, @NotNull DrawState state) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter(matrixStack, "matrixStack");
        Intrinsics.checkNotNullParameter(state, "state");
        Iterable $this$filterIsInstance$iv = this.drawables;
        boolean $i$f$filterIsInstance = false;
        Iterator iterator2 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof TextDrawable)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TextDrawable it = (TextDrawable)element$iv;
            boolean bl = false;
            it.beforeDraw(state);
        }
        $this$forEach$iv = this.drawables;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Drawable it = (Drawable)element$iv;
            boolean bl = false;
            it.drawCompat(matrixStack, state);
        }
    }

    @Override
    @NotNull
    public Cursor<?> cursorAt(float mouseX, float mouseY, boolean dragged, int mouseButton) {
        Object v0;
        Object it;
        float linePadding;
        block18: {
            linePadding = this.getConfig().getParagraphConfig().getSpaceBetweenLines() / 2.0f;
            Iterable $this$firstOrNull$iv = this.drawables;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                it = (Drawable)element$iv;
                boolean bl = false;
                if (!ParagraphDrawable.cursorAt$yRange(linePadding, (Drawable)it).contains((Float)((Comparable)Float.valueOf(mouseY)))) continue;
                v0 = element$iv;
                break block18;
            }
            v0 = null;
        }
        Drawable firstInRow = v0;
        if (firstInRow == null) {
            if (mouseY < ((Drawable)CollectionsKt.first(this.drawables)).getY() - linePadding) {
                return this.cursorAtStart();
            }
            return this.cursorAtEnd();
        }
        if (mouseX < firstInRow.getX()) {
            return firstInRow.cursorAtStart();
        }
        Ref.ObjectRef<Drawable> currentDrawable = new Ref.ObjectRef<Drawable>();
        currentDrawable.element = firstInRow;
        while (mouseX > ((Drawable)currentDrawable.element).getX() + ((Drawable)currentDrawable.element).getWidth() && ((Drawable)currentDrawable.element).getNext() != null) {
            Drawable nextDrawable;
            Intrinsics.checkNotNull(((Drawable)currentDrawable.element).getNext());
            while (!(nextDrawable instanceof TextDrawable) && !(nextDrawable instanceof ImageDrawable) && nextDrawable.getNext() != null) {
                Intrinsics.checkNotNull(nextDrawable.getNext());
            }
            if (!(nextDrawable instanceof TextDrawable) && !(nextDrawable instanceof ImageDrawable)) {
                return ((Drawable)currentDrawable.element).cursorAtEnd();
            }
            if (!ParagraphDrawable.cursorAt$yRange(linePadding, nextDrawable).contains((Float)((Comparable)Float.valueOf(mouseY)))) {
                return ((Drawable)currentDrawable.element).cursorAtEnd();
            }
            currentDrawable.element = nextDrawable;
        }
        if (currentDrawable.element instanceof ImageDrawable) {
            return new ImageCursor((ImageDrawable)currentDrawable.element);
        }
        if (!(currentDrawable.element instanceof TextDrawable)) {
            throw (Throwable)new NotImplementedError(null, 1, null);
        }
        String string = ((TextDrawable)currentDrawable.element).getStyle().getLinkLocation();
        if (string != null) {
            Object element$iv;
            element$iv = string;
            it = element$iv;
            boolean bl = false;
            Object object = !dragged && mouseButton == 0 ? element$iv : null;
            if (object != null) {
                Object linkLocation = object;
                boolean bl2 = false;
                if (this.getMd().fireLinkClickEvent$Elementa(new MarkdownComponent.LinkClickEvent((String)linkLocation))) {
                    try {
                        UDesktop.browse(new URI((String)linkLocation));
                    }
                    catch (URISyntaxException uRISyntaxException) {
                    }
                }
            }
        }
        int offset = ((TextDrawable)currentDrawable.element).getStyle().getNumFormattingChars();
        float cachedWidth = 0.0f;
        while (offset < ((TextDrawable)currentDrawable.element).getFormattedText().length()) {
            int element$iv = offset;
            offset = element$iv + 1;
            float newWidth = ParagraphDrawable.cursorAt$textWidth(currentDrawable, offset);
            if (((Drawable)currentDrawable.element).getX() + newWidth > mouseX) {
                float newDist;
                float oldDist = Math.abs(mouseX - ((Drawable)currentDrawable.element).getX() - cachedWidth);
                if (oldDist < (newDist = Math.abs(newWidth - (mouseX - ((Drawable)currentDrawable.element).getX())))) {
                    int n = offset;
                    offset = n + -1;
                }
                return new TextCursor((TextDrawable)currentDrawable.element, offset - ((TextDrawable)currentDrawable.element).getStyle().getNumFormattingChars());
            }
            cachedWidth = newWidth;
        }
        return ((TextDrawable)currentDrawable.element).cursorAtEnd();
    }

    @Override
    @NotNull
    public Cursor<?> cursorAtStart() {
        Object element$iv2;
        block1: {
            Iterable $this$first$iv = this.drawables;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                Drawable it = (Drawable)element$iv2;
                boolean bl = false;
                if (!(it instanceof TextDrawable || it instanceof ImageDrawable)) continue;
                break block1;
            }
            throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        return ((Drawable)element$iv2).cursorAtStart();
    }

    @Override
    @NotNull
    public Cursor<?> cursorAtEnd() {
        Object element$iv;
        block1: {
            List $this$last$iv = this.drawables;
            boolean $i$f$last = false;
            ListIterator iterator$iv = $this$last$iv.listIterator($this$last$iv.size());
            while (iterator$iv.hasPrevious()) {
                element$iv = iterator$iv.previous();
                Drawable it = (Drawable)element$iv;
                boolean bl = false;
                if (!(it instanceof TextDrawable || it instanceof ImageDrawable)) continue;
                break block1;
            }
            throw (Throwable)new NoSuchElementException("List contains no element matching the predicate.");
        }
        return ((Drawable)element$iv).cursorAtEnd();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String selectedText(boolean asMarkdown) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.drawables;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Drawable it = (Drawable)element$iv$iv;
            boolean bl = false;
            if (!(it instanceof TextDrawable || it instanceof ImageDrawable)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.joinToString$default((List)destination$iv$iv, "", null, null, 0, null, new Function1<Drawable, CharSequence>(asMarkdown){
            final /* synthetic */ boolean $asMarkdown;
            {
                this.$asMarkdown = $asMarkdown;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull Drawable it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return it.selectedText(this.$asMarkdown);
            }
        }, 30, null);
    }

    private final Color randomColor() {
        return new Color(this.randomComponent(), this.randomComponent(), this.randomComponent());
    }

    private final int randomComponent() {
        return (int)Math.floor(Math.random() * (double)256.0f);
    }

    private static final void layoutImpl$gotoNextLine(Ref.FloatRef currX, float $x, Ref.FloatRef currY, Ref.FloatRef maxLineHeight, ParagraphDrawable this$0, List<Drawable> currentLine, Ref.FloatRef widthRemaining, float $width, List<List<Drawable>> lines, Ref.BooleanRef trimNextText) {
        currX.element = $x;
        currY.element += maxLineHeight.element * this$0.scaleModifier + this$0.getConfig().getParagraphConfig().getSpaceBetweenLines();
        if (maxLineHeight.element > 9.0f) {
            for (Drawable drawable : currentLine) {
                drawable.setY(drawable.getY() + (maxLineHeight.element - drawable.getHeight()) / 2.0f);
            }
        }
        maxLineHeight.element = Float.MIN_VALUE;
        widthRemaining.element = $width;
        lines.add(CollectionsKt.toList((Iterable)currentLine));
        currentLine.clear();
        trimNextText.element = true;
    }

    private static final void layoutImpl$layout(Ref.BooleanRef trimNextText, Ref.FloatRef currX, Ref.FloatRef currY, Ref.FloatRef widthRemaining, List<Drawable> currentLine, List<Drawable> newDrawables, Ref.FloatRef maxLineHeight, Drawable drawable, float width) {
        Drawable.Layout layout;
        float f;
        if (trimNextText.element && drawable instanceof TextDrawable) {
            ((TextDrawable)drawable).ensureTrimmed();
            f = ((TextDrawable)drawable).width();
        } else {
            f = width;
        }
        float newWidth = f;
        Drawable.Layout it = layout = drawable.layout(currX.element, currY.element, newWidth);
        boolean bl = false;
        if (it.getHeight() > maxLineHeight.element) {
            maxLineHeight.element = it.getHeight();
        }
        widthRemaining.element -= newWidth;
        currX.element += newWidth;
        trimNextText.element = false;
        currentLine.add(drawable);
        newDrawables.add(drawable);
    }

    private static final ClosedFloatingPointRange<Float> cursorAt$yRange(float linePadding, Drawable d) {
        return RangesKt.rangeTo(d.getY() - linePadding, d.getY() + d.getHeight() + linePadding);
    }

    private static final float cursorAt$textWidth(Ref.ObjectRef<Drawable> currentDrawable, int offset) {
        String string = ((TextDrawable)currentDrawable.element).getFormattedText();
        int n = 0;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, offset);
        Intrinsics.checkNotNullExpressionValue(string3, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return UtilitiesKt.width$default(string3, ((TextDrawable)currentDrawable.element).getScaleModifier(), null, 2, null);
    }
}

