/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.elementa.markdown.drawables;

import gg.essential.elementa.dsl.UtilitiesKt;
import gg.essential.elementa.markdown.DrawState;
import gg.essential.elementa.markdown.MarkdownComponent;
import gg.essential.elementa.markdown.drawables.Drawable;
import gg.essential.elementa.markdown.drawables.DrawableList;
import gg.essential.elementa.markdown.drawables.TextDrawable;
import gg.essential.elementa.markdown.selection.Cursor;
import gg.essential.universal.UMatrixStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u00017B'\u0012\u0006\u00104\u001a\u000203\u0012\u0006\u0010%\u001a\u00020$\u0012\u0006\u0010.\u001a\u00020\u0005\u0012\u0006\u0010,\u001a\u00020\u0005\u00a2\u0006\u0004\b5\u00106J3\u0010\n\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0013\u0010\f\u001a\u0006\u0012\u0002\b\u00030\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u0013\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\tH\u0016\u00a2\u0006\u0004\b\u000e\u0010\rJ\u001f\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J'\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fR\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00010 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0014\u0010%\u001a\u00020$8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010&R\u0014\u0010)\u001a\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0016\u0010*\u001a\u00020\u00078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b*\u0010+R\u0016\u0010,\u001a\u00020\u00058\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b,\u0010-R\u0014\u0010.\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b.\u0010-R\u001e\u00101\u001a\f\u0012\b\u0012\u000600R\u00020\u00000/8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b1\u00102\u00a8\u00068"}, d2={"Lgg/essential/elementa/markdown/drawables/ListDrawable;", "Lgg/essential/elementa/markdown/drawables/Drawable;", "", "mouseX", "mouseY", "", "dragged", "", "mouseButton", "Lgg/essential/elementa/markdown/selection/Cursor;", "cursorAt", "(FFZI)Lgg/essential/elementa/markdown/selection/Cursor;", "cursorAtEnd", "()Lgg/essential/elementa/markdown/selection/Cursor;", "cursorAtStart", "Lgg/essential/universal/UMatrixStack;", "matrixStack", "Lgg/essential/elementa/markdown/DrawState;", "state", "", "draw", "(Lgg/essential/universal/UMatrixStack;Lgg/essential/elementa/markdown/DrawState;)V", "x", "y", "width", "Lgg/essential/elementa/markdown/drawables/Drawable$Layout;", "layoutImpl", "(FFF)Lgg/essential/elementa/markdown/drawables/Drawable$Layout;", "asMarkdown", "", "selectedText", "(Z)Ljava/lang/String;", "", "getChildren", "()Ljava/util/List;", "children", "Lgg/essential/elementa/markdown/drawables/DrawableList;", "drawables", "Lgg/essential/elementa/markdown/drawables/DrawableList;", "getElementSpacing", "()F", "elementSpacing", "indentLevel", "I", "isLoose", "Z", "isOrdered", "", "Lgg/essential/elementa/markdown/drawables/ListDrawable$ListEntry;", "listItems", "Ljava/util/List;", "Lgg/essential/elementa/markdown/MarkdownComponent;", "md", "<init>", "(Lgg/essential/elementa/markdown/MarkdownComponent;Lgg/essential/elementa/markdown/drawables/DrawableList;ZZ)V", "ListEntry", "Elementa"})
public final class ListDrawable
extends Drawable {
    @NotNull
    private final DrawableList drawables;
    private final boolean isOrdered;
    private boolean isLoose;
    @NotNull
    private final List<ListEntry> listItems;
    private int indentLevel;

    public ListDrawable(@NotNull MarkdownComponent md, @NotNull DrawableList drawables, boolean isOrdered, boolean isLoose) {
        Intrinsics.checkNotNullParameter(md, "md");
        Intrinsics.checkNotNullParameter(drawables, "drawables");
        super(md);
        this.drawables = drawables;
        this.isOrdered = isOrdered;
        this.isLoose = isLoose;
        this.listItems = new ArrayList();
        Drawable.Companion.trim(this.drawables);
        this.drawables.setParent(this);
    }

    @Override
    @NotNull
    public List<Drawable> getChildren() {
        return this.listItems;
    }

    private final float getElementSpacing() {
        return this.isLoose ? this.getConfig().getListConfig().getElementSpacingLoose() : this.getConfig().getListConfig().getElementSpacingTight();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected Drawable.Layout layoutImpl(float x, float y, float width) {
        float f;
        this.listItems.clear();
        float marginTop = this.getInsertSpaceBefore() ? this.getConfig().getListConfig().getSpaceBeforeList() : 0.0f;
        float marginBottom = this.getInsertSpaceAfter() ? this.getConfig().getListConfig().getSpaceAfterList() : 0.0f;
        Ref.FloatRef currY = new Ref.FloatRef();
        currY.element = y + marginTop;
        float spaceAfterSymbol = this.getConfig().getListConfig().getSpaceBeforeText();
        float indentation = this.getConfig().getListConfig().getIndentation();
        Ref.IntRef orderedListShift = new Ref.IntRef();
        if (this.isOrdered) {
            void $this$filterTo$iv$iv;
            float dotWidth = UtilitiesKt.width$default('.', 0.0f, 1, null);
            Iterable $this$filter$iv = CollectionsKt.getIndices(this.drawables);
            boolean $i$f$filter22 = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                int it = ((Number)element$iv$iv).intValue();
                boolean bl = false;
                if (!(!(this.drawables.get(it) instanceof ListDrawable))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterator $i$f$filter22 = ((Iterable)((List)destination$iv$iv)).iterator();
            if (!$i$f$filter22.hasNext()) {
                throw (Throwable)new NoSuchElementException();
            }
            int it22 = ((Number)$i$f$filter22.next()).intValue();
            boolean bl = false;
            float it22 = UtilitiesKt.width$default(String.valueOf(it22), 0.0f, null, 3, null) + dotWidth;
            while ($i$f$filter22.hasNext()) {
                int it32 = ((Number)$i$f$filter22.next()).intValue();
                $i$a$-maxOf-ListDrawable$layoutImpl$symbolWidth$2 = false;
                float it32 = UtilitiesKt.width$default(String.valueOf(it32), 0.0f, null, 3, null) + dotWidth;
                it22 = Math.max(it22, it32);
            }
            f = it22;
        } else {
            String symbols = this.getConfig().getListConfig().getUnorderedSymbols();
            f = UtilitiesKt.width$default(symbols.charAt(this.indentLevel % symbols.length()), 0.0f, 1, null);
        }
        float symbolWidth = f;
        Ref.IntRef index2 = new Ref.IntRef();
        for (Drawable drawable_ : this.drawables) {
            Drawable last2;
            Drawable drawable = drawable_;
            if (drawable instanceof ListDrawable) {
                ((ListDrawable)drawable).indentLevel = this.indentLevel + 1;
            }
            if (drawable instanceof DrawableList && (last2 = (Drawable)CollectionsKt.last((List)((Object)drawable))) instanceof ListDrawable) {
                drawable = new DrawableList(this.getMd(), CollectionsKt.dropLast((List)((Object)drawable), 1));
                ListDrawable.layoutImpl$addItem(this, index2, symbolWidth, spaceAfterSymbol, currY, x, indentation, width, orderedListShift, drawable);
                int n = index2.element;
                index2.element = n + 1;
                n = orderedListShift.element;
                orderedListShift.element = n + 1;
                Drawable.Companion.trim(last2);
                ((ListDrawable)last2).isLoose = this.isLoose;
                drawable = last2;
            }
            ListDrawable.layoutImpl$addItem(this, index2, symbolWidth, spaceAfterSymbol, currY, x, indentation, width, orderedListShift, drawable);
            int n = index2.element;
            index2.element = n + 1;
        }
        currY.element -= this.getElementSpacing();
        currY.element += marginBottom;
        float height = currY.element - y;
        return new Drawable.Layout(x, y, width, height, new Drawable.Margin(0.0f, marginTop, 0.0f, marginBottom));
    }

    @Override
    public void draw(@NotNull UMatrixStack matrixStack, @NotNull DrawState state) {
        Intrinsics.checkNotNullParameter(matrixStack, "matrixStack");
        Intrinsics.checkNotNullParameter(state, "state");
        Iterable $this$forEach$iv = this.listItems;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ListEntry it = (ListEntry)element$iv;
            boolean bl = false;
            it.drawCompat(matrixStack, state);
        }
    }

    @Override
    @NotNull
    public Cursor<?> cursorAt(float mouseX, float mouseY, boolean dragged, int mouseButton) {
        return this.drawables.cursorAt(mouseX, mouseY, dragged, mouseButton);
    }

    @Override
    @NotNull
    public Cursor<?> cursorAtStart() {
        return this.drawables.cursorAtStart();
    }

    @Override
    @NotNull
    public Cursor<?> cursorAtEnd() {
        return this.drawables.cursorAtEnd();
    }

    @Override
    @NotNull
    public String selectedText(boolean asMarkdown) {
        return CollectionsKt.joinToString$default(this.listItems, "\n", null, null, 0, null, new Function1<ListEntry, CharSequence>(asMarkdown){
            final /* synthetic */ boolean $asMarkdown;
            {
                this.$asMarkdown = $asMarkdown;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull ListEntry it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return it.selectedText(this.$asMarkdown);
            }
        }, 30, null);
    }

    private static final String layoutImpl$symbol(ListDrawable this$0, Ref.IntRef orderedListShift, int index2) {
        String string;
        if (this$0.isOrdered) {
            string = "" + (index2 + 1 - orderedListShift.element) + '.';
        } else {
            String symbols = this$0.getConfig().getListConfig().getUnorderedSymbols();
            string = String.valueOf(symbols.charAt(this$0.indentLevel % symbols.length()));
        }
        return string;
    }

    private static final void layoutImpl$addItem(ListDrawable this$0, Ref.IntRef index2, float symbolWidth, float spaceAfterSymbol, Ref.FloatRef currY, float $x, float indentation, float $width, Ref.IntRef orderedListShift, Drawable drawable) {
        ListEntry item = this$0.new ListEntry(this$0.getMd(), ListDrawable.layoutImpl$symbol(this$0, orderedListShift, index2.element), symbolWidth, spaceAfterSymbol, drawable);
        this$0.listItems.add(item);
        currY.element += item.layout($x + indentation, currY.element, $width - indentation).getHeight();
        currY.element += this$0.getElementSpacing();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010/\u001a\u00020.\u0012\u0006\u0010*\u001a\u00020\u001d\u0012\u0006\u0010-\u001a\u00020\u0002\u0012\u0006\u0010,\u001a\u00020\u0002\u0012\u0006\u0010&\u001a\u00020\u0001\u00a2\u0006\u0004\b0\u00101J3\u0010\n\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0013\u0010\f\u001a\u0006\u0012\u0002\b\u00030\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u0013\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\tH\u0016\u00a2\u0006\u0004\b\u000e\u0010\rJ\u001f\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J'\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b \u0010!R\u001a\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00010\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0017\u0010&\u001a\u00020\u00018\u0006\u00a2\u0006\f\n\u0004\b&\u0010'\u001a\u0004\b(\u0010)R\u0014\u0010*\u001a\u00020\u001d8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b*\u0010+R\u0014\u0010,\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b,\u0010!R\u0014\u0010-\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b-\u0010!\u00a8\u00062"}, d2={"Lgg/essential/elementa/markdown/drawables/ListDrawable$ListEntry;", "Lgg/essential/elementa/markdown/drawables/Drawable;", "", "mouseX", "mouseY", "", "dragged", "", "mouseButton", "Lgg/essential/elementa/markdown/selection/Cursor;", "cursorAt", "(FFZI)Lgg/essential/elementa/markdown/selection/Cursor;", "cursorAtEnd", "()Lgg/essential/elementa/markdown/selection/Cursor;", "cursorAtStart", "Lgg/essential/universal/UMatrixStack;", "matrixStack", "Lgg/essential/elementa/markdown/DrawState;", "state", "", "draw", "(Lgg/essential/universal/UMatrixStack;Lgg/essential/elementa/markdown/DrawState;)V", "x", "y", "width", "Lgg/essential/elementa/markdown/drawables/Drawable$Layout;", "layoutImpl", "(FFF)Lgg/essential/elementa/markdown/drawables/Drawable$Layout;", "asMarkdown", "", "selectedText", "(Z)Ljava/lang/String;", "actualSymbolWidth", "F", "", "getChildren", "()Ljava/util/List;", "children", "drawable", "Lgg/essential/elementa/markdown/drawables/Drawable;", "getDrawable", "()Lgg/essential/elementa/markdown/drawables/Drawable;", "symbol", "Ljava/lang/String;", "symbolPaddingRight", "symbolWidth", "Lgg/essential/elementa/markdown/MarkdownComponent;", "md", "<init>", "(Lgg/essential/elementa/markdown/drawables/ListDrawable;Lgg/essential/elementa/markdown/MarkdownComponent;Ljava/lang/String;FFLgg/essential/elementa/markdown/drawables/Drawable;)V", "Elementa"})
    public final class ListEntry
    extends Drawable {
        @NotNull
        private final String symbol;
        private final float symbolWidth;
        private final float symbolPaddingRight;
        @NotNull
        private final Drawable drawable;
        private final float actualSymbolWidth;

        public ListEntry(@NotNull MarkdownComponent md, String symbol, float symbolWidth, @NotNull float symbolPaddingRight, Drawable drawable) {
            Intrinsics.checkNotNullParameter(ListDrawable.this, "this$0");
            Intrinsics.checkNotNullParameter(md, "md");
            Intrinsics.checkNotNullParameter(symbol, "symbol");
            Intrinsics.checkNotNullParameter(drawable, "drawable");
            super(md);
            this.symbol = symbol;
            this.symbolWidth = symbolWidth;
            this.symbolPaddingRight = symbolPaddingRight;
            this.drawable = drawable;
            this.actualSymbolWidth = UtilitiesKt.width$default(this.symbol, 0.0f, null, 3, null);
            Drawable.Companion.trim(this.drawable);
            if (this.drawable instanceof DrawableList) {
                Iterator<Drawable> iterator2 = ((DrawableList)this.drawable).iterator();
                int n = 0;
                while (iterator2.hasNext()) {
                    int index2 = n++;
                    Drawable item = iterator2.next();
                    if (!(item instanceof ListDrawable)) continue;
                    if (index2 != 0) {
                        Drawable.Companion.trim(((DrawableList)this.drawable).get(index2 - 1));
                    }
                    if (index2 == CollectionsKt.getLastIndex((List)((Object)this.drawable))) continue;
                    Drawable.Companion.trim(((DrawableList)this.drawable).get(index2 + 1));
                }
            }
        }

        @NotNull
        public final Drawable getDrawable() {
            return this.drawable;
        }

        @Override
        @NotNull
        public List<Drawable> getChildren() {
            return CollectionsKt.listOf(this.drawable);
        }

        @Override
        @NotNull
        protected Drawable.Layout layoutImpl(float x, float y, float width) {
            float nonDrawableSpace = this.symbolWidth + this.symbolPaddingRight;
            this.drawable.layout(x + nonDrawableSpace, y, width - nonDrawableSpace);
            return new Drawable.Layout(x, y, width, this.drawable.getHeight(), null, 16, null);
        }

        @Override
        public void draw(@NotNull UMatrixStack matrixStack, @NotNull DrawState state) {
            Intrinsics.checkNotNullParameter(matrixStack, "matrixStack");
            Intrinsics.checkNotNullParameter(state, "state");
            float newX = this.getX() + this.symbolWidth - this.actualSymbolWidth;
            if (!(this.drawable instanceof ListDrawable)) {
                TextDrawable.Companion.drawString$default(TextDrawable.Companion, matrixStack, this.getConfig(), this.getMd().getFontProvider(), this.symbol, newX + state.getXShift(), this.getY() + state.getYShift(), false, false, false, null, 960, null);
            }
            this.drawable.drawCompat(matrixStack, state);
        }

        @Override
        @NotNull
        public Cursor<?> cursorAt(float mouseX, float mouseY, boolean dragged, int mouseButton) {
            return this.drawable.cursorAt(mouseX, mouseY, dragged, mouseButton);
        }

        @Override
        @NotNull
        public Cursor<?> cursorAtStart() {
            return this.drawable.cursorAtStart();
        }

        @Override
        @NotNull
        public Cursor<?> cursorAtEnd() {
            return this.drawable.cursorAtEnd();
        }

        @Override
        @NotNull
        public String selectedText(boolean asMarkdown) {
            StringBuilder stringBuilder;
            if (!this.hasSelectedText()) {
                return "";
            }
            String text = this.drawable.selectedText(asMarkdown);
            ListDrawable listDrawable = ListDrawable.this;
            StringBuilder $this$selectedText_u24lambda_u2d1 = stringBuilder = new StringBuilder();
            boolean bl = false;
            int n = listDrawable.indentLevel;
            int n2 = 0;
            int n3 = n;
            while (n2 < n3) {
                int it = n2++;
                boolean bl2 = false;
                $this$selectedText_u24lambda_u2d1.append("  ");
            }
            if (asMarkdown) {
                $this$selectedText_u24lambda_u2d1.append(this.symbol);
                $this$selectedText_u24lambda_u2d1.append(' ');
            }
            $this$selectedText_u24lambda_u2d1.append(text);
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
            return string;
        }
    }
}

