/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.elementa.markdown.drawables;

import gg.essential.elementa.components.UIBlock;
import gg.essential.elementa.markdown.DrawState;
import gg.essential.elementa.markdown.HeaderLevelConfig;
import gg.essential.elementa.markdown.MarkdownComponent;
import gg.essential.elementa.markdown.drawables.Drawable;
import gg.essential.elementa.markdown.drawables.HeaderDrawable;
import gg.essential.elementa.markdown.drawables.ParagraphDrawable;
import gg.essential.elementa.markdown.selection.Cursor;
import gg.essential.universal.UMatrixStack;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u00101\u001a\u000200\u0012\u0006\u0010+\u001a\u00020\u0007\u0012\u0006\u0010.\u001a\u00020-\u00a2\u0006\u0004\b2\u00103J3\u0010\n\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0013\u0010\f\u001a\u0006\u0012\u0002\b\u00030\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u0013\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\tH\u0016\u00a2\u0006\u0004\b\u000e\u0010\rJ\u001f\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J'\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fR\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00010 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0014\u0010%\u001a\u00020$8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010&R\u001a\u0010'\u001a\u00020\u001d8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b'\u0010(\u001a\u0004\b)\u0010*R\u0014\u0010+\u001a\u00020\u00078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b+\u0010,R\u0014\u0010.\u001a\u00020-8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b.\u0010/\u00a8\u00064"}, d2={"Lgg/essential/elementa/markdown/drawables/HeaderDrawable;", "Lgg/essential/elementa/markdown/drawables/Drawable;", "", "mouseX", "mouseY", "", "dragged", "", "mouseButton", "Lgg/essential/elementa/markdown/selection/Cursor;", "cursorAt", "(FFZI)Lgg/essential/elementa/markdown/selection/Cursor;", "cursorAtEnd", "()Lgg/essential/elementa/markdown/selection/Cursor;", "cursorAtStart", "Lgg/essential/universal/UMatrixStack;", "matrixStack", "Lgg/essential/elementa/markdown/DrawState;", "state", "", "draw", "(Lgg/essential/universal/UMatrixStack;Lgg/essential/elementa/markdown/DrawState;)V", "x", "y", "width", "Lgg/essential/elementa/markdown/drawables/Drawable$Layout;", "layoutImpl", "(FFF)Lgg/essential/elementa/markdown/drawables/Drawable$Layout;", "asMarkdown", "", "selectedText", "(Z)Ljava/lang/String;", "", "getChildren", "()Ljava/util/List;", "children", "Lgg/essential/elementa/markdown/HeaderLevelConfig;", "headerConfig", "Lgg/essential/elementa/markdown/HeaderLevelConfig;", "id", "Ljava/lang/String;", "getId$Elementa", "()Ljava/lang/String;", "level", "I", "Lgg/essential/elementa/markdown/drawables/ParagraphDrawable;", "paragraph", "Lgg/essential/elementa/markdown/drawables/ParagraphDrawable;", "Lgg/essential/elementa/markdown/MarkdownComponent;", "md", "<init>", "(Lgg/essential/elementa/markdown/MarkdownComponent;ILgg/essential/elementa/markdown/drawables/ParagraphDrawable;)V", "Elementa"})
public final class HeaderDrawable
extends Drawable {
    private final int level;
    @NotNull
    private final ParagraphDrawable paragraph;
    @NotNull
    private final String id;
    @NotNull
    private final HeaderLevelConfig headerConfig;

    public HeaderDrawable(@NotNull MarkdownComponent md, int level, @NotNull ParagraphDrawable paragraph) {
        HeaderLevelConfig headerLevelConfig;
        Intrinsics.checkNotNullParameter(md, "md");
        Intrinsics.checkNotNullParameter(paragraph, "paragraph");
        super(md);
        this.level = level;
        this.paragraph = paragraph;
        this.id = CollectionsKt.joinToString$default(this.paragraph.getTextDrawables(), " ", null, null, 0, null, id.1.INSTANCE, 30, null);
        this.paragraph.setParent(this);
        switch (this.level) {
            case 1: {
                headerLevelConfig = this.getConfig().getHeaderConfig().getLevel1();
                break;
            }
            case 2: {
                headerLevelConfig = this.getConfig().getHeaderConfig().getLevel2();
                break;
            }
            case 3: {
                headerLevelConfig = this.getConfig().getHeaderConfig().getLevel3();
                break;
            }
            case 4: {
                headerLevelConfig = this.getConfig().getHeaderConfig().getLevel4();
                break;
            }
            case 5: {
                headerLevelConfig = this.getConfig().getHeaderConfig().getLevel5();
                break;
            }
            case 6: {
                headerLevelConfig = this.getConfig().getHeaderConfig().getLevel6();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.headerConfig = headerLevelConfig;
        this.paragraph.setHeaderConfig$Elementa(this.headerConfig);
        Drawable.Companion.trim(this.paragraph);
    }

    @Override
    @NotNull
    public List<Drawable> getChildren() {
        return CollectionsKt.listOf(this.paragraph);
    }

    @NotNull
    public final String getId$Elementa() {
        return this.id;
    }

    @Override
    @NotNull
    protected Drawable.Layout layoutImpl(float x, float y, float width) {
        float spaceBefore = this.getInsertSpaceBefore() ? this.headerConfig.getVerticalSpaceBefore() : 0.0f;
        float spaceAfter = this.getInsertSpaceAfter() ? this.headerConfig.getVerticalSpaceAfter() : 0.0f;
        this.paragraph.layout(x, y + spaceBefore, width);
        float height = spaceBefore + this.paragraph.getHeight() + spaceAfter + (this.headerConfig.getHasDivider() ? this.headerConfig.getSpaceBeforeDivider() + this.headerConfig.getDividerWidth() : 0.0f);
        return new Drawable.Layout(x, y, width, height, new Drawable.Margin(0.0f, spaceBefore, 0.0f, spaceAfter));
    }

    @Override
    public void draw(@NotNull UMatrixStack matrixStack, @NotNull DrawState state) {
        Intrinsics.checkNotNullParameter(matrixStack, "matrixStack");
        Intrinsics.checkNotNullParameter(state, "state");
        this.paragraph.drawCompat(matrixStack, state);
        if (this.headerConfig.getHasDivider()) {
            float y = this.getLayout().getBottom() - this.getLayout().getMargin().getBottom() - this.headerConfig.getDividerWidth();
            UIBlock.Companion.drawBlockSized(matrixStack, this.headerConfig.getDividerColor(), this.getX() + state.getXShift(), y + state.getYShift(), this.getWidth(), this.headerConfig.getDividerWidth());
        }
    }

    @Override
    @NotNull
    public Cursor<?> cursorAt(float mouseX, float mouseY, boolean dragged, int mouseButton) {
        return this.paragraph.cursorAt(mouseX, mouseY, dragged, mouseButton);
    }

    @Override
    @NotNull
    public Cursor<?> cursorAtStart() {
        return this.paragraph.cursorAtStart();
    }

    @Override
    @NotNull
    public Cursor<?> cursorAtEnd() {
        return this.paragraph.cursorAtEnd();
    }

    @Override
    @NotNull
    public String selectedText(boolean asMarkdown) {
        if (!this.hasSelectedText()) {
            return "";
        }
        String text = this.paragraph.selectedText(asMarkdown);
        return asMarkdown ? StringsKt.repeat("#", this.level) + ' ' + text : text;
    }
}

