/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.elementa.markdown.drawables;

import gg.essential.elementa.components.UIBlock;
import gg.essential.elementa.markdown.BlockquoteConfig;
import gg.essential.elementa.markdown.DrawState;
import gg.essential.elementa.markdown.MarkdownComponent;
import gg.essential.elementa.markdown.drawables.BlockquoteDrawable;
import gg.essential.elementa.markdown.drawables.Drawable;
import gg.essential.elementa.markdown.drawables.DrawableList;
import gg.essential.elementa.markdown.selection.Cursor;
import gg.essential.universal.UMatrixStack;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010,\u001a\u00020+\u0012\u0006\u0010'\u001a\u00020&\u00a2\u0006\u0004\b-\u0010.J3\u0010\n\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0013\u0010\f\u001a\u0006\u0012\u0002\b\u00030\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u0013\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\tH\u0016\u00a2\u0006\u0004\b\u000e\u0010\rJ\u001f\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J'\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fR\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00010 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0016\u0010$\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b$\u0010%R\u0017\u0010'\u001a\u00020&8\u0006\u00a2\u0006\f\n\u0004\b'\u0010(\u001a\u0004\b)\u0010*\u00a8\u0006/"}, d2={"Lgg/essential/elementa/markdown/drawables/BlockquoteDrawable;", "Lgg/essential/elementa/markdown/drawables/Drawable;", "", "mouseX", "mouseY", "", "dragged", "", "mouseButton", "Lgg/essential/elementa/markdown/selection/Cursor;", "cursorAt", "(FFZI)Lgg/essential/elementa/markdown/selection/Cursor;", "cursorAtEnd", "()Lgg/essential/elementa/markdown/selection/Cursor;", "cursorAtStart", "Lgg/essential/universal/UMatrixStack;", "matrixStack", "Lgg/essential/elementa/markdown/DrawState;", "state", "", "draw", "(Lgg/essential/universal/UMatrixStack;Lgg/essential/elementa/markdown/DrawState;)V", "x", "y", "width", "Lgg/essential/elementa/markdown/drawables/Drawable$Layout;", "layoutImpl", "(FFF)Lgg/essential/elementa/markdown/drawables/Drawable$Layout;", "asMarkdown", "", "selectedText", "(Z)Ljava/lang/String;", "", "getChildren", "()Ljava/util/List;", "children", "dividerHeight", "F", "Lgg/essential/elementa/markdown/drawables/DrawableList;", "drawables", "Lgg/essential/elementa/markdown/drawables/DrawableList;", "getDrawables", "()Lgg/essential/elementa/markdown/drawables/DrawableList;", "Lgg/essential/elementa/markdown/MarkdownComponent;", "md", "<init>", "(Lgg/essential/elementa/markdown/MarkdownComponent;Lgg/essential/elementa/markdown/drawables/DrawableList;)V", "Elementa"})
public final class BlockquoteDrawable
extends Drawable {
    @NotNull
    private final DrawableList drawables;
    private float dividerHeight;

    public BlockquoteDrawable(@NotNull MarkdownComponent md, @NotNull DrawableList drawables) {
        Intrinsics.checkNotNullParameter(md, "md");
        Intrinsics.checkNotNullParameter(drawables, "drawables");
        super(md);
        this.drawables = drawables;
        this.dividerHeight = -1.0f;
        this.drawables.setParent(this);
    }

    @NotNull
    public final DrawableList getDrawables() {
        return this.drawables;
    }

    @Override
    @NotNull
    public List<Drawable> getChildren() {
        return this.drawables;
    }

    @Override
    @NotNull
    protected Drawable.Layout layoutImpl(float x, float y, float width) {
        BlockquoteConfig config = this.getConfig().getBlockquoteConfig();
        float padding = config.getSpaceBeforeDivider() + config.getDividerWidth() + config.getSpaceAfterDivider();
        float currY = 0.0f;
        currY = y;
        float dividerStart = currY += this.getInsertSpaceBefore() ? config.getSpaceBeforeBlockquote() : 0.0f;
        currY += config.getDividerPaddingTop();
        Drawable.Companion.trim(this.drawables);
        Iterable $this$forEach$iv = this.drawables;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Drawable it = (Drawable)element$iv;
            boolean bl = false;
            currY += it.layout(x + padding, currY, width - padding).getHeight();
        }
        this.dividerHeight = (currY += config.getDividerPaddingBottom()) - dividerStart;
        if (this.getInsertSpaceAfter()) {
            currY += config.getSpaceAfterBlockquote();
        }
        float height = currY - y;
        return new Drawable.Layout(x, y, width, height, new Drawable.Margin(0.0f, config.getSpaceBeforeBlockquote(), 0.0f, config.getSpaceAfterBlockquote()));
    }

    @Override
    public void draw(@NotNull UMatrixStack matrixStack, @NotNull DrawState state) {
        Intrinsics.checkNotNullParameter(matrixStack, "matrixStack");
        Intrinsics.checkNotNullParameter(state, "state");
        UIBlock.Companion.drawBlockSized(matrixStack, this.getConfig().getBlockquoteConfig().getDividerColor(), (double)(this.getX() + state.getXShift()) + (double)this.getConfig().getBlockquoteConfig().getSpaceBeforeDivider(), (double)(this.getY() + state.getYShift()) + (double)this.getConfig().getBlockquoteConfig().getSpaceBeforeBlockquote(), this.getConfig().getBlockquoteConfig().getDividerWidth(), this.dividerHeight);
        Iterable $this$forEach$iv = this.drawables;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Drawable it = (Drawable)element$iv;
            boolean bl = false;
            it.drawCompat(matrixStack, state);
        }
    }

    @Override
    @NotNull
    public Cursor<?> cursorAt(float mouseX, float mouseY, boolean dragged, int mouseButton) {
        return this.drawables.cursorAt(mouseX, mouseY, dragged, mouseButton);
    }

    @Override
    @NotNull
    public Cursor<?> cursorAtStart() {
        return this.drawables.cursorAtStart();
    }

    @Override
    @NotNull
    public Cursor<?> cursorAtEnd() {
        return this.drawables.cursorAtEnd();
    }

    @Override
    @NotNull
    public String selectedText(boolean asMarkdown) {
        if (!this.hasSelectedText()) {
            return "";
        }
        String text = this.drawables.selectedText(asMarkdown);
        return asMarkdown ? CollectionsKt.joinToString$default(StringsKt.lines(text), "\n", null, null, 0, null, selectedText.1.INSTANCE, 30, null) : text;
    }
}

