/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.elementa.markdown;

import gg.essential.elementa.UIComponent;
import gg.essential.elementa.components.Window;
import gg.essential.elementa.constraints.HeightConstraint;
import gg.essential.elementa.dsl.UtilitiesKt;
import gg.essential.elementa.events.UIClickEvent;
import gg.essential.elementa.events.UIEvent;
import gg.essential.elementa.font.ElementaFonts;
import gg.essential.elementa.font.FontProvider;
import gg.essential.elementa.markdown.DrawState;
import gg.essential.elementa.markdown.MarkdownConfig;
import gg.essential.elementa.markdown.MarkdownRenderer;
import gg.essential.elementa.markdown.drawables.Drawable;
import gg.essential.elementa.markdown.drawables.DrawableList;
import gg.essential.elementa.markdown.drawables.HeaderDrawable;
import gg.essential.elementa.markdown.selection.Cursor;
import gg.essential.elementa.markdown.selection.Selection;
import gg.essential.elementa.state.BasicState;
import gg.essential.elementa.state.State;
import gg.essential.elementa.utils.OptionsKt;
import gg.essential.universal.UDesktop;
import gg.essential.universal.UKeyboard;
import gg.essential.universal.UMatrixStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 S2\u00020\u0001:\u0003STUB/\b\u0017\u0012\u0006\u0010O\u001a\u00020\u0006\u0012\b\b\u0002\u0010-\u001a\u00020,\u0012\b\b\u0002\u0010(\u001a\u00020\"\u0012\b\b\u0002\u0010*\u001a\u00020)\u00a2\u0006\u0004\bP\u0010QB7\u0012\u0006\u0010O\u001a\u00020\u0006\u0012\b\b\u0002\u0010-\u001a\u00020,\u0012\b\b\u0002\u0010(\u001a\u00020\"\u0012\b\b\u0002\u0010*\u001a\u00020)\u0012\b\b\u0002\u00104\u001a\u00020\u0013\u00a2\u0006\u0004\bP\u0010RJ\u000f\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001b\u0010\b\u001a\u00020\u00002\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0011H\u0000\u00a2\u0006\u0004\b\u0014\u0010\u0015J\r\u0010\u0017\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0004J,\u0010\u001b\u001a\u00020\u00022\u001d\u0010\u001a\u001a\u0019\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00020\u0018\u00a2\u0006\u0002\b\u0019\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u000f\u0010\u001d\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u001d\u0010\u0004J\u0015\u0010 \u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u001e\u00a2\u0006\u0004\b \u0010!R\u0016\u0010#\u001a\u00020\"8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b#\u0010$R\u0016\u0010%\u001a\u00020\"8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b%\u0010$R\u0016\u0010&\u001a\u00020\u00138\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b&\u0010'R\u0014\u0010(\u001a\u00020\"8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b(\u0010$R\u0014\u0010*\u001a\u00020)8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b*\u0010+R\u0017\u0010-\u001a\u00020,8\u0006\u00a2\u0006\f\n\u0004\b-\u0010.\u001a\u0004\b/\u00100R\u001c\u00102\u001a\b\u0012\u0002\b\u0003\u0018\u0001018\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b2\u00103R\u0014\u00104\u001a\u00020\u00138\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b4\u0010'R\u0017\u00106\u001a\u0002058\u0006\u00a2\u0006\f\n\u0004\b6\u00107\u001a\u0004\b8\u00109R\u0016\u0010:\u001a\u00020\n8\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b:\u0010;R1\u0010=\u001a\u001f\u0012\u001b\u0012\u0019\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00020\u0018\u00a2\u0006\u0002\b\u00190<8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b=\u0010>R\u0016\u0010\u001f\u001a\u00020\u001e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001f\u0010?R\u0016\u0010@\u001a\u00020\u00138\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b@\u0010'R\u001c\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00020A8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bB\u0010CR<\u0010F\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\"0D2\u0012\u0010E\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\"0D8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\bF\u0010G\u001a\u0004\bH\u0010IR\u0018\u0010K\u001a\u0004\u0018\u00010J8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bK\u0010LR\u001c\u0010M\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bM\u0010N\u00a8\u0006V"}, d2={"Lgg/essential/elementa/markdown/MarkdownComponent;", "Lgg/essential/elementa/UIComponent;", "", "animationFrame", "()V", "Lgg/essential/elementa/state/State;", "", "state", "bindText", "(Lgg/essential/elementa/state/State;)Lgg/essential/elementa/markdown/MarkdownComponent;", "Lgg/essential/elementa/markdown/MarkdownComponent$ConstraintValues;", "constraintValues", "()Lgg/essential/elementa/markdown/MarkdownComponent$ConstraintValues;", "Lgg/essential/universal/UMatrixStack;", "matrixStack", "draw", "(Lgg/essential/universal/UMatrixStack;)V", "Lgg/essential/elementa/markdown/MarkdownComponent$LinkClickEvent;", "event", "", "fireLinkClickEvent$Elementa", "(Lgg/essential/elementa/markdown/MarkdownComponent$LinkClickEvent;)Z", "fireLinkClickEvent", "layout", "Lkotlin/Function2;", "Lkotlin/ExtensionFunctionType;", "block", "onLinkClicked", "(Lkotlin/jvm/functions/Function2;)V", "reparse", "Lgg/essential/elementa/constraints/HeightConstraint;", "maxHeight", "setMaxHeight", "(Lgg/essential/elementa/constraints/HeightConstraint;)Lgg/essential/elementa/markdown/MarkdownComponent;", "", "baseX", "F", "baseY", "canDrag", "Z", "codeFontPointSize", "Lgg/essential/elementa/font/FontProvider;", "codeFontRenderer", "Lgg/essential/elementa/font/FontProvider;", "Lgg/essential/elementa/markdown/MarkdownConfig;", "config", "Lgg/essential/elementa/markdown/MarkdownConfig;", "getConfig", "()Lgg/essential/elementa/markdown/MarkdownConfig;", "Lgg/essential/elementa/markdown/selection/Cursor;", "cursor", "Lgg/essential/elementa/markdown/selection/Cursor;", "disableSelection", "Lgg/essential/elementa/markdown/drawables/DrawableList;", "drawables", "Lgg/essential/elementa/markdown/drawables/DrawableList;", "getDrawables", "()Lgg/essential/elementa/markdown/drawables/DrawableList;", "lastValues", "Lgg/essential/elementa/markdown/MarkdownComponent$ConstraintValues;", "", "linkClickListeners", "Ljava/util/List;", "Lgg/essential/elementa/constraints/HeightConstraint;", "needsInitialLayout", "Lkotlin/Function0;", "removeListener", "Lkotlin/jvm/functions/Function0;", "", "<set-?>", "sectionOffsets", "Ljava/util/Map;", "getSectionOffsets", "()Ljava/util/Map;", "Lgg/essential/elementa/markdown/selection/Selection;", "selection", "Lgg/essential/elementa/markdown/selection/Selection;", "textState", "Lgg/essential/elementa/state/State;", "text", "<init>", "(Ljava/lang/String;Lgg/essential/elementa/markdown/MarkdownConfig;FLgg/essential/elementa/font/FontProvider;)V", "(Ljava/lang/String;Lgg/essential/elementa/markdown/MarkdownConfig;FLgg/essential/elementa/font/FontProvider;Z)V", "Companion", "ConstraintValues", "LinkClickEvent", "Elementa"})
public final class MarkdownComponent
extends UIComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MarkdownConfig config;
    private final float codeFontPointSize;
    @NotNull
    private final FontProvider codeFontRenderer;
    private final boolean disableSelection;
    @NotNull
    private State<String> textState;
    @NotNull
    private Function0<Unit> removeListener;
    @NotNull
    private final DrawableList drawables;
    @NotNull
    private Map<String, Float> sectionOffsets;
    private float baseX;
    private float baseY;
    private ConstraintValues lastValues;
    @NotNull
    private HeightConstraint maxHeight;
    @Nullable
    private Cursor<?> cursor;
    @Nullable
    private Selection selection;
    private boolean canDrag;
    private boolean needsInitialLayout;
    @NotNull
    private final List<Function2<MarkdownComponent, LinkClickEvent, Unit>> linkClickListeners;
    public static final boolean DEBUG = false;

    public MarkdownComponent(@NotNull String text, @NotNull MarkdownConfig config, float codeFontPointSize, @NotNull FontProvider codeFontRenderer, boolean disableSelection) {
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(config, "config");
        Intrinsics.checkNotNullParameter(codeFontRenderer, "codeFontRenderer");
        this.config = config;
        this.codeFontPointSize = codeFontPointSize;
        this.codeFontRenderer = codeFontRenderer;
        this.disableSelection = disableSelection;
        this.textState = new BasicState<String>(text);
        this.removeListener = this.textState.onSetValue(new Function1<String, Unit>(this){
            final /* synthetic */ MarkdownComponent this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter(it, "it");
                MarkdownComponent.access$reparse(this.this$0);
                this.this$0.layout();
            }
        });
        this.drawables = new DrawableList(this, CollectionsKt.emptyList());
        this.sectionOffsets = MapsKt.emptyMap();
        this.baseX = -1.0f;
        this.baseY = -1.0f;
        this.maxHeight = UtilitiesKt.pixels$default(Integer.MAX_VALUE, false, false, 3, null);
        this.needsInitialLayout = true;
        this.linkClickListeners = new ArrayList();
        this.onMouseClick((Function2<? super UIComponent, ? super UIClickEvent, Unit>)new Function2<UIComponent, UIClickEvent, Unit>(){

            @Override
            public final void invoke(@NotNull UIComponent $this$onMouseClick, @NotNull UIClickEvent it) {
                Intrinsics.checkNotNullParameter($this$onMouseClick, "$this$onMouseClick");
                Intrinsics.checkNotNullParameter(it, "it");
                float xShift = $this$onMouseClick.getLeft() - baseX;
                float yShift = $this$onMouseClick.getTop() - baseY;
                cursor = this.getDrawables().cursorAt(it.getAbsoluteX() - xShift, it.getAbsoluteY() - yShift, false, it.getMouseButton());
                Selection selection = selection;
                if (selection != null) {
                    selection.remove();
                }
                selection = null;
                $this$onMouseClick.releaseWindowFocus();
            }
        });
        if (!this.disableSelection) {
            this.onMouseClick((Function2<? super UIComponent, ? super UIClickEvent, Unit>)new Function2<UIComponent, UIClickEvent, Unit>(){

                @Override
                public final void invoke(@NotNull UIComponent $this$onMouseClick, @NotNull UIClickEvent it) {
                    Intrinsics.checkNotNullParameter($this$onMouseClick, "$this$onMouseClick");
                    Intrinsics.checkNotNullParameter(it, "it");
                    canDrag = true;
                }
            });
            this.onMouseRelease((Function1<? super UIComponent, Unit>)new Function1<UIComponent, Unit>(){

                @Override
                public final void invoke(@NotNull UIComponent $this$onMouseRelease) {
                    Intrinsics.checkNotNullParameter($this$onMouseRelease, "$this$onMouseRelease");
                    canDrag = false;
                }
            });
            this.onMouseDrag((Function4<? super UIComponent, ? super Float, ? super Float, ? super Integer, Unit>)new Function4<UIComponent, Float, Float, Integer, Unit>(){

                @Override
                public final void invoke(@NotNull UIComponent $this$onMouseDrag, float mouseX, float mouseY, int mouseButton) {
                    Intrinsics.checkNotNullParameter($this$onMouseDrag, "$this$onMouseDrag");
                    if (mouseButton != 0 || !canDrag) {
                        return;
                    }
                    float x = baseX + RangesKt.coerceIn(mouseX, 0.0f, $this$onMouseDrag.getWidth());
                    float y = baseY + RangesKt.coerceIn(mouseY, 0.0f, $this$onMouseDrag.getHeight());
                    Cursor<?> otherEnd = this.getDrawables().cursorAt(x, y, true, mouseButton);
                    if (Intrinsics.areEqual(cursor, otherEnd)) {
                        return;
                    }
                    Selection selection = selection;
                    if (selection != null) {
                        selection.remove();
                    }
                    Cursor cursor = cursor;
                    Intrinsics.checkNotNull(cursor);
                    selection = Selection.Companion.fromCursors(cursor, otherEnd);
                    $this$onMouseDrag.grabWindowFocus();
                }
            });
            this.onKeyType((Function3<? super UIComponent, ? super Character, ? super Integer, Unit>)new Function3<UIComponent, Character, Integer, Unit>(){

                @Override
                public final void invoke(@NotNull UIComponent $this$onKeyType, char $noName_0, int keyCode) {
                    Intrinsics.checkNotNullParameter($this$onKeyType, "$this$onKeyType");
                    if (selection != null && keyCode == UKeyboard.KEY_C && UKeyboard.isCtrlKeyDown()) {
                        UDesktop.setClipboardString(this.getDrawables().selectedText(UKeyboard.isShiftKeyDown()));
                    }
                }
            });
        }
    }

    public /* synthetic */ MarkdownComponent(String string, MarkdownConfig markdownConfig, float f, FontProvider fontProvider, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            markdownConfig = new MarkdownConfig(null, null, null, null, null, null, null, null, 255, null);
        }
        if ((n & 4) != 0) {
            f = 10.0f;
        }
        if ((n & 8) != 0) {
            fontProvider = ElementaFonts.getJETBRAINS_MONO();
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        this(string, markdownConfig, f, fontProvider, bl);
    }

    @NotNull
    public final MarkdownConfig getConfig() {
        return this.config;
    }

    @JvmOverloads
    public MarkdownComponent(@NotNull String text, @NotNull MarkdownConfig config, float codeFontPointSize, @NotNull FontProvider codeFontRenderer) {
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(config, "config");
        Intrinsics.checkNotNullParameter(codeFontRenderer, "codeFontRenderer");
        this(text, config, codeFontPointSize, codeFontRenderer, false);
    }

    public /* synthetic */ MarkdownComponent(String string, MarkdownConfig markdownConfig, float f, FontProvider fontProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            markdownConfig = new MarkdownConfig(null, null, null, null, null, null, null, null, 255, null);
        }
        if ((n & 4) != 0) {
            f = 10.0f;
        }
        if ((n & 8) != 0) {
            fontProvider = ElementaFonts.getJETBRAINS_MONO();
        }
        this(string, markdownConfig, f, fontProvider);
    }

    @NotNull
    public final DrawableList getDrawables() {
        return this.drawables;
    }

    @NotNull
    public final Map<String, Float> getSectionOffsets() {
        return this.sectionOffsets;
    }

    @NotNull
    public final MarkdownComponent bindText(@NotNull State<String> state) {
        MarkdownComponent markdownComponent;
        Intrinsics.checkNotNullParameter(state, "state");
        MarkdownComponent $this$bindText_u24lambda_u2d0 = markdownComponent = this;
        boolean bl = false;
        $this$bindText_u24lambda_u2d0.removeListener.invoke();
        $this$bindText_u24lambda_u2d0.textState = state;
        $this$bindText_u24lambda_u2d0.reparse();
        $this$bindText_u24lambda_u2d0.layout();
        $this$bindText_u24lambda_u2d0.removeListener = $this$bindText_u24lambda_u2d0.textState.onSetValue(new Function1<String, Unit>($this$bindText_u24lambda_u2d0){
            final /* synthetic */ MarkdownComponent $this_apply;
            {
                this.$this_apply = $receiver;
                super(1);
            }

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter(it, "it");
                MarkdownComponent.access$reparse(this.$this_apply);
                this.$this_apply.layout();
            }
        });
        return markdownComponent;
    }

    @NotNull
    public final MarkdownComponent setMaxHeight(@NotNull HeightConstraint maxHeight) {
        MarkdownComponent markdownComponent;
        Intrinsics.checkNotNullParameter(maxHeight, "maxHeight");
        MarkdownComponent $this$setMaxHeight_u24lambda_u2d1 = markdownComponent = this;
        boolean bl = false;
        $this$setMaxHeight_u24lambda_u2d1.maxHeight = maxHeight;
        return markdownComponent;
    }

    private final void reparse() {
        this.drawables.setDrawables(new MarkdownRenderer(this.textState.get(), this, this.config).render());
    }

    /*
     * WARNING - void declaration
     */
    public final void layout() {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        this.baseX = this.getLeft();
        this.baseY = this.getTop();
        float currY = 0.0f;
        currY = this.baseY;
        float width = this.getWidth();
        Iterable $this$forEach$iv = this.drawables;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Drawable it = (Drawable)element$iv;
            boolean bl = false;
            currY += it.layout(this.baseX, currY, width).getHeight();
        }
        $this$forEach$iv = this.drawables;
        MarkdownComponent markdownComponent = this;
        boolean $i$f$filterIsInstance = false;
        Iterator iterator2 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof HeaderDrawable)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv2;
            HeaderDrawable it = (HeaderDrawable)element$iv$iv;
            boolean bl = false;
            Pair<String, Float> pair = TuplesKt.to(it.getId$Elementa(), Float.valueOf(it.getY()));
            map2.put(pair.getFirst(), pair.getSecond());
        }
        markdownComponent.sectionOffsets = destination$iv$iv2;
        this.setHeight(UtilitiesKt.pixels$default(Float.valueOf(RangesKt.coerceAtMost(currY - this.baseY, this.maxHeight.getHeight(this))), false, false, 3, null));
    }

    @Override
    public void animationFrame() {
        super.animationFrame();
        if (this.needsInitialLayout) {
            this.needsInitialLayout = false;
            this.reparse();
            this.layout();
            this.lastValues = this.constraintValues();
        }
        ConstraintValues currentValues = this.constraintValues();
        ConstraintValues constraintValues = this.lastValues;
        if (constraintValues == null) {
            Intrinsics.throwUninitializedPropertyAccessException("lastValues");
            constraintValues = null;
        }
        if (!Intrinsics.areEqual(currentValues, constraintValues)) {
            this.layout();
        }
        this.lastValues = currentValues;
    }

    @Override
    public void draw(@NotNull UMatrixStack matrixStack) {
        Intrinsics.checkNotNullParameter(matrixStack, "matrixStack");
        this.beforeDraw(matrixStack);
        DrawState drawState = new DrawState(this.getLeft() - this.baseX, this.getTop() - this.baseY);
        Window parentWindow = Window.Companion.of(this);
        Iterable $this$forEach$iv = this.drawables;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Drawable it = (Drawable)element$iv;
            boolean bl = false;
            if (!parentWindow.isAreaVisible((double)it.getLayout().getLeft() + (double)drawState.getXShift(), (double)it.getLayout().getTop() + (double)drawState.getYShift(), (double)it.getLayout().getRight() + (double)drawState.getXShift(), (double)it.getLayout().getBottom() + (double)drawState.getYShift())) continue;
            if (OptionsKt.getElementaDebug()) {
                UIComponent.Companion.drawDebugOutline$Elementa(matrixStack, (double)it.getLayout().getLeft() + (double)drawState.getXShift(), (double)it.getLayout().getTop() + (double)drawState.getYShift(), (double)it.getLayout().getRight() + (double)drawState.getXShift(), (double)it.getLayout().getBottom() + (double)drawState.getYShift(), this);
            }
            it.draw(matrixStack, drawState);
        }
        if (!this.disableSelection) {
            Unit unit;
            Unit unit2;
            Selection selection = this.selection;
            if (selection == null) {
                unit2 = null;
            } else {
                selection.draw(matrixStack, drawState);
                unit2 = unit = Unit.INSTANCE;
            }
            if (unit2 == null) {
                Cursor<?> cursor = this.cursor;
                if (cursor == null) {
                    unit = null;
                } else {
                    cursor.draw(matrixStack, drawState);
                    unit = Unit.INSTANCE;
                }
            }
        }
        super.draw(matrixStack);
    }

    private final ConstraintValues constraintValues() {
        return new ConstraintValues(this.getWidth(), this.getTextScale());
    }

    public final void onLinkClicked(@NotNull Function2<? super MarkdownComponent, ? super LinkClickEvent, Unit> block) {
        Intrinsics.checkNotNullParameter(block, "block");
        this.linkClickListeners.add(block);
    }

    public final boolean fireLinkClickEvent$Elementa(@NotNull LinkClickEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        for (Function2<MarkdownComponent, LinkClickEvent, Unit> listener2 : this.linkClickListeners) {
            listener2.invoke(this, event);
            if (!event.getPropagationStoppedImmediately()) continue;
            return false;
        }
        return !event.getPropagationStopped();
    }

    @JvmOverloads
    public MarkdownComponent(@NotNull String text, @NotNull MarkdownConfig config, float codeFontPointSize) {
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(config, "config");
        this(text, config, codeFontPointSize, null, 8, null);
    }

    @JvmOverloads
    public MarkdownComponent(@NotNull String text, @NotNull MarkdownConfig config) {
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(config, "config");
        this(text, config, 0.0f, null, 12, null);
    }

    @JvmOverloads
    public MarkdownComponent(@NotNull String text) {
        Intrinsics.checkNotNullParameter(text, "text");
        this(text, null, 0.0f, null, 14, null);
    }

    public static final /* synthetic */ void access$reparse(MarkdownComponent $this) {
        $this.reparse();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0007\u0010\bR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0004\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lgg/essential/elementa/markdown/MarkdownComponent$LinkClickEvent;", "Lgg/essential/elementa/events/UIEvent;", "", "url", "Ljava/lang/String;", "getUrl", "()Ljava/lang/String;", "<init>", "(Ljava/lang/String;)V", "Elementa"})
    public static final class LinkClickEvent
    extends UIEvent {
        @NotNull
        private final String url;

        public LinkClickEvent(@NotNull String url) {
            Intrinsics.checkNotNullParameter(url, "url");
            this.url = url;
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0010\u0010\u0003\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0004J$\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0006\u001a\u00020\u00022\b\b\u0002\u0010\u0007\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\f\u001a\u00020\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000f\u001a\u00020\u000eH\u00d6\u0001\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0012\u001a\u00020\u0011H\u00d6\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0007\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0014\u001a\u0004\b\u0015\u0010\u0004R\u0017\u0010\u0006\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0014\u001a\u0004\b\u0016\u0010\u0004\u00a8\u0006\u0019"}, d2={"Lgg/essential/elementa/markdown/MarkdownComponent$ConstraintValues;", "", "", "component1", "()F", "component2", "width", "textScale", "copy", "(FF)Lgg/essential/elementa/markdown/MarkdownComponent$ConstraintValues;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "F", "getTextScale", "getWidth", "<init>", "(FF)V", "Elementa"})
    public static final class ConstraintValues {
        private final float width;
        private final float textScale;

        public ConstraintValues(float width, float textScale) {
            this.width = width;
            this.textScale = textScale;
        }

        public final float getWidth() {
            return this.width;
        }

        public final float getTextScale() {
            return this.textScale;
        }

        public final float component1() {
            return this.width;
        }

        public final float component2() {
            return this.textScale;
        }

        @NotNull
        public final ConstraintValues copy(float width, float textScale) {
            return new ConstraintValues(width, textScale);
        }

        public static /* synthetic */ ConstraintValues copy$default(ConstraintValues constraintValues, float f, float f2, int n, Object object) {
            if ((n & 1) != 0) {
                f = constraintValues.width;
            }
            if ((n & 2) != 0) {
                f2 = constraintValues.textScale;
            }
            return constraintValues.copy(f, f2);
        }

        @NotNull
        public String toString() {
            return "ConstraintValues(width=" + this.width + ", textScale=" + this.textScale + ')';
        }

        public int hashCode() {
            int result2 = Float.hashCode(this.width);
            result2 = result2 * 31 + Float.hashCode(this.textScale);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ConstraintValues)) {
                return false;
            }
            ConstraintValues constraintValues = (ConstraintValues)other;
            if (!Intrinsics.areEqual((Object)Float.valueOf(this.width), (Object)Float.valueOf(constraintValues.width))) {
                return false;
            }
            return Intrinsics.areEqual((Object)Float.valueOf(this.textScale), (Object)Float.valueOf(constraintValues.textScale));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0003\u001a\u00020\u00028\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0007"}, d2={"Lgg/essential/elementa/markdown/MarkdownComponent$Companion;", "", "", "DEBUG", "Z", "<init>", "()V", "Elementa"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

