/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.elementa.impl.dom4j.datatype;

import com.sun.msv.datatype.xsd.XSDatatype;
import gg.essential.elementa.impl.dom4j.DocumentFactory;
import gg.essential.elementa.impl.dom4j.Element;
import gg.essential.elementa.impl.dom4j.QName;
import gg.essential.elementa.impl.dom4j.datatype.DatatypeElementFactory;
import java.util.HashMap;
import java.util.Map;

class NamedTypeResolver {
    protected Map<QName, DocumentFactory> complexTypeMap = new HashMap<QName, DocumentFactory>();
    protected Map<QName, XSDatatype> simpleTypeMap = new HashMap<QName, XSDatatype>();
    protected Map<Element, QName> typedElementMap = new HashMap<Element, QName>();
    protected Map<Element, DocumentFactory> elementFactoryMap = new HashMap<Element, DocumentFactory>();
    protected DocumentFactory documentFactory;

    NamedTypeResolver(DocumentFactory documentFactory) {
        this.documentFactory = documentFactory;
    }

    void registerComplexType(QName type2, DocumentFactory factory2) {
        this.complexTypeMap.put(type2, factory2);
    }

    void registerSimpleType(QName type2, XSDatatype datatype) {
        this.simpleTypeMap.put(type2, datatype);
    }

    void registerTypedElement(Element element, QName type2, DocumentFactory parentFactory) {
        this.typedElementMap.put(element, type2);
        this.elementFactoryMap.put(element, parentFactory);
    }

    void resolveElementTypes() {
        for (Element element : this.typedElementMap.keySet()) {
            QName elementQName = this.getQNameOfSchemaElement(element);
            QName type2 = this.typedElementMap.get(element);
            if (this.complexTypeMap.containsKey(type2)) {
                DocumentFactory factory2 = this.complexTypeMap.get(type2);
                elementQName.setDocumentFactory(factory2);
                continue;
            }
            if (!this.simpleTypeMap.containsKey(type2)) continue;
            XSDatatype datatype = this.simpleTypeMap.get(type2);
            DocumentFactory factory3 = this.elementFactoryMap.get(element);
            if (!(factory3 instanceof DatatypeElementFactory)) continue;
            ((DatatypeElementFactory)factory3).setChildElementXSDatatype(elementQName, datatype);
        }
    }

    void resolveNamedTypes() {
        this.resolveElementTypes();
    }

    private QName getQNameOfSchemaElement(Element element) {
        String name = element.attributeValue("name");
        return this.getQName(name);
    }

    private QName getQName(String name) {
        return this.documentFactory.createQName(name);
    }
}

